/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.rdserver.popups;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.jetbrains.rdserver.actions.ClientMouseEvent;
import com.jetbrains.rdserver.ui.popup.util.BackendEditorContext;
import com.jetbrains.rider.services.popups.nova.PopupViewModel;
import com.jetbrains.rider.services.popups.nova.layouter.HackPopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterSource;
import com.jetbrains.rider.services.popups.nova.ui.UiPopupMenus;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/rdserver/popups/RiderBackendUiPopupMenus;", "Lcom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "findRemoteSelectedEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "showNoItemsBanner", "", "viewModel", "Lcom/jetbrains/rider/services/popups/nova/PopupViewModel;", "showPopup", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "intellij.rider.cwm.core"})
public final class RiderBackendUiPopupMenus
extends UiPopupMenus {
    @NotNull
    private final ClientProjectSession session;

    public RiderBackendUiPopupMenus(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    protected void showPopup(@NotNull PopupViewModel viewModel, @NotNull WizardPopup popup) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        PopupLayouterSource popupLayouterSource = viewModel.getPopupLayouterSource();
        Intrinsics.checkNotNull((Object)popupLayouterSource);
        PopupLayouter layouter = popupLayouterSource.createLayouter(viewModel.getLifetime());
        if (layouter instanceof HackPopupLayouter) {
            ClientMouseEvent inputEvent;
            EditorEx editor;
            EditorEx editorEx = editor = this.findRemoteSelectedEditor();
            InputEvent inputEvent2 = editorEx != null ? (InputEvent)editorEx.getUserData(BackendEditorContext.Companion.getEditorLastEventKey()) : null;
            ClientMouseEvent clientMouseEvent = inputEvent = inputEvent2 instanceof ClientMouseEvent ? (ClientMouseEvent)inputEvent2 : null;
            if (editor != null && inputEvent != null) {
                popup.show(new RelativePoint((MouseEvent)inputEvent));
                editor.putUserData(BackendEditorContext.Companion.getEditorLastEventKey(), null);
                return;
            }
        }
        super.showPopup(viewModel, popup);
    }

    private final EditorEx findRemoteSelectedEditor() {
        FileEditor fileEditor = ClientFileEditorManager.Companion.getCurrentInstance(this.session.getProject()).getSelectedEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        Editor editor = textEditor != null ? textEditor.getEditor() : null;
        return editor instanceof EditorEx ? (EditorEx)editor : null;
    }

    protected void showNoItemsBanner(@NotNull PopupViewModel viewModel) {
        EditorEx editor;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        EditorEx editorEx = editor = this.findRemoteSelectedEditor();
        if (editorEx != null) {
            this.showErrorHint((Editor)editorEx, viewModel);
        } else {
            super.showNoItemsBanner(viewModel);
        }
    }
}

