/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.rdserver.completion;

import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdserver.completion.BackendLookupManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/rdserver/completion/RiderLookupManager;", "Lcom/jetbrains/rdserver/completion/BackendLookupManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createLookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "arranger", "Lcom/intellij/codeInsight/lookup/LookupArranger;", "intellij.rider.cwm.core"})
public final class RiderLookupManager
extends BackendLookupManagerImpl {
    public RiderLookupManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    protected LookupImpl createLookup(@NotNull Editor editor, @NotNull LookupArranger arranger, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)arranger, (String)"arranger");
        if (project == null) {
            return super.createLookup(editor, arranger, null);
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return super.createLookup(editor, arranger, project);
        }
        Project editorProject = project2;
        return (LookupImpl)new BackendLookupManagerImpl.BackendLookupImpl(editor, project, arranger, editorProject){
            @Nullable
            private final EditorSynchronizer editorSynchronizer;
            @Nullable
            private final DocumentSynchronizer documentSynchronizer;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $editorProject;
            {
                this.$editor = $editor;
                this.$editorProject = $editorProject;
                super($project, $editor, $arranger);
                this.editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)$editor);
                Document document = $editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                this.documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)$project);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected boolean suppressHidingOnChange() {
                FrontendMarkupContributor editorMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.$editor);
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                FrontendMarkupContributor documentMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.$editorProject, document);
                EditorSynchronizer editorSynchronizer = this.editorSynchronizer;
                if (editorSynchronizer != null ? editorSynchronizer.isReceivingChange() : false) return true;
                DocumentSynchronizer documentSynchronizer = this.documentSynchronizer;
                if (documentSynchronizer != null ? documentSynchronizer.isReceivingChange() : false) return true;
                FrontendMarkupContributor frontendMarkupContributor = editorMarkupContributor;
                if (frontendMarkupContributor != null ? frontendMarkupContributor.isUpdating() : false) return true;
                FrontendMarkupContributor frontendMarkupContributor2 = documentMarkupContributor;
                if (frontendMarkupContributor2 == null) return false;
                boolean bl = frontendMarkupContributor2.isUpdating();
                if (!bl) return false;
                return true;
            }
        };
    }
}

