/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.tests;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangLanguageServiceStartupActivity;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangProjectScanStartupActivity;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdTestUtilBase {
    @Nullable
    public ClangLanguageService doSetUp(@NotNull Project project, @NotNull Disposable disposable, final @NotNull Runnable onCrash, boolean useCommonTarget) {
        if (project == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(1);
        }
        if (onCrash == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(2);
        }
        ClangUtils.forceClangdOn(project);
        ClangUtils.forceClangdShowErrorsOn(project);
        ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
        assert (provider2 != null);
        project.putUserData(ClangDaemonContext.URL_CONVERTER_KEY, (Object)new ClangMockUrlConverter());
        if (useCommonTarget) {
            project.putUserData(ClangUtils.CLANGD_ARCHITECTURE, (Object)"x86_64");
            project.putUserData(ClangUtils.CLANGD_OS, (Object)"darwin");
            project.putUserData(ClangUtils.CLANGD_ENVIRONMENT, (Object)"unknown");
        }
        project.putUserData(ClangUtils.CLANGD_C_LANGUAGE_STANDARD, (Object)OCLanguageStandard.C11);
        project.putUserData(ClangUtils.CLANGD_CXX_LANGUAGE_STANDARD, (Object)OCLanguageStandard.CPP14);
        project.putUserData(ClangdBridge.CLANG_CAN_OPEN_FILE, (Object)true);
        if (!(project instanceof ProjectEx) || !((ProjectEx)project).isLight()) {
            ClangProjectScanStartupActivity scanActivity = new ClangProjectScanStartupActivity();
            scanActivity.executeAndWait(project);
        }
        this.runStartupActivity(project);
        Disposer.register((Disposable)disposable, () -> {
            ClangdTestUtilBase.ensureStopped(provider2.stop());
            ClangdTestUtilBase.ensureStopped(provider2.stopIndexer());
            ClangUtils.nonForceClangd(project);
            ClangUtils.nonForceClangdShowErrors(project);
        });
        ClangLanguageService service = provider2.getOrStart();
        if (service == null) {
            return null;
        }
        service.getMessageBus().connect(disposable).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            @Override
            public void onServerFailure() {
                onCrash.run();
            }
        });
        return service;
    }

    protected void runStartupActivity(Project project) {
        ClangLanguageServiceStartupActivity.runStartupActivity(project);
    }

    private static void ensureStopped(@NotNull ClangStopData stopData) {
        if (stopData == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(3);
        }
        try {
            stopData.exitCode.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            CidrLogService.LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            CidrLogService.LOG.warn("Killing clangd");
            stopData.killRunnable.run();
        }
    }

    @NotNull
    public static String dumpThreads(@NotNull Project project) {
        if (project == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(4);
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        return ClangdTestUtilBase.dumpThreads(service);
    }

    @NotNull
    public static String dumpThreads(@Nullable ClangLanguageService service) {
        String nativeStacktrace;
        StringBuilder dump = new StringBuilder();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadAndStack : stackTraces.entrySet()) {
            Thread thread = threadAndStack.getKey();
            StackTraceElement[] elements = threadAndStack.getValue();
            dump.append('\"').append(thread.getName()).append("\"\n");
            dump.append("  java.lang.Thread.State: ").append((Object)thread.getState()).append("\n");
            for (StackTraceElement element : elements) {
                dump.append("    at ").append(element).append("\n");
            }
            dump.append("\n");
        }
        if (service != null && !StringUtil.isEmpty((String)(nativeStacktrace = service.getNativeStacktrace()))) {
            dump.append("\n\nClangd stacktrace:\n").append(nativeStacktrace);
        }
        String string = dump.toString();
        if (string == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void enableDFA(@NotNull Project project, boolean inspectHeaderFunctionsMode, int statementsCntLimit) {
        if (project == null) {
            ClangdTestUtilBase.$$$reportNull$$$0(6);
        }
        project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, Optional.of(new ClionClangDFAConfigParams(inspectHeaderFunctionsMode, statementsCntLimit)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCrash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/tests/ClangdTestUtilBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/tests/ClangdTestUtilBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doSetUp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureStopped";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreads";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "enableDFA";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class ClangMockUrlConverter
    extends ClangUrlConverter {
        private ClangMockUrlConverter() {
        }

        @Override
        public boolean isAcceptable(@NotNull String url) {
            if (url == null) {
                ClangMockUrlConverter.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/cidr/lang/tests/ClangdTestUtilBase$ClangMockUrlConverter", "isAcceptable"));
        }
    }
}

