/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OurClangTidyInspection
extends ClangTidyInspectionBase
implements OCInspectionBase.CLionClangTidyBasedMarker {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected OurClangTidyInspection() {
    }

    public abstract String getCheckName();

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        if (clangTidyMessage == null) {
            OurClangTidyInspection.$$$reportNull$$$0(0);
        }
        String string = clangTidyMessage;
        if (string == null) {
            OurClangTidyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OurClangTidyInspection.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OurClangTidyInspection.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        if (clangTidyCheckName == null) {
            OurClangTidyInspection.$$$reportNull$$$0(4);
        }
        String string = this.getShortName();
        if (string == null) {
            OurClangTidyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (problemsHolder == null) {
            OurClangTidyInspection.$$$reportNull$$$0(6);
        }
        if (session == null) {
            OurClangTidyInspection.$$$reportNull$$$0(7);
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (isOnTheFly && problemsHolder.isOnTheFly()) {
                    return;
                }
                if (!ClangdBridge.isSupported(file.getProject(), file.getVirtualFile())) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(file.getProject());
                if (service == null) {
                    return;
                }
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                try {
                    List allDiagnostics = service.computeWithOpenedAndParsed(virtualFile, OurClangTidyInspection::getDiagnosticsFromResponse);
                    if (allDiagnostics == null) {
                        return;
                    }
                    List diagnostics = ContainerUtil.filter((Collection)allDiagnostics, diagnostic -> diagnostic.getDiagnosticName().equals(OurClangTidyInspection.this.getCheckName()));
                    ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
                    Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                    if (document2 != null) {
                        applier.annotateSuccess(file, (List<ClangTidyDiagnostic>)diagnostics, problemsHolder);
                    }
                }
                catch (ProcessCanceledException allDiagnostics) {
                }
                catch (Exception e) {
                    OurClangTidyInspection.this.LOG.warn(((Object)((Object)this)).getClass().getName() + " in batch mode failed.", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/inspections/OurClangTidyInspection$1", "visitFile"));
            }
        };
    }

    @Nullable
    private static List<ClangTidyDiagnostic> getDiagnosticsFromResponse(@Nullable ClangParseResponse response) throws ExecutionException {
        return response != null ? ClangUtils.waitForClangFuture(response.getOurTidyDiagnostics()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyMessage";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OurClangTidyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OurClangTidyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeDisabledByClangTidyCheckName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

