/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClazyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection,
OCInspectionBase.CLionClangTidyBasedMarker {
    @NotNull
    @NonNls
    private String myClazyChecks = "level0";

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        if (clangTidyMessage == null) {
            ClazyInspection.$$$reportNull$$$0(0);
        }
        String string = isBatchMode ? clangTidyMessage : ClangdBundle.message("inspection.clazy.message", clangTidyMessage);
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = ClangdBundle.message("inspection.static.analysis", new Object[0]);
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = ClangdBundle.message("inspection.clazy.name", new Object[0]);
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        ClangTidyFilesState clangTidyFilesState;
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ClazyInspection.$$$reportNull$$$0(5);
        }
        return !(clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class)).hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        if (clangTidyCheckName == null) {
            ClazyInspection.$$$reportNull$$$0(6);
        }
        String string = clangTidyCheckName;
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getInspectionShortName() {
        String string = new ClazyInspection().getShortName();
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            ClazyInspection.$$$reportNull$$$0(10);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ClazyInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            ClazyInspection.$$$reportNull$$$0(13);
        }
        ClazyAnnotator annotator = new ClazyAnnotator(new ClazyAnnotatorExecutionConfig(this));
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
        if (problemDescriptorArray == null) {
            ClazyInspection.$$$reportNull$$$0(14);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.expandableString((String)"myClazyChecks", (String)ClangdBundle.message("label.list.checks.comma.separated", new Object[0]), (String)",").description((HtmlChunk)HtmlChunk.link((String)"https://github.com/KDE/clazy#list-of-checks", (String)ClangdBundle.message("configurable.clazy.checks.link", new Object[0])))});
        if (optPane == null) {
            ClazyInspection.$$$reportNull$$$0(15);
        }
        return optPane;
    }

    @NotNull
    @NonNls
    public String getClazyChecks() {
        String string = this.myClazyChecks;
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setClazyChecks(@NotNull @NonNls String checks) {
        if (checks == null) {
            ClazyInspection.$$$reportNull$$$0(17);
        }
        this.myClazyChecks = checks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 8, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClazyInspection";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClazyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionShortName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClazyChecks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeDisabledByClangTidyCheckName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setClazyChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 8, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

