/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyInspectionDescriptionProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionChecksDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection {
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    private boolean myPreferClangTidyFilesOverIDESettings = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @NotNull
    public static String getInspectionShortName() {
        String string = new ClangTidyInspection().getShortName();
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = ClangdBundle.message("inspection.static.analysis", new Object[0]);
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = ClangdBundle.message("inspection.clangTidy.name", new Object[0]);
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClangTidyInspection.addComponent((Component)this.createClangTidyFilesCheckbox(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsBottom((int)10));
        ClangTidyInspection.addComponent(this.createChecksComponent(), childPanel, 0, 2, 1, 1, 0, (Insets)JBInsets.emptyInsets());
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 2, 3, 1, 0, (Insets)JBInsets.emptyInsets());
        builder.addComponent((JComponent)childPanel);
        builder.addComponent(this.createOptionsButton(childPanel), 10);
        builder.addComponent((JComponent)CidrLangUtil.createLinkToConfigurable((String)ClangdBundle.message("configurable.clangTidy.executable", new Object[0]), ClangTidyConfigurable.class, null, null), 10);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        return panel;
    }

    @NotNull
    private JBCheckBox createClangTidyFilesCheckbox() {
        final JBCheckBox checkBox = new JBCheckBox(ClangdBundle.message("configurable.clangTidy.prefer.files.over.ide.settings", new Object[0]), this.myPreferClangTidyFilesOverIDESettings);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myPreferClangTidyFilesOverIDESettings = checkBox.isSelected();
            }
        });
        JBCheckBox jBCheckBox = checkBox;
        if (jBCheckBox == null) {
            ClangTidyInspection.$$$reportNull$$$0(3);
        }
        return jBCheckBox;
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        if (clangTidyMessage == null) {
            ClangTidyInspection.$$$reportNull$$$0(4);
        }
        String string = isBatchMode ? clangTidyMessage : ClangdBundle.message("inspection.clangTidy.message", clangTidyMessage);
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ClangTidyInspection.$$$reportNull$$$0(7);
        }
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        return !this.myPreferClangTidyFilesOverIDESettings || !clangTidyFilesState.hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        if (clangTidyCheckName == null) {
            ClangTidyInspection.$$$reportNull$$$0(8);
        }
        String string = clangTidyCheckName;
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void disableGroups(@NotNull List<String> groups) {
        if (groups == null) {
            ClangTidyInspection.$$$reportNull$$$0(10);
        }
        if (groups.size() == ClangTidyInspection.getAllAvailableGroups().size()) {
            this.setClangTidyChecks("-*");
            return;
        }
        super.disableGroups(groups);
    }

    @Override
    public void enableGroups(@NotNull List<String> groups) {
        if (groups == null) {
            ClangTidyInspection.$$$reportNull$$$0(11);
        }
        if (groups.size() == ClangTidyInspection.getAllAvailableGroups().size()) {
            this.setClangTidyChecks("*");
            return;
        }
        super.enableGroups(groups);
    }

    @Override
    public void disableAllChecksInGroup(@NotNull String group) {
        if (group == null) {
            ClangTidyInspection.$$$reportNull$$$0(12);
        }
        this.setClangTidyChecks(CommonClangTidyUtil.disableGroup(this.getClangTidyChecks(), group));
    }

    @Override
    public void enableAllChecksInGroup(@NotNull String group) {
        if (group == null) {
            ClangTidyInspection.$$$reportNull$$$0(13);
        }
        this.setClangTidyChecks(CommonClangTidyUtil.enableGroup(this.getClangTidyChecks(), group));
    }

    @Override
    public void enableCheck(@NotNull String check) {
        if (check == null) {
            ClangTidyInspection.$$$reportNull$$$0(14);
        }
        this.setClangTidyChecks(CommonClangTidyUtil.enableCheck(this.getClangTidyChecks(), check));
    }

    @Override
    public void disableCheck(@NotNull String check) {
        if (check == null) {
            ClangTidyInspection.$$$reportNull$$$0(15);
        }
        this.setClangTidyChecks(CommonClangTidyUtil.disableCheck(this.getClangTidyChecks(), check));
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(16);
        }
        if (panel == null) {
            ClangTidyInspection.$$$reportNull$$$0(17);
        }
        if (insets == null) {
            ClangTidyInspection.$$$reportNull$$$0(18);
        }
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(19);
        }
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton(ClangdBundle.message("configurable.clangTidy.checks.options.button", new Object[0]));
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, ClangTidyInspection.this.myClangTidyCheckOptions, null);
                if (!optionsDialog.showAndGet()) {
                    return;
                }
                List<ClangTidyCheckOption> newOptions = optionsDialog.getResultCheckOptions();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(newOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = newOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            ClangTidyInspection.$$$reportNull$$$0(20);
        }
        return jPanel;
    }

    @NotNull
    private JComponent createChecksComponent() {
        final RawCommandLineEditor checksField = this.createChecksField();
        final ClangTidySettings settings = ClangTidySettings.getInstance();
        final Set<String> allChecks = settings.getPreviousClangTidyChecks();
        ActionListener browseButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (settings.getUseExternalClangTidy()) {
                    ((MessageDialogBuilder.Message)new MessageDialogBuilder.Message(ClangdBundle.message("clang.tidy.checks.dialog.title", new Object[0]), ClangdBundle.message("configurable.clangTidy.checks.button.not.available", new Object[0])).buttons(new String[]{IdeBundle.message((String)"button.ok", (Object[])new Object[0])}).icon(UIUtil.getInformationIcon())).show(null, null);
                } else {
                    InspectionChecksDialog dialog = new InspectionChecksDialog(ContainerUtil.notNullize((Set)allChecks), ClangTidyInspection.this.getClangTidyChecks(), ClangdBundle.message("clang.tidy.checks.dialog.title", new Object[0]), ClangTidyInspection.this, new ClangTidyInspectionDescriptionProvider(), null);
                    dialog.showAndGet();
                    checksField.setText(ClangTidyInspection.this.myClangTidyChecks);
                }
            }
        };
        ComponentWithBrowseButton component = new ComponentWithBrowseButton((JComponent)checksField, browseButtonListener);
        component.setButtonIcon(AllIcons.Actions.Edit);
        component.getButton().setToolTipText(ClangdBundle.message("configurable.clangTidy.checks.button", new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 64)) + ")");
        ComponentWithBrowseButton componentWithBrowseButton = component;
        if (componentWithBrowseButton == null) {
            ClangTidyInspection.$$$reportNull$$$0(21);
        }
        return componentWithBrowseButton;
    }

    @NotNull
    private RawCommandLineEditor createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.getTextField().setFont(EditorUtil.getEditorFont((int)JBUI.Fonts.label().getSize()));
        checksEditor.setText(StringUtil.trim((String)this.myClangTidyChecks));
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ClangTidyInspection.this.myClangTidyChecks = StringUtil.trim((String)checksEditor.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/inspections/ClangTidyInspection$4", "textChanged"));
            }
        });
        RawCommandLineEditor rawCommandLineEditor = checksEditor;
        if (rawCommandLineEditor == null) {
            ClangTidyInspection.$$$reportNull$$$0(22);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel();
        hint.setFontSize(UIUtil.FontSize.SMALL);
        hint.setTextWithHyperlink(ClangdBundle.message("configurable.clangTidy.checks.hint", new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        HyperlinkLabel hyperlinkLabel = hint;
        if (hyperlinkLabel == null) {
            ClangTidyInspection.$$$reportNull$$$0(23);
        }
        return hyperlinkLabel;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(24);
        }
        if (manager == null) {
            ClangTidyInspection.$$$reportNull$$$0(25);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(26);
        }
        if (context == null) {
            ClangTidyInspection.$$$reportNull$$$0(27);
        }
        if (manager == null) {
            ClangTidyInspection.$$$reportNull$$$0(28);
        }
        ClangTidyInspectionAnnotatorExecutionConfig executionConfig = new ClangTidyInspectionAnnotatorExecutionConfig(this);
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(executionConfig);
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
        if (problemDescriptorArray == null) {
            ClangTidyInspection.$$$reportNull$$$0(29);
        }
        return problemDescriptorArray;
    }

    @Override
    public boolean isPreferClangTidyFilesOverIDESettings() {
        return this.myPreferClangTidyFilesOverIDESettings;
    }

    public void setPreferClangTidyFilesOverIDESettings(boolean preferClangTidyFilesOverIDESettings) {
        this.myPreferClangTidyFilesOverIDESettings = preferClangTidyFilesOverIDESettings;
    }

    @NotNull
    public String getClangTidyChecks() {
        return !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        if (clangTidyChecks == null) {
            ClangTidyInspection.$$$reportNull$$$0(30);
        }
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        String string = StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String getAllEnabledChecks() {
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        return "-*";
    }

    private static List<String> getDefaultChecksConfiguration() {
        return List.of("-*", "bugprone-argument-comment", "bugprone-assert-side-effect", "bugprone-bad-signal-to-kill-thread", "bugprone-branch-clone", "bugprone-copy-constructor-init", "bugprone-dangling-handle", "bugprone-dynamic-static-initializers", "bugprone-fold-init-type", "bugprone-forward-declaration-namespace", "bugprone-forwarding-reference-overload", "bugprone-inaccurate-erase", "bugprone-incorrect-roundings", "bugprone-integer-division", "bugprone-lambda-function-name", "bugprone-macro-parentheses", "bugprone-macro-repeated-side-effects", "bugprone-misplaced-operator-in-strlen-in-alloc", "bugprone-misplaced-pointer-arithmetic-in-alloc", "bugprone-misplaced-widening-cast", "bugprone-move-forwarding-reference", "bugprone-multiple-statement-macro", "bugprone-no-escape", "bugprone-parent-virtual-call", "bugprone-posix-return", "bugprone-reserved-identifier", "bugprone-sizeof-container", "bugprone-sizeof-expression", "bugprone-spuriously-wake-up-functions", "bugprone-string-constructor", "bugprone-string-integer-assignment", "bugprone-string-literal-with-embedded-nul", "bugprone-suspicious-enum-usage", "bugprone-suspicious-include", "bugprone-suspicious-memset-usage", "bugprone-suspicious-missing-comma", "bugprone-suspicious-semicolon", "bugprone-suspicious-string-compare", "bugprone-suspicious-memory-comparison", "bugprone-suspicious-realloc-usage", "bugprone-swapped-arguments", "bugprone-terminating-continue", "bugprone-throw-keyword-missing", "bugprone-too-small-loop-variable", "bugprone-undefined-memory-manipulation", "bugprone-undelegated-constructor", "bugprone-unhandled-self-assignment", "bugprone-unused-raii", "bugprone-unused-return-value", "bugprone-use-after-move", "bugprone-virtual-near-miss", "cert-dcl21-cpp", "cert-dcl58-cpp", "cert-err34-c", "cert-err52-cpp", "cert-err60-cpp", "cert-flp30-c", "cert-msc50-cpp", "cert-msc51-cpp", "cert-str34-c", "cppcoreguidelines-interfaces-global-init", "cppcoreguidelines-narrowing-conversions", "cppcoreguidelines-pro-type-member-init", "cppcoreguidelines-pro-type-static-cast-downcast", "cppcoreguidelines-slicing", "google-default-arguments", "google-explicit-constructor", "google-runtime-operator", "hicpp-exception-baseclass", "hicpp-multiway-paths-covered", "misc-misplaced-const", "misc-new-delete-overloads", "misc-no-recursion", "misc-non-copyable-objects", "misc-throw-by-value-catch-by-reference", "misc-unconventional-assign-operator", "misc-uniqueptr-reset-release", "modernize-avoid-bind", "modernize-concat-nested-namespaces", "modernize-deprecated-headers", "modernize-deprecated-ios-base-aliases", "modernize-loop-convert", "modernize-make-shared", "modernize-make-unique", "modernize-pass-by-value", "modernize-raw-string-literal", "modernize-redundant-void-arg", "modernize-replace-auto-ptr", "modernize-replace-disallow-copy-and-assign-macro", "modernize-replace-random-shuffle", "modernize-return-braced-init-list", "modernize-shrink-to-fit", "modernize-unary-static-assert", "modernize-use-auto", "modernize-use-bool-literals", "modernize-use-emplace", "modernize-use-equals-default", "modernize-use-equals-delete", "modernize-use-nodiscard", "modernize-use-noexcept", "modernize-use-nullptr", "modernize-use-override", "modernize-use-transparent-functors", "modernize-use-uncaught-exceptions", "mpi-buffer-deref", "mpi-type-mismatch", "openmp-use-default-none", "performance-faster-string-find", "performance-for-range-copy", "performance-implicit-conversion-in-loop", "performance-inefficient-algorithm", "performance-inefficient-string-concatenation", "performance-inefficient-vector-operation", "performance-move-const-arg", "performance-move-constructor-init", "performance-no-automatic-move", "performance-noexcept-move-constructor", "performance-trivially-destructible", "performance-type-promotion-in-math-fn", "performance-unnecessary-copy-initialization", "performance-unnecessary-value-param", "portability-simd-intrinsics", "readability-avoid-const-params-in-decls", "readability-const-return-type", "readability-container-size-empty", "readability-convert-member-functions-to-static", "readability-delete-null-pointer", "readability-deleted-default", "readability-inconsistent-declaration-parameter-name", "readability-make-member-function-const", "readability-misleading-indentation", "readability-misplaced-array-index", "readability-non-const-parameter", "readability-redundant-control-flow", "readability-redundant-declaration", "readability-redundant-function-ptr-dereference", "readability-redundant-smartptr-get", "readability-redundant-string-cstr", "readability-redundant-string-init", "readability-simplify-subscript-expr", "readability-static-accessed-through-instance", "readability-static-definition-in-anonymous-namespace", "readability-string-compare", "readability-uniqueptr-delete-release", "readability-use-anyofallof");
    }

    private static Collection<String> getAllAvailableGroups() {
        ClangTidySettings settings = ClangTidySettings.getInstance();
        Set<String> allChecks = settings.getPreviousClangTidyChecks();
        HashSet<String> groups = new HashSet<String>();
        for (String check : allChecks) {
            groups.add(CommonClangTidyUtil.getGroupName(check));
        }
        return groups;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26, 27, 28, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyMessage";
                break;
            }
            case 6: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyChecks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangTidyFilesCheckbox";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsButton";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksComponent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksField";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksExampleLink";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChecks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeDisabledByClangTidyCheckName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "disableGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableAllChecksInGroup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enableAllChecksInGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enableCheck";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disableCheck";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsButton";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26, 27, 28, 30 -> new IllegalArgumentException(string);
        };
    }
}

