/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlDataKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.Note;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticMessage;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlReplacement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u001e\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001e0\u001eH\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticV2;", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnostic;", "()V", "DiagnosticMessage", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticMessage;", "DiagnosticName", "", "Notes", "", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/Note;", "addOffsets", "", "fileToByteOffset", "", "Ljava/util/SortedSet;", "", "appliedToSourceFile", "", "sourceFilePath", "fixWSLPaths", "converter", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;", "isSuppressed", "isValid", "mapOverlaysToSourceFiles", "overlayMapping", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/OverlayMapping;", "toClangTidyDiagnostic", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyDiagnostic;", "byteToCharOffsetMap", "", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangTidyYamlData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangTidyYamlData.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1726#2,3:289\n1855#2,2:292\n1855#2,2:294\n1549#2:296\n1620#2,3:297\n1855#2,2:300\n*S KotlinDebug\n*F\n+ 1 ClangTidyYamlData.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticV2\n*L\n99#1:289,3\n106#1:292,2\n118#1:294,2\n127#1:296\n127#1:297,3\n136#1:300,2\n*E\n"})
public class YamlDiagnosticV2
extends YamlDiagnostic {
    @JvmField
    @Nullable
    public String DiagnosticName;
    @JvmField
    @Nullable
    public YamlDiagnosticMessage DiagnosticMessage;
    @JvmField
    @Nullable
    public List<Note> Notes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        YamlReplacement it;
        CharSequence charSequence = this.DiagnosticName;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        if (this.DiagnosticMessage == null) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
        charSequence = yamlDiagnosticMessage.FilePath;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage2);
        charSequence = yamlDiagnosticMessage2.Message;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage3);
        if (yamlDiagnosticMessage3.FileOffset < 0) return false;
        YamlDiagnosticMessage yamlDiagnosticMessage4 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage4);
        if (yamlDiagnosticMessage4.Replacements == null) return true;
        YamlDiagnosticMessage yamlDiagnosticMessage5 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage5);
        List<YamlReplacement> list = yamlDiagnosticMessage5.Replacements;
        Intrinsics.checkNotNull(list);
        Iterable $this$all$iv = list;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (YamlReplacement)element$iv;
            boolean bl4 = false;
        } while (it.isValid());
        return false;
    }

    @Override
    public boolean isSuppressed() {
        String string = this.DiagnosticName;
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.startsWith$default((String)string, (String)"clang-diagnostic", (boolean)false, (int)2, null);
    }

    @Override
    public void fixWSLPaths(@NotNull ClangUrlConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        Intrinsics.checkNotNull((Object)this.DiagnosticMessage);
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
        String string = yamlDiagnosticMessage.FilePath;
        Intrinsics.checkNotNull((Object)string);
        this.DiagnosticMessage.FilePath = converter.fromWslPath(string);
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage2);
        List<YamlReplacement> list = yamlDiagnosticMessage2.Replacements;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YamlReplacement it = (YamlReplacement)element$iv;
            boolean bl = false;
            it.fixWSLPaths(converter);
        }
    }

    @Override
    public boolean appliedToSourceFile(@NotNull String sourceFilePath) {
        Intrinsics.checkNotNullParameter((Object)sourceFilePath, (String)"sourceFilePath");
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
        return FileUtil.pathsEqual((String)FileUtil.toCanonicalPath((String)yamlDiagnosticMessage.FilePath), (String)sourceFilePath);
    }

    @Override
    public void mapOverlaysToSourceFiles(@NotNull OverlayMapping overlayMapping) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)overlayMapping, (String)"overlayMapping");
            YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
            Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
            String string = yamlDiagnosticMessage.FilePath;
            Intrinsics.checkNotNull((Object)string);
            File diagnosticFile = new File(string);
            if (overlayMapping.hasSourceFile(diagnosticFile)) {
                Intrinsics.checkNotNull((Object)this.DiagnosticMessage);
                File file = overlayMapping.getSourceFile(diagnosticFile);
                Intrinsics.checkNotNull((Object)file);
                this.DiagnosticMessage.FilePath = file.getPath();
            }
            YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
            Intrinsics.checkNotNull((Object)yamlDiagnosticMessage2);
            List<YamlReplacement> list = yamlDiagnosticMessage2.Replacements;
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                Intrinsics.checkNotNull((Object)string2);
                File replacementFile = new File(string2);
                if (!overlayMapping.hasSourceFile(replacementFile)) continue;
                File file = overlayMapping.getSourceFile(replacementFile);
                Intrinsics.checkNotNull((Object)file);
                it.FilePath = file.getPath();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ClangTidyDiagnostic toClangTidyDiagnostic(@NotNull Map<String, ? extends Map<Integer, Integer>> byteToCharOffsetMap) {
        List list;
        Intrinsics.checkNotNullParameter(byteToCharOffsetMap, (String)"byteToCharOffsetMap");
        Object object = this.DiagnosticMessage;
        if (object != null && (object = ((YamlDiagnosticMessage)object).Replacements) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                YamlReplacement yamlReplacement = (YamlReplacement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toClangTidyReplacement(byteToCharOffsetMap));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List replacements = list;
        YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
        String string = yamlDiagnosticMessage.FilePath;
        Intrinsics.checkNotNull((Object)string);
        YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage2);
        int offset = ClangTidyYamlDataKt.access$getCharOffset(string, yamlDiagnosticMessage2.FileOffset, byteToCharOffsetMap);
        YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage3);
        String string2 = yamlDiagnosticMessage3.Message;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = this.DiagnosticName;
        Intrinsics.checkNotNull((Object)string3);
        YamlDiagnosticMessage yamlDiagnosticMessage4 = this.DiagnosticMessage;
        Intrinsics.checkNotNull((Object)yamlDiagnosticMessage4);
        String string4 = yamlDiagnosticMessage4.FilePath;
        Intrinsics.checkNotNull((Object)string4);
        return new ClangTidyDiagnostic(string2, string3, string4, offset, CollectionsKt.emptyList(), replacements, null);
    }

    @Override
    public void addOffsets(@NotNull Map<String, SortedSet<Integer>> fileToByteOffset) {
        block1: {
            Intrinsics.checkNotNullParameter(fileToByteOffset, (String)"fileToByteOffset");
            YamlDiagnosticMessage yamlDiagnosticMessage = this.DiagnosticMessage;
            Intrinsics.checkNotNull((Object)yamlDiagnosticMessage);
            String string = yamlDiagnosticMessage.FilePath;
            Intrinsics.checkNotNull((Object)string);
            YamlDiagnosticMessage yamlDiagnosticMessage2 = this.DiagnosticMessage;
            Intrinsics.checkNotNull((Object)yamlDiagnosticMessage2);
            ByteToCharOffsetMapBuilder.Companion.addOffset(string, yamlDiagnosticMessage2.FileOffset, fileToByteOffset);
            YamlDiagnosticMessage yamlDiagnosticMessage3 = this.DiagnosticMessage;
            Intrinsics.checkNotNull((Object)yamlDiagnosticMessage3);
            List<YamlReplacement> list = yamlDiagnosticMessage3.Replacements;
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                Intrinsics.checkNotNull((Object)string2);
                ByteToCharOffsetMapBuilder.Companion.addOffset(string2, it.Offset, fileToByteOffset);
                String string3 = it.FilePath;
                Intrinsics.checkNotNull((Object)string3);
                ByteToCharOffsetMapBuilder.Companion.addOffset(string3, it.Offset + it.Length, fileToByteOffset);
            }
        }
    }
}

