/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV1;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV2;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV3;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV4;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV1;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV2;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV3;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV4;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

public class ClangTidyYamlLoader {
    private static final Logger LOG = Logger.getInstance(ClangTidyYamlLoader.class);

    public List<ClangTidyDiagnostic> load(@NotNull String yamlContent, @NotNull String sourceFilePath, @NotNull OverlayMapping overlayMapping, @NotNull ClangUrlConverter converter) {
        ArrayList<YamlDiagnostic> diagnostics;
        if (yamlContent == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(0);
        }
        if (sourceFilePath == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(1);
        }
        if (overlayMapping == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(yamlContent = yamlContent.replaceAll("(\\V)\\n'", "$1\n\n'")))) {
            LOG.info("clang-tidy output is empty");
            return ContainerUtil.emptyList();
        }
        Ref yamlDataV4 = Ref.create();
        Ref yamlDataV3 = Ref.create();
        Ref yamlDataV2 = Ref.create();
        Ref yamlDataV1 = Ref.create();
        if (this.tryLoadYamlData(yamlContent, yamlDataV4, YamlDataV4.class, YamlDiagnosticV4.class)) {
            diagnostics = new ArrayList<YamlDiagnostic>(ContainerUtil.notNullize(((YamlDataV4)yamlDataV4.get()).Diagnostics));
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV3, YamlDataV3.class, YamlDiagnosticV3.class)) {
            diagnostics = new ArrayList(ContainerUtil.notNullize(((YamlDataV3)yamlDataV3.get()).Diagnostics));
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV2, YamlDataV2.class, YamlDiagnosticV2.class)) {
            diagnostics = new ArrayList(ContainerUtil.notNullize(((YamlDataV2)yamlDataV2.get()).Diagnostics));
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV1, YamlDataV1.class, YamlDiagnosticV1.class)) {
            diagnostics = new ArrayList(ContainerUtil.notNullize(((YamlDataV1)yamlDataV1.get()).Diagnostics));
        } else {
            LOG.error("clang-tidy output format is not recognized");
            return ContainerUtil.emptyList();
        }
        diagnostics.removeIf(d -> !d.isValid() || d.isSuppressed());
        if (converter.isWslMode()) {
            diagnostics.forEach(d -> d.fixWSLPaths(converter));
        }
        diagnostics.forEach(d -> d.mapOverlaysToSourceFiles(overlayMapping));
        diagnostics.removeIf(d -> !d.appliedToSourceFile(sourceFilePath));
        Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangTidyYamlLoader.createByteToCharOffsetMap(diagnostics, overlayMapping);
        return ContainerUtil.map(diagnostics, d -> d.toClangTidyDiagnostic(byteToCharOffsetMap));
    }

    private <T> boolean tryLoadYamlData(@NotNull String yamlContent, Ref<T> output, Class<T> outputClass, Class<?> diagnosticClass) {
        if (yamlContent == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(4);
        }
        try {
            CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(outputClass, this.getClass().getClassLoader(), new LoaderOptions());
            TypeDescription diagsDesc = new TypeDescription(outputClass);
            diagsDesc.addPropertyParameters("Diagnostics", new Class[]{diagnosticClass});
            constructor.addTypeDescription(diagsDesc);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            output.set(yaml.loadAs(yamlContent, outputClass));
            return output.get() != null;
        }
        catch (Exception e) {
            LOG.warn("Can't deserialize clang-tidy output of type " + outputClass.getSimpleName() + ": " + e.getMessage());
            return false;
        }
    }

    private static Map<String, Map<Integer, Integer>> createByteToCharOffsetMap(@NotNull List<YamlDiagnostic> diagnostics, @NotNull OverlayMapping overlayMapping) {
        if (diagnostics == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(5);
        }
        if (overlayMapping == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(6);
        }
        Set<String> unsavedFilePaths = overlayMapping.getSourceFiles().stream().map(file -> file.getPath()).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder = new ByteToCharOffsetMapBuilder();
        HashMap<String, SortedSet<Integer>> fileToByteOffset = new HashMap<String, SortedSet<Integer>>();
        for (YamlDiagnostic diagnostic : diagnostics) {
            diagnostic.addOffsets(fileToByteOffset);
        }
        return builder.createFor(fileToByteOffset, unsavedFilePaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlayMapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyYamlLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadYamlData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createByteToCharOffsetMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

