/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ClangTidyCheckOptionsProvider {
    @Nullable
    Project myProject;
    @NotNull
    private static final Logger LOG = Logger.getInstance(ClangTidyCheckOptionsProvider.class);

    public ClangTidyCheckOptionsProvider(@Nullable Project project) {
        this.myProject = project != null ? project : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
    }

    @NotNull
    public List<ClangTidyCheckOption> getAvailableOptions(@NotNull ProgressIndicator indicator) {
        List<ClangTidyCheckOption> list;
        if (indicator == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(0);
        }
        try {
            CompletableFuture<List<ClangTidyCheckOption>> future = this.getAvailableOptionsAsync(indicator);
            list = future.get();
        }
        catch (Exception e) {
            LOG.warn("Failed to get Clang-Tidy checks options", (Throwable)e);
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ClangTidyCheckOptionsProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (list == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public CompletableFuture<List<ClangTidyCheckOption>> getAvailableOptionsAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(3);
        }
        final File clangTidyPath = CommonClangTidyUtil.getClangTidyPath();
        final CompletableFuture<List<ClangTidyCheckOption>> future = new CompletableFuture<List<ClangTidyCheckOption>>();
        if (!clangTidyPath.exists()) {
            future.complete(ContainerUtil.emptyList());
            CompletableFuture<List<ClangTidyCheckOption>> completableFuture = future;
            if (completableFuture == null) {
                ClangTidyCheckOptionsProvider.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, ClangdBundle.message("clang.tidy.read.available.check.options.task.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    String output = ClangTidyCheckOptionsProvider.getProcessOutput(clangTidyPath, indicator);
                    future.complete(ClangTidyCheckOptionsProvider.loadOptionsFromYaml(output));
                }
                catch (Exception e) {
                    LOG.warn("Failed to get Clang-Tidy options", (Throwable)e);
                    future.completeExceptionally(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
        CompletableFuture<List<ClangTidyCheckOption>> completableFuture = future;
        if (completableFuture == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @NotNull
    private static List<ClangTidyCheckOption> loadOptionsFromYaml(@Nullable String outputText) {
        ArrayList<ClangTidyCheckOption> arrayList;
        Map yamlData;
        block14: {
            if (StringUtil.isEmpty((String)outputText)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    ClangTidyCheckOptionsProvider.$$$reportNull$$$0(6);
                }
                return list;
            }
            Yaml yaml = new Yaml();
            yamlData = (Map)yaml.load(outputText);
            if (yamlData.containsKey("CheckOptions")) break block14;
            LOG.warn("The output doesn't contain CheckOptions property");
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ClangTidyCheckOptionsProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        try {
            ArrayList<ClangTidyCheckOption> options = new ArrayList<ClangTidyCheckOption>();
            Object checkOptionsRaw = yamlData.get("CheckOptions");
            if (checkOptionsRaw instanceof Map) {
                Map checkOptions = (Map)checkOptionsRaw;
                for (Map.Entry entry : checkOptions.entrySet()) {
                    ClangTidyCheckOption option = ClangTidyCheckOptionsProvider.createOptionFromKeyValuePair(entry.getKey(), entry.getValue());
                    if (option == null) continue;
                    options.add(option);
                }
            } else if (checkOptionsRaw instanceof ArrayList) {
                ArrayList checkOptions = (ArrayList)checkOptionsRaw;
                for (Object optionEntry : checkOptions) {
                    Map optionEntryMap;
                    ClangTidyCheckOption option;
                    if (!(optionEntry instanceof Map) || (option = ClangTidyCheckOptionsProvider.createOptionFromKeyValuePair((optionEntryMap = (Map)optionEntry).get("key"), optionEntryMap.get("value"))) == null) continue;
                    options.add(option);
                }
            } else {
                LOG.warn("Unknown type for CheckOptions property");
            }
            arrayList = options;
        }
        catch (Exception e) {
            LOG.warn("Can't deserialize Clang-Tidy checks options output", (Throwable)e);
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ClangTidyCheckOptionsProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (arrayList == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static ClangTidyCheckOption createOptionFromKeyValuePair(@Nullable Object key, @Nullable Object value) {
        if (!(key instanceof String) || !(value instanceof String)) {
            String keyClass = key != null ? key.getClass().getSimpleName() : "<null>";
            String valueClass = value != null ? value.getClass().getSimpleName() : "<null>";
            LOG.warn("Unknown type for check option property. Actual key type: " + keyClass + ", value type: " + valueClass);
            return null;
        }
        return new ClangTidyCheckOption((String)key, (String)value);
    }

    @Nullable
    private static String getProcessOutput(@NotNull File clangTidyPath, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (clangTidyPath == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            ClangTidyCheckOptionsProvider.$$$reportNull$$$0(11);
        }
        CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{clangTidyPath.getPath(), "-checks=*", "--dump-config"}));
        ProcessOutput output = processHandler.runProcessWithProgressIndicator(indicator);
        boolean notEmptyStderr = StringUtil.isNotEmpty((String)output.getStderr());
        if (output.getExitCode() != 0 || notEmptyStderr) {
            LOG.warn("Failed to get Clang-Tidy checks options: process exited with " + output.getExitCode() + " code" + (notEmptyStderr ? " with not empty stderr" : ""));
            return null;
        }
        return output.getStdout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyCheckOptionsProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableOptionsAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOptionsFromYaml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableOptions";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableOptionsAsync";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

