/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J:\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010JF\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J \u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder;", "", "()V", "createByteToCharMap", "", "", "byteOffsets", "Ljava/util/SortedSet;", "contentInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "createFor", "", "errors", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangTidyError;", "unsavedFilePaths", "", "fileToByteOffset", "getContentInfo", "filePath", "Companion", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nByteToCharOffsetMapBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteToCharOffsetMapBuilder.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n125#2:110\n152#2,3:111\n1747#3,3:114\n*S KotlinDebug\n*F\n+ 1 ByteToCharOffsetMapBuilder.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder\n*L\n41#1:110\n41#1:111,3\n77#1:114,3\n*E\n"})
public final class ByteToCharOffsetMapBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull List<? extends ClionClangTidyError> errors, @NotNull Collection<String> unsavedFilePaths) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        HashMap fileToByteOffset = new HashMap();
        for (ClionClangTidyError clionClangTidyError : errors) {
            String string = clionClangTidyError.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
            Companion.addOffset(string, clionClangTidyError.getFileOffset(), fileToByteOffset);
            if (clionClangTidyError.getReplacements() != null) {
                for (ClionClangTidyReplacement replacement : clionClangTidyError.getReplacements()) {
                    String string2 = replacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(...)");
                    Companion.addOffset(string2, replacement.getOffset(), fileToByteOffset);
                    String string3 = replacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFilePath(...)");
                    Companion.addOffset(string3, replacement.getOffset() + replacement.getLength(), fileToByteOffset);
                }
            }
            if (clionClangTidyError.getRanges() == null) continue;
            for (ClangTidyRange range : clionClangTidyError.getRanges()) {
                String string4 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFilePath(...)");
                if (!(((CharSequence)string4).length() > 0)) continue;
                String string5 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFilePath(...)");
                Companion.addOffset(string5, range.getFileOffset(), fileToByteOffset);
                String string6 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFilePath(...)");
                Companion.addOffset(string6, range.getFileOffset() + range.getLength(), fileToByteOffset);
            }
        }
        return this.createFor(fileToByteOffset, unsavedFilePaths);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull Map<String, ? extends SortedSet<Integer>> fileToByteOffset, @NotNull Collection<String> unsavedFilePaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileToByteOffset, (String)"fileToByteOffset");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        Map<String, ? extends SortedSet<Integer>> $this$map$iv = fileToByteOffset;
        boolean $i$f$map = false;
        Map<String, ? extends SortedSet<Integer>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String filePath = (String)it.getKey();
            SortedSet byteOffsets = (SortedSet)it.getValue();
            Companion.ContentInfo contentInfo = this.getContentInfo(filePath, unsavedFilePaths);
            collection.add(TuplesKt.to((Object)filePath, this.createByteToCharMap(byteOffsets, contentInfo)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Map<Integer, Integer> createByteToCharMap(SortedSet<Integer> byteOffsets, Companion.ContentInfo contentInfo) {
        if (contentInfo == null) {
            return MapsKt.emptyMap();
        }
        HashMap byteToCharMap = new HashMap();
        int lastCharOffset = 0;
        int lastByteOffset = contentInfo.getBomLength();
        for (Integer byteOffset : byteOffsets) {
            String sliceWithUnifiedSeparators;
            Intrinsics.checkNotNull((Object)byteOffset);
            if (byteOffset > contentInfo.getContent().length) break;
            int sliceLength = Math.max(0, byteOffset - lastByteOffset);
            String slice = new String(contentInfo.getContent(), lastByteOffset, sliceLength, contentInfo.getEncoding());
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.convertLineSeparators((String)slice), (String)"convertLineSeparators(...)");
            int charOffset = lastCharOffset + sliceWithUnifiedSeparators.length();
            Integer n = charOffset;
            ((Map)byteToCharMap).put(byteOffset, n);
            lastCharOffset = charOffset;
            lastByteOffset = byteOffset;
        }
        return byteToCharMap;
    }

    private final Companion.ContentInfo getContentInfo(String filePath, Collection<String> unsavedFilePaths) {
        Document document2;
        VirtualFile virtualFile;
        boolean bl;
        FileDocumentManager manager;
        block6: {
            if (((CharSequence)filePath).length() == 0) {
                return null;
            }
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            manager = fileDocumentManager;
            Iterable $this$any$iv = unsavedFilePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!FileUtil.pathsEqual((String)it, (String)filePath)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl && (virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) != null && (document2 = (Document)ActionsKt.runReadAction((Function0)((Function0)new Function0<Document>(manager, virtualFile){
            final /* synthetic */ FileDocumentManager $manager;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$manager = $manager;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            @Nullable
            public final Document invoke() {
                return this.$manager.getDocument(this.$virtualFile);
            }
        }))) != null) {
            Charset documentEncoding = Charsets.UTF_8;
            byte[] content2 = (byte[])ActionsKt.runReadAction((Function0)((Function0)new Function0<byte[]>(document2, documentEncoding){
                final /* synthetic */ Document $document;
                final /* synthetic */ Charset $documentEncoding;
                {
                    this.$document = $document;
                    this.$documentEncoding = $documentEncoding;
                    super(0);
                }

                @NotNull
                public final byte[] invoke() {
                    String string = this.$document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = string;
                    byte[] byArray = string2.getBytes(this.$documentEncoding);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    return byArray;
                }
            }));
            return new Companion.ContentInfo(content2, documentEncoding, ByteToCharOffsetMapBuilder.Companion.getBomLength(content2, documentEncoding));
        }
        virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        byte[] content3 = FileUtil.loadFileBytes((File)new File(filePath));
        Intrinsics.checkNotNull((Object)content3);
        Charset charset = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        Charset charset2 = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"getCharset(...)");
        return new Companion.ContentInfo(content3, charset, ByteToCharOffsetMapBuilder.Companion.getBomLength(content3, charset2));
    }

    @JvmStatic
    public static final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
        Companion.addOffset(filePath, offset, result);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion;", "", "()V", "addOffset", "", "filePath", "", "offset", "", "result", "", "Ljava/util/SortedSet;", "getBomLength", "content", "", "encoding", "Ljava/nio/charset/Charset;", "ContentInfo", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        private final int getBomLength(byte[] content2, Charset encoding) {
            return CharsetToolkit.getBOMLength((byte[])content2, (Charset)encoding);
        }

        @JvmStatic
        public final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (!result.containsKey(filePath)) {
                result.put(filePath, new TreeSet());
            }
            SortedSet<Integer> sortedSet = result.get(filePath);
            Intrinsics.checkNotNull(sortedSet);
            sortedSet.add(offset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "", "content", "", "encoding", "Ljava/nio/charset/Charset;", "bomLength", "", "([BLjava/nio/charset/Charset;I)V", "getBomLength", "()I", "getContent", "()[B", "getEncoding", "()Ljava/nio/charset/Charset;", "intellij.c.clangd"})
        private static final class ContentInfo {
            @NotNull
            private final byte[] content;
            @NotNull
            private final Charset encoding;
            private final int bomLength;

            public ContentInfo(@NotNull byte[] content2, @NotNull Charset encoding, int bomLength) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
                this.content = content2;
                this.encoding = encoding;
                this.bomLength = bomLength;
            }

            @NotNull
            public final byte[] getContent() {
                return this.content;
            }

            @NotNull
            public final Charset getEncoding() {
                return this.encoding;
            }

            public final int getBomLength() {
                return this.bomLength;
            }
        }
    }
}

