/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.BuildPreambleError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0013H\u0002J\u0015\u0010\u0014\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u0015\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J)\u0010\u0016\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0017\u001a\u00020\u00062\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002J\u0013\u0010\u0018\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdInfoPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "indexerStatus", "", "getIndexerStatus", "()Ljava/lang/String;", "setIndexerStatus", "(Ljava/lang/String;)V", "mainStatus", "getMainStatus", "setMainStatus", "getProject", "()Lcom/intellij/openapi/project/Project;", "copyableLabel", "Ljavax/swing/JTextPane;", "text", "Lcom/intellij/openapi/util/NlsSafe;", "makeClangdModulesLine", "makeCpp20ModulesLine", "makePidText", "status", "makePreambleStatsText", "intellij.c.clangd"})
public final class ClangdInfoPanel
extends ClangdPanelBase {
    @NotNull
    private final Project project;
    @NotNull
    private volatile String mainStatus;
    @NotNull
    private volatile String indexerStatus;

    /*
     * WARNING - void declaration
     */
    public ClangdInfoPanel(@NotNull Project project) {
        ClangLanguageService clangLanguageService;
        ClangLanguageService clangLanguageService2;
        void tablesPanel;
        JPanel jPanel;
        void cpp20PathPanel;
        JPanel jPanel2;
        void modulesPathPanel;
        JPanel jPanel3;
        void pidPanel;
        JPanel jPanel4;
        void preamblePanel;
        JPanel jPanel5;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainStatus = "Stopped";
        this.indexerStatus = "Stopped";
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        ClangLanguageService service = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        ClangLanguageServiceProvider clangLanguageServiceProvider2 = ClangLanguageServiceProvider.getProvider(this.project);
        ClangLanguageService indexer = clangLanguageServiceProvider2 != null ? clangLanguageServiceProvider2.getIfStartedIndexer() : null;
        ClangLanguageService clangLanguageService3 = service;
        if (!(clangLanguageService3 != null ? clangLanguageService3.getServerPid() == -1 : false)) {
            this.mainStatus = "Running";
        }
        ClangLanguageService clangLanguageService4 = indexer;
        if (!(clangLanguageService4 != null ? clangLanguageService4.getServerPid() == -1 : false)) {
            this.indexerStatus = "Running";
        }
        final JTextPane memoryLabel = this.copyableLabel("Memory usage info: N/A");
        final JTextPane preambleLabel = this.copyableLabel(this.makePreambleStatsText(this.project));
        final JTextPane pidLabel = this.copyableLabel(this.makePidText(this.project, this.mainStatus, this.indexerStatus));
        JTextPane modulesPathLabel = this.copyableLabel(this.makeClangdModulesLine(this.project));
        JTextPane cpp20ModulesPathLabel = this.copyableLabel(this.makeCpp20ModulesLine(this.project));
        AbstractTableModel perFileModel2 = new AbstractTableModel(){
            @NotNull
            private List<ClangMemoryUsageInfo.PerFile> perFile;
            {
                this.perFile = CollectionsKt.emptyList();
            }

            @NotNull
            public final List<ClangMemoryUsageInfo.PerFile> getPerFile() {
                return this.perFile;
            }

            public final void setPerFile(@NotNull List<ClangMemoryUsageInfo.PerFile> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.perFile = list;
            }

            public int getRowCount() {
                return this.perFile.size();
            }

            public int getColumnCount() {
                return 2;
            }

            @Nullable
            public String getValueAt(int rowIndex, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> this.perFile.get(rowIndex).getPath();
                    case 1 -> ClangdInfoPanelKt.access$kb2Mb(this.perFile.get(rowIndex).getKb());
                    default -> null;
                };
            }
        };
        AbstractTableModel perModuleModel2 = new AbstractTableModel(){
            @NotNull
            private List<Pair<String, Integer>> perModule;
            {
                this.perModule = CollectionsKt.emptyList();
            }

            @NotNull
            public final List<Pair<String, Integer>> getPerModule() {
                return this.perModule;
            }

            public final void setPerModule(@NotNull List<Pair<String, Integer>> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.perModule = list;
            }

            public int getRowCount() {
                return this.perModule.size();
            }

            public int getColumnCount() {
                return 2;
            }

            @Nullable
            public String getValueAt(int rowIndex, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> (String)this.perModule.get(rowIndex).getFirst();
                    case 1 -> String.valueOf(((Number)this.perModule.get(rowIndex).getSecond()).intValue());
                    default -> null;
                };
            }
        };
        JBTable modulesTable = new JBTable((TableModel)perModuleModel2);
        JBTable table = new JBTable((TableModel)perFileModel2);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)memoryLabel, "First");
        JPanel jPanel6 = jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel7 = centerPanel;
        boolean bl = false;
        preamblePanel.add((Component)preambleLabel, "First");
        JPanel jPanel8 = jPanel4 = new JPanel(new BorderLayout());
        void var19_20 = preamblePanel;
        boolean bl2 = false;
        pidPanel.add((Component)pidLabel, "First");
        JPanel jPanel9 = jPanel3 = new JPanel(new BorderLayout());
        void var23_24 = pidPanel;
        boolean bl3 = false;
        modulesPathPanel.add((Component)modulesPathLabel, "First");
        JPanel jPanel10 = jPanel2 = new JPanel(new BorderLayout());
        void var27_28 = modulesPathPanel;
        boolean bl4 = false;
        cpp20PathPanel.add((Component)cpp20ModulesPathLabel, "First");
        JPanel jPanel11 = jPanel = new JPanel();
        void var31_32 = cpp20PathPanel;
        boolean bl5 = false;
        tablesPanel.setLayout(new BoxLayout((Container)tablesPanel, 3));
        JLabel modulesLabel = new JLabel(ClangdBundle.message("language.cpp.clangd.info.panel.per.module.label", new Object[0]));
        modulesLabel.setAlignmentX(0.0f);
        JLabel filesLabel = new JLabel(ClangdBundle.message("language.cpp.clangd.info.panel.per.file.label", new Object[0]));
        filesLabel.setAlignmentX(0.0f);
        modulesTable.setAlignmentX(0.0f);
        table.setAlignmentX(0.0f);
        tablesPanel.add(modulesLabel);
        tablesPanel.add((Component)modulesTable);
        tablesPanel.add(filesLabel);
        tablesPanel.add((Component)table);
        var31_32.add(jPanel);
        var27_28.add(jPanel2);
        var23_24.add(jPanel3);
        var19_20.add(jPanel4);
        jPanel7.add((Component)jPanel5, "Center");
        this.add(centerPanel);
        ClangLanguageService clangLanguageService5 = service;
        if (clangLanguageService5 != null && (clangLanguageService5 = clangLanguageService5.getMessageBus()) != null && (clangLanguageService5 = clangLanguageService5.connect(this)) != null) {
            Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            clangLanguageService5.subscribe(topic, new ClangServerListener(perFileModel2, table){
                final /* synthetic */ perFileModel.1 $perFileModel;
                final /* synthetic */ JBTable $table;
                {
                    this.$perFileModel = $perFileModel;
                    this.$table = $table;
                }

                @Override
                public void onServerRunning() {
                    this.setMainStatus("Running");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }

                @Override
                public void onServerFailure() {
                    this.setMainStatus("Failure");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }

                @Override
                public void onServerShutDown() {
                    this.setMainStatus("Shut Down");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }

                @Override
                public void onMemoryUsageInfoReceived(@NotNull ClangMemoryUsageInfo info) {
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    memoryLabel.setText("Memory usage info: working set: " + ClangdInfoPanelKt.access$kb2Mb(info.getWorkingSet()) + ", drafts: " + ClangdInfoPanelKt.access$kb2Mb(info.getDrafts()) + ", unsaved: " + ClangdInfoPanelKt.access$kb2Mb(info.getUnsaved()));
                    this.$perFileModel.setPerFile(info.getPerFile());
                    this.$table.updateUI();
                }
            });
        }
        if ((clangLanguageService2 = indexer) != null && (clangLanguageService2 = clangLanguageService2.getMessageBus()) != null && (clangLanguageService2 = clangLanguageService2.connect(this)) != null) {
            Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            clangLanguageService2.subscribe(topic, new ClangServerListener(){

                @Override
                public void onServerRunning() {
                    this.setIndexerStatus("Running");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }

                @Override
                public void onServerFailure() {
                    this.setIndexerStatus("Failure");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }

                @Override
                public void onServerShutDown() {
                    this.setIndexerStatus("Shut Down");
                    pidLabel.setText(this.makePidText(this.getProject(), this.getMainStatus(), this.getIndexerStatus()));
                }
            });
        }
        if ((clangLanguageService = service) != null && (clangLanguageService = clangLanguageService.getMessageBus()) != null && (clangLanguageService = clangLanguageService.connect(this)) != null) {
            Topic<ClangTelemetryListener> topic = ClangTelemetryListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            clangLanguageService.subscribe(topic, new ClangTelemetryListener(perModuleModel2, modulesTable){
                final /* synthetic */ perModuleModel.1 $perModuleModel;
                final /* synthetic */ JBTable $modulesTable;
                {
                    this.$perModuleModel = $perModuleModel;
                    this.$modulesTable = $modulesTable;
                }

                @Override
                public void onPreambleTelemetry(@NotNull ClangTelemetry telemetry) {
                    Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
                    preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
                }

                @Override
                public void onGeneralTelemetry(@NotNull ClangTelemetry telemetry) {
                    Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
                    ArrayList newPerModuleInfo = new ArrayList();
                    telemetry.getGeneralTelemetry().forEachCompiledModule((arg_0, arg_1) -> 4.onGeneralTelemetry$lambda$0(newPerModuleInfo, arg_0, arg_1));
                    this.$perModuleModel.setPerModule(newPerModuleInfo);
                    this.$modulesTable.updateUI();
                }

                private static final void onGeneralTelemetry$lambda$0(ArrayList $newPerModuleInfo, String name, Integer counter) {
                    Intrinsics.checkNotNullParameter((Object)$newPerModuleInfo, (String)"$newPerModuleInfo");
                    $newPerModuleInfo.add(new Pair((Object)name, (Object)counter));
                }
            });
        }
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getMainStatus() {
        return this.mainStatus;
    }

    public final void setMainStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mainStatus = string;
    }

    @NotNull
    public final String getIndexerStatus() {
        return this.indexerStatus;
    }

    public final void setIndexerStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indexerStatus = string;
    }

    @NotNull
    public final String makePreambleStatsText(@NotNull Project project) {
        ClangTelemetry telemetry;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
        String curFile = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getPath() : null;
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted(project);
        ClangTelemetry clangTelemetry = telemetry = clangLanguageService != null ? clangLanguageService.getTelemetry() : null;
        if (curFile != null && telemetry != null) {
            ClangPreambleTelemetry clangPreambleTelemetry = telemetry.getPreambleTelemetry();
            Intrinsics.checkNotNullExpressionValue((Object)clangPreambleTelemetry, (String)"getPreambleTelemetry(...)");
            ClangPreambleTelemetry preambleTelemetry = clangPreambleTelemetry;
            int preambleParses = preambleTelemetry.getPreambleParses(curFile);
            int preambleReuses = preambleTelemetry.getPreambleReuses(curFile);
            int preambleFailures = preambleTelemetry.getPreambleFailures(curFile);
            BuildPreambleError[] buildPreambleErrorArray = new BuildPreambleError[]{BuildPreambleError.DidntHitTargetFile};
            int preambleDidntHitTarget = preambleTelemetry.getPreambleFailures(curFile, buildPreambleErrorArray);
            int preambleCancels = preambleTelemetry.getPreambleCancels(curFile);
            return "Preamble [reparsed: " + (preambleParses - preambleCancels) + ", cancelled: " + preambleCancels + ", reused: " + preambleReuses + ", failed: " + preambleFailures + " (" + preambleDidntHitTarget + " didn't hit)]";
        }
        return "Preamble [reparsed: N/A, cancelled: N/A, reused: N/A, failed: N/A, empty: N/A]";
    }

    private final String makePidText(Project project, @Nls String status, @Nls String indexerStatus) {
        Object object;
        Integer indexerPid;
        Object object2 = ClangLanguageServiceProvider.getProvider(project);
        Integer pid = object2 != null && (object2 = object2.getIfStarted()) != null ? Integer.valueOf(object2.getServerPid()) : null;
        Object object3 = ClangLanguageServiceProvider.getProvider(project);
        Integer n = indexerPid = object3 != null && (object3 = object3.getIfStartedIndexer()) != null ? Integer.valueOf(object3.getServerPid()) : null;
        Object object4 = pid;
        if (object4 == null || (object4 = ((Integer)object4).toString()) == null) {
            object4 = "Unknown";
        }
        if ((object = indexerPid) == null || (object = ((Integer)object).toString()) == null) {
            object = "Unknown";
        }
        return "Clangd server PID: " + (String)object4 + " [" + status + "], Clangd indexer PID: " + (String)object + " [" + indexerStatus + "]";
    }

    private final String makeClangdModulesLine(Project project) {
        Object object = ClangLanguageServiceProvider.getProvider(project);
        return "Clangd modules path: " + (object != null && (object = object.getIfStarted()) != null ? object.getClangdModulesPath() : null);
    }

    private final String makeCpp20ModulesLine(Project project) {
        Object object = ClangLanguageServiceProvider.getProvider(project);
        return "C++20 modules path: " + (object != null && (object = object.getIfStarted()) != null ? object.getCpp20ModulesPath() : null);
    }

    private final JTextPane copyableLabel(String text) {
        JLabel label = new JLabel("Dummy");
        JTextPane pane = new JTextPane();
        pane.setPreferredSize(new Dimension(Integer.MAX_VALUE, label.getPreferredSize().height));
        pane.setContentType("text/html");
        pane.setEditable(false);
        pane.setBackground(null);
        pane.setBorder(null);
        pane.setText(text);
        return pane;
    }
}

