/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001aC\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\fH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018H\u0002\u001a\u001a\u0010 \u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "WHITESPACES", "Lkotlin/text/Regex;", "actWithService", "", "project", "Lcom/intellij/openapi/project/Project;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "isStateful", "block", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "Lkotlin/ParameterName;", "name", "service", "", "createIndexOptionsPanel", "Ljavax/swing/JComponent;", "getIfStartedIndexer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "printConsole", "message", "", "runIndexerCommand", "Ljava/util/concurrent/CompletableFuture;", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "showJsonInEditor", "text", "caption", "showNotification", "toOneLine", "s", "intellij.c.clangd"})
public final class ClangdIndexerPanelKt {
    @NotNull
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH.mm.ss.SSS");
    @NotNull
    private static final Regex WHITESPACES = new Regex("(\\n|\\r|\\s)+");

    @Nullable
    public static final ClangLanguageService getIfStartedIndexer(@NotNull Project project, boolean isStateful) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        if (clangLanguageServiceProvider == null) {
            return null;
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        if (isStateful) {
            return provider2.getIfStartedIndexer();
        }
        return provider2.getIfStartedStatelessIndexer();
    }

    private static final void printConsole(ConsoleView console, String message) {
        Function0 edt2 = (Function0)new Function0<Unit>(console, message){
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ String $message;
            {
                this.$console = $console;
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                this.$console.print(this.$message, ConsoleViewContentType.NORMAL_OUTPUT);
                this.$console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        };
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ClangdIndexerPanelKt.printConsole$lambda$0(edt2));
    }

    private static final String toOneLine(String s) {
        String string = StringUtil.shortenTextWithEllipsis((String)s, (int)320, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        CharSequence charSequence = string;
        Regex regex = WHITESPACES;
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }

    private static final void showJsonInEditor(Project project, String text, String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)JsonLanguage.INSTANCE, (CharSequence)text), true);
    }

    private static final void showNotification(Project project, @Nls String message) {
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("Clang Execute Command");
        group.createNotification(message, NotificationType.ERROR).notify(project);
    }

    private static final JComponent createIndexOptionsPanel(Project project) {
        Ref.ObjectRef dialogPanel = new Ref.ObjectRef();
        Ref.ObjectRef enableModulesCheck = new Ref.ObjectRef();
        dialogPanel.element = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((Ref.ObjectRef<JBCheckBox>)enableModulesCheck, project, (Ref.ObjectRef<DialogPanel>)dialogPanel){
            final /* synthetic */ Ref.ObjectRef<JBCheckBox> $enableModulesCheck;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef<DialogPanel> $dialogPanel;
            {
                this.$enableModulesCheck = $enableModulesCheck;
                this.$project = $project;
                this.$dialogPanel = $dialogPanel;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$enableModulesCheck, this.$project){
                    final /* synthetic */ Ref.ObjectRef<JBCheckBox> $enableModulesCheck;
                    final /* synthetic */ Project $project;
                    {
                        this.$enableModulesCheck = $enableModulesCheck;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.indexer.opt.modules", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.$enableModulesCheck.element = Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return ClangdSettings.getInstance(this.$project).getIndexerUseModules();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(boolean enabled) {
                                ClangdSettings.getInstance(this.$project).setIndexerUseModules(enabled);
                            }
                        })), (String)ClangdBundle.message("clangd.indexer.opt.modules.comment", new Object[0]), (int)0, null, (int)6, null).getComponent();
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.indexer.opt.dynamic.index", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return !ClangdSettings.getInstance(this.$project).getIndexerStaticOnly();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(boolean enabled) {
                                ClangdSettings.getInstance(this.$project).setIndexerStaticOnly(!enabled);
                            }
                        })), (String)ClangdBundle.message("clangd.indexer.opt.dynamic.index.comment", new Object[0]), (int)0, null, (int)6, null).getComponent();
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.indexer.opt.optimize.include.graph", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return ClangdSettings.getInstance(this.$project).getIndexerOptimizeIncludeGraph();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(boolean enabled) {
                                ClangdSettings.getInstance(this.$project).setIndexerOptimizeIncludeGraph(enabled);
                            }
                        })), (String)ClangdBundle.message("clangd.indexer.opt.optimize.include.graph.comment", new Object[0]), (int)0, null, (int)6, null).getComponent();
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.indexer.opt.progress", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return ClangdSettings.getInstance(this.$project).getIndexerShowProgress();
                            }
                        }), (Function1)((Function1)new Function1<Boolean, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(boolean enabled) {
                                ClangdSettings.getInstance(this.$project).setIndexerShowProgress(enabled);
                            }
                        })), (String)ClangdBundle.message("clangd.indexer.opt.progress.comment", new Object[0]), (int)0, null, (int)6, null).getComponent();
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$dialogPanel){
                    final /* synthetic */ Ref.ObjectRef<DialogPanel> $dialogPanel;
                    {
                        this.$dialogPanel = $dialogPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = ClangdBundle.message("clangd.indexer.apply", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.button(string, (Function1)new Function1<ActionEvent, Unit>(this.$dialogPanel){
                            final /* synthetic */ Ref.ObjectRef<DialogPanel> $dialogPanel;
                            {
                                this.$dialogPanel = $dialogPanel;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DialogPanel dialogPanel = (DialogPanel)this.$dialogPanel.element;
                                if (dialogPanel != null) {
                                    dialogPanel.apply();
                                }
                                ApplicationManager.getApplication().invokeLater(createIndexOptionsPanel.1::invoke$lambda$0, ModalityState.nonModal());
                            }

                            private static final void invoke$lambda$0() {
                                RegistryBooleanOptionDescriptor.suggestRestart(null);
                            }
                        });
                    }
                }), (int)1, null);
            }
        }));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic<ClangdSettingsListener> topic = ClangdSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangdSettingsListener((Ref.ObjectRef<JBCheckBox>)enableModulesCheck){
            final /* synthetic */ Ref.ObjectRef<JBCheckBox> $enableModulesCheck;
            {
                this.$enableModulesCheck = $enableModulesCheck;
            }

            public void onIndexerUseModulesChanged(boolean value) {
                JBCheckBox jBCheckBox = (JBCheckBox)this.$enableModulesCheck.element;
                if (!(jBCheckBox != null ? jBCheckBox.isSelected() == value : false)) {
                    JBCheckBox jBCheckBox2 = (JBCheckBox)this.$enableModulesCheck.element;
                    if (jBCheckBox2 != null) {
                        jBCheckBox2.setSelected(value);
                    }
                }
            }
        });
        return InspectionUiUtilKt.addScrollPaneIfNecessary((JComponent)((JComponent)dialogPanel.element));
    }

    private static final CompletableFuture<Boolean> runIndexerCommand(Project project, ConsoleView console, boolean isStateful, ClangIndexerCommand command) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!ClangdIndexerPanelKt.actWithService(project, console, isStateful, (Function1<? super ClangdIndexerService, Unit>)((Function1)new Function1<ClangdIndexerService, Unit>(command, console, result){
            final /* synthetic */ ClangIndexerCommand $command;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ CompletableFuture<Boolean> $result;
            {
                this.$command = $command;
                this.$console = $console;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull ClangdIndexerService it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.executeCommand(this.$command).whenComplete((arg_0, arg_1) -> runIndexerCommand.1.invoke$lambda$0((Function2)new Function2<Boolean, Throwable, Unit>(this.$console, this.$command, this.$result){
                    final /* synthetic */ ConsoleView $console;
                    final /* synthetic */ ClangIndexerCommand $command;
                    final /* synthetic */ CompletableFuture<Boolean> $result;
                    {
                        this.$console = $console;
                        this.$command = $command;
                        this.$result = $result;
                        super(2);
                    }

                    public final void invoke(Boolean res, Throwable ex) {
                        if (ex != null || res != null && !res.booleanValue()) {
                            this.$console.print(this.$command.getCommand() + ": failed\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(false);
                        } else {
                            this.$console.print(this.$command.getCommand() + ": success\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            this.$result.complete(true);
                        }
                    }
                }, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        }))) {
            result.complete(false);
        }
        return result;
    }

    private static final boolean actWithService(Project project, ConsoleView console, boolean isStateful, Function1<? super ClangdIndexerService, Unit> block) {
        ClangLanguageService service = ClangdIndexerPanelKt.getIfStartedIndexer(project, isStateful);
        if (service == null) {
            console.print("Service is not started yet!\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        if (!(service instanceof ClangdIndexerService)) {
            console.print("Service is not an instance of " + ClangdIndexerService.class.getSimpleName() + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return false;
        }
        block.invoke((Object)service);
        return true;
    }

    private static final void printConsole$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ JComponent access$createIndexOptionsPanel(Project project) {
        return ClangdIndexerPanelKt.createIndexOptionsPanel(project);
    }

    public static final /* synthetic */ CompletableFuture access$runIndexerCommand(Project project, ConsoleView console, boolean isStateful, ClangIndexerCommand command) {
        return ClangdIndexerPanelKt.runIndexerCommand(project, console, isStateful, command);
    }

    public static final /* synthetic */ SimpleDateFormat access$getDATE_FORMAT$p() {
        return DATE_FORMAT;
    }

    public static final /* synthetic */ String access$toOneLine(String s) {
        return ClangdIndexerPanelKt.toOneLine(s);
    }

    public static final /* synthetic */ void access$showJsonInEditor(Project project, String text, String caption) {
        ClangdIndexerPanelKt.showJsonInEditor(project, text, caption);
    }

    public static final /* synthetic */ void access$printConsole(ConsoleView console, String message) {
        ClangdIndexerPanelKt.printConsole(console, message);
    }

    public static final /* synthetic */ void access$showNotification(Project project, String message) {
        ClangdIndexerPanelKt.showNotification(project, message);
    }
}

