/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangChangeModuleMapActionKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangModifyModuleMapDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ModifyModuleMapParams;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangModifyModuleMapDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "params", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ModifyModuleMapParams;", "getParams", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ModifyModuleMapParams;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "send", "intellij.c.clangd"})
final class ClangModifyModuleMapDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    private DialogPanel panel;
    @NotNull
    private final ModifyModuleMapParams params;

    public ClangModifyModuleMapDialog(@NotNull Project project) {
        ClangLanguageService service;
        ClangLanguageServiceProvider provider2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.params = new ModifyModuleMapParams(null, 1, null);
        this.setTitle("Modify C/C++20 Module Map");
        ClangLanguageServiceProvider clangLanguageServiceProvider = provider2 = ClangLanguageServiceProvider.getProvider(this.project);
        ClangLanguageService clangLanguageService = service = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        if (service != null) {
            String string = VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getCpp20ModuleMapPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
            String url = string;
            String content2 = service.getContext().getRemoteWorkspace().apply(url, ClangModifyModuleMapDialog::_init_$lambda$0);
            String string2 = content2;
            if (string2 == null) {
                string2 = "";
            }
            this.params.setText(string2);
        }
        this.setOKButtonText("Send");
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ModifyModuleMapParams getParams() {
        return this.params;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ ClangModifyModuleMapDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ClangModifyModuleMapDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EditorTextField textEditor = new EditorTextField(this.this$0.getProject(), (FileType)PlainTextFileType.INSTANCE);
                        textEditor.setOneLineMode(false);
                        textEditor.setFontInheritedFromLAF(false);
                        textEditor.setFont(EditorUtil.getEditorFont());
                        $this$row.cell((JComponent)textEditor).align(Align.FILL).label("File text", LabelPosition.TOP).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0.getParams()){

                            @Nullable
                            public Object get() {
                                return ((ModifyModuleMapParams)this.receiver).getText();
                            }

                            public void set(@Nullable Object value) {
                                ((ModifyModuleMapParams)this.receiver).setText((String)value);
                            }
                        })));
                    }
                }), (int)1, null).resizableRow();
            }
        }));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangModifyModMapDimensions")) == null) {
            dimension = (Dimension)JBUI.size((int)640, (int)480);
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.send();
    }

    private final void send() {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        if (clangLanguageServiceProvider == null) {
            ClangChangeModuleMapActionKt.access$showNotification(this.project, "ClangLanguageServiceProvider not found");
            return;
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        ClangLanguageService clangLanguageService = provider2.getIfStarted();
        ClangdLanguageService clangdLanguageService = clangLanguageService instanceof ClangdLanguageService ? (ClangdLanguageService)clangLanguageService : null;
        if (clangdLanguageService == null) {
            ClangChangeModuleMapActionKt.access$showNotification(this.project, "ClangdLanguageService not found");
            return;
        }
        ClangdLanguageService service = clangdLanguageService;
        String string = VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getCpp20ModuleMapPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        String url = string;
        service.notifyDocumentChanged(url, this.params.getText());
    }

    private static final String _init_$lambda$0(RemoteWorkspaceFile wf) {
        return wf.getContent();
    }
}

