/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangScanLog;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyInspectionDescriptionProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionChecksDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangTidyUpdateStartupActivity
implements StartupActivity.DumbAware {
    private static final int TIMEOUT_IN_MS = 30000;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || !CommonClangTidyUtil.getBuiltinClangTidyPath().exists()) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, ClangdBundle.message("clang.tidy.check.for.update.task", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ClangTidySettings settings = ClangTidySettings.getInstance();
                Version actualClangTidyVersion = ClangTidyUpdateStartupActivity.getActualClangTidyVersion(indicator);
                if (actualClangTidyVersion == null) {
                    return;
                }
                Version previousClangTidyVersion = VersionUtil.parseVersion((String)StringUtil.notNullize((String)settings.getPreviousClangTidyVersion()), (Pattern[])new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
                Pair<Set<String>, Set<String>> tidyAndMisraChecks = ClangTidyUpdateStartupActivity.getActualClangTidyChecks(indicator);
                if (tidyAndMisraChecks == null) {
                    return;
                }
                Set actualClangTidyChecks = (Set)tidyAndMisraChecks.first;
                Set<String> previousClangTidyChecks = settings.getPreviousClangTidyChecks();
                ClangTidyUpdateStartupActivity.showNotificationOnUpdate(actualClangTidyVersion, previousClangTidyVersion, actualClangTidyChecks, previousClangTidyChecks, project);
                settings.setPreviousClangTidyVersion(actualClangTidyVersion.toString());
                settings.setPreviousClangTidyChecks(actualClangTidyChecks);
                settings.setAvailableMisraChecks((Set)tidyAndMisraChecks.second);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static void showNotificationOnUpdate(@NotNull Version actualClangTidyVersion, @Nullable Version previousClangTidyVersion, @NotNull Set<String> actualClangTidyChecks, @Nullable Set<String> previousClangTidyChecks, final @NotNull Project project) {
        if (actualClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(1);
        }
        if (actualClangTidyChecks == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(3);
        }
        if (previousClangTidyVersion == null || previousClangTidyChecks == null) {
            return;
        }
        if (!ClangTidyUpdateStartupActivity.isVersionUpdated(actualClangTidyVersion, previousClangTidyVersion)) {
            return;
        }
        final HashSet<String> newChecks = new HashSet<String>(actualClangTidyChecks);
        newChecks.removeAll(previousClangTidyChecks);
        if (newChecks.isEmpty()) {
            return;
        }
        if (CommonClangTidyUtil.getClangTidyInspection(null, project) == null) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Clang-Tidy Updated");
        Notification notification = notificationGroup.createNotification(ClangdBundle.message("clang.tidy.update.notification.title", new Object[0]), ClangTidyUpdateStartupActivity.getNotificationMessage(newChecks), NotificationType.INFORMATION);
        notification.addAction((AnAction)new DumbAwareAction(ClangdBundle.message("clang.tidy.update.review.new.checks.link", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ClangTidyUpdateStartupActivity.showInspectionChecksDialog(newChecks, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity$2", "actionPerformed"));
            }
        });
        notification.notify(project);
    }

    private static void showInspectionChecksDialog(@NotNull Set<String> newChecks, @NotNull Project project) {
        ClangTidyInspection inspection;
        if (newChecks == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(5);
        }
        ClangScanLog.LOG.assertTrue((inspection = CommonClangTidyUtil.getClangTidyInspection(null, project)) != null);
        InspectionChecksDialog dialog = new InspectionChecksDialog(newChecks, inspection.getClangTidyChecks(), ClangdBundle.message("clang.tidy.update.new.checks.dialog.title", new Object[0]), inspection, new ClangTidyInspectionDescriptionProvider(), project);
        dialog.showAndGet();
    }

    @NotNull
    @NlsContexts.NotificationContent
    private static String getNotificationMessage(@NotNull Collection<String> newChecks) {
        if (newChecks == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(6);
        }
        int howManyChecks = newChecks.size() == 1 ? 1 : 2;
        String string = ClangdBundle.message("clang.tidy.update.notification.message", newChecks.size(), howManyChecks);
        if (string == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean isVersionUpdated(@NotNull Version actualClangTidyVersion, @NotNull Version previousClangTidyVersion) {
        if (actualClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(8);
        }
        if (previousClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(9);
        }
        return previousClangTidyVersion.compareTo(actualClangTidyVersion) <= 0;
    }

    @Nullable
    private static Version getActualClangTidyVersion(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(10);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--version"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            return VersionUtil.parseVersion((String)output.getStdout().trim(), (Pattern[])new Pattern[]{CommonClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
        }
        catch (Exception e) {
            ClangScanLog.LOG.warn("Cannot get Clang-Tidy version", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Pair<Set<String>, Set<String>> getActualClangTidyChecks(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(11);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{CommonClangTidyUtil.getBuiltinClangTidyPath().getPath(), "--checks=*", "--list-checks"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            String[] outputLines = StringUtil.splitByLines((String)output.getStdout());
            HashSet<String> checks = new HashSet<String>();
            HashSet<String> misraChecks = new HashSet<String>();
            for (String line : outputLines) {
                String trimmedLine = line.trim();
                if (StringUtil.isEmpty((String)trimmedLine)) continue;
                if (StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"clion-")) {
                    if (!StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"clion-misra-")) continue;
                    misraChecks.add(trimmedLine);
                    continue;
                }
                if (StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"Enabled checks:")) continue;
                checks.add(trimmedLine);
            }
            return Pair.create(checks, misraChecks);
        }
        catch (Exception e) {
            ClangScanLog.LOG.warn("Cannot get Clang-Tidy checks", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClangTidyVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClangTidyChecks";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChecks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousClangTidyVersion";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationOnUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showInspectionChecksDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationMessage";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVersionUpdated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualClangTidyVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActualClangTidyChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

