/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangScanLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.InitialScanFinishedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanDocumentEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanFileSystemEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanIndexEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanPathEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.UpdateFromWorkspaceEvent;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0004\u001a\u00020\u0006J\b\u0010\u0018\u001a\u00020\fH\u0007R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangProjectScanStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/Disposable;", "()V", "isInitialScanFinished", "Lcom/intellij/openapi/util/Ref;", "", "kotlin.jvm.PlatformType", "myQueueProcessor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ClangScanEvent;", "connectClangServerListener", "", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "doExecute", "doScan", "scanEvent", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeAndWait", "waitForQueueProcessor", "intellij.c.clangd"})
public final class ClangProjectScanStartupActivity
implements ProjectActivity,
Disposable {
    @NotNull
    private final QueueProcessor<ClangScanEvent> myQueueProcessor = new QueueProcessor(arg_0 -> ClangProjectScanStartupActivity.myQueueProcessor$lambda$0((Function1)new Function1<ClangScanEvent, Unit>(this){
        final /* synthetic */ ClangProjectScanStartupActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull ClangScanEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ClangProjectScanStartupActivity.access$doScan(this.this$0, e);
        }
    }, arg_0));
    private Ref<Boolean> isInitialScanFinished = Ref.create((Object)false);

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        if (service == null) {
            MessageBusConnection connection = project.getMessageBus().connect();
            Topic<ClangLanguageServiceProviderListener> topic = ClangLanguageServiceProviderListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new ClangLanguageServiceProviderListener(this, project, connection){
                final /* synthetic */ ClangProjectScanStartupActivity this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ MessageBusConnection $connection;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$connection = $connection;
                }

                public void onServiceStarted(@NotNull ClangLanguageService service) {
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    ClangProjectScanStartupActivity.access$connectClangServerListener(this.this$0, service, this.$project);
                    this.$connection.disconnect();
                }
            });
        } else {
            this.doExecute(project);
        }
        return Unit.INSTANCE;
    }

    @TestOnly
    public final void executeAndWait(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.doExecute(project);
        this.waitForQueueProcessor();
    }

    public final boolean isInitialScanFinished() {
        Object object = this.isInitialScanFinished.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void connectClangServerListener(ClangLanguageService service, Project project) {
        MessageBusConnection connection = service.getMessageBus().connect((Disposable)project);
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ClangServerListener(this, project, connection){
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$connection = $connection;
            }

            public void onServerRunning() {
                ClangProjectScanStartupActivity.access$doExecute(this.this$0, this.$project);
                this.$connection.disconnect();
            }
        });
    }

    private final void doExecute(Project project) {
        ClangScanLog.LOG.debug("Executing ClangProjectScanStartupActivity");
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        this.myQueueProcessor.add((Object)new ScanFileSystemEvent(project));
        this.myQueueProcessor.add((Object)new ScanIndexEvent(project));
        this.myQueueProcessor.add((Object)new InitialScanFinishedEvent(this.isInitialScanFinished, project));
        if (DumbService.Companion.getInstance(project).isDumb()) {
            DumbService.Companion.getInstance(project).runWhenSmart(() -> ClangProjectScanStartupActivity.doExecute$lambda$1(this, project));
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (!this.$project.isDisposed()) {
                    for (VFileEvent vFileEvent : events) {
                        ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanPathEvent(vFileEvent, this.$project));
                    }
                }
            }
        });
        Topic topic2 = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new OCWorkspaceListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new UpdateFromWorkspaceEvent(this.$project));
                }
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanDocumentEvent(event, this.$project));
                }
            }
        }, (Disposable)this);
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void exitDumbMode() {
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanIndexEvent(this.$project));
                }
            }
        });
    }

    public void dispose() {
        this.myQueueProcessor.clear();
    }

    @TestOnly
    public final void waitForQueueProcessor() {
        this.myQueueProcessor.waitFor();
    }

    private final void doScan(ClangScanEvent scanEvent) {
        Object object = ReadAction.compute(() -> ClangProjectScanStartupActivity.doScan$lambda$2(scanEvent));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        scanEvent.scan();
    }

    private static final void myQueueProcessor$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void doExecute$lambda$1(ClangProjectScanStartupActivity this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.myQueueProcessor.add((Object)new ScanIndexEvent($project));
    }

    private static final Boolean doScan$lambda$2(ClangScanEvent $scanEvent) {
        Intrinsics.checkNotNullParameter((Object)$scanEvent, (String)"$scanEvent");
        return $scanEvent.getProject().isDisposed();
    }

    public static final /* synthetic */ void access$connectClangServerListener(ClangProjectScanStartupActivity $this, ClangLanguageService service, Project project) {
        $this.connectClangServerListener(service, project);
    }

    public static final /* synthetic */ void access$doExecute(ClangProjectScanStartupActivity $this, Project project) {
        $this.doExecute(project);
    }

    public static final /* synthetic */ QueueProcessor access$getMyQueueProcessor$p(ClangProjectScanStartupActivity $this) {
        return $this.myQueueProcessor;
    }

    public static final /* synthetic */ void access$doScan(ClangProjectScanStartupActivity $this, ClangScanEvent scanEvent) {
        $this.doScan(scanEvent);
    }
}

