/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.google.gson.Gson;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.JSONCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.WslContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangInternalCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyStatusBarWidgetFactory;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationUtil;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangLanguageServiceStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangLanguageServiceStartupActivity.runStartupActivity(project);
    }

    public static void runStartupActivity(@NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(1);
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        project.getService(CppModulesState.class);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
            if (provider2 == null) {
                return;
            }
            ClangLanguageServiceStartupActivity.installProjectListeners(project, provider2);
            String crashesDir = System.getProperty("clangd.report.crashes.to.directory");
            if (crashesDir != null) {
                try {
                    Path crashesDirPath = Path.of(crashesDir, new String[0]);
                    Files.createDirectories(crashesDirPath, new FileAttribute[0]);
                    project.putUserData(ClangCrashHandler.CRASH_REPORTER_KEY, (Object)new ClangInternalCrashReporter(crashesDirPath));
                }
                catch (IOException ex) {
                    ClangUtils.LOG.warn((Throwable)ex);
                }
            }
            if (ClangUtils.isClangdOn(project)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(provider2, project);
            }
        });
    }

    private static void installProjectListeners(final @NotNull Project project, ClangLanguageServiceProvider provider2) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                StatusBarWidgetsManager manager;
                if (profile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((manager = (StatusBarWidgetsManager)project.getService(StatusBarWidgetsManager.class)) != null) {
                    manager.updateWidget(ClangTidyStatusBarWidgetFactory.class);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$1", "profileChanged"));
            }
        });
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new MyClangdWorkspaceListener(project, provider2));
        connection.subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project, provider2));
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyClangdBulkFilesListener(provider2));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyClangdDocumentsListener(project, provider2), (Disposable)project);
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new MyClangdEditorsListener(provider2), (Disposable)project);
        ClangToolsWslService.Companion.getInstance(project).attachListener((Function1<? super WslContext, Unit>)((Function1)newCtx -> {
            ClangLanguageService langService = provider2.getIfStarted();
            if (langService != null) {
                String newWslId;
                String string = newWslId = newCtx != null ? newCtx.getId() : "";
                if (!langService.getWslMsId().equals(newWslId)) {
                    ClangLanguageServiceStartupActivity.stopLanguageServices(provider2);
                    ClangLanguageServiceStartupActivity.initLanguageServices(provider2, project);
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> ClangdSettings.rehighlight());
            return Unit.INSTANCE;
        }));
    }

    private static void initLanguageServices(@NotNull ClangLanguageServiceProvider provider2, @NotNull Project project) {
        if (provider2 == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(4);
        }
        final ClangLanguageService service = provider2.getOrStart();
        ClangLanguageService indexer = provider2.getOrStartIndexer();
        ClangdIndexerService statelessIndexer = provider2.getOrStartStatelessIndexer();
        if (service == null && indexer == null && statelessIndexer == null) {
            ClangUtils.LOG.warn("Neither service, nor indexerService are found");
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project.isDisposed()) {
                return;
            }
            ReadAction.run(() -> {
                ClangLanguageServiceStartupActivity.openAtService(project, service);
                ClangLanguageServiceStartupActivity.openAtService(project, indexer);
            });
            OCWorkspaceInitializationUtil.runWhenOrIfOCWorkspaceIsLoaded((Project)project, (Disposable)provider2, () -> {
                Path clangdCmdPath;
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    Set<VirtualFile> projectRoots = ClangLanguageServiceUtils.getProjectRoots(project);
                    if (!projectRoots.isEmpty()) {
                        if (service != null && service.isActive() && (ClangdBridge.isClangdOnlyMode() || Registry.is((String)"cidr.disable.symbols", (boolean)false))) {
                            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)service.getAssociatedDisposable(), () -> service.notifySetCDB(projectRoots));
                        }
                        if (indexer != null && indexer.isActive()) {
                            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)indexer.getAssociatedDisposable(), () -> indexer.notifySetCDB(projectRoots));
                        }
                        if (statelessIndexer != null && statelessIndexer.isActive()) {
                            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)statelessIndexer.getAssociatedDisposable(), () -> statelessIndexer.notifySetCDB(projectRoots));
                        }
                    }
                });
                if (ApplicationManager.getApplication().isInternal() && project.getBasePath() != null && (clangdCmdPath = Paths.get(project.getBasePath(), "clion_compile_commands.json")).toFile().exists()) {
                    try {
                        List commands = (List)new Gson().fromJson(FileUtilRt.loadFile((File)clangdCmdPath.toFile()), JSONCommand.LIST_TYPE_TOKEN.getType());
                        for (JSONCommand cmd : commands) {
                            ClangUtils.putCustomCommand(project, cmd.file, cmd.getCommandAsArgs());
                            ClangUtils.putCustomCommand(project, "UseThisCommandToParseHeaders", cmd.getCommandAsArgs());
                        }
                    }
                    catch (IOException ex) {
                        ClangUtils.LOG.error((Throwable)ex);
                    }
                }
                return Unit.INSTANCE;
            });
        });
        if (service != null && indexer != null) {
            File symbolsDir;
            File includeGraphFile = Paths.get(service.getClangdModulesPath(), "compilation_graph.txt").toFile();
            if (includeGraphFile.exists()) {
                service.notifyLoadGraph(includeGraphFile.getPath());
            }
            if ((symbolsDir = Paths.get(service.getClangdModulesPath(), "symbols").toFile()).exists()) {
                service.notifyLoadIndex(Collections.emptyList(), symbolsDir.getPath());
            }
            indexer.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

                @Override
                public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                    if (deletedSymbolsPaths == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (symbolsDirPath == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    service.notifyLoadIndex(deletedSymbolsPaths, symbolsDirPath);
                }

                @Override
                public void onGraphFinished(@NotNull String path) {
                    if (path == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    service.notifyLoadGraph(path);
                }

                @Override
                public void onIndexPartFinished(@NotNull String path) {
                    if (path == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    service.notifyIndexPartFinished(path);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "deletedSymbolsPaths";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "symbolsDirPath";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onIndexingFinished";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onGraphFinished";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onIndexPartFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static void openAtService(@NotNull Project project, @Nullable ClangLanguageService service) {
        if (project == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(5);
        }
        if (project.isDisposed()) {
            return;
        }
        if (service == null || !service.isActive()) {
            return;
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
            service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
        }
    }

    private static void stopLanguageServices(@NotNull ClangLanguageServiceProvider provider2) {
        if (provider2 == null) {
            ClangLanguageServiceStartupActivity.$$$reportNull$$$0(6);
        }
        provider2.stop();
        provider2.stopIndexer();
        provider2.stopStatelessIndexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installProjectListeners";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initLanguageServices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openAtService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "stopLanguageServices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyClangdWorkspaceListener
    implements OCWorkspaceListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdWorkspaceListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            if (project == null) {
                MyClangdWorkspaceListener.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                MyClangdWorkspaceListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myProvider = provider2;
        }

        public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
            if (event == null) {
                MyClangdWorkspaceListener.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ClangdIndexerService statelessIndexer;
                ClangLanguageService indexer;
                ClangLanguageService service;
                if (this.myProject.isDisposed()) {
                    return;
                }
                if (ClangdBridge.isClangdOnlyMode() && (service = this.myProvider.getIfStarted()) != null) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)service.getAssociatedDisposable(), () -> service.notifySetCDB(ClangLanguageServiceUtils.getProjectRoots(this.myProject)));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)indexer.getAssociatedDisposable(), () -> indexer.notifySetCDB(ClangLanguageServiceUtils.getProjectRoots(this.myProject)));
                }
                if ((statelessIndexer = this.myProvider.getIfStartedStatelessIndexer()) != null) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)statelessIndexer.getAssociatedDisposable(), () -> statelessIndexer.notifySetCDB(ClangLanguageServiceUtils.getProjectRoots(this.myProject)));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdWorkspaceListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "workspaceChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        MyClangdSettingsListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            if (project == null) {
                MyClangdSettingsListener.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                MyClangdSettingsListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myProvider = provider2;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(this.myProvider, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageServices(this.myProvider);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdSettingsListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyClangdBulkFilesListener
    implements BulkFileListener {
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdBulkFilesListener(@NotNull ClangLanguageServiceProvider provider2) {
            if (provider2 == null) {
                MyClangdBulkFilesListener.$$$reportNull$$$0(0);
            }
            this.myProvider = provider2;
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyClangdBulkFilesListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                ClangLanguageService indexer;
                VFilePropertyChangeEvent event;
                VirtualFile file;
                if (vFileEvent instanceof VFileMoveEvent) {
                    ClangLanguageService indexer2;
                    VFileMoveEvent event2 = (VFileMoveEvent)vFileEvent;
                    file = event2.getFile();
                    String oldUrl = event2.getOldParent().getUrl() + "/" + file.getName();
                    String newUrl = file.getUrl();
                    ClangLanguageService service = this.myProvider.getIfStarted();
                    if (service != null) {
                        service.notifyDocumentMoved(event2.getFile(), oldUrl, newUrl);
                    }
                    if ((indexer2 = this.myProvider.getIfStarted()) == null) continue;
                    indexer2.notifyDocumentMoved(event2.getFile(), oldUrl, newUrl);
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent && (event = (VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                    ClangLanguageService indexer3;
                    if (Objects.equals(event.getNewValue(), event.getOldValue())) continue;
                    String newName = (String)event.getNewValue();
                    String newUrl = event.getFile().getUrl();
                    assert (newUrl.endsWith(newName));
                    String oldName = (String)event.getOldValue();
                    String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                    ClangLanguageService service = this.myProvider.getIfStarted();
                    if (service != null) {
                        service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    }
                    if ((indexer3 = this.myProvider.getIfStartedIndexer()) == null) continue;
                    indexer3.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                    continue;
                }
                if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                VFileContentChangeEvent event3 = (VFileContentChangeEvent)vFileEvent;
                if (!vFileEvent.isFromSave()) continue;
                file = event3.getFile();
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentSaved(file);
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) == null) continue;
                indexer.notifyDocumentSaved(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdBulkFilesListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyClangdDocumentsListener
    implements DocumentListener {
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdDocumentsListener(@NotNull Project project, @NotNull ClangLanguageServiceProvider provider2) {
            if (project == null) {
                MyClangdDocumentsListener.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                MyClangdDocumentsListener.$$$reportNull$$$0(1);
            }
            this.myProvider = provider2;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            boolean isDocumentSaved;
            if (event == null) {
                MyClangdDocumentsListener.$$$reportNull$$$0(2);
            }
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            boolean bl = isDocumentSaved = !FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument());
            if (file != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentChanged(file, event);
                    if (isDocumentSaved) {
                        service.notifyDocumentSaved(file);
                    }
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentChanged(file, event);
                    if (isDocumentSaved) {
                        indexer.notifyDocumentSaved(file);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdDocumentsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyClangdEditorsListener
    implements EditorFactoryListener {
        @NotNull
        private final ClangLanguageServiceProvider myProvider;

        private MyClangdEditorsListener(@NotNull ClangLanguageServiceProvider provider2) {
            if (provider2 == null) {
                MyClangdEditorsListener.$$$reportNull$$$0(0);
            }
            this.myProvider = provider2;
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            VirtualFile file;
            if (event == null) {
                MyClangdEditorsListener.$$$reportNull$$$0(1);
            }
            if ((file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument())) != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentOpened(file, new EditorOpenRequestId(event.getEditor()));
                }
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            VirtualFile file;
            if (event == null) {
                MyClangdEditorsListener.$$$reportNull$$$0(2);
            }
            if ((file = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument())) != null) {
                ClangLanguageService indexer;
                ClangLanguageService service = this.myProvider.getIfStarted();
                if (service != null) {
                    service.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                }
                if ((indexer = this.myProvider.getIfStartedIndexer()) != null) {
                    indexer.notifyDocumentClosed(file, new EditorOpenRequestId(event.getEditor()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangLanguageServiceStartupActivity$MyClangdEditorsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

