/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionModuleMappingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.AbstractClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangRemoteWorkspaceImpl
extends AbstractClangWorkspace<RemoteWorkspaceFile>
implements ClangRemoteWorkspace,
WorkspaceFileListener {
    @NotNull
    private final Set<String> myUnsavedFiles = ConcurrentCollectionFactory.createConcurrentSet();
    @Nullable
    private volatile String myIndexUri = null;
    @Nullable
    private volatile CLionModuleMappingParams myCpp20ModuleMapping = null;
    @Nullable
    private volatile String myLoadedGraphUri = null;
    @NotNull
    private final List<ClionSetCDBParams> myCDBs = Collections.synchronizedList(new ArrayList());
    private volatile boolean myIsPaused = false;

    @Override
    @NotNull
    public Set<String> getUnsavedFiles() {
        Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.myUnsavedFiles));
        if (set == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    public String getLoadedIndexParams() {
        return this.myIndexUri;
    }

    @Override
    public void setLoadedIndexParams(@NotNull String uri) {
        if (uri == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(1);
        }
        this.myIndexUri = uri;
    }

    @Override
    @Nullable
    public CLionModuleMappingParams getCpp20ModuleMapping() {
        return this.myCpp20ModuleMapping;
    }

    @Override
    public void setCpp20ModuleMapping(@Nullable CLionModuleMappingParams params) {
        this.myCpp20ModuleMapping = params;
    }

    @Override
    @Nullable
    public String getLoadedGraphUri() {
        return this.myLoadedGraphUri;
    }

    @Override
    public void setLoadedGraphUri(@NotNull String uri) {
        if (uri == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(2);
        }
        this.myLoadedGraphUri = uri;
    }

    @Override
    @NotNull
    public List<ClionSetCDBParams> getCDBs() {
        return new ArrayList<ClionSetCDBParams>(this.myCDBs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrSetCDB(@Nullable ClionSetCDBParams params) {
        List<ClionSetCDBParams> list = this.myCDBs;
        synchronized (list) {
            if (!this.myCDBs.isEmpty() && this.myCDBs.get(this.myCDBs.size() - 1).isLastBatch()) {
                this.myCDBs.clear();
            }
            this.myCDBs.add(params);
        }
    }

    @Override
    public boolean isOpenedRemotely(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(3);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED));
    }

    @Override
    public boolean isClosedRemotely(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(4);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED) == false);
    }

    @Override
    public boolean isParsed(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(5);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_PARSED));
    }

    @Override
    public ClionReparseTextDocumentParams getReparseParams(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(6);
        }
        return this.apply(url, (WF wf) -> wf.getReparseParams());
    }

    @Override
    public String getContent(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(7);
        }
        return this.apply(url, (WF wf) -> wf.getContent());
    }

    @Override
    public boolean isPaused() {
        return this.myIsPaused;
    }

    @Override
    public void setPaused(boolean value) {
        this.myIsPaused = value;
    }

    @Override
    @NotNull
    protected RemoteWorkspaceFile createWorkspaceFile(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(8);
        }
        return new RemoteWorkspaceFileImpl(url, this);
    }

    @Override
    public <T> void onChanged(@NotNull String url, @NotNull WorkspaceFile.Key<T> key, T value) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(9);
        }
        if (key == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(10);
        }
        if (key == RemoteWorkspaceFile.IS_SAVED) {
            if (Objects.equals(value, Boolean.TRUE)) {
                this.myUnsavedFiles.remove(url);
            } else {
                this.myUnsavedFiles.add(url);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.myIndexUri = null;
        this.myCpp20ModuleMapping = null;
        this.myLoadedGraphUri = null;
        this.myCDBs.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLoadedIndexParams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLoadedGraphUri";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedRemotely";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isClosedRemotely";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isParsed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReparseParams";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

