/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangdMemoryUsageCollector;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ClangMemoryUsageWatchDogImpl
implements ClangMemoryUsageWatchDog,
ClangServerListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ClangMemoryUsageWatchDog.class.getName());
    private static final int DELAY = 10000;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangLanguageService myService;
    @NotNull
    private final AtomicLong myMemoryLimit;
    @NotNull
    private final AtomicLong myLastReportedMemory;
    @NotNull
    private final AtomicLong myMaxReportedMemory;
    @NotNull
    private final AtomicLong myAverageReportedMemory;
    @NotNull
    private final AtomicLong myReportedMemoryCounter;
    @NotNull
    private final ScheduledFuture<?> myFuture;

    public ClangMemoryUsageWatchDogImpl(final @NotNull ClangDaemonContext context, @NotNull ClangLanguageService service) {
        if (context == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(0);
        }
        if (service == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(1);
        }
        this.myMemoryLimit = new AtomicLong(-1L);
        this.myLastReportedMemory = new AtomicLong(0L);
        this.myMaxReportedMemory = new AtomicLong(0L);
        this.myAverageReportedMemory = new AtomicLong(0L);
        this.myReportedMemoryCounter = new AtomicLong(0L);
        this.myContext = context;
        this.myService = service;
        Disposer.register((Disposable)context, (Disposable)this);
        ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue(context.isIndexer()).addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context.canPublishMessage() && !ClangMemoryUsageWatchDogImpl.this.isCustomMemoryLimit()) {
                    ((ClangMemoryUsageWatchDogListener)context.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(ClangMemoryUsageWatchDogImpl.getMaxMemoryFromRegistryValue(value));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl$1", "afterValueChanged"));
            }
        }, (Disposable)context);
        context.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)this);
        this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::requestState, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getCurrentMemory() {
        return this.myLastReportedMemory.get();
    }

    @Override
    public long getUsedAverageMemory() {
        return this.myAverageReportedMemory.get();
    }

    @Override
    public long getUsedMaxMemory() {
        return this.myMaxReportedMemory.get();
    }

    @Override
    public long getMaxMemory() {
        long customMemoryLimit = this.myMemoryLimit.get();
        if (customMemoryLimit != -1L) {
            return customMemoryLimit;
        }
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryFromRegistryValue(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue(this.myContext.isIndexer()));
    }

    @Override
    public long setMaxMemory(long maxMemory) {
        long oldLimit = this.myMemoryLimit.get();
        this.myMemoryLimit.set(maxMemory);
        if (this.myContext.canPublishMessage()) {
            ((ClangMemoryUsageWatchDogListener)this.myContext.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(this.getMaxMemory());
        }
        return oldLimit;
    }

    @Override
    public void onServerFailure() {
        this.reportMemoryUsed(0L);
    }

    @Override
    public void onServerShutDown() {
        this.reportMemoryUsed(0L);
    }

    private void requestState() {
        try {
            ClangMemoryUsageInfo memoryUsage = (ClangMemoryUsageInfo)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(this.myService.getMemoryStat(), (long)10000L, (String)"memory stats");
            if (memoryUsage != null) {
                long workingSet = (long)memoryUsage.getWorkingSet() * 1024L;
                this.myLastReportedMemory.set(workingSet);
                long measurementsCounter = this.myReportedMemoryCounter.incrementAndGet();
                this.myAverageReportedMemory.accumulateAndGet(workingSet, (prevAvg, newWorkingSet) -> Double.valueOf((double)prevAvg * (((double)measurementsCounter - 1.0) / (double)measurementsCounter) + (double)newWorkingSet / (double)measurementsCounter).longValue());
                this.myMaxReportedMemory.accumulateAndGet(workingSet, (prevMax, newWorkingSet) -> Math.max(prevMax, newWorkingSet));
                this.restartServerIfNecessary(workingSet);
                this.reportMemoryUsed(workingSet);
            }
        }
        catch (ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.warn("Timeout when getting memory stats");
        }
    }

    private void restartServerIfNecessary(long workingSet) {
        long maxMemory = this.getMaxMemory();
        if (ClangMemoryUsageWatchDogImpl.isEnabled(maxMemory) && workingSet > maxMemory && this.myContext.getProject().getUserData(ClangDaemonContext.DISABLE_MEMORY_LIMIT) == null) {
            String nativeStackTrace = maxMemory >= 4096L ? "\n\n" + this.myService.getNativeStacktrace() : "";
            ClangStopData stopData = this.myService.shutDownServer();
            LOG.warn("Server was restarted because the memory limit was exceeded: " + workingSet / 0x100000L + "M used of " + maxMemory / 0x100000L + "M" + nativeStackTrace);
            ClangdMemoryUsageCollector.MEMORY_LIMIT_EXCEED.log();
            try {
                stopData.exitCode.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.warn((Throwable)ex);
            }
            catch (TimeoutException ex) {
                LOG.warn("clangd is not down after 5 seconds, killing it.");
                stopData.killRunnable.run();
            }
        }
    }

    public void dispose() {
        this.myFuture.cancel(true);
        this.reportMemoryUsed(0L);
    }

    private void reportMemoryUsed(long howMuch) {
        if (this.myContext.canPublishMessage()) {
            ((ClangMemoryUsageWatchDogListener)this.myContext.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(howMuch);
        }
    }

    private boolean isCustomMemoryLimit() {
        return this.myMemoryLimit.get() != -1L;
    }

    private static boolean isEnabled(long maxMemory) {
        return maxMemory > 0L;
    }

    private static long getMaxMemoryFromRegistryValue(@NotNull RegistryValue value) {
        if (value == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(2);
        }
        return (long)value.asInteger() * 0x100000L;
    }

    @NotNull
    private static RegistryValue getMaxMemoryRegistryValue(boolean indexer) {
        RegistryValue registryValue = indexer ? Registry.get((String)"clion.clangd.indexer.max.memory") : Registry.get((String)"clion.clangd.max.memory");
        if (registryValue == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxMemoryRegistryValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMaxMemoryFromRegistryValue";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

