/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportBugDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdReportBugAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        Project project;
        if (e == null) {
            ClangdReportBugAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            ClangdReportBugDialog dialog = new ClangdReportBugDialog(project);
            dialog.show();
            if (dialog.isOK()) {
                ClangLanguageService service = ClangLanguageServiceProvider.getOrStart(project);
                if (service == null) {
                    ClangUtils.LOG.warn("Failed to getOrStart() ClangLanguageService");
                    return;
                }
                Map report = (Map)CidrConcurrentUtilsKt.computeUnderProgress((String)ClangdBundle.message("clangd.report.bug.collecting.title", new Object[0]), (Project)project, () -> {
                    try {
                        return ClangdReportBugAction.prepareReport(dialog.getSelectedOption(), service, curFile);
                    }
                    catch (IOException ex) {
                        ClangUtils.LOG.error((Throwable)ex);
                        return null;
                    }
                });
                if (report != null && !report.isEmpty()) {
                    try {
                        if (dialog.getSendAsException() && dialog.getSelectedOption() == ClangdReportBugDialog.CollectOption.AS_IS) {
                            ClangdReportBugAction.reportZipAsException(project, report);
                        } else if (dialog.getSendAsException()) {
                            ClangdReportBugAction.reportAsException(project, report);
                        } else {
                            ClangdReportBugAction.saveZip(project, report, "_report");
                        }
                    }
                    catch (IOException ex) {
                        ClangUtils.LOG.error((Throwable)ex);
                    }
                }
            }
        }
    }

    @NotNull
    private static Map<String, String> prepareReport(ClangdReportBugDialog.CollectOption opt, ClangLanguageService service, VirtualFile curFile) throws IOException {
        Map<String, String> map = switch (opt) {
            default -> throw new IncompatibleClassChangeError();
            case ClangdReportBugDialog.CollectOption.AS_IS -> ClangReportUtils.prepareAsIsReport(service, Collections.singletonList(curFile.getUrl()));
            case ClangdReportBugDialog.CollectOption.PREPROCESSED -> ClangReportUtils.preparePreprocessedReport(service, Collections.singletonList(curFile.getUrl()), false);
            case ClangdReportBugDialog.CollectOption.PREPROCESSED_AND_OBFUSCATED -> ClangReportUtils.preparePreprocessedReport(service, Collections.singletonList(curFile.getUrl()), true);
        };
        if (map == null) {
            ClangdReportBugAction.$$$reportNull$$$0(1);
        }
        return map;
    }

    static void reportAsException(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(2);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(3);
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Map.Entry<String, String> entry : file2Content.entrySet()) {
            attachments.add(new Attachment(entry.getKey(), entry.getValue()));
        }
        ClangUtils.LOG.error("Please, attach collected sources to the report", attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    static void reportZipAsException(@NotNull Project project, @NotNull Map<String, String> file2Content) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(4);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(5);
        }
        byte[] zipArchive = ClangReportUtils.makeZipArchive(file2Content);
        ClangUtils.LOG.error("Collected sources are placed into ZIP archive. Please, attach it to the report", new Attachment[]{new Attachment("report.zip", zipArchive, "Collected sources in a .zip archive")});
    }

    static void saveZip(@NotNull Project project, @NotNull Map<String, String> file2Content, @NotNull String fileSuffix) throws IOException {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(6);
        }
        if (file2Content == null) {
            ClangdReportBugAction.$$$reportNull$$$0(7);
        }
        if (fileSuffix == null) {
            ClangdReportBugAction.$$$reportNull$$$0(8);
        }
        byte[] zipArchive = ClangReportUtils.makeZipArchive(file2Content);
        File savePath = ClangdReportBugAction.getSavePath(project, fileSuffix);
        if (savePath != null) {
            FileUtil.writeToFile((File)savePath, (byte[])zipArchive);
        }
    }

    @Nullable
    private static File getSavePath(@NotNull Project project, @NotNull String fileSuffix) {
        if (project == null) {
            ClangdReportBugAction.$$$reportNull$$$0(9);
        }
        if (fileSuffix == null) {
            ClangdReportBugAction.$$$reportNull$$$0(10);
        }
        String name = project.getName().replaceAll("[^a-zA-Z0-9\\-_]", "_");
        VirtualFileWrapper saved = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ClangdBundle.message("clangd.report.bug.save.title", new Object[0]), ClangdBundle.message("clangd.report.bug.save.description", new Object[0]), new String[0]), project).save(name + fileSuffix + ".zip");
        return saved != null ? saved.getFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportBugAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2Content";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportBugAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportAsException";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportZipAsException";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveZip";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSavePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

