/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.JSONCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.IndexerCDB;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0007"}, d2={"prepareIndexerCDB", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/IndexerCDB;", "indexer", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "tus", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.c.clangd"})
public final class ClangdDumpIndexerCDBKt {
    @NotNull
    public static final IndexerCDB prepareIndexerCDB(@NotNull ClangLanguageService indexer, @NotNull Iterable<? extends VirtualFile> tus) {
        Intrinsics.checkNotNullParameter((Object)indexer, (String)"indexer");
        Intrinsics.checkNotNullParameter(tus, (String)"tus");
        Project project = indexer.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ClangIdeFacade clangIdeFacade = indexer.getClangIdeFacade();
        Intrinsics.checkNotNullExpressionValue((Object)clangIdeFacade, (String)"getClangIdeFacade(...)");
        ClangIdeFacade facade = clangIdeFacade;
        ClangUrlConverter clangUrlConverter = indexer.getUrlConverter();
        Intrinsics.checkNotNullExpressionValue((Object)clangUrlConverter, (String)"getUrlConverter(...)");
        ClangUrlConverter urlConv = clangUrlConverter;
        Cpp20ModulesContext cpp20ModulesContext = Cpp20ModulesContext.create(indexer.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)cpp20ModulesContext, (String)"create(...)");
        Cpp20ModulesContext cpp20Context = cpp20ModulesContext;
        ArrayList<JSONCommand> jsonCommands = new ArrayList<JSONCommand>();
        Map macros2File = new LinkedHashMap();
        Ref.IntRef macrosFileCounter = new Ref.IntRef();
        macrosFileCounter.element = 1;
        for (VirtualFile virtualFile : tus) {
            String defaultMacrosFile = "clion.macros.file" + macrosFileCounter.element;
            Object command = null;
            CompletableFuture<ClangdCompilationCommand> completableFuture = facade.getCompilationCommandAsync(urlConv, project2, virtualFile, "/" + defaultMacrosFile, cpp20Context);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getCompilationCommandAsync(...)");
            ClangdCompilationCommand clangdCompilationCommand = (ClangdCompilationCommand)CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture, (String)"compilation command");
            if (clangdCompilationCommand == null) continue;
            command = clangdCompilationCommand;
            if (((ClangdCompilationCommand)command).ppDefines != null) {
                String newPath2;
                String it;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)macros2File.computeIfAbsent(it, arg_0 -> ClangdDumpIndexerCDBKt.prepareIndexerCDB$lambda$1$lambda$0((Function1)new Function1<String, String>(macrosFileCounter){
                    final /* synthetic */ Ref.IntRef $macrosFileCounter;
                    {
                        this.$macrosFileCounter = $macrosFileCounter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ++this.$macrosFileCounter.element;
                        int cfr_ignored_0 = this.$macrosFileCounter.element;
                        return "clion.macros.file" + this.$macrosFileCounter.element;
                    }
                }, arg_0)), (String)"computeIfAbsent(...)");
                if (!Intrinsics.areEqual((Object)newPath2, (Object)defaultMacrosFile)) {
                    CompletableFuture<ClangdCompilationCommand> completableFuture2 = facade.getCompilationCommandAsync(urlConv, project2, virtualFile, "/" + newPath2, cpp20Context);
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"getCompilationCommandAsync(...)");
                    Object object = CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture2, (String)"compilation command");
                    Intrinsics.checkNotNull((Object)object);
                    command = object;
                }
            }
            String string = ((ClangdCompilationCommand)command).ccParams.getDirectory();
            List<String> list = ((ClangdCompilationCommand)command).ccParams.getCommandLine();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCommandLine(...)");
            jsonCommands.add(new JSONCommand(string, CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), urlConv.fromUri(((ClangdCompilationCommand)command).ccParams.getUri())));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String string = gson.toJson(jsonCommands);
        Intrinsics.checkNotNull((Object)string);
        return new IndexerCDB(string, macros2File);
    }

    private static final String prepareIndexerCDB$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

