/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdCanceledException;
import com.jetbrains.cidr.lang.daemon.clang.clangd.FullCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdContentDependentCaches;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdRequestsPlanner;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.HoverInfoKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.InlayHintsKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.LineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ParsingParamsTransformer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.SignatureHelpKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.TestLineMarkersKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory.ClangMemoryUsageWatchDogImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionDocumentRangeFormattingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionFindUsagesParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionModuleMappingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTypehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReferencesParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReloadIndexParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCancelParseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClionHoverInfoRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClionLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCloseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCompletionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDeleteNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpASTRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangDumpTokensRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFindUsagesRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFolderChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatConfigurationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFormatRangeRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGetLocalVariablesRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoDefinitionRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangGotoTypeDeclarationRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHoverRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndentRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangIndexPartFinishedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInlayHintsRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMatchAngleBracketRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMatchPPRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangParseCommandLineRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangPreprocessRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadGraphNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadIndexNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSaveRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSetCDBNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSignatureHelpRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangTestLineMarkersRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangVisibility;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdFatalError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdInlayHintData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightIndexRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightSymbolInfoResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.lang.highlighting.ClangBracketMatchResult;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdLanguageService
implements ClangLanguageService,
PendingParseListener,
PsiModificationTracker.Listener {
    private static final Logger LOG = Logger.getInstance((String)ClangdLanguageService.class.getName());
    private static final int DEFAULT_CDB_BATCH_SIZE = 2048;
    private static final WorkspaceFile.Key<Map<OpenRequestId, Integer>> OPEN_REQUESTS = new WorkspaceFile.Key<Map>("OpenRequests", () -> new HashMap());
    private static final Key<UsagesInfo> USAGES_MAP = new Key("UsagesMap");
    private static final Key<Object> CANCELED_FLAG = new Key("CanceledFlag");
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final ClangLocalWorkspace myWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    protected final ClangdRequestsPlanner myRequestsPlanner;
    @NotNull
    private final ClangMemoryUsageWatchDog myMemoryUsageWatchDog;
    @NotNull
    private final Set<UserDataHolder> myDebugUsagesSet;
    @NotNull
    private final ClangdContentDependentCaches myContentDependentCache;
    @NotNull
    private final AtomicLong myProfileModificationCounter;
    @NotNull
    private final AtomicLong myNumOfPendingDuplicatedReparseNotifications;
    @NotNull
    private final AtomicLong myNumOfWaitingDefferedRequestBuilders;
    @NotNull
    private final Cache<GotoDefinitionKey, ClangGotoDefinitionRequest> myGotoDefinitionCache;
    private final Cache<GotoDefinitionKey, ClangGotoTypeDeclarationRequest> myGotoTypeDeclarationCache;

    public ClangdLanguageService(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdLanguageService.$$$reportNull$$$0(0);
        }
        this.myDebugUsagesSet = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
        this.myContentDependentCache = new ClangdContentDependentCaches();
        this.myProfileModificationCounter = new AtomicLong(0L);
        this.myNumOfPendingDuplicatedReparseNotifications = new AtomicLong(0L);
        this.myNumOfWaitingDefferedRequestBuilders = new AtomicLong(0L);
        this.myGotoDefinitionCache = CacheBuilder.newBuilder().maximumSize(4096L).build();
        this.myGotoTypeDeclarationCache = CacheBuilder.newBuilder().maximumSize(4096L).build();
        this.myContext = context;
        this.myProject = context.getProject();
        this.myWorkspace = context.getLocalWorkspace();
        this.myIdeFacade = context.getIdeFacade();
        this.myRequestsPlanner = new ClangdRequestsPlanner(context.getDescriptor(), context.getServerAccessorProvider().createServerAccessor(context));
        this.myWorkspace.addPendingParseListener(this);
        this.myMemoryUsageWatchDog = new ClangMemoryUsageWatchDogImpl(context, this);
        context.getProject().getMessageBus().connect((Disposable)context).subscribe(PsiModificationTracker.TOPIC, (Object)this);
        if (context.shouldStartServerImmediately()) {
            this.myRequestsPlanner.sendImmediately(ClangInteraction.createSimple("Misc", (Consumer<? super ClangServer>)((Consumer)server -> {}), true));
        }
        context.getProject().getMessageBus().connect((Disposable)context).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    1.$$$reportNull$$$0(0);
                }
                ClangdLanguageService.this.myProfileModificationCounter.incrementAndGet();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService$1", "profileChanged"));
            }
        });
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        if (oldest == null) {
            ClangdLanguageService.$$$reportNull$$$0(1);
        }
        this.myWorkspace.modify(oldest.getUrl(), wf -> this.sendCancelParse("overflow", oldest));
        LOG.warn("Overflow in responses storage! Removing " + oldest.getUrl() + " of version " + oldest.getVersion() + "\n" + ClangParseResponse.showAnswerStates(oldest));
    }

    public void modificationCountChanged() {
        this.myContentDependentCache.clear();
    }

    @Override
    @NotNull
    public ClangDaemonContext getContext() {
        ClangDaemonContext clangDaemonContext = this.myContext;
        if (clangDaemonContext == null) {
            ClangdLanguageService.$$$reportNull$$$0(2);
        }
        return clangDaemonContext;
    }

    @Override
    @NotNull
    public Disposable getAssociatedDisposable() {
        ClangDaemonContext clangDaemonContext = this.myContext;
        if (clangDaemonContext == null) {
            ClangdLanguageService.$$$reportNull$$$0(3);
        }
        return clangDaemonContext;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        String string = this.myContext.getDescriptor();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getWslMsId() {
        String string = this.myContext.getUrlConverter().getWslMsId();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myContext.getMessageBus();
        if (messageBus == null) {
            ClangdLanguageService.$$$reportNull$$$0(6);
        }
        return messageBus;
    }

    @Override
    @NotNull
    public ClangIdeFacade getClangIdeFacade() {
        ClangIdeFacade clangIdeFacade = this.myIdeFacade;
        if (clangIdeFacade == null) {
            ClangdLanguageService.$$$reportNull$$$0(7);
        }
        return clangIdeFacade;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        ClangUrlConverter clangUrlConverter = this.myContext.getUrlConverter();
        if (clangUrlConverter == null) {
            ClangdLanguageService.$$$reportNull$$$0(8);
        }
        return clangUrlConverter;
    }

    @Override
    public boolean isActive() {
        return !this.myContext.isStopped();
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        ClangTelemetry clangTelemetry = this.myContext.getTelemetry();
        if (clangTelemetry == null) {
            ClangdLanguageService.$$$reportNull$$$0(9);
        }
        return clangTelemetry;
    }

    @Override
    @NotNull
    public ClangMemoryUsageWatchDog getMemoryUsageWatchDog() {
        ClangMemoryUsageWatchDog clangMemoryUsageWatchDog = this.myMemoryUsageWatchDog;
        if (clangMemoryUsageWatchDog == null) {
            ClangdLanguageService.$$$reportNull$$$0(10);
        }
        return clangMemoryUsageWatchDog;
    }

    @Override
    public <E extends Throwable> void gotoDefinition(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(12);
        }
        ClangResultImpl result = this.computeWithParsedInternal("gotoDefinition", file, (wf, response) -> this.sendGotoDefinition((LocalWorkspaceFile)wf, (ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void findUsages(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangFoundUsage>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(14);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "findUsages for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl result = this.computeWithParsedInternal("findUsages", file, (wf, resp) -> this.sendFindUsages((LocalWorkspaceFile)wf, file, offset));
            ClangdLanguageService.applyConsumer(consumer, result);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void getLocalVariables(@NotNull VirtualFile file, int line, @NotNull ClangResultConsumer<List<String>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(16);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "getLocalVariables for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl result = this.computeWithParsedInternal("getLocalVariables", file, (wf, resp) -> this.sendGetLocalVariables((LocalWorkspaceFile)wf, file, line));
            ClangdLanguageService.applyConsumer(consumer, result);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    @Override
    public <E extends Throwable> void matchAngleBracket(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<ClangBracketMatchResult, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(18);
        }
        ClangResultImpl result = this.computeWithParsedInternal("matchAngleBracket", file, (wf, response) -> this.sendMatchAngleBracket((LocalWorkspaceFile)wf, (ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void matchPP(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<Range>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(20);
        }
        ClangResultImpl result = this.computeWithParsedInternal("clionMatchPP", file, (wf, response) -> this.sendMatchPP((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void gotoTypeDeclaration(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<List<ClangSym>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(22);
        }
        ClangResultImpl result = this.computeWithParsedInternal("clionTypeDeclaration", file, (wf, response) -> this.sendGotoTypeDeclaration((LocalWorkspaceFile)wf, (ClangParseResponse)response, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getCLionHoverInfo(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<ClionHoverInfo, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(24);
        }
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("clionHoverInfo", file, (wf, response) -> this.sendClionHoverInfo((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getHover(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<Hover, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(26);
        }
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("getHover", file, (wf, response) -> this.sendHoverRequest((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpAST(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(28);
        }
        ClangResultImpl result = this.computeWithParsedInternal("dumpAST", file, (wf, response) -> this.sendDumpAST((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void dumpTokens(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<String, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(29);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(30);
        }
        ClangResultImpl result = this.computeWithParsedInternal("dumpTokens", file, (wf, response) -> this.sendDumpTokens((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void complete(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, @NotNull int completionKind, Pair<Integer, ArrayList<String>> postfixTemplates, @NotNull ClangResultConsumer<Either<List<CLionCompletionItem>, CLionCompletionList>, E> consumer) throws E {
        ClangCompletionRequest request;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(31);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(32);
        }
        if (kind == null) {
            ClangdLanguageService.$$$reportNull$$$0(33);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(34);
        }
        if ((request = this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            if (!wf.isOpened()) {
                return null;
            }
            return this.sendRequestComplete((LocalWorkspaceFile)wf, file, line, column, fileText, kind, completionKind, postfixTemplates);
        })) == null) {
            ClangdLanguageService.applyConsumer(consumer, new ClangResultImpl<Object>("complete", CompletableFuture.completedFuture(null)));
            return;
        }
        int reqUsageID = this.trackRequestUsage(request);
        ClangResultImpl result = new ClangResultImpl("complete", request.getResponse(), () -> this.freeRequestUsage(request, reqUsageID));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getFastLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(35);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(36);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getFastLineMarkers", file, (wf, response) -> this.sendClionLineMarkers((LocalWorkspaceFile)wf, file, fromOffset, toOffset, true));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getSlowLineMarkers(@NotNull VirtualFile file, int fromOffset, int toOffset, @NotNull ClangResultConsumer<List<ClionLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(37);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(38);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getSlowLineMarkers", file, (wf, response) -> this.sendClionLineMarkers((LocalWorkspaceFile)wf, file, fromOffset, toOffset, false));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getTestLineMarkers(@NotNull VirtualFile file, @NotNull List<String> enabledTestFrameworksNames, @NotNull ClangResultConsumer<List<ClionTestRunLineMarker>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(39);
        }
        if (enabledTestFrameworksNames == null) {
            ClangdLanguageService.$$$reportNull$$$0(40);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(41);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getTestRunLineMarkers", file, (wf, response) -> this.sendClionTestLineMarkers((LocalWorkspaceFile)wf, file, enabledTestFrameworksNames));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getInlayHints(@NotNull VirtualFile file, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig, @NotNull ClangResultConsumer<CachingSupplier<ClangdInlayHintData>, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(42);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(43);
        }
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("getInlayHints", file, (wf, response) -> this.sendInlayHints((LocalWorkspaceFile)wf, file, parameterConfig, typeConfig));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void getSignatureHelp(@NotNull VirtualFile file, int offset, @NotNull ClangResultConsumer<SignatureHelp, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(44);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(45);
        }
        ClangResultImpl result = this.computeWithParsedInternal("getSignatureHelp", file, (wf, response) -> this.sendSignatureHelp((LocalWorkspaceFile)wf, file, offset));
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    @NotNull
    public CompletableFuture<ClionFileStats> requestTimingStats(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(46);
        }
        CompletableFuture<ClionFileStats> result = new CompletableFuture<ClionFileStats>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("RequestTimingsStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionRequestTimingsStat(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file))).whenComplete((res, ex) -> result.complete((ClionFileStats)res)))).onSkipped(() -> result.complete(null)).onRejected(() -> result.complete(null)).requiresRecover().create());
        CompletableFuture<ClionFileStats> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(47);
        }
        return completableFuture;
    }

    @Override
    public <E extends Throwable> void preprocess(@NotNull VirtualFile file, @NotNull ClangResultConsumer<CLionClangPreprocessResult, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(48);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(49);
        }
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("preprocess", file, (wf, response) -> {
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            ClangPreprocessRequest request = new ClangPreprocessRequest(wf.getUrl(), identifier);
            this.myRequestsPlanner.send(request);
            return request;
        });
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    public <E extends Throwable> void preprocessSubstitution(@NotNull VirtualFile file, int offset, int depth, @NotNull ClangResultConsumer<CLionClangPreprocessResult, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(50);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(51);
        }
        ClangResultImpl result = this.computeWithOpenedAndParsedInternal("preprocessSubstitution", file, (wf, response) -> {
            Document document2 = this.myContext.getIdeFacade().getDocument(file);
            if (document2 == null) {
                return null;
            }
            Position lspPos = ClangLanguageServiceUtils.offset2LspPos(document2, offset);
            String uri = this.myContext.getUrlConverter().toUri(file);
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
            ClangPreprocessRequest request = new ClangPreprocessRequest(wf.getUrl(), identifier, lspPos, depth);
            this.myRequestsPlanner.send(request);
            return request;
        });
        ClangdLanguageService.applyConsumer(consumer, result);
    }

    @Override
    @NotNull
    public CompletableFuture<String> requestClangFormatConfiguration(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(52);
        }
        return this.ifOpened(file, wf -> this.sendRequestClangFormatConfiguration(file));
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> formatRange(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style, int cursorOffset) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(53);
        }
        if (range == null) {
            ClangdLanguageService.$$$reportNull$$$0(54);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.sendFormatRangeRequest(file, range, style, cursorOffset));
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(55);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLightSymbolInfoResponse>> clionLightIndex(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(56);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.sendClionLightIndex(file));
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(57);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangLineColReplace>> indentLine(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(58);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> this.isAcceptable(file) ? this.sendIndentRequest(file, lineStartOffset, style) : CompletableFuture.completedFuture(null));
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(59);
        }
        return completableFuture;
    }

    @Override
    @Nullable
    public ClangParseResponse getParsed(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(60);
        }
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return null;
        }
        return this.myWorkspace.applyWithRead(url, wf -> this.getOrParse(file, (LocalWorkspaceFile)wf, null, null));
    }

    @Override
    @NotNull
    public CompletableFuture<List<CLionSymbolInformation>> getSymbols(@NotNull String query, boolean onlyStatic) {
        if (query == null) {
            ClangdLanguageService.$$$reportNull$$$0(61);
        }
        CompletableFuture<List<CLionSymbolInformation>> result = new CompletableFuture<List<CLionSymbolInformation>>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("workspace/symbol").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionWorkspaceSymbol(new CLionWorkspaceSymbolParams(query, onlyStatic))))).onSkipped(() -> result.complete(Collections.emptyList())).onRejected(() -> result.complete(Collections.emptyList())).create());
        CompletableFuture<List<CLionSymbolInformation>> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(62);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<ClangFoundUsage>> getReferences(@NotNull String symID, boolean onlyStatic) {
        if (symID == null) {
            ClangdLanguageService.$$$reportNull$$$0(63);
        }
        CompletableFuture<List<ClangFoundUsage>> result = new CompletableFuture<List<ClangFoundUsage>>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("clionReferences").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionReferences(new ClionReferencesParams(symID, onlyStatic))))).onSkipped(() -> result.complete(Collections.emptyList())).onRejected(() -> result.complete(Collections.emptyList())).create());
        CompletableFuture<List<ClangFoundUsage>> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(64);
        }
        return completableFuture;
    }

    @Override
    public <E extends Throwable> void runWithParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(65);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(66);
        }
        this.computeWithParsed(file, response -> {
            consumer.consume(response);
            return null;
        });
    }

    @Override
    public <T, E extends Throwable> T computeWithParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(67);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(68);
        }
        return this.computeWithCustomParsed(file, null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithCustomParsed(@NotNull VirtualFile file, @Nullable ParsingParamsTransformer transform, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(69);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(70);
        }
        Ref response = Ref.create();
        Ref usageID = Ref.create();
        try {
            ReadAction.run(() -> {
                String url = file.getUrl();
                if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                    return;
                }
                ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
                try {
                    this.myWorkspace.modify(url, workspaceFile -> {
                        if (!workspaceFile.isOpened() && ClangDebugLevel.isWarnOrMore()) {
                            CidrLogService.logOnce((Level)Level.WARNING, (String)("Trying to parse closed file: " + workspaceFile.getUrl()), (Throwable)new Exception());
                        }
                        response.set((Object)this.getOrParse(file, (LocalWorkspaceFile)workspaceFile, transform, deferrer));
                        usageID.set((Object)this.trackParseUsage((LocalWorkspaceFile)workspaceFile, (ClangParseResponse)response.get()));
                    });
                }
                finally {
                    deferrer.runDeferred();
                }
            });
            T t = consumer.apply((ClangParseResponse)response.get());
            return t;
        }
        finally {
            if (!response.isNull() && !usageID.isNull()) {
                this.freeParseUsage((ClangParseResponse)response.get(), (Integer)usageID.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithOpenedAndCustomParsed(@NotNull VirtualFile file, @Nullable ParsingParamsTransformer transform, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(71);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(72);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "computeWithOpenedAndCustomParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            T t = this.computeWithCustomParsed(file, transform, consumer);
            return t;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computeWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableFunction<ClangParseResponse, T, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(73);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(74);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "computeWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            T t = this.computeWithParsed(file, consumer);
            return t;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> void runWithOpenedAndParsed(@NotNull VirtualFile file, @NotNull ThrowableConsumer<ClangParseResponse, E> consumer) throws E {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(75);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(76);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "runWithOpenedAndParsed for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            this.runWithParsed(file, consumer);
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    @NotNull
    private <T> ClangResultImpl<T> computeWithParsedInternal(@NonNls @NotNull String title, @NotNull VirtualFile file, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTReadRequest<?, T>> consumer) {
        if (title == null) {
            ClangdLanguageService.$$$reportNull$$$0(77);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(78);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(79);
        }
        ClangResultImpl clangResultImpl = (ClangResultImpl)ReadAction.compute(() -> {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
            }
            ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
            ClangResultImpl result = null;
            try {
                ClangResultImpl clangResultImpl = result = this.myWorkspace.apply(url, workspaceFile -> {
                    ClangParseResponse response = this.getOrParse(file, (LocalWorkspaceFile)workspaceFile, null, deferrer);
                    if (response != null) {
                        int parseUsageID = this.trackParseUsage((LocalWorkspaceFile)workspaceFile, response);
                        try {
                            ClangASTReadRequest request = (ClangASTReadRequest)consumer.apply((LocalWorkspaceFile)workspaceFile, response);
                            if (request != null) {
                                int reqUsageID = this.trackRequestUsage(request);
                                return new ClangResultImpl(title, request.getResponse(), () -> {
                                    this.freeRequestUsage(request, reqUsageID);
                                    this.freeParseUsage(response, parseUsageID);
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.freeParseUsage(response, parseUsageID);
                    }
                    return new ClangResultImpl<Object>(title, CompletableFuture.completedFuture(null));
                });
                return clangResultImpl;
            }
            finally {
                try {
                    deferrer.runDeferred();
                }
                catch (Throwable thr) {
                    if (result != null) {
                        result.release();
                    }
                    ExceptionUtil.rethrow((Throwable)thr);
                }
            }
        });
        if (clangResultImpl == null) {
            ClangdLanguageService.$$$reportNull$$$0(80);
        }
        return clangResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ClangResultImpl<T> computeWithOpenedAndParsedInternal(@NonNls @NotNull String title, @NotNull VirtualFile file, @NotNull BiFunction<LocalWorkspaceFile, ClangParseResponse, ClangASTReadRequest<?, T>> consumer) {
        if (title == null) {
            ClangdLanguageService.$$$reportNull$$$0(81);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(82);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(83);
        }
        SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), title + " for " + file.getPath() + "[" + System.identityHashCode(consumer) + "]");
        try {
            this.notifyDocumentOpened(file, openRequestId);
            ClangResultImpl<T> clangResultImpl = this.computeWithParsedInternal(title, file, consumer);
            return clangResultImpl;
        }
        finally {
            this.notifyDocumentClosed(file, openRequestId);
        }
    }

    protected static <T, E extends Throwable> void applyConsumer(@NotNull ClangResultConsumer<T, E> consumer, @NotNull ClangResultImpl<T> res) throws E {
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(84);
        }
        if (res == null) {
            ClangdLanguageService.$$$reportNull$$$0(85);
        }
        try {
            consumer.consume(res);
        }
        finally {
            res.release();
        }
    }

    private int trackParseUsage(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(86);
        }
        if (response == null) {
            return -1;
        }
        assert (wf.getUrl().contentEquals(response.getUrl()));
        UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
        int ID = ++usages.nextID;
        usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)response));
        return ID;
    }

    private void freeParseUsage(@NotNull ClangParseResponse response, int usageID) {
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(87);
        }
        this.myWorkspace.modify(response.getUrl(), wf -> {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)response);
                this.cancelParse((LocalWorkspaceFile)wf, response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int trackRequestUsage(@NotNull ClangAbstractRequest<?, ?> request) {
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(88);
        }
        ClangAbstractRequest<?, ?> clangAbstractRequest = request;
        synchronized (clangAbstractRequest) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent(request, USAGES_MAP, () -> new UsagesInfo());
            int ID = ++usages.nextID;
            usages.id2Stack.put(ID, this.debugTrackUsage((UserDataHolder)request));
            return ID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeRequestUsage(@NotNull ClangAbstractRequest<?, ?> request, int usageID) {
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(89);
        }
        ClangAbstractRequest<?, ?> clangAbstractRequest = request;
        synchronized (clangAbstractRequest) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent(request, USAGES_MAP, () -> new UsagesInfo());
            usages.id2Stack.remove(usageID);
            if (usages.id2Stack.isEmpty()) {
                this.debugFreeUsage((UserDataHolder)request);
                this.cancelRequest(request);
            }
        }
    }

    @Nullable
    private Exception debugTrackUsage(@NotNull UserDataHolder usedObject) {
        if (usedObject == null) {
            ClangdLanguageService.$$$reportNull$$$0(90);
        }
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            this.myDebugUsagesSet.add(usedObject);
            return new Exception();
        }
        return null;
    }

    private void debugFreeUsage(@NotNull UserDataHolder usedObject) {
        if (usedObject == null) {
            ClangdLanguageService.$$$reportNull$$$0(91);
        }
        if (Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            assert (usages != null && usages.id2Stack.isEmpty());
            this.myDebugUsagesSet.remove(usedObject);
        }
    }

    private static boolean isCanceled(@NotNull UserDataHolder something) {
        if (something == null) {
            ClangdLanguageService.$$$reportNull$$$0(92);
        }
        return something.getUserData(CANCELED_FLAG) != null;
    }

    private static void setCanceled(@NotNull UserDataHolder something) {
        if (something == null) {
            ClangdLanguageService.$$$reportNull$$$0(93);
        }
        something.putUserData(CANCELED_FLAG, (Object)true);
    }

    private void cancelParseGently(@NotNull LocalWorkspaceFile wf, @Nullable ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(94);
        }
        if (response != null) {
            UsagesInfo usages = ClangdLanguageService.computeIfAbsent((UserDataHolder)response, USAGES_MAP, () -> new UsagesInfo());
            if (usages.id2Stack.isEmpty()) {
                this.cancelParse(wf, response);
            }
        }
    }

    private void cancelParse(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse response) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(95);
        }
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(96);
        }
        if (response.isCancellable() && wf.getVersion() > response.getVersion() && !ClangParseResponse.areAnswersCompleted(response)) {
            this.sendCancelParse("cancelParse", response);
        }
    }

    private void cancelRequest(@NotNull ClangAbstractRequest<?, ?> request) {
        if (request == null) {
            ClangdLanguageService.$$$reportNull$$$0(97);
        }
        if (!ClangdLanguageService.isCanceled(request) && !request.getResponse().isDone()) {
            this.myRequestsPlanner.sendImmediately(request.cancel());
            ClangdLanguageService.setCanceled(request);
        }
    }

    private void sendCancelParse(@NotNull String reason, @NotNull ClangParseResponse response) {
        if (reason == null) {
            ClangdLanguageService.$$$reportNull$$$0(98);
        }
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(99);
        }
        if (!ClangdLanguageService.isCanceled((UserDataHolder)response)) {
            this.myRequestsPlanner.send(new ClangCancelParseNotification(this.myContext, response));
            ClangdLanguageService.setCanceled((UserDataHolder)response);
            response.nextOpState(ClangParseResponse.OpState.Failed);
            ClangParseResponse.completeAnswersExceptionally(response, (Throwable)((Object)new ClangdCanceledException(reason)));
        }
    }

    @NotNull
    private static <T> T computeIfAbsent(@NotNull UserDataHolder holder, @NotNull Key<T> key, @NotNull Producer<? extends T> producer) {
        Object data;
        if (holder == null) {
            ClangdLanguageService.$$$reportNull$$$0(100);
        }
        if (key == null) {
            ClangdLanguageService.$$$reportNull$$$0(101);
        }
        if (producer == null) {
            ClangdLanguageService.$$$reportNull$$$0(102);
        }
        if ((data = holder.getUserData(key)) == null) {
            data = producer.produce();
            assert (data != null);
            holder.putUserData(key, data);
        }
        Object object = data;
        if (object == null) {
            ClangdLanguageService.$$$reportNull$$$0(103);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        String string = this.myContext.getClangdModulesPath();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(104);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCpp20ModulesPath() {
        String string = this.myContext.getCpp20ModulesPath();
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(105);
        }
        return string;
    }

    @Override
    public boolean isIndexer() {
        return this.myContext.isIndexer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<ClangPreprocessedReport> generatePreprocessedReport(@NotNull List<String> urls, boolean allowOpeningFiles) {
        if (urls == null) {
            ClangdLanguageService.$$$reportNull$$$0(106);
        }
        CompletableFuture<ClangPreprocessedReport> result = new CompletableFuture<ClangPreprocessedReport>();
        ArrayList crashReportFutures = new ArrayList();
        java.util.function.Consumer<String> processUrl = url -> {
            CompletableFuture crashReportFuture = new CompletableFuture();
            crashReportFutures.add(crashReportFuture);
            ClangRemoteWorkspace ws = this.getContext().getRemoteWorkspace();
            String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
            String cpp20ModuleMapUrl = VirtualFileManager.constructUrl((String)"file", (String)this.getContext().getCpp20ModuleMapPath());
            String stdModuleMapUrl = VirtualFileManager.constructUrl((String)"file", (String)this.getContext().getModuleMapPath());
            String cpp20ModuleMap = StringUtil.notNullize((String)ws.getContent(cpp20ModuleMapUrl));
            String stdModuleMap = StringUtil.notNullize((String)ws.getContent(stdModuleMapUrl));
            ClangInteraction preprocessRequest = ClangInteraction.newInteraction("CrashReport").action((server, _ws) -> {
                ClionReparseTextDocumentParams cc = _ws.getReparseParams((String)url);
                String macros = StringUtil.notNullize((String)_ws.getContent(macrosUrl));
                ClangParseResponse lastParseResponse = this.myContext.getLocalWorkspace().apply((String)url, wf -> wf.getLastParseResponse());
                ClangUtils.tie(crashReportFuture, ((CompletableFuture)server.clionPreprocessFile(new CLionClangPreprocessParams(cc.getCompilationCommand(), null, null, null, null)).thenApply(res -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUrl((String)url), cc, macros, cpp20ModuleMap, stdModuleMap, lastParseResponse, res, null))).exceptionally(ex -> ClangdLanguageService.createPreprocessedFile(this.myContext.getUrlConverter().fromUrl((String)url), cc, macros, cpp20ModuleMap, stdModuleMap, lastParseResponse, null, ex)));
            }).requiresRecover().onSkipped(() -> crashReportFuture.complete(null)).onRejected(() -> crashReportFuture.complete(null)).create();
            ClangInteractionPromise preprocessPromise = new ClangInteractionPromiseImpl.Builder<ClangInteraction>(preprocessRequest).addReadAccessedProperties(macrosUrl, ClangProperty.Content).addWriteAccessedProperties(macrosUrl, ClangProperty.Content).addReadAccessedProperties((String)url, ClangProperty.Content).addReadAccessedProperties((String)url, ClangProperty.Ast).create();
            if (ws.getReparseParams((String)url) != null) {
                this.myRequestsPlanner.send(preprocessPromise);
            } else if (allowOpeningFiles) {
                ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
                this.myContext.getLocalWorkspace().modifyWithRead((String)url, wf -> {
                    VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file != null) {
                        this.scheduleReparse(file, (LocalWorkspaceFile)wf, null, deferrer, true);
                        this.myRequestsPlanner.send(preprocessPromise);
                    } else {
                        crashReportFuture.complete(null);
                    }
                });
                deferrer.runDeferred();
            } else {
                LOG.warn("Failed to get compilation command for previously parsed file " + url);
            }
        };
        for (String url2 : urls) {
            if (allowOpeningFiles) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url2);
                if (file == null) continue;
                SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "generatePreprocessedReport for " + file.getPath() + "[" + System.identityHashCode(processUrl) + "]");
                try {
                    this.notifyDocumentOpened(file, openRequestId);
                    processUrl.accept(url2);
                    continue;
                }
                finally {
                    this.notifyDocumentClosed(file, openRequestId);
                    continue;
                }
            }
            processUrl.accept(url2);
        }
        CompletableFuture.allOf(crashReportFutures.toArray(new CompletableFuture[0])).whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.warn("Failed to generate crash reports!", ex);
                result.complete(null);
                return;
            }
            try {
                ArrayList<ClangPreprocessedReport.PreprocessedFile> crashReports = new ArrayList<ClangPreprocessedReport.PreprocessedFile>();
                for (CompletableFuture reportFuture : crashReportFutures) {
                    assert (reportFuture.isDone());
                    ClangPreprocessedReport.PreprocessedFile file = (ClangPreprocessedReport.PreprocessedFile)reportFuture.get();
                    if (file == null) continue;
                    crashReports.add(file);
                }
                result.complete(new ClangPreprocessedReport(crashReports));
            }
            catch (InterruptedException | ExecutionException ee) {
                LOG.warn((Throwable)ee);
                result.complete(null);
            }
        });
        CompletableFuture<ClangPreprocessedReport> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(107);
        }
        return completableFuture;
    }

    private static @Nullable ClangPreprocessedReport.PreprocessedFile createPreprocessedFile(@NotNull String path, @NotNull ClionReparseTextDocumentParams cc, @NotNull String macros, @NotNull String cpp20ModuleMap, @NotNull String stdModuleMap, @Nullable ClangParseResponse lastParseReponse, @Nullable CLionClangPreprocessResult ppRes, @Nullable Throwable ex) {
        List lastDiagsList;
        Supplier lastDiagsSupplier;
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(108);
        }
        if (cc == null) {
            ClangdLanguageService.$$$reportNull$$$0(109);
        }
        if (macros == null) {
            ClangdLanguageService.$$$reportNull$$$0(110);
        }
        if (cpp20ModuleMap == null) {
            ClangdLanguageService.$$$reportNull$$$0(111);
        }
        if (stdModuleMap == null) {
            ClangdLanguageService.$$$reportNull$$$0(112);
        }
        if (ppRes == null && ex == null) {
            return null;
        }
        String lastDiags = null;
        if (lastParseReponse != null && (lastDiagsSupplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(lastParseReponse.getDiagnostics())) != null && (lastDiagsList = (List)lastDiagsSupplier.get()) != null) {
            StringBuilder lastDiagsBuilder = new StringBuilder();
            for (ClangDiagnostic lastDiag : lastDiagsList) {
                lastDiagsBuilder.append(lastDiag.toString()).append("\n");
            }
            lastDiags = lastDiagsBuilder.toString();
        }
        String clangTidyConfig = "";
        String clionClangTidyConfig = "";
        if (cc.getClangTidyOptions() != null) {
            clangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getConfig());
            clionClangTidyConfig = StringUtil.notNullize((String)cc.getClangTidyOptions().getClionConfig());
        }
        String clazyConfig = "";
        if (cc.getClazyOptions() != null) {
            clazyConfig = StringUtil.notNullize((String)cc.getClazyOptions().getConfig());
        }
        UnusedIncludesInspectionMode uiMode = cc.getUnusedIncludesInspectionMode() != null ? cc.getUnusedIncludesInspectionMode() : UnusedIncludesInspectionMode.Off;
        String diags = ex != null ? ExceptionUtil.getThrowableText((Throwable)ex) : "";
        String ppBody = ppRes != null ? ppRes.getOutput() : "";
        return new ClangPreprocessedReport.PreprocessedFile(path, lastDiags, cc.getCompilationCommand().getCommandLine(), clangTidyConfig, clionClangTidyConfig, clazyConfig, cc.getDFAOptions(), uiMode, diags, ppBody, macros, cpp20ModuleMap, stdModuleMap);
    }

    @Override
    @NotNull
    public String printStats(@NotNull String linePrefix) {
        if (linePrefix == null) {
            ClangdLanguageService.$$$reportNull$$$0(113);
        }
        String string = this.myContext.getLocalWorkspace().printStats(linePrefix) + linePrefix + "Num of pending duplicated reparse notifications = " + this.myNumOfPendingDuplicatedReparseNotifications.get() + "\n" + linePrefix + "Num of waiting deferred builders = " + this.myNumOfWaitingDefferedRequestBuilders.get() + "\n" + this.myContext.getCrashHandler().printStats(linePrefix + "Blacklist: ");
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(114);
        }
        return string;
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangUtils.warnClangd(LOG, this.printStats("  "));
        Disposer.dispose((Disposable)this.myContext);
        ClangStopData clangStopData = this.myRequestsPlanner.stop();
        if (clangStopData == null) {
            ClangdLanguageService.$$$reportNull$$$0(115);
        }
        return clangStopData;
    }

    @Override
    public int getVersion(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(116);
        }
        return this.myWorkspace.apply(file.getUrl(), wf -> wf.getVersion());
    }

    @Override
    @NotNull
    public CompletableFuture<ClionPublishDiagnosticsParams> checkPreprocessedCase(@NotNull File crashCase, @NotNull FullCompilationInfo ccInfo) {
        if (crashCase == null) {
            ClangdLanguageService.$$$reportNull$$$0(117);
        }
        if (ccInfo == null) {
            ClangdLanguageService.$$$reportNull$$$0(118);
        }
        ClangUrlConverter conv = this.myContext.getUrlConverter();
        String crashCaseUri = conv.toUri(crashCase, false);
        CLionCheckPreprocessedCaseParams params = new CLionCheckPreprocessedCaseParams(crashCaseUri, new ClionReparseTextDocumentParams(new VersionedTextDocumentIdentifier(crashCaseUri, Integer.valueOf(1)), new ClionCompileCommandParams(conv.toUri(new File(ccInfo.targetFile), false), conv.toUri(new File(ccInfo.entryFile), false), new File(ccInfo.entryFile).getParent(), ccInfo.compilationCommand, "/dev/null", ccInfo.usePredefines), new ClionClangTidyConfigParams(ccInfo.ourClangTidyConfig, ccInfo.clangTidyConfig, false), ccInfo.unusedMode, new CLionClazyConfigParams(ccInfo.clazyConfig), ClionWantDiagnostics.Yes, ccInfo.dfaOptions, 0));
        CompletableFuture<ClionPublishDiagnosticsParams> result = new CompletableFuture<ClionPublishDiagnosticsParams>();
        this.myRequestsPlanner.getServerAccessor().post(ClangInteraction.newInteraction("checkPreprocessedCase").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> ClangUtils.tie(result, server.clionCheckPreprocessedCase(params)))).onRejected(() -> result.complete(null)).onSkipped(() -> result.complete(null)).create());
        CompletableFuture<ClionPublishDiagnosticsParams> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(119);
        }
        return completableFuture;
    }

    @Override
    public boolean hadCrashes() {
        return this.myContext.getCrashHandler().hadCrashes();
    }

    @Override
    @Nullable
    public ClangdFatalError getFatalError() {
        return this.myRequestsPlanner.getServerAccessor().getFatalError();
    }

    @Override
    public boolean notifyDocumentOpened(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(120);
        }
        if (openRequestId == null) {
            ClangdLanguageService.$$$reportNull$$$0(121);
        }
        return this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return false;
            }
            ClangdLanguageService.addOpenRequest(wf, openRequestId);
            if (!wf.isOpened()) {
                Document document2 = this.myContext.getIdeFacade().getDocument(file);
                wf.preambleChanged(ClangUtils.skipPreamble(document2));
                int nextVersion = wf.nextOpen();
                this.myRequestsPlanner.send(ClangOpenNotification.create(this.myContext, file, nextVersion));
            }
            return true;
        });
    }

    private static void addOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(122);
        }
        if (id == null) {
            ClangdLanguageService.$$$reportNull$$$0(123);
        }
        Map<OpenRequestId, Integer> openRequests = wf.getOrDefault(OPEN_REQUESTS);
        if (id.ignoreSame()) {
            openRequests.putIfAbsent(id, 1);
        } else {
            openRequests.merge(id, 1, Integer::sum);
        }
    }

    @Override
    public void notifyDocumentClosed(@NotNull VirtualFile file, @NotNull OpenRequestId openRequestId) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(124);
        }
        if (openRequestId == null) {
            ClangdLanguageService.$$$reportNull$$$0(125);
        }
        String url = file.getUrl();
        if (!this.myContext.getUrlConverter().isAcceptable(url)) {
            return;
        }
        String macrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, url);
        this.myWorkspace.modifyWithRead(Arrays.asList(url, macrosUrl), files -> {
            LocalWorkspaceFile workspaceFile = (LocalWorkspaceFile)files.get(url);
            assert (workspaceFile != null) : "requested file must not be null!";
            LocalWorkspaceFile macrosWorkspaceFile = (LocalWorkspaceFile)files.get(macrosUrl);
            assert (macrosWorkspaceFile != null) : "requested macros file must not be null!";
            if (!this.isAcceptable(file)) {
                return;
            }
            if (!workspaceFile.isOpened()) {
                return;
            }
            if (ClangdLanguageService.removeOpenRequest(workspaceFile, openRequestId)) {
                boolean isSaved = !this.myIdeFacade.isModified(file);
                ClangFileFacade helper = this.myIdeFacade.getFileFacade(file);
                String content2 = helper != null ? helper.getText().toString() : "";
                workspaceFile.preambleChanged(workspaceFile.getPreambleBounds());
                int nextVersion = workspaceFile.nextClose();
                this.myRequestsPlanner.send(ClangCloseNotification.create(this.myContext, workspaceFile.getUrl(), nextVersion, content2, isSaved));
                workspaceFile.cancelPendingParses("File " + workspaceFile.getUrl() + " was closed at the server");
                if (macrosWorkspaceFile.getVersion() >= 0) {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, macrosWorkspaceFile.getUrl(), macrosWorkspaceFile.nextDelete()));
                }
            }
        });
    }

    @NotNull
    private static CharSequence notNullize(@Nullable CharSequence seq) {
        return seq != null ? seq : "";
    }

    private static boolean removeOpenRequest(@NotNull LocalWorkspaceFile wf, @NotNull OpenRequestId id) {
        Map<OpenRequestId, Integer> openRequests;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(126);
        }
        if (id == null) {
            ClangdLanguageService.$$$reportNull$$$0(127);
        }
        if ((openRequests = wf.get(OPEN_REQUESTS)).containsKey(id)) {
            openRequests.merge(id, -1, (oldV, newV) -> oldV + newV > 0 ? Integer.valueOf(oldV + newV) : null);
            return openRequests.isEmpty();
        }
        return false;
    }

    @Override
    public void notifyDocumentChanged(@NotNull VirtualFile file, @NotNull DocumentEvent event) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(128);
        }
        if (event == null) {
            ClangdLanguageService.$$$reportNull$$$0(129);
        }
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            int editLine = event.getDocument().getLineNumber(event.getOffset());
            if (editLine <= wf.getPreambleBounds()) {
                wf.preambleChanged(ClangUtils.skipPreamble(event.getDocument()));
            }
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = this.prepareChangeParams(event, file, nextVersion);
            boolean isSaved = !this.myIdeFacade.isModified(file);
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, params, isSaved));
        });
    }

    @Override
    public void notifyDocumentChanged(@NotNull String url, @NotNull String content2) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(130);
        }
        if (content2 == null) {
            ClangdLanguageService.$$$reportNull$$$0(131);
        }
        this.myWorkspace.modifyWithRead(url, wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            wf.preambleChanged(ClangUtils.skipPreamble(content2));
            int nextVersion = wf.nextChange();
            DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(this.myContext.getUrlConverter().toUriFromUrl(url), Integer.valueOf(nextVersion)), Collections.singletonList(new TextDocumentContentChangeEvent(content2)));
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, params, false));
        });
    }

    @Override
    public void notifyFolderChanged(@NotNull String oldUrl, @NotNull String newUrl) {
        if (oldUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(132);
        }
        if (newUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(133);
        }
        this.myRequestsPlanner.send(new ClangFolderChangeNotification(this.myContext, oldUrl, newUrl));
    }

    @NotNull
    private DidChangeTextDocumentParams prepareChangeParams(@NotNull DocumentEvent event, @NotNull VirtualFile file, int version) {
        if (event == null) {
            ClangdLanguageService.$$$reportNull$$$0(134);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(135);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextDocumentSyncKind syncKind = TextDocumentSyncKind.None;
        ServerCapabilities serverCapabilities = this.myRequestsPlanner.getServerAccessor().getCapabilities();
        if (serverCapabilities != null) {
            syncKind = serverCapabilities.getTextDocumentSync().isLeft() ? (TextDocumentSyncKind)serverCapabilities.getTextDocumentSync().getLeft() : ((TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight()).getChange();
        }
        Document document2 = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
        switch (syncKind) {
            case Incremental: {
                changeEvent.setText(ClangdLanguageService.notNullize(this.myIdeFacade.getFileFacade(file, document2).getText()).toString());
                break;
            }
            case None: 
            case Full: {
                changeEvent.setText(document2.getText());
            }
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(this.myContext.getUrlConverter().toUri(file));
        docId.setVersion(Integer.valueOf(version));
        return new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReparseRequired(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(136);
        }
        ClangHeavyRequestBuilder deferrer = new ClangHeavyRequestBuilder();
        try {
            String url = file.getUrl();
            if (!this.myContext.getUrlConverter().isAcceptable(url)) {
                return;
            }
            this.myWorkspace.modifyWithRead(url, wf -> this.scheduleReparse(file, (LocalWorkspaceFile)wf, null, deferrer, false));
        }
        finally {
            deferrer.runDeferred();
        }
    }

    @Nullable
    private ClangParseResponse scheduleReparse(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @Nullable ParsingParamsTransformer transform, @NotNull ClangHeavyRequestBuilder deferrer, boolean prepareOnly) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(137);
        }
        if (workspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(138);
        }
        if (deferrer == null) {
            ClangdLanguageService.$$$reportNull$$$0(139);
        }
        if (this.myContext.getProject().isDisposed()) {
            ClangUtils.warnClangd(LOG, "Will not reparse file " + file.getName() + " because project is already disposed.");
            return null;
        }
        if (!this.isAcceptable(file)) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not acceptable.");
            return null;
        }
        if (!workspaceFile.isOpened()) {
            ClangUtils.warnClangd(LOG, "Cannot reparse because file " + file.getName() + " is not opened locally.");
            return null;
        }
        ClangParseResponse prevResponse = workspaceFile.getLastParseResponse();
        ClangParseResponse response = workspaceFile.nextParse(file, true);
        response.putUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER, this.myIdeFacade.getPsiModificationCounter(this.myProject));
        response.putUserData(ClangParseResponse.PROFILE_MODIFICATION_COUNTER, this.myProfileModificationCounter.get());
        if (transform != null) {
            response.putUserData(ClangParseResponse.PARSING_PARAMS_TRANSFORM, transform);
        }
        this.cancelParseGently(workspaceFile, prevResponse);
        ClangInteractionPromise promise = ClangReparseNotification.createPromise(deferrer, this.myContext, file, response, prepareOnly);
        if (prepareOnly) {
            response.nextOpState(ClangParseResponse.OpState.Fake);
            ClangParseResponse.completeAnswers(response);
        }
        response.attachReparseNotification(promise);
        this.myRequestsPlanner.send(promise);
        ClangdLanguageService.addLoggingForParseNotification(response, promise);
        return response;
    }

    private boolean scheduleDuplicatedReparse(@NotNull ClangParseResponse response, @NotNull VirtualFile file, @NotNull ClangHeavyRequestBuilder deferrer) {
        ClangInteractionPromise newReparsePromise;
        List<ClangInteractionPromise> attached;
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(140);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(141);
        }
        if (deferrer == null) {
            ClangdLanguageService.$$$reportNull$$$0(142);
        }
        if ((attached = response.attachReparseNotification(newReparsePromise = ClangReparseNotification.createPromise(deferrer, this.myContext, file, response, false))) != null) {
            this.myNumOfPendingDuplicatedReparseNotifications.incrementAndGet();
            assert (!attached.isEmpty()) : "First reparse notification must already be attached";
            deferrer.laterFirst(() -> {
                this.myNumOfWaitingDefferedRequestBuilders.incrementAndGet();
                boolean needCancel = true;
                try {
                    CompletableFuture<Void> allPreviouslyAttachedAreReady = CompletableFuture.allOf(ContainerUtil.map((Collection)attached, promise -> promise.getInteraction()).toArray(new CompletableFuture[0]));
                    CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(allPreviouslyAttachedAreReady, (String)"ClangHeavyRequestBuilder: prevReparseFailed");
                    for (ClangInteractionPromise promise2 : attached) {
                        if (!CidrConcurrentUtilsKt.isCompletedNormally(promise2.getInteraction())) continue;
                        return;
                    }
                    needCancel = false;
                }
                catch (ExecutionException executionException) {
                }
                finally {
                    this.myNumOfWaitingDefferedRequestBuilders.decrementAndGet();
                    if (needCancel) {
                        newReparsePromise.getInteraction().cancel(false);
                    }
                }
            });
            this.myRequestsPlanner.send(newReparsePromise);
            newReparsePromise.getInteraction().whenComplete((res, ex) -> this.myNumOfPendingDuplicatedReparseNotifications.decrementAndGet());
            ClangdLanguageService.addLoggingForParseNotification(response, newReparsePromise);
            return true;
        }
        return false;
    }

    @Override
    public void notifyDocumentSaved(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(143);
        }
        this.myWorkspace.modifyWithRead(file.getUrl(), wf -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.isAcceptable(file)) {
                return;
            }
            this.myRequestsPlanner.send(new ClangSaveRequest(this.myContext, wf.getUrl()));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<List<? extends ClangCommandLineArgument>> parseCommandLine(@NotNull List<String> switches, @Nullable EnumSet<ClangOptionsFlags> flagsToInclude, @Nullable EnumSet<ClangOptionsFlags> flagsToExclude, @NotNull EnumSet<ClangVisibility> visibilityMask) {
        if (switches == null) {
            ClangdLanguageService.$$$reportNull$$$0(144);
        }
        if (visibilityMask == null) {
            ClangdLanguageService.$$$reportNull$$$0(145);
        }
        ClangCommandLine commandLine = new ClangCommandLine(switches, ClangdLanguageService.flagsEnumSetToBitField(flagsToInclude), ClangdLanguageService.flagsEnumSetToBitField(flagsToExclude), ClangdLanguageService.visibilityEnumSetToBitField(visibilityMask));
        ClangParseCommandLineRequest request = new ClangParseCommandLineRequest(commandLine);
        this.myRequestsPlanner.sendImmediately(request);
        CompletableFuture<List<? extends ClangCommandLineArgument>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(146);
        }
        return completableFuture;
    }

    private static int flagsEnumSetToBitField(@Nullable EnumSet<ClangOptionsFlags> flags) {
        if (flags == null) {
            return 0;
        }
        int bitField = 0;
        for (ClangOptionsFlags flag : flags) {
            bitField |= flag.getValue();
        }
        return bitField;
    }

    private static int visibilityEnumSetToBitField(@NotNull EnumSet<ClangVisibility> flags) {
        if (flags == null) {
            ClangdLanguageService.$$$reportNull$$$0(147);
        }
        int bitField = 0;
        for (ClangVisibility flag : flags) {
            bitField |= flag.getValue();
        }
        return bitField;
    }

    @Override
    public void notifyDocumentMoved(@NotNull VirtualFile newFile, @NotNull String oldUrl, @NotNull String newUrl) {
        if (newFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(148);
        }
        if (oldUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(149);
        }
        if (newUrl == null) {
            ClangdLanguageService.$$$reportNull$$$0(150);
        }
        ThreadingAssertions.assertEventDispatchThread();
        assert (newUrl.contentEquals(newFile.getUrl()));
        if (oldUrl.contentEquals(newUrl)) {
            return;
        }
        String oldMacrosUrl = ClangRequestsHelper.getMacrosFileUrl(this.myContext, oldUrl);
        this.myWorkspace.modifyWithRead(Arrays.asList(oldUrl, newUrl, oldMacrosUrl), mapOfFiles -> {
            LocalWorkspaceFile oldWf = (LocalWorkspaceFile)mapOfFiles.get(oldUrl);
            LocalWorkspaceFile oldMacrosWf = (LocalWorkspaceFile)mapOfFiles.get(oldMacrosUrl);
            LocalWorkspaceFile newWf = (LocalWorkspaceFile)mapOfFiles.get(newUrl);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            boolean oldIsAcceptable = oldWf.getVersion() > 0;
            boolean oldIsOpened = oldWf.isOpened();
            boolean newIsAcceptable = this.isAcceptable(newFile);
            if (oldIsAcceptable && newIsAcceptable) {
                if (oldIsOpened) {
                    Map<OpenRequestId, Integer> newOpenRequests = newWf.getOrDefault(OPEN_REQUESTS);
                    Map<OpenRequestId, Integer> oldOpenRequests = oldWf.getOrDefault(OPEN_REQUESTS);
                    oldOpenRequests.forEach((id, counter) -> newOpenRequests.merge((OpenRequestId)id, (Integer)counter, Integer::sum));
                    oldOpenRequests.clear();
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    oldWf.cancelPendingParses("File " + oldWf.getUrl() + " was deleted at the server");
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                    this.myRequestsPlanner.send(ClangOpenNotification.create(this.myContext, newFile, newWf.nextOpen()));
                } else {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                    this.sendContent(newWf, newFile);
                }
            } else if (oldIsAcceptable) {
                Map<OpenRequestId, Integer> oldEditors = oldWf.getOrDefault(OPEN_REQUESTS);
                oldEditors.clear();
                this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldWf.getUrl(), oldWf.nextDelete()));
                oldWf.cancelPendingParses("File " + oldWf.getUrl() + " was deleted at the server");
                if (oldIsOpened) {
                    this.myRequestsPlanner.send(new ClangDeleteNotification(this.myContext, oldMacrosWf.getUrl(), oldMacrosWf.nextDelete()));
                }
            } else if (newIsAcceptable) {
                List<OpenRequestId> openRequests = this.myIdeFacade.getOpenRequests(this.myProject, newFile);
                for (OpenRequestId openRequest : openRequests) {
                    this.notifyDocumentOpened(newFile, openRequest);
                }
                if (!newWf.isOpened() && this.myIdeFacade.isModified(newFile)) {
                    this.sendContent(newWf, newFile);
                }
            }
        });
    }

    @Override
    public void notifySetCDB(@NotNull Collection<VirtualFile> forFiles) {
        if (forFiles == null) {
            ClangdLanguageService.$$$reportNull$$$0(151);
        }
        Application app = ApplicationManager.getApplication();
        assert (app.isUnitTestMode() && EDT.isCurrentThreadEdt() || !app.isReadAccessAllowed() && !EDT.isCurrentThreadEdt()) : "notifySetCDB() should be called either from background thread without read access, or from EDT in tests";
        ArrayList<ClionCompileCommandParams> commands = new ArrayList<ClionCompileCommandParams>();
        ArrayList<String> macrosPaths = new ArrayList<String>();
        ArrayList<String> macrosContents = new ArrayList<String>();
        Cpp20ModulesContext cpp20ModulesContext = Cpp20ModulesContext.create(this.myContext);
        Integer userBatchSize = (Integer)this.myContext.getProject().getUserData(ClangDaemonContext.CDB_BATCH_SIZE);
        int batchSize = userBatchSize != null ? userBatchSize : 2048;
        int counter = 0;
        for (VirtualFile file : forFiles) {
            ClangdCompilationCommand command;
            ClangUrlConverter urlConv = this.myContext.getUrlConverter();
            String macrosPath = ClangRequestsHelper.getMacrosFilePath(this.myContext, file.getUrl()).getPath();
            try {
                command = (ClangdCompilationCommand)CidrConcurrentUtilsKt.waitCancelAware(this.myIdeFacade.getCompilationCommandAsync(urlConv, this.myProject, file, macrosPath, cpp20ModulesContext), (String)"compilation command");
            }
            catch (ExecutionException ex) {
                ClangUtils.LOG.error((Throwable)ex);
                command = null;
            }
            if (command == null) continue;
            if (counter++ % batchSize == 0 && !commands.isEmpty()) {
                ClionSetCDBParams batch = new ClionSetCDBParams(new ArrayList<ClionCompileCommandParams>(commands), new ArrayList<String>(macrosPaths), new ArrayList<String>(macrosContents), false);
                this.myRequestsPlanner.sendImmediately(new ClangSetCDBNotification(batch));
                commands.clear();
                macrosPaths.clear();
                macrosContents.clear();
            }
            commands.add(command.ccParams);
            macrosPaths.add(macrosPath);
            macrosContents.add(command.ppDefines);
        }
        ClionSetCDBParams lastBatch = new ClionSetCDBParams(commands, macrosPaths, macrosContents, true);
        this.myRequestsPlanner.sendImmediately(new ClangSetCDBNotification(lastBatch));
    }

    @NotNull
    private TextDocumentIdentifier convertPathToDoc(@NotNull String path) {
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(152);
        }
        return new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(new File(path), false));
    }

    @Override
    public void notifyLoadIndex(@NotNull List<String> deletedPaths, @NotNull String symbolsDirPath) {
        if (deletedPaths == null) {
            ClangdLanguageService.$$$reportNull$$$0(153);
        }
        if (symbolsDirPath == null) {
            ClangdLanguageService.$$$reportNull$$$0(154);
        }
        List deletedPathsDocs = ContainerUtil.map(deletedPaths, p -> this.convertPathToDoc((String)p));
        TextDocumentIdentifier dirPath = this.convertPathToDoc(symbolsDirPath);
        ClionReloadIndexParams NotifParams = new ClionReloadIndexParams(deletedPathsDocs, dirPath);
        this.myRequestsPlanner.sendImmediately(new ClangReloadIndexNotification(NotifParams));
    }

    @Override
    public void notifyLoadGraph(@NotNull String path) {
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(155);
        }
        this.myRequestsPlanner.sendImmediately(new ClangReloadGraphNotification(this.convertPathToDoc(path)));
    }

    @Override
    public void notifyIndexPartFinished(@NotNull String path) {
        if (path == null) {
            ClangdLanguageService.$$$reportNull$$$0(156);
        }
        this.myRequestsPlanner.sendImmediately(new ClangIndexPartFinishedNotification(this.convertPathToDoc(path)));
    }

    @Override
    public void notifyModuleMappingChanged(@NotNull List<String> moduleNames, @NotNull List<ClionCompileCommandParams> moduleCompileCommands, @NotNull List<String> modulePPDefines) {
        if (moduleNames == null) {
            ClangdLanguageService.$$$reportNull$$$0(157);
        }
        if (moduleCompileCommands == null) {
            ClangdLanguageService.$$$reportNull$$$0(158);
        }
        if (modulePPDefines == null) {
            ClangdLanguageService.$$$reportNull$$$0(159);
        }
        CLionModuleMappingParams mapping = new CLionModuleMappingParams(moduleNames, moduleCompileCommands, modulePPDefines);
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("ModuleMappingsChanged").action((server, ws) -> {
            server.clionModuleMappingsChanged(mapping);
            ws.setCpp20ModuleMapping(mapping);
        }).onSkipped((Consumer<? super ClangRemoteWorkspace>)((Consumer)ws -> ws.setCpp20ModuleMapping(mapping))).create());
    }

    @Nullable
    public Endpoint remoteEndpoint() {
        return this.myRequestsPlanner.getServerAccessor().getRemoteEndpoint();
    }

    @Nullable
    public ServerConnection serverConnection() {
        return this.myRequestsPlanner.getServerAccessor().getServerConnection();
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> startUpServer() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ServerConnection connection = this.myRequestsPlanner.getServerAccessor().getServerConnection();
        if (connection == null || !connection.isActive()) {
            this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("startUpServer").requiresRecover().action((Consumer<? super ClangServer>)((Consumer)server -> result.complete(true))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).create());
        } else {
            result.complete(true);
        }
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(160);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public ClangStopData shutDownServer() {
        ClangStopData clangStopData = this.myRequestsPlanner.getServerAccessor().shutDown();
        if (clangStopData == null) {
            ClangdLanguageService.$$$reportNull$$$0(161);
        }
        return clangStopData;
    }

    @Override
    public boolean isFileBanned(@NotNull String url) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(162);
        }
        return !ClangRequestsHelper.isAllowedByGuard(this.myContext, url);
    }

    @Override
    public void printServerState() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpServerState").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDumpServerState())).requiresRecover().create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugDumpUsages(@NotNull String url) {
        if (url == null) {
            ClangdLanguageService.$$$reportNull$$$0(163);
        }
        if (!Registry.is((String)"clion.clang.clangd.debug.cancellation")) {
            return "Did you forget to turn on 'clion.clang.clangd.debug.cancellation'?\n";
        }
        BiConsumer<StringBuilder, UserDataHolder> usagesDumper = (sb, usedObject) -> {
            if (sb == null) {
                ClangdLanguageService.$$$reportNull$$$0(239);
            }
            if (usedObject == null) {
                ClangdLanguageService.$$$reportNull$$$0(240);
            }
            UsagesInfo usages = (UsagesInfo)usedObject.getUserData(USAGES_MAP);
            sb.append("usage counter = ").append(usages != null ? usages.id2Stack.size() : 0).append("\n");
            if (usages != null && !usages.id2Stack.isEmpty()) {
                usages.id2Stack.values().forEach(ex -> {
                    sb.append("=== Usage:");
                    if (ex != null) {
                        StackTraceElement[] stackTrace = ex.getStackTrace();
                        for (int i = 0; i < Math.min(stackTrace.length, 20); ++i) {
                            StackTraceElement trace = stackTrace[i];
                            sb.append("  ").append(trace.toString()).append("\n");
                        }
                    } else {
                        sb.append(" stack trace is not available. Did you forget to turn on 'clion.clang.clangd.debug.cancellation'?\n");
                    }
                });
            }
        };
        StringBuilder sb2 = new StringBuilder();
        Set<UserDataHolder> copyOfUsagesSet = Collections.newSetFromMap(new IdentityHashMap());
        Set<UserDataHolder> set = this.myDebugUsagesSet;
        synchronized (set) {
            copyOfUsagesSet.addAll(this.myDebugUsagesSet);
        }
        for (UserDataHolder holder : copyOfUsagesSet) {
            ClangAbstractRequest request;
            if (holder instanceof ClangParseResponse) {
                ClangParseResponse response = (ClangParseResponse)holder;
                this.myWorkspace.modify(response.getUrl(), wf -> {
                    sb2.append("Parse ").append(response.getVersion()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)response) ? "canceled" : "not canceled").append(", ").append(response.isCancellable() ? "cancellable" : "not cancellable").append(", ").append(ClangParseResponse.areAnswersCompleted(response) ? "completed" : "not completed").append(", ");
                    usagesDumper.accept(sb2, (UserDataHolder)response);
                });
                continue;
            }
            if (!(holder instanceof ClangAbstractRequest)) continue;
            ClangAbstractRequest clangAbstractRequest = request = (ClangAbstractRequest)holder;
            synchronized (clangAbstractRequest) {
                sb2.append(request.getClass().getSimpleName()).append(": ").append(ClangdLanguageService.isCanceled((UserDataHolder)request) ? "canceled" : "not canceled").append(", ").append(request.getResponse().isDone() ? "completed" : "not completed").append(", ");
                usagesDumper.accept(sb2, (UserDataHolder)request);
            }
        }
        return sb2.toString();
    }

    @Override
    @NotNull
    public CompletableFuture<ClangMemoryUsageInfo> getMemoryStat() {
        CompletableFuture<ClangMemoryUsageInfo> answer = new CompletableFuture<ClangMemoryUsageInfo>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("DumpMemoryStat").action((Consumer<? super ClangServer>)((Consumer)server -> server.clionDebugDumpMemoryStat().whenComplete((info, ex) -> {
            if (ex != null) {
                answer.completeExceptionally((Throwable)ex);
                return;
            }
            ClangMemoryUsageInfo memoryUsageInfo = new ClangMemoryUsageInfo(info.getWorkingSet(), info.getDrafts(), info.getUnsaved(), ContainerUtil.map(info.getPerFile(), p -> new ClangMemoryUsageInfo.PerFile(p.getPath(), p.getKb())));
            answer.complete(memoryUsageInfo);
            this.myIdeFacade.sendMessageLater(() -> {
                if (this.myContext.canPublishMessage()) {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMemoryUsageInfoReceived(memoryUsageInfo);
                }
            });
        }))).onSkipped(() -> answer.complete(null)).onRejected(() -> answer.complete(null)).create());
        CompletableFuture<ClangMemoryUsageInfo> completableFuture = answer;
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(164);
        }
        return completableFuture;
    }

    @Override
    public void debugCrashServer() {
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("CrashServer").action((Consumer<? super ClangServer>)((Consumer)server -> {
            server.shutdown();
            server.exit();
        })).create());
    }

    @Override
    public void waitUntilTasksFinished() {
        if (this.isActive()) {
            this.myRequestsPlanner.waitUntilTasksFinished();
        }
    }

    @Override
    public int getServerPid() {
        return ClangLanguageServiceUtils.getServerPid(this.serverConnection());
    }

    @Override
    @NonNls
    @NotNull
    public String getNativeStacktrace() {
        String string = ClangLanguageServiceUtils.getNativeStacktrace(this.serverConnection());
        if (string == null) {
            ClangdLanguageService.$$$reportNull$$$0(165);
        }
        return string;
    }

    @NotNull
    private <T> CompletableFuture<T> ifOpened(@NotNull VirtualFile file, @NotNull Function<LocalWorkspaceFile, CompletableFuture<T>> consumer) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(166);
        }
        if (consumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(167);
        }
        CompletableFuture completableFuture = this.myWorkspace.applyWithRead(file.getUrl(), wf -> {
            if (!wf.isOpened()) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)consumer.apply((LocalWorkspaceFile)wf);
        });
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(168);
        }
        return completableFuture;
    }

    private static void addLoggingForParseNotification(@NotNull ClangParseResponse response, @NotNull ClangInteractionPromise parsePromise) {
        if (response == null) {
            ClangdLanguageService.$$$reportNull$$$0(169);
        }
        if (parsePromise == null) {
            ClangdLanguageService.$$$reportNull$$$0(170);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            String duplicated = response.isFirstReparseNotification(parsePromise) ? "" : "duplicated ";
            LOG.warn("Scheduled " + duplicated + "reparse notification for file " + response.getUrl() + " of version " + response.getVersion());
            parsePromise.getInteraction().whenComplete((res, ex) -> {
                boolean isCanceled = CidrConcurrentUtilsKt.isCompletedByCancel(parsePromise.getInteraction());
                String op = isCanceled ? "Cancelled " : (ex != null ? "Failed " : "Completed ");
                String message = op + duplicated + "reparse notification for file " + response.getUrl() + " of version " + response.getVersion();
                if (ex != null && !isCanceled) {
                    LOG.warn(message, ex);
                } else {
                    LOG.warn(message);
                }
            });
        }
    }

    @Nullable
    private ClangParseResponse getOrParse(@NotNull VirtualFile file, @NotNull LocalWorkspaceFile workspaceFile, @Nullable ParsingParamsTransformer transform, @Nullable ClangHeavyRequestBuilder deferrer) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(171);
        }
        if (workspaceFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(172);
        }
        if (!workspaceFile.isOpened()) {
            return null;
        }
        ClangParseResponse reparsedFile = workspaceFile.getLastParseResponse();
        if (reparsedFile != null) {
            if (transform != null) {
                reparsedFile = null;
            } else if (reparsedFile.getUserData(ClangParseResponse.PARSING_PARAMS_TRANSFORM) != null) {
                reparsedFile = null;
            } else if (reparsedFile.getVersion() < workspaceFile.getVersion()) {
                reparsedFile = null;
            } else if (ClangdLanguageService.isCanceled((UserDataHolder)reparsedFile)) {
                reparsedFile = null;
            } else if (!reparsedFile.getOpState().isValid()) {
                reparsedFile = null;
            } else {
                Long lastReparsedAtCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PSI_GLOBAL_MODIFICATION_COUNTER);
                Long currentCounter = this.myIdeFacade.getPsiModificationCounter(this.myProject);
                if (currentCounter != null && lastReparsedAtCounter != null && currentCounter > lastReparsedAtCounter) {
                    reparsedFile = null;
                } else {
                    Long lastReparsedProfileCounter = (Long)reparsedFile.getUserData(ClangParseResponse.PROFILE_MODIFICATION_COUNTER);
                    long curProfileModCounter = this.myProfileModificationCounter.get();
                    if (lastReparsedProfileCounter != null && curProfileModCounter > lastReparsedProfileCounter) {
                        reparsedFile = null;
                    }
                }
            }
        }
        if (deferrer != null) {
            if (reparsedFile != null && reparsedFile.getOpState() == ClangParseResponse.OpState.None && !this.scheduleDuplicatedReparse(reparsedFile, file, deferrer)) {
                deferrer.clear();
                reparsedFile = null;
            }
            if (reparsedFile == null) {
                reparsedFile = this.scheduleReparse(file, workspaceFile, transform, deferrer, false);
            }
        }
        return reparsedFile;
    }

    @Nullable
    private ClangGotoDefinitionRequest sendGotoDefinition(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(173);
        }
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(174);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(175);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoDefinitionRequest cachedAnswer = (ClangGotoDefinitionRequest)this.myGotoDefinitionCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            if (!cachedAnswer.getResponse().isDone()) {
                return cachedAnswer;
            }
            if (!cachedAnswer.getResponse().isCompletedExceptionally()) {
                try {
                    List answer = (List)cachedAnswer.getResponse().get();
                    if (answer != null && !answer.isEmpty()) {
                        return cachedAnswer;
                    }
                }
                catch (Throwable answer) {
                    // empty catch block
                }
            }
        }
        if ((paramsAndRange = this.getParamsAndRange(file, offset)) == null) {
            return null;
        }
        ClangGotoDefinitionRequest gotoRequest = new ClangGotoDefinitionRequest(this.myContext, wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(gotoRequest);
        ClangdLanguageService.cacheGotoRequest(this.myGotoDefinitionCache, requestCacheKey, gotoRequest, reparse, (TextRange)paramsAndRange.second);
        return gotoRequest;
    }

    @Nullable
    private ClangGotoTypeDeclarationRequest sendGotoTypeDeclaration(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(176);
        }
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(177);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(178);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GotoDefinitionKey requestCacheKey = new GotoDefinitionKey(reparse, offset);
        ClangGotoTypeDeclarationRequest cachedAnswer = (ClangGotoTypeDeclarationRequest)this.myGotoTypeDeclarationCache.getIfPresent((Object)requestCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangGotoTypeDeclarationRequest gotoRequest = new ClangGotoTypeDeclarationRequest(this.myContext, wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(gotoRequest);
        ClangdLanguageService.cacheGotoRequest(this.myGotoTypeDeclarationCache, requestCacheKey, gotoRequest, reparse, (TextRange)paramsAndRange.second);
        return gotoRequest;
    }

    @Nullable
    private ClangClionHoverInfoRequest sendClionHoverInfo(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(179);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(180);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HoverInfoKey hoverInfoKey = new HoverInfoKey(file.getUrl(), offset);
        ClangClionHoverInfoRequest cachedAnswer = (ClangClionHoverInfoRequest)this.myContentDependentCache.getHoverInfoCache().get(hoverInfoKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangClionHoverInfoRequest hoverInfoRequest = new ClangClionHoverInfoRequest(wf.getUrl(), (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(hoverInfoRequest);
        this.myContentDependentCache.getHoverInfoCache().put(hoverInfoKey, hoverInfoRequest);
        return hoverInfoRequest;
    }

    @Nullable
    private ClangHoverRequest sendHoverRequest(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(181);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(182);
        }
        HoverInfoKey hoverKey = new HoverInfoKey(file.getUrl(), offset);
        ClangHoverRequest cachedAnswer = (ClangHoverRequest)this.myContentDependentCache.getFullHoverInfoCache().get(hoverKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange = this.getParamsAndRange(file, offset);
        if (paramsAndRange == null) {
            return null;
        }
        ClangHoverRequest hoverRequest = new ClangHoverRequest(wf.getUrl(), new HoverParams(((TextDocumentPositionParams)paramsAndRange.first).getTextDocument(), ((TextDocumentPositionParams)paramsAndRange.first).getPosition()));
        this.myRequestsPlanner.send(hoverRequest);
        this.myContentDependentCache.getFullHoverInfoCache().put(hoverKey, hoverRequest);
        return hoverRequest;
    }

    @Nullable
    private ClangClionLineMarkersRequest sendClionLineMarkers(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int fromOffset, int toOffset, boolean fast) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(183);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(184);
        }
        LineMarkersKey lineMarkersCacheKey = new LineMarkersKey(file.getUrl(), fromOffset, toOffset, fast);
        ClangClionLineMarkersRequest cachedAnswer = (ClangClionLineMarkersRequest)this.myContentDependentCache.getLineMarkersCache().get(lineMarkersCacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        Range lspRange = ClangLanguageServiceUtils.offsets2Range(document2, fromOffset, toOffset);
        ClangClionLineMarkersRequest request = new ClangClionLineMarkersRequest(wf.getUrl(), docIdent, lspRange, fast);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getLineMarkersCache().put(lineMarkersCacheKey, request);
        return request;
    }

    @Nullable
    private ClangTestLineMarkersRequest sendClionTestLineMarkers(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, @NotNull List<String> enabledFrameworkNames) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(185);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(186);
        }
        if (enabledFrameworkNames == null) {
            ClangdLanguageService.$$$reportNull$$$0(187);
        }
        TestLineMarkersKey cacheKey = new TestLineMarkersKey(file.getUrl(), enabledFrameworkNames);
        ClangTestLineMarkersRequest cachedAnswer = (ClangTestLineMarkersRequest)this.myContentDependentCache.getTestLineMarkersCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            return null;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        ClangTestLineMarkersRequest request = new ClangTestLineMarkersRequest(wf.getUrl(), docIdent, enabledFrameworkNames);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getTestLineMarkersCache().put(cacheKey, request);
        return request;
    }

    @NotNull
    private ClangInlayHintsRequest sendInlayHints(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, @Nullable ClionClangNamehintConfigParams parameterConfig, @Nullable ClionClangTypehintConfigParams typeConfig) {
        ClangInlayHintsRequest cachedAnswer;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(188);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(189);
        }
        boolean isLightVirtualFile = file instanceof LightVirtualFile;
        InlayHintsKey cacheKey = new InlayHintsKey(file.getUrl(), parameterConfig, typeConfig);
        if (!isLightVirtualFile && (cachedAnswer = (ClangInlayHintsRequest)this.myContentDependentCache.getInlayHintsCache().get(cacheKey)) != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            ClangInlayHintsRequest clangInlayHintsRequest = cachedAnswer;
            if (clangInlayHintsRequest == null) {
                ClangdLanguageService.$$$reportNull$$$0(190);
            }
            return clangInlayHintsRequest;
        }
        TextDocumentIdentifier docIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        ClangInlayHintsRequest request = new ClangInlayHintsRequest(this.myContext, wf.getUrl(), file, docIdent, parameterConfig, typeConfig);
        this.myRequestsPlanner.send(request);
        if (!isLightVirtualFile) {
            this.myContentDependentCache.getInlayHintsCache().put(cacheKey, request);
        }
        ClangInlayHintsRequest clangInlayHintsRequest = request;
        if (clangInlayHintsRequest == null) {
            ClangdLanguageService.$$$reportNull$$$0(191);
        }
        return clangInlayHintsRequest;
    }

    @Nullable
    private ClangSignatureHelpRequest sendSignatureHelp(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(192);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(193);
        }
        SignatureHelpKey cacheKey = new SignatureHelpKey(file.getUrl(), offset);
        ClangSignatureHelpRequest cachedAnswer = (ClangSignatureHelpRequest)this.myContentDependentCache.getSignatureHelpCache().get(cacheKey);
        if (cachedAnswer != null && !ClangdLanguageService.isCanceled((UserDataHolder)cachedAnswer)) {
            return cachedAnswer;
        }
        TextDocumentPositionParams params = this.toTextDocumentPositionParams(file, offset);
        if (params == null) {
            return null;
        }
        ClangSignatureHelpRequest request = new ClangSignatureHelpRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        this.myContentDependentCache.getSignatureHelpCache().put(cacheKey, request);
        return request;
    }

    @Nullable
    private ClangFindUsagesRequest sendFindUsages(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        Pair posAndRange;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(194);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(195);
        }
        if ((posAndRange = this.findLine(file, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        })) == null) {
            return null;
        }
        CLionFindUsagesParams params = new CLionFindUsagesParams((TextDocumentPositionParams)posAndRange.first);
        params.setOnlyStatic(ClangdSettings.getInstance(this.myProject).getIndexerStaticOnly());
        ClangFindUsagesRequest request = new ClangFindUsagesRequest(wf, params);
        this.myRequestsPlanner.send(request);
        return request;
    }

    @Nullable
    private ClangGetLocalVariablesRequest sendGetLocalVariables(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int line) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(196);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(197);
        }
        TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        Position position = new Position(line, 0);
        TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
        ClangGetLocalVariablesRequest request = new ClangGetLocalVariablesRequest(this.myContext, wf, params);
        this.myRequestsPlanner.send(ClangGetLocalVariablesRequest.createPromise(this.myContext, request));
        return request;
    }

    @Nullable
    private ClangMatchAngleBracketRequest sendMatchAngleBracket(@NotNull LocalWorkspaceFile wf, @NotNull ClangParseResponse reparse, @NotNull VirtualFile file, int offset) {
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(198);
        }
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(199);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(200);
        }
        if ((paramsAndRange = this.getParamsAndRange(file, offset)) == null) {
            return null;
        }
        ClangMatchAngleBracketRequest matchRequest = new ClangMatchAngleBracketRequest(wf, (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(matchRequest.createPromise());
        return matchRequest;
    }

    @Nullable
    private ClangMatchPPRequest sendMatchPP(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        Pair<TextDocumentPositionParams, TextRange> paramsAndRange;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(201);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(202);
        }
        if ((paramsAndRange = this.getParamsAndRange(file, offset)) == null) {
            return null;
        }
        ClangMatchPPRequest matchPPRequest = new ClangMatchPPRequest(wf.getUrl(), (TextDocumentPositionParams)paramsAndRange.first);
        this.myRequestsPlanner.send(matchPPRequest.createPromise());
        return matchPPRequest;
    }

    @Nullable
    private ClangDumpASTRequest sendDumpAST(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(203);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(204);
        }
        if ((params = this.toTextDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        ClangDumpASTRequest dumpASTRequest = new ClangDumpASTRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(dumpASTRequest);
        return dumpASTRequest;
    }

    @NotNull
    private CompletableFuture<String> sendRequestClangFormatConfiguration(@NotNull VirtualFile file) {
        TextDocumentPositionParams params;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(205);
        }
        if ((params = this.toTextDocumentPositionParams(file, 0)) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(206);
            }
            return completableFuture;
        }
        ClangFormatConfigurationRequest formatConfigurationRequest = new ClangFormatConfigurationRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(formatConfigurationRequest);
        CompletableFuture<String> completableFuture = formatConfigurationRequest.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(207);
        }
        return completableFuture;
    }

    @Nullable
    private ClangDumpTokensRequest sendDumpTokens(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int offset) {
        TextDocumentPositionParams params;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(208);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(209);
        }
        if ((params = this.toTextDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        ClangDumpTokensRequest request = new ClangDumpTokensRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        return request;
    }

    @NotNull
    private static FormattingOptions buildFormattingOptions(@Nullable String style) {
        FormattingOptions options = new FormattingOptions(4, true);
        if (style != null) {
            options.putString("style", "#yaml\n" + style);
        }
        FormattingOptions formattingOptions = options;
        if (formattingOptions == null) {
            ClangdLanguageService.$$$reportNull$$$0(210);
        }
        return formattingOptions;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendFormatRangeRequest(@NotNull VirtualFile file, @NotNull TextRange range, @Nullable String style, int cursorOffset) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(211);
        }
        if (range == null) {
            ClangdLanguageService.$$$reportNull$$$0(212);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(213);
            }
            return completableFuture;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document2.getText());
        Position cursorPosition = cursorOffset < 0 ? new Position(-1, -1) : ClangLanguageServiceUtils.offset2LspPos(document2, cursorOffset);
        CLionDocumentRangeFormattingParams params = new CLionDocumentRangeFormattingParams(identifier, options, new Range(ClangLanguageServiceUtils.offset2LspPos(document2, range.getStartOffset()), ClangLanguageServiceUtils.offset2LspPos(document2, range.getEndOffset())), cursorPosition);
        ClangFormatRangeRequest request = new ClangFormatRangeRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(request);
        CompletableFuture<List<ClangLineColReplace>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(214);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<List<ClangLightSymbolInfoResponse>> sendClionLightIndex(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(215);
        }
        ClangLightIndexRequest request = new ClangLightIndexRequest(new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file)));
        this.myRequestsPlanner.send(request);
        CompletableFuture<List<ClangLightSymbolInfoResponse>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(216);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<List<ClangLineColReplace>> sendIndentRequest(@NotNull VirtualFile file, int lineStartOffset, @Nullable String style) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(217);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = this.myContext.getIdeFacade().getDocument(file);
        if (document2 == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                ClangdLanguageService.$$$reportNull$$$0(218);
            }
            return completableFuture;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
        DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams(ClangLanguageServiceUtils.offset2LspPos(document2, lineStartOffset), "\n");
        params.setTextDocument(identifier);
        FormattingOptions options = ClangdLanguageService.buildFormattingOptions(style);
        options.putString("code", document2.getText());
        params.setOptions(options);
        ClangIndentRequest request = new ClangIndentRequest(file.getUrl(), params);
        this.myRequestsPlanner.send(request);
        CompletableFuture<List<ClangLineColReplace>> completableFuture = request.getResponse();
        if (completableFuture == null) {
            ClangdLanguageService.$$$reportNull$$$0(219);
        }
        return completableFuture;
    }

    @NotNull
    private ClangCompletionRequest sendRequestComplete(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull CompletionTriggerKind kind, int completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(220);
        }
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(221);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(222);
        }
        if (kind == null) {
            ClangdLanguageService.$$$reportNull$$$0(223);
        }
        CLionCompletionParams params = this.toCompletionParams(file, line, column, fileText, completionKind, postfixTemplates);
        CompletionContext context = new CompletionContext();
        context.setTriggerKind(kind);
        params.setContext(context);
        ClangCompletionRequest request = new ClangCompletionRequest(wf.getUrl(), params);
        this.myRequestsPlanner.send(request);
        ClangCompletionRequest clangCompletionRequest = request;
        if (clangCompletionRequest == null) {
            ClangdLanguageService.$$$reportNull$$$0(224);
        }
        return clangCompletionRequest;
    }

    @Nullable
    private Pair<TextDocumentIdentifier, Position> textDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(225);
        }
        return this.findLine(file, offset, (text, lineColumn) -> Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file)), (Object)new Position(lineColumn.line, lineColumn.column)));
    }

    private <R> R findLine(@NotNull VirtualFile file, int offset, @NotNull BiFunction<CharSequence, LineColumn, R> lineConsumer) {
        CharSequence content2;
        ClangFileFacade helper;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(226);
        }
        if (lineConsumer == null) {
            ClangdLanguageService.$$$reportNull$$$0(227);
        }
        LineColumn lineColumn = (helper = this.myIdeFacade.getFileFacade(file)) != null ? helper.getLineColumn(offset) : null;
        CharSequence charSequence = content2 = helper != null ? helper.getText() : null;
        if (content2 == null || lineColumn == null) {
            return null;
        }
        return lineConsumer.apply(content2, lineColumn);
    }

    private static <T> void cacheGotoRequest(@NotNull Cache<GotoDefinitionKey, T> cache, @NotNull GotoDefinitionKey requestCacheKey, @NotNull T gotoRequest, @NotNull ClangParseResponse reparse, @Nullable TextRange range) {
        if (cache == null) {
            ClangdLanguageService.$$$reportNull$$$0(228);
        }
        if (requestCacheKey == null) {
            ClangdLanguageService.$$$reportNull$$$0(229);
        }
        if (gotoRequest == null) {
            ClangdLanguageService.$$$reportNull$$$0(230);
        }
        if (reparse == null) {
            ClangdLanguageService.$$$reportNull$$$0(231);
        }
        if (!ClangParseResponse.areAnswersCompleted(reparse)) {
            return;
        }
        if (range != null) {
            for (int cacheOffset = range.getStartOffset(); cacheOffset < range.getEndOffset(); ++cacheOffset) {
                cache.put((Object)new GotoDefinitionKey(reparse, cacheOffset), gotoRequest);
            }
        } else {
            cache.put((Object)requestCacheKey, gotoRequest);
        }
    }

    @Nullable
    private Pair<TextDocumentPositionParams, TextRange> getParamsAndRange(@NotNull VirtualFile file, int offset) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(232);
        }
        return this.findLine(file, offset, (text, lineColumn) -> {
            TextDocumentIdentifier textDocIdent = new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file));
            Position position = new Position(lineColumn.line, lineColumn.column);
            TextDocumentPositionParams params = new TextDocumentPositionParams(textDocIdent, position);
            return Pair.create((Object)params, (Object)ClangUtils.findIdentifierRange(text, offset));
        });
    }

    @Nullable
    private TextDocumentPositionParams toTextDocumentPositionParams(@NotNull VirtualFile file, int offset) {
        Pair<TextDocumentIdentifier, Position> params;
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(233);
        }
        if ((params = this.textDocumentPositionParams(file, offset)) == null) {
            return null;
        }
        return new TextDocumentPositionParams((TextDocumentIdentifier)params.first, (Position)params.second);
    }

    @NotNull
    private CLionCompletionParams toCompletionParams(@NotNull VirtualFile file, int line, int column, @NotNull String fileText, @NotNull int completionKind, Pair<Integer, ArrayList<String>> postfixTemplates) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(234);
        }
        if (fileText == null) {
            ClangdLanguageService.$$$reportNull$$$0(235);
        }
        Pair params = Pair.create((Object)new TextDocumentIdentifier(this.myContext.getUrlConverter().toUri(file)), (Object)new Position(line, column));
        return new CLionCompletionParams((TextDocumentIdentifier)params.first, (Position)params.second, fileText, completionKind, (Integer)postfixTemplates.first, (List)postfixTemplates.second);
    }

    private void sendContent(@NotNull LocalWorkspaceFile wf, @NotNull VirtualFile virtFile) {
        ClangFileFacade helper;
        CharSequence fileText;
        if (wf == null) {
            ClangdLanguageService.$$$reportNull$$$0(236);
        }
        if (virtFile == null) {
            ClangdLanguageService.$$$reportNull$$$0(237);
        }
        CharSequence charSequence = fileText = (helper = this.myIdeFacade.getFileFacade(virtFile)) != null ? helper.getText() : null;
        if (fileText != null) {
            wf.preambleChanged(ClangUtils.skipPreamble(fileText));
            int nextVersion = wf.nextChange();
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(fileText.toString());
            VersionedTextDocumentIdentifier id = new VersionedTextDocumentIdentifier();
            id.setUri(this.myContext.getUrlConverter().toUri(virtFile));
            id.setVersion(Integer.valueOf(nextVersion));
            this.myRequestsPlanner.send(ClangChangeNotification.create(this.myContext, wf.getUrl(), nextVersion, new DidChangeTextDocumentParams(id, Collections.singletonList(changeEvent)), false));
        }
    }

    private boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdLanguageService.$$$reportNull$$$0(238);
        }
        return this.myContext.getUrlConverter().isAcceptable(file.getUrl()) && ClangdBridge.isSupported(this.myProject, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 47, 55, 57, 59, 62, 64, 80, 103, 104, 105, 107, 114, 115, 119, 146, 160, 161, 164, 165, 168, 190, 191, 206, 207, 210, 213, 214, 216, 218, 219, 224 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 47: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 64: 
            case 80: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 114: 
            case 115: 
            case 119: 
            case 146: 
            case 160: 
            case 161: 
            case 164: 
            case 165: 
            case 168: 
            case 190: 
            case 191: 
            case 206: 
            case 207: 
            case 210: 
            case 213: 
            case 214: 
            case 216: 
            case 218: 
            case 219: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 82: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 135: 
            case 136: 
            case 137: 
            case 141: 
            case 143: 
            case 166: 
            case 171: 
            case 175: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 189: 
            case 193: 
            case 195: 
            case 197: 
            case 200: 
            case 202: 
            case 204: 
            case 205: 
            case 209: 
            case 211: 
            case 215: 
            case 217: 
            case 221: 
            case 225: 
            case 226: 
            case 232: 
            case 233: 
            case 234: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 51: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 83: 
            case 84: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 32: 
            case 222: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 33: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledTestFrameworksNames";
                break;
            }
            case 54: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symID";
                break;
            }
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 86: 
            case 94: 
            case 95: 
            case 122: 
            case 126: 
            case 173: 
            case 176: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 201: 
            case 203: 
            case 208: 
            case 220: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
            case 87: 
            case 96: 
            case 99: 
            case 140: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 88: 
            case 89: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 90: 
            case 91: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedObject";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "something";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 108: 
            case 152: 
            case 155: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cc";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macros";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20ModuleMap";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdModuleMap";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashCase";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ccInfo";
                break;
            }
            case 121: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openRequestId";
                break;
            }
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 129: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 130: 
            case 162: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 132: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldUrl";
                break;
            }
            case 133: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 138: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deferrer";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityMask";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFiles";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedPaths";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolsDirPath";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCompileCommands";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePPDefines";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsePromise";
                break;
            }
            case 174: 
            case 177: 
            case 199: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparse";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledFrameworkNames";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineConsumer";
                break;
            }
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestCacheKey";
                break;
            }
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoRequest";
                break;
            }
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtFile";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedDisposable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslMsId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangIdeFacade";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlConverter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryUsageWatchDog";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "requestTimingStats";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRange";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "clionLightIndex";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "indentLine";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbols";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithParsedInternal";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIfAbsent";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdModulesPath";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpp20ModulesPath";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreprocessedReport";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "printStats";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPreprocessedCase";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandLine";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "startUpServer";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "shutDownServer";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryStat";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeStacktrace";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "ifOpened";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "sendInlayHints";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestClangFormatConfiguration";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFormattingOptions";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "sendFormatRangeRequest";
                break;
            }
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "sendClionLightIndex";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "sendIndentRequest";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestComplete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onOverflow";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 47: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 64: 
            case 80: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 114: 
            case 115: 
            case 119: 
            case 146: 
            case 160: 
            case 161: 
            case 164: 
            case 165: 
            case 168: 
            case 190: 
            case 191: 
            case 206: 
            case 207: 
            case 210: 
            case 213: 
            case 214: 
            case 216: 
            case 218: 
            case 219: 
            case 224: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "gotoDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVariables";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchAngleBracket";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matchPP";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "gotoTypeDeclaration";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCLionHoverInfo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getHover";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dumpAST";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "dumpTokens";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFastLineMarkers";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSlowLineMarkers";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTestLineMarkers";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInlayHints";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureHelp";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "requestTimingStats";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "preprocessSubstitution";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "requestClangFormatConfiguration";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "formatRange";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "clionLightIndex";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getParsed";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSymbols";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "runWithParsed";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "computeWithParsed";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "computeWithCustomParsed";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "computeWithOpenedAndCustomParsed";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "computeWithOpenedAndParsed";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "runWithOpenedAndParsed";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "computeWithParsedInternal";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "computeWithOpenedAndParsedInternal";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "applyConsumer";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "trackParseUsage";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "freeParseUsage";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "trackRequestUsage";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "freeRequestUsage";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "debugTrackUsage";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "debugFreeUsage";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isCanceled";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "setCanceled";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "cancelParseGently";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "cancelParse";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "cancelRequest";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "sendCancelParse";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "generatePreprocessedReport";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "createPreprocessedFile";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "printStats";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "checkPreprocessedCase";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentOpened";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "addOpenRequest";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentClosed";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "removeOpenRequest";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentChanged";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "notifyFolderChanged";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "prepareChangeParams";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "notifyReparseRequired";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReparse";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "scheduleDuplicatedReparse";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentSaved";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandLine";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "visibilityEnumSetToBitField";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "notifyDocumentMoved";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "notifySetCDB";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "convertPathToDoc";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "notifyLoadIndex";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "notifyLoadGraph";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "notifyIndexPartFinished";
                break;
            }
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "notifyModuleMappingChanged";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isFileBanned";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "debugDumpUsages";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "ifOpened";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "addLoggingForParseNotification";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getOrParse";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "sendGotoDefinition";
                break;
            }
            case 176: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "sendGotoTypeDeclaration";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "sendClionHoverInfo";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "sendHoverRequest";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "sendClionLineMarkers";
                break;
            }
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "sendClionTestLineMarkers";
                break;
            }
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "sendInlayHints";
                break;
            }
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "sendSignatureHelp";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "sendFindUsages";
                break;
            }
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "sendGetLocalVariables";
                break;
            }
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "sendMatchAngleBracket";
                break;
            }
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "sendMatchPP";
                break;
            }
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "sendDumpAST";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestClangFormatConfiguration";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "sendDumpTokens";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "sendFormatRangeRequest";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "sendClionLightIndex";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "sendIndentRequest";
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestComplete";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "textDocumentPositionParams";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "findLine";
                break;
            }
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "cacheGotoRequest";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "getParamsAndRange";
                break;
            }
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "toTextDocumentPositionParams";
                break;
            }
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "toCompletionParams";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "sendContent";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "lambda$debugDumpUsages$82";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 47, 55, 57, 59, 62, 64, 80, 103, 104, 105, 107, 114, 115, 119, 146, 160, 161, 164, 165, 168, 190, 191, 206, 207, 210, 213, 214, 216, 218, 219, 224 -> new IllegalStateException(string);
        };
    }

    private static class UsagesInfo {
        @NotNull
        final Map<Integer, Exception> id2Stack = new HashMap<Integer, Exception>(12);
        int nextID = 0;

        private UsagesInfo() {
        }
    }

    private static final class GotoDefinitionKey {
        @NotNull
        private final String myUrl;
        private final int myFileVersion;
        private final int myOffset;

        private GotoDefinitionKey(@NotNull ClangParseResponse file, int offset) {
            if (file == null) {
                GotoDefinitionKey.$$$reportNull$$$0(0);
            }
            this.myUrl = file.getUrl();
            this.myFileVersion = file.getVersion();
            this.myOffset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GotoDefinitionKey key = (GotoDefinitionKey)o;
            return Objects.equals(this.myUrl, key.myUrl) && this.myOffset == key.myOffset && this.myFileVersion == key.myFileVersion;
        }

        public int hashCode() {
            return Objects.hash(this.myUrl, this.myFileVersion, this.myOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageService$GotoDefinitionKey", "<init>"));
        }
    }
}

