/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.execution.debugger.NativeStacktraceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangLanguageServiceUtils {
    private static final Logger LOG = Logger.getInstance((String)ClangLanguageServiceUtils.class.getName());
    @NonNls
    private static final String ERROR_FRAGMENT = "error:";
    @NonNls
    private static final String NOTE_FRAGMENT = "note:";
    private static final Pattern NOTE_POSITION_PATTERN = Pattern.compile("(?<path>.*?):(?<line>[0-9]+):(?<character>[0-9]+)\\s*");

    private static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static void appendSegment(@NotNull ByteArrayOutputStream newPath2, @NotNull String path, int from, int to) {
        if (newPath2 == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(1);
        }
        for (int i = from; i < to; ++i) {
            newPath2.write(path.charAt(i));
        }
    }

    @NotNull
    public static String unescapePath(@NotNull String path) {
        int curPos;
        if (path == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(2);
        }
        if ((curPos = path.indexOf(92)) == -1) {
            String string = path;
            if (string == null) {
                ClangLanguageServiceUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        int segStart = 0;
        ByteArrayOutputStream newPath2 = new ByteArrayOutputStream(path.length());
        do {
            ClangLanguageServiceUtils.appendSegment(newPath2, path, segStart, curPos);
            if (++curPos == path.length()) {
                String string = newPath2.toString();
                if (string == null) {
                    ClangLanguageServiceUtils.$$$reportNull$$$0(4);
                }
                return string;
            }
            switch (path.charAt(curPos)) {
                case '\\': {
                    newPath2.write(92);
                    break;
                }
                case 't': {
                    newPath2.write(9);
                    ++curPos;
                    break;
                }
                case 'n': {
                    newPath2.write(10);
                    ++curPos;
                    break;
                }
                case '\"': {
                    newPath2.write(34);
                    ++curPos;
                    break;
                }
                default: {
                    int codePoint = 0;
                    for (int i = 0; i < 3 && curPos < path.length() && ClangLanguageServiceUtils.isOctalDigit(path.charAt(curPos)); ++curPos, ++i) {
                        codePoint <<= 3;
                        codePoint += path.charAt(curPos) - 48;
                    }
                    newPath2.write(codePoint);
                }
            }
            segStart = ++curPos;
        } while ((curPos = path.indexOf(92, curPos)) != -1);
        ClangLanguageServiceUtils.appendSegment(newPath2, path, segStart, path.length());
        String string = newPath2.toString(StandardCharsets.UTF_8);
        if (string == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static int lspPos2Offset(@NotNull Document doc, @NotNull Position pos) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(6);
        }
        if (pos == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (doc.getLineCount() <= pos.getLine()) {
            return Math.min(doc.getTextLength(), doc.getLineStartOffset(doc.getLineCount() - 1) + pos.getCharacter());
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    @NotNull
    public static Position offset2LspPos(@NotNull Document doc, int offset) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int lineNumber = doc.getLineNumber(offset);
        int columnNumber = offset - doc.getLineStartOffset(lineNumber);
        return new Position(lineNumber, columnNumber);
    }

    @NotNull
    public static Range offsets2Range(@NotNull Document doc, int from, int to) {
        if (doc == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new Range(ClangLanguageServiceUtils.offset2LspPos(doc, from), ClangLanguageServiceUtils.offset2LspPos(doc, to));
    }

    @Nullable
    public static <T> T getFromClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException, InterruptedException {
        if (future == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(10);
        }
        assert (future.isDone());
        Supplier<? extends T> supplier = future.get();
        return supplier != null ? (T)supplier.get() : null;
    }

    @Nullable
    public static ClangNote parseNote(@NotNull String note, @NotNull ClangUrlConverter converter) {
        String pathAndPosition;
        Matcher matcher;
        if (note == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(11);
        }
        if (converter == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(12);
        }
        int separatorLength = NOTE_FRAGMENT.length();
        int separator = note.indexOf(NOTE_FRAGMENT);
        if (separator == -1) {
            separatorLength = ERROR_FRAGMENT.length();
            separator = note.indexOf(ERROR_FRAGMENT);
        }
        if (separator >= 0 && (matcher = NOTE_POSITION_PATTERN.matcher(pathAndPosition = note.substring(0, separator))).find()) {
            String path = matcher.group("path");
            if (converter.isWslMode()) {
                path = converter.fromWslPath(path);
            }
            if (path.equals("<command-line>")) {
                return null;
            }
            String lineAsString = matcher.group("line");
            String characterAsString = matcher.group("character");
            String message = note.substring(separator + separatorLength);
            try {
                int line = Integer.parseInt(lineAsString);
                int character = Integer.parseInt(characterAsString);
                return new ClangNote(message, path, line, character);
            }
            catch (NumberFormatException ex) {
                LOG.warn((Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public static int getServerPid(@Nullable ServerConnection connection) {
        if (!(connection instanceof ProcessServerConnectionProvider.ProcessServerConnection)) {
            return -1;
        }
        Process serverProcess = ((ProcessServerConnectionProvider.ProcessServerConnection)connection).getProcess();
        return OSProcessUtil.getProcessID((Process)serverProcess);
    }

    @NonNls
    @NotNull
    public static String getNativeStacktrace(@Nullable ServerConnection connection) {
        block5: {
            NativeStacktraceProvider nativeStacktraceProvider;
            int pid = ClangLanguageServiceUtils.getServerPid(connection);
            if (pid != -1 && (nativeStacktraceProvider = (NativeStacktraceProvider)ApplicationManager.getApplication().getService(NativeStacktraceProvider.class)) != null) {
                String string;
                try {
                    String stacktrace = nativeStacktraceProvider.getNativeStacktrace(pid);
                    if (stacktrace == null) break block5;
                    string = stacktrace;
                }
                catch (ExecutionException ex) {
                    String string2 = ExceptionUtil.getThrowableText((Throwable)ex);
                    if (string2 == null) {
                        ClangLanguageServiceUtils.$$$reportNull$$$0(14);
                    }
                    return string2;
                }
                if (string == null) {
                    ClangLanguageServiceUtils.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        return "unavailable";
    }

    public static Set<VirtualFile> getProjectRoots(@NotNull Project project) {
        if (project == null) {
            ClangLanguageServiceUtils.$$$reportNull$$$0(15);
        }
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            sources.addAll(config.getSources());
        }
        return sources;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeStacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendSegment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unescapePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lspPos2Offset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "offset2LspPos";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "offsets2Range";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFromClangFuture";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseNote";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static final class ClangNote {
        @NotNull
        public final String message;
        @NotNull
        public final String path;
        public final int line;
        public final int character;

        private ClangNote(@NotNull String message, @NotNull String path, int line, int character) {
            if (message == null) {
                ClangNote.$$$reportNull$$$0(0);
            }
            if (path == null) {
                ClangNote.$$$reportNull$$$0(1);
            }
            this.message = message;
            this.path = path;
            this.line = line;
            this.character = character;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClangNote note = (ClangNote)o;
            return this.line == note.line && this.character == note.character && this.message.equals(note.message) && this.path.equals(note.path);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.path, this.line, this.character);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangLanguageServiceUtils$ClangNote";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

