/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCommandLineParser;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangCommandLineParserKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOptionsFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangVisibility;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineOption;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParser;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserCancellationException;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserException;
import com.jetbrains.cidr.lang.toolchains.CidrCommandLineParserUnknownException;
import com.jetbrains.cidr.lang.toolchains.CidrInvalidSwitchException;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J8\u0010\b\u001a*\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCommandLineParser;", "Lcom/jetbrains/cidr/lang/toolchains/CidrCommandLineParser;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allExceptClOption", "Ljava/util/EnumSet;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangVisibility;", "compilerToFlags", "Lkotlin/Triple;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangOptionsFlags;", "compiler", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "parse", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrCommandLineOption;", "switches", "", "", "parseSync", "Companion", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangCommandLineParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangCommandLineParser.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCommandLineParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n1#2:127\n13#3:128\n*S KotlinDebug\n*F\n+ 1 ClangCommandLineParser.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCommandLineParser\n*L\n24#1:128\n*E\n"})
public final class ClangCommandLineParser
implements CidrCommandLineParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public ClangCommandLineParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public CompletableFuture<List<CidrCommandLineOption>> parse(@NotNull OCCompilerKind compiler, @NotNull List<String> switches) {
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(switches, (String)"switches");
        Triple<EnumSet<ClangOptionsFlags>, EnumSet<ClangOptionsFlags>, EnumSet<ClangVisibility>> triple = this.compilerToFlags(compiler);
        EnumSet flagsToInclude = (EnumSet)triple.component1();
        EnumSet flagsToExclude = (EnumSet)triple.component2();
        EnumSet visibilityMask = (EnumSet)triple.component3();
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        if (clangLanguageServiceProvider == null) {
            throw new IllegalStateException("No clangd language provider");
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        ClangLanguageService clangLanguageService = provider2.getOrStart();
        if (clangLanguageService == null) {
            CompletableFuture<List<CidrCommandLineOption>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ClangLanguageService service = clangLanguageService;
        CompletionStage completionStage = ((CompletableFuture)service.parseCommandLine(switches, flagsToInclude, flagsToExclude, visibilityMask).exceptionally(arg_0 -> ClangCommandLineParser.parse$lambda$1(switches, arg_0))).thenApply(arg_0 -> ClangCommandLineParser.parse$lambda$2(parse.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final EnumSet<ClangVisibility> allExceptClOption() {
        EnumSet<Enum> enumSet = EnumSet.complementOf(EnumSet.of((Enum)ClangVisibility.CLOption));
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"complementOf(...)");
        return enumSet;
    }

    private final Triple<EnumSet<ClangOptionsFlags>, EnumSet<ClangOptionsFlags>, EnumSet<ClangVisibility>> compilerToFlags(OCCompilerKind compiler) {
        OCCompilerKind oCCompilerKind = compiler;
        return Intrinsics.areEqual((Object)oCCompilerKind, (Object)GCCCompilerKind.INSTANCE) ? new Triple(null, null, this.allExceptClOption()) : ((Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangCompilerKind.INSTANCE) ? true : Intrinsics.areEqual((Object)oCCompilerKind, (Object)AppleClangCompilerKind.INSTANCE)) ? new Triple(null, null, this.allExceptClOption()) : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)MSVCCompilerKind.INSTANCE) ? new Triple(EnumSet.of((Enum)ClangOptionsFlags.NoXarchOption), null, EnumSet.of((Enum)ClangVisibility.CLOption)) : (Intrinsics.areEqual((Object)oCCompilerKind, (Object)ClangClCompilerKind.INSTANCE) ? new Triple(EnumSet.of((Enum)ClangOptionsFlags.NoXarchOption), null, EnumSet.of((Enum)ClangVisibility.CLOption)) : new Triple(null, null, EnumSet.of((Enum)ClangVisibility.Anything)))));
    }

    @NotNull
    public List<CidrCommandLineOption> parseSync(@NotNull OCCompilerKind compiler, @NotNull List<String> switches) throws CidrCommandLineParserException {
        List list;
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(switches, (String)"switches");
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            application.assertIsNonDispatchThread();
        }
        if ((list = (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)this.parse((OCCompilerKind)UnknownCompilerKind.INSTANCE, switches), (long)Long.MAX_VALUE, (String)"clionParseCommandLine")) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List parse$lambda$1(List $switches, Throwable cause) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$switches, (String)"$switches");
        LOG.warn(cause);
        Throwable throwable2 = cause;
        if (throwable2 instanceof CancellationException ? true : throwable2 instanceof InterruptedException) {
            throwable = (Throwable)new CidrCommandLineParserCancellationException(cause);
        } else if (throwable2 instanceof ExecutionException ? true : throwable2 instanceof ResponseErrorException) {
            Pair pair;
            String string = cause.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                pair = ClangCommandLineParserKt.access$parseErrorMessage(it);
            } else {
                pair = null;
            }
            Pair pair2 = pair;
            throwable = (Throwable)(pair2 != null ? (CidrCommandLineParserException)new CidrInvalidSwitchException($switches, ((Number)pair2.getFirst()).intValue(), cause) : (CidrCommandLineParserException)new CidrCommandLineParserUnknownException(cause));
        } else {
            throwable = (Throwable)new CidrCommandLineParserUnknownException(cause);
        }
        throw throwable;
    }

    private static final List parse$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CidrCommandLineParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCommandLineParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

