/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.language;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightElement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.language.ClangItemPresentation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/language/ClangReferenceElement;", "Lcom/intellij/psi/impl/light/LightElement;", "lexerElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getText", "", "getTextOffset", "", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "toString", "intellij.c.clangd"})
public final class ClangReferenceElement
extends LightElement {
    @NotNull
    private final PsiElement lexerElement;

    public ClangReferenceElement(@NotNull PsiElement lexerElement) {
        Intrinsics.checkNotNullParameter((Object)lexerElement, (String)"lexerElement");
        super(lexerElement.getManager(), lexerElement.getLanguage());
        this.lexerElement = lexerElement;
    }

    @NotNull
    public String toString() {
        return "ClangReferenceElement: " + this.lexerElement.getText();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.lexerElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @NotNull
    public String getText() {
        String string = this.lexerElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile2 = this.lexerElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        return psiFile2;
    }

    public int getTextOffset() {
        return this.lexerElement.getTextOffset();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ClangItemPresentation(this.getText(), null);
    }
}

