/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class OurClangTidyInspectionsViaClangdAnnotatorPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPass.class);
    private final PsiFile myFile;
    private final HighlightInfoHolder myHolder;
    private int myParsedVersion;

    public OurClangTidyInspectionsViaClangdAnnotatorPass(@NotNull PsiFile file, @NotNull Document document2) {
        if (file == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), document2);
        this.myParsedVersion = -1;
        this.myFile = file;
        this.myHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(2);
        }
        this.myHolder.clear();
        this.myParsedVersion = -1;
        if (!this.isAnnotatorPassEnabled() || !ClangAnnotatorUtil.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        if (service == null) {
            return;
        }
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            this.myParsedVersion = response.getVersion();
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> future = response.getOurTidyDiagnostics();
            this.waitForFuture(virtualFile, response.getVersion(), future);
        });
    }

    public void doApplyInformationToEditor() {
        if (this.isAnnotatorPassEnabled()) {
            ClangUtils.traceClangd(LOG, () -> {
                VirtualFile virtualFile = this.myFile.getVirtualFile();
                return "Applying our clang-tidy inspections for " + virtualFile.getName() + "[" + this.myParsedVersion + "].";
            });
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(this.myHolder.size());
        for (int j = 0; j < this.myHolder.size(); ++j) {
            HighlightInfo info = this.myHolder.get(j);
            highlights.add(info);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private void waitForFuture(VirtualFile virtualFile, int curFileVersion, Future<Supplier<List<ClangTidyDiagnostic>>> diagnosticsFuture) {
        try {
            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(diagnosticsFuture, (long)Long.MAX_VALUE, (String)"our clang-tidy inspections");
            if (supplier != null) {
                ClangUtils.traceClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                List diagnostics = (List)supplier.get();
                if (diagnostics != null) {
                    ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
                    applier.annotateSuccess(this.myFile, diagnostics, this.myHolder, true);
                }
            } else {
                ClangUtils.traceClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
            }
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.traceClangd(LOG, "Waiting for our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ex.getMessage(), ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd(LOG, ex);
        }
    }

    private boolean isAnnotatorPassEnabled() {
        return ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangTidyViaClangdOn(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/OurClangTidyInspectionsViaClangdAnnotatorPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

