/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.LocalVariablesFilterHandler;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/ClangLocalVarsFilterHandler;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/LocalVariablesFilterHandler;", "()V", "canFilterAtPos", "", "proj", "Lcom/intellij/openapi/project/Project;", "pos", "Lcom/intellij/xdebugger/XSourcePosition;", "filterVars", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "vars", "intellij.c.clangd"})
public final class ClangLocalVarsFilterHandler
implements LocalVariablesFilterHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFilterAtPos(@NotNull Project proj, @NotNull XSourcePosition pos) {
        Intrinsics.checkNotNullParameter((Object)proj, (String)"proj");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(proj);
        if (!Registry.is((String)"clion.clangd.clangd.debugger.localVarsFilter")) return false;
        if (!ClangUtils.isClangdOn(proj)) return false;
        if (!ClangdBridge.isSupported(proj, pos.getFile())) return false;
        ClangLanguageService clangLanguageService = service;
        if (clangLanguageService == null) return true;
        boolean bl = clangLanguageService.isFileBanned(pos.getFile().getUrl());
        if (bl) return false;
        return true;
    }

    @NotNull
    public CompletableFuture<List<LLValue>> filterVars(@NotNull Project proj, @NotNull XSourcePosition pos, @NotNull List<? extends LLValue> vars) {
        Ref.ObjectRef result;
        block0: {
            Intrinsics.checkNotNullParameter((Object)proj, (String)"proj");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            result = new Ref.ObjectRef();
            CompletableFuture<List<? extends LLValue>> completableFuture = CompletableFuture.completedFuture(vars);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            result.element = completableFuture;
            ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getOrStart(proj);
            if (clangLanguageService == null) break block0;
            clangLanguageService.getLocalVariables(pos.getFile(), pos.getLine(), arg_0 -> ClangLocalVarsFilterHandler.filterVars$lambda$2(result, vars, arg_0));
        }
        return (CompletableFuture)result.element;
    }

    private static final List filterVars$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void filterVars$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void filterVars$lambda$2(Ref.ObjectRef $result, List $vars, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$vars, (String)"$vars");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClangResultFuture<List<String>> clangResultFuture = it.iWillNotForgetToCancelTheFuture();
        Intrinsics.checkNotNullExpressionValue(clangResultFuture, (String)"iWillNotForgetToCancelTheFuture(...)");
        ClangResultFuture<List<String>> a = clangResultFuture;
        CompletionStage completionStage = ((CompletableFuture)a.asFuture().thenApply(arg_0 -> ClangLocalVarsFilterHandler.filterVars$lambda$2$lambda$0((Function1)new Function1<List<String>, List<? extends LLValue>>((List<? extends LLValue>)$vars){
            final /* synthetic */ List<LLValue> $vars;
            {
                this.$vars = $vars;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<LLValue> invoke(List<String> clangdLocals) {
                LLValue v;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                IndexedValue p0;
                Object object;
                IndexedValue indexedValue;
                Iterable $this$associateByTo$iv$iv;
                Intrinsics.checkNotNull(clangdLocals);
                Iterable $this$associateBy$iv = CollectionsKt.withIndex((Iterable)clangdLocals);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    indexedValue = (IndexedValue)element$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    p0 = (IndexedValue)element$iv$iv;
                    String string = (String)p0.getValue();
                    boolean bl2 = false;
                    Integer n = p0.getIndex();
                    object.put(string, n);
                }
                Map clangdLocalsOrder = destination$iv$iv;
                Iterable $this$map$iv = this.$vars;
                boolean $i$f$map = false;
                $this$associateByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void v2;
                    p0 = (LLValue)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    String string = v2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add(TuplesKt.to((Object)v2, (Object)clangdLocalsOrder.getOrDefault(string, -1)));
                }
                List varsWithDeclOrder = (List)destination$iv$iv;
                $this$map$iv = varsWithDeclOrder;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair pair = (Pair)a;
                        boolean bl = false;
                        int declOrder = ((Number)pair.component2()).intValue();
                        pair = (Pair)b;
                        Comparable comparable = Integer.valueOf(declOrder);
                        bl = false;
                        declOrder = ((Number)pair.component2()).intValue();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(declOrder));
                    }
                });
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    indexedValue = (Pair)element$iv$iv;
                    boolean bl = false;
                    v = (LLValue)indexedValue.component1();
                    int declOrder = ((Number)indexedValue.component2()).intValue();
                    if (!(declOrder >= 0 || Intrinsics.areEqual((Object)v.getName(), (Object)"this"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    indexedValue = (Pair)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    v = (LLValue)indexedValue.component1();
                    object.add(v);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0))).whenComplete((arg_0, arg_1) -> ClangLocalVarsFilterHandler.filterVars$lambda$2$lambda$1((Function2)new Function2<List<? extends LLValue>, Throwable, Unit>(a){
            final /* synthetic */ ClangResultFuture<List<String>> $a;
            {
                this.$a = $a;
                super(2);
            }

            public final void invoke(List<? extends LLValue> list, Throwable throwable) {
                this.$a.release();
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        $result.element = completionStage;
    }
}

