/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfig;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigExecutor;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerOutput;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerResolveAlias;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/webpack/WebpackConfigExecutor;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configureCommandLine", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "path", "", "workingDir", "isESM", "", "parseJsonResult", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "result", "parseOutput", "reader", "Lcom/google/gson/stream/JsonReader;", "config", "parseResolve", "parseResolveAlias", "key", "paths", "Lcom/google/gson/JsonElement;", "parseRootConfig", "intellij.webpack"})
@SourceDebugExtension(value={"SMAP\nWebpackConfigExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpackConfigExecutor.kt\ncom/intellij/webpack/WebpackConfigExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1855#2,2:226\n1#3:228\n*S KotlinDebug\n*F\n+ 1 WebpackConfigExecutor.kt\ncom/intellij/webpack/WebpackConfigExecutor\n*L\n182#1:226,2\n*E\n"})
public final class WebpackConfigExecutor
extends WebBundlerConfigExecutor {
    public WebpackConfigExecutor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "Webpack");
    }

    protected void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String path, @NotNull String workingDir, boolean isESM) {
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        if (isESM) {
            commandLine.addParameter("--input-type");
            commandLine.addParameter("module");
        }
        if (TypeScriptUtil.isTypeScriptFile((CharSequence)path)) {
            if (isESM) {
                commandLine.addParameter("--loader");
                commandLine.addParameter("ts-node/esm");
            } else {
                commandLine.addParameter("-r");
                commandLine.addParameter("ts-node/register");
            }
        }
        Ref.ObjectRef header = new Ref.ObjectRef();
        header.element = "";
        if (!isESM) {
            header.element = "require.main = { require: require };";
        }
        Ref.ObjectRef loaders = new Ref.ObjectRef();
        loaders.element = "";
        if (StringsKt.contains$default((CharSequence)path, (CharSequence)".babel.", (boolean)false, (int)2, null) && !isESM) {
            loaders.element = "try {\n  require('@babel/register');\n} catch (e) {\n  require('babel-register');\n}";
        }
        String runnable = isESM ? "import(modulePath).then(config => printConfig(config, true)).catch(err => console.error(err));" : "var config = require(modulePath);\nprintConfig(config, true);";
        commandLine.addParameter("-e");
        TargetValue targetValue = TargetValue.map((TargetValue)targetRun.path(path), arg_0 -> WebpackConfigExecutor.configureCommandLine$lambda$0((Function1)new Function1<String, String>(isESM, (Ref.ObjectRef<String>)header, (Ref.ObjectRef<String>)loaders, this, runnable){
            final /* synthetic */ boolean $isESM;
            final /* synthetic */ Ref.ObjectRef<String> $header;
            final /* synthetic */ Ref.ObjectRef<String> $loaders;
            final /* synthetic */ WebpackConfigExecutor this$0;
            final /* synthetic */ String $runnable;
            {
                this.$isESM = $isESM;
                this.$header = $header;
                this.$loaders = $loaders;
                this.this$0 = $receiver;
                this.$runnable = $runnable;
                super(1);
            }

            public final String invoke(String it) {
                String string = StringUtil.escapeBackSlashes((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeBackSlashes(...)");
                String targetPath = string;
                String importUrl = this.$isESM && SystemInfoRt.isWindows ? "file:///" + targetPath : targetPath;
                return ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)("\n        " + this.$header.element + "\n        " + this.$loaders.element + "\n  \n        function mergeConfigs(array){\n          var result = {};\n          for (var i = 0; i < array.length; i++) {\n            var obj = array[i];\n            result.output = result.output || obj.output;\n            if (!result.resolve) {\n              result.resolve = obj.resolve;\n            } else if (obj.resolve) {\n              if (!result.resolve.alias) {\n                result.resolve.alias = obj.resolve.alias;\n              } else if (obj.resolve.alias) {\n                result.resolve.alias = Object.assign(result.resolve.alias, obj.resolve.alias);\n              }\n              if (!result.resolve.extensions) {\n                result.resolve.extensions = obj.resolve.extensions;\n              } else if (obj.resolve.extensions) {\n                result.resolve.extensions = result.resolve.extensions.concat(obj.resolve.extensions);\n              }\n              if (!result.resolve.modules) {\n                result.resolve.modules = obj.resolve.modules;\n              } else if (obj.resolve.modules) {\n                result.resolve.modules = result.resolve.modules.concat(obj.resolve.modules);\n              }\n              if (!result.resolve.modulesDirectories) {\n                result.resolve.modulesDirectories = obj.resolve.modulesDirectories;\n              } else if (obj.resolve.modulesDirectories) {\n                result.resolve.modulesDirectories = result.resolve.modulesDirectories.concat(obj.resolve.modulesDirectories);\n              }\n              result.resolve.root = result.resolve.root || obj.resolve.root;\n            }\n          }\n          return result;\n        }\n  \n        function printConfig(config, resolvePromise) {\n          if (config.default !== undefined) config = config.default;\n          if (typeof config === 'function') config = config({development: true}, {});\n          if (resolvePromise && typeof Promise !== 'undefined') {\n            Promise.resolve(config).then(function(value) {\n              printConfig(value, false)\n            });\n            return;\n          }\n          if (Array.isArray(config)) {\n            config = mergeConfigs(config);\n          }\n          config = {resolve: config.resolve, output: config.output}\n          if (config.resolve) config.resolve.plugins = undefined;\n          console.log(\"" + WebpackConfigExecutor.access$getMarker(this.this$0) + "\");\n          console.log(JSON.stringify(config, null, 1));\n          process.exit(0);\n        }\n  \n        var modulePath = '" + importUrl + "';\n        " + this.$runnable + "\n        ")))).toString();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"map(...)");
        commandLine.addParameter(targetValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected WebBundlerConfig parseJsonResult(@NotNull String result, @NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        WebBundlerConfig config = new WebBundlerConfig(null, null, 3, null);
        Closeable closeable = (Closeable)new JsonReader((Reader)new StringReader(result));
        Throwable throwable = null;
        try {
            JsonReader reader = (JsonReader)closeable;
            boolean bl = false;
            reader.setLenient(true);
            this.parseRootConfig(reader, config, targetRun);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return config;
    }

    private final void parseRootConfig(JsonReader reader, WebBundlerConfig config, NodeTargetRun targetRun) {
        reader.beginObject();
        while (reader.hasNext()) {
            String string = reader.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"resolve")) {
                this.parseResolve(reader, config, targetRun);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"output")) {
                this.parseOutput(reader, config, targetRun);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseResolve(JsonReader reader, WebBundlerConfig config, NodeTargetRun targetRun) {
        block6: {
            Object object = JsonParser.parseReader((JsonReader)reader);
            JsonObject jsonObject = object instanceof JsonObject ? (JsonObject)object : null;
            if (jsonObject == null) {
                return;
            }
            JsonObject resolve = jsonObject;
            Object object2 = JsonUtil.getChildAsObject((JsonObject)resolve, (String)"alias");
            if (object2 != null && (object = object2.entrySet()) != null) {
                void $this$forEach$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    String key = (String)entry.getKey();
                    JsonElement paths = (JsonElement)entry.getValue();
                    Intrinsics.checkNotNull((Object)key);
                    Intrinsics.checkNotNull((Object)paths);
                    this.parseResolveAlias(key, paths, config, targetRun);
                }
            }
            if ((object2 = JsonUtil.getChildAsStringList((JsonObject)resolve, (String)"modules")) != null && (object = this.convertPathsToLocal((Collection)object2, targetRun)) != null) {
                Object it = object;
                boolean bl = false;
                config.getResolve().getModules().addAll(it);
            }
            object2 = JsonUtil.getChildAsStringList((JsonObject)resolve, (String)"modulesDirectories");
            if (object2 != null && (object = this.convertPathsToLocal((Collection)object2, targetRun)) != null) {
                Object it = object;
                boolean bl = false;
                config.getResolve().getModulesDirectories().addAll(it);
            }
            object2 = JsonUtil.getChildAsStringList((JsonObject)resolve, (String)"extensions");
            if (object2 != null) {
                Object it = object2;
                boolean bl = false;
                config.getResolve().getExtensions().addAll((Collection)it);
            }
            object2 = JsonUtil.getChildAsStringList((JsonObject)resolve, (String)"roots");
            if (object2 == null || (object = this.convertPathsToLocal((Collection)object2, targetRun)) == null) break block6;
            Object it = object;
            boolean bl = false;
            config.getResolve().getRoots().addAll(it);
        }
    }

    private final void parseResolveAlias(String key, JsonElement paths, WebBundlerConfig config, NodeTargetRun targetRun) {
        List mappings = new ArrayList();
        if (paths instanceof JsonPrimitive && ((JsonPrimitive)paths).isString()) {
            String string = ((JsonPrimitive)paths).getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            mappings.add(string);
        } else if (paths instanceof JsonArray) {
            List list = JsonUtil.arrayToStringList((JsonArray)((JsonArray)paths));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"arrayToStringList(...)");
            mappings.addAll(list);
        }
        if (!StringsKt.isBlank((CharSequence)key) && !((Collection)mappings).isEmpty()) {
            List localMappings = CollectionsKt.toMutableList((Collection)this.convertPathsToLocal(mappings, targetRun));
            config.getResolve().getAlias().put(key, new WebBundlerResolveAlias(key, localMappings, null, 4, null));
        }
    }

    private final void parseOutput(JsonReader reader, WebBundlerConfig config, NodeTargetRun targetRun) {
        String string;
        String string2;
        WebBundlerOutput webBundlerOutput;
        JsonElement jsonElement = JsonParser.parseReader((JsonReader)reader);
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            return;
        }
        JsonObject output = jsonObject;
        WebBundlerOutput $this$parseOutput_u24lambda_u247 = webBundlerOutput = config.getOutput();
        boolean bl = false;
        String string3 = string2 = JsonUtil.getChildAsString((JsonObject)output, (String)"path");
        if (string3 != null) {
            Intrinsics.checkNotNull((Object)string3);
            string = this.convertPathToLocal(string2, targetRun);
        } else {
            string = null;
        }
        $this$parseOutput_u24lambda_u247.setPath(string);
        $this$parseOutput_u24lambda_u247.setFilename(JsonUtil.getChildAsString((JsonObject)output, (String)"filename"));
    }

    private static final String configureCommandLine$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getMarker(WebpackConfigExecutor $this) {
        return $this.getMarker();
    }
}

