/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstCompoundStatement;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstRecursiveElementVisitor;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.psi.PyElementType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PyPsiUtilsCore {
    private PyPsiUtilsCore() {
    }

    @ApiStatus.Internal
    public static <T extends PyAstElement> T @NotNull [] nodesToPsi(ASTNode[] nodes, T[] array) {
        PyAstElement[] psiElements = (PyAstElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array), (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = (PyAstElement)nodes[i].getPsi();
        }
        if (psiElements == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(0);
        }
        return psiElements;
    }

    @Nullable
    public static PsiElement getNextNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        if (!(strict || start instanceof PsiWhiteSpace || start instanceof PsiComment)) {
            return start;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)start);
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type) {
        ASTNode child;
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(2);
        }
        return (child = element.getNode().findChildByType((IElementType)type)) != null ? child.getPsi() : null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode node;
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(4);
        }
        if ((node = element.getNode()) != null) {
            ASTNode[] children = node.getChildren(filter);
            return 0 <= number && number < children.length ? children[number].getPsi() : null;
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends PyAstElement> List<T> collectChildren(@NotNull PyAstFile pyFile, final @NotNull Class<T> elementType) {
        if (pyFile == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(5);
        }
        if (elementType == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(6);
        }
        final ArrayList result = new ArrayList();
        pyFile.acceptChildren(new TopLevelVisitor(){

            @Override
            protected void checkAddElement(PsiElement node) {
                if (elementType.isInstance(node)) {
                    result.add((PyAstElement)elementType.cast(node));
                }
            }

            @Override
            public void visitPyStatement(@NotNull PyAstStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PyAstStatement.class.isAssignableFrom(elementType) && !(node instanceof PyAstCompoundStatement)) {
                    this.checkAddElement((PsiElement)node);
                    return;
                }
                super.visitPyStatement(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/ast/impl/PyPsiUtilsCore$1", "visitPyStatement"));
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PsiElement> collectAllChildren(PsiElement e) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        e.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

            @Override
            protected void checkAddElement(PsiElement node) {
                result.add(node);
            }
        });
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSiblingOnSameLine(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(9);
        }
        for (PsiElement cur = element.getNextSibling(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof PsiWhiteSpace)) {
                return cur;
            }
            if (cur.textContains('\n')) break;
        }
        return null;
    }

    @Nullable
    public static String strValue(@Nullable PyAstExpression expression) {
        return expression instanceof PyAstStringLiteralExpression ? ((PyAstStringLiteralExpression)expression).getStringValue() : null;
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyAstExpression expr) {
        return expr instanceof PyAstQualifiedExpression ? ((PyAstQualifiedExpression)expr).asQualifiedName() : null;
    }

    @Nullable
    public static QualifiedName asQualifiedName(@NotNull PyAstQualifiedExpression expr) {
        if (expr == null) {
            PyPsiUtilsCore.$$$reportNull$$$0(10);
        }
        LinkedList<String> path = new LinkedList<String>();
        String firstName = expr.getReferencedName();
        if (firstName == null) {
            return null;
        }
        path.add(firstName);
        PyAstExpression qualifier = expr.getQualifier();
        while (qualifier != null) {
            PyAstReferenceExpression qualifierReference = (PyAstReferenceExpression)ObjectUtils.tryCast((Object)qualifier, PyAstReferenceExpression.class);
            if (qualifierReference == null) {
                return null;
            }
            String qualifierName = qualifierReference.getReferencedName();
            if (qualifierName == null) {
                return null;
            }
            path.add(0, qualifierName);
            qualifier = qualifierReference.getQualifier();
        }
        return QualifiedName.fromComponents(path);
    }

    public static void assertValid(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/impl/PyPsiUtilsCore";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesToPsi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/impl/PyPsiUtilsCore";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectChildren";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSiblingOnSameLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "asQualifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class TopLevelVisitor
    extends PyAstRecursiveElementVisitor {
        private TopLevelVisitor() {
        }

        @Override
        public void visitPyElement(@NotNull PyAstElement node) {
            if (node == null) {
                TopLevelVisitor.$$$reportNull$$$0(0);
            }
            super.visitPyElement(node);
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyClass(@NotNull PyAstClass node) {
            if (node == null) {
                TopLevelVisitor.$$$reportNull$$$0(1);
            }
            this.checkAddElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyAstFunction node) {
            if (node == null) {
                TopLevelVisitor.$$$reportNull$$$0(2);
            }
            this.checkAddElement(node);
        }

        protected abstract void checkAddElement(PsiElement var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/ast/impl/PyPsiUtilsCore$TopLevelVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

