/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstAnnotationOwner;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstNamedElementContainer;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.ast.impl.PyUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstAssignmentStatement
extends PyAstStatement,
PyAstNamedElementContainer,
PyAstAnnotationOwner {
    @Override
    @Nullable
    default public PyAstAnnotation getAnnotation() {
        return PyAstElementKt.findChildByClass(this, PyAstAnnotation.class);
    }

    public PyAstExpression @NotNull [] getTargets();

    public PyAstExpression @NotNull [] getRawTargets();

    @Nullable
    default public PyAstExpression getAssignedValue() {
        PsiElement child;
        for (child = this.getLastChild(); child != null && !(child instanceof PyAstExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyAstExpression)child;
    }

    @NotNull
    public List<? extends Pair<? extends PyAstExpression, ? extends PyAstExpression>> getTargetsToValuesMapping();

    @Nullable
    default public PyAstExpression getLeftHandSideExpression() {
        PsiElement child;
        for (child = this.getFirstChild(); child != null && !(child instanceof PyAstExpression); child = child.getPrevSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return null;
        }
        return (PyAstExpression)child;
    }

    default public boolean isAssignmentTo(@NotNull String name) {
        PyAstExpression lhs;
        if (name == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(0);
        }
        return (lhs = this.getLeftHandSideExpression()) instanceof PyAstTargetExpression && name.equals(lhs.getName());
    }

    @Override
    @NotNull
    default public List<PsiNamedElement> getNamedElements() {
        List<PyAstExpression> expressions = PyUtilCore.flattenedParensAndStars(this.getTargets());
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        for (PyAstExpression expression : expressions) {
            if (expression instanceof PyAstQualifiedExpression && ((PyAstQualifiedExpression)expression).isQualified() || !(expression instanceof PsiNamedElement)) continue;
            result.add((PsiNamedElement)expression);
        }
        ArrayList<PsiNamedElement> arrayList = result;
        if (arrayList == null) {
            PyAstAssignmentStatement.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyAssignmentStatement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstAssignmentStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstAssignmentStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentTo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

