/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharSequenceReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigIndex
extends FileBasedIndexExtension<String, TypeScriptExternalPaths> {
    public static final ID<String, TypeScriptExternalPaths> NAME = ID.create((String)"TypeScriptExternalPathCandidates");
    public static final String KEY_INFO = "TypeScriptConfigShortInfo";
    private final DataIndexer<String, TypeScriptExternalPaths, FileContent> myDataIndexer = new DataIndexer<String, TypeScriptExternalPaths, FileContent>(){

        @NotNull
        public Map<String, TypeScriptExternalPaths> map(@NotNull FileContent inputData) {
            CharSequence text2;
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!StringUtil.contains((CharSequence)(text2 = inputData.getContentAsText()), (CharSequence)"\"paths\"") && !StringUtil.contains((CharSequence)text2, (CharSequence)"\"rootDirs\"")) {
                Map<String, TypeScriptExternalPaths> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }
            TypeScriptExternalPaths result2 = TypeScriptConfigIndex.parseConfig(inputData);
            if (result2 != null) {
                Map<String, TypeScriptExternalPaths> map = Collections.singletonMap(TypeScriptConfigIndex.KEY_INFO, result2);
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }
            Map<String, TypeScriptExternalPaths> map = Collections.emptyMap();
            if (map == null) {
                1.$$$reportNull$$$0(3);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$1";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    };

    @Nullable
    private static TypeScriptExternalPaths parseConfig(@NotNull FileContent inputData) {
        if (inputData == null) {
            TypeScriptConfigIndex.$$$reportNull$$$0(0);
        }
        try {
            JsonElement element = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new CharSequenceReader(inputData.getContentAsText())));
            JsonObject object = element.getAsJsonObject();
            JsonElement options = object.get("compilerOptions");
            JsonObject compilerOptions = options.getAsJsonObject();
            JsonElement baseUrlElement = compilerOptions.get("baseUrl");
            String baseUrl = baseUrlElement == null ? null : baseUrlElement.getAsString();
            ArrayList<String> pathsInMappings = new ArrayList<String>();
            JsonElement paths = compilerOptions.get("paths");
            if (paths != null) {
                JsonObject pathsObject = paths.getAsJsonObject();
                for (Map.Entry entry : pathsObject.entrySet()) {
                    JsonElement value = (JsonElement)entry.getValue();
                    JsonArray array = value.getAsJsonArray();
                    for (JsonElement jsonElement : array) {
                        String pathMapping = jsonElement.getAsString();
                        pathsInMappings.add(pathMapping);
                    }
                }
            }
            JsonElement rootDirsElement = compilerOptions.get("rootDirs");
            ArrayList<String> rootDirs = new ArrayList<String>();
            if (rootDirsElement != null) {
                JsonArray array = rootDirsElement.getAsJsonArray();
                for (JsonElement jsonElement : array) {
                    rootDirs.add(jsonElement.getAsString());
                }
            }
            if (!pathsInMappings.isEmpty() || !rootDirs.isEmpty()) {
                return new TypeScriptExternalPaths(StringUtil.notNullize((String)baseUrl), rootDirs, pathsInMappings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public ID<String, TypeScriptExternalPaths> getName() {
        ID<String, TypeScriptExternalPaths> iD = NAME;
        if (iD == null) {
            TypeScriptConfigIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, TypeScriptExternalPaths, FileContent> getIndexer() {
        DataIndexer<String, TypeScriptExternalPaths, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            TypeScriptConfigIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            TypeScriptConfigIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<TypeScriptExternalPaths> getValueExternalizer() {
        return new DataExternalizer<TypeScriptExternalPaths>(){

            public void save(@NotNull DataOutput out, TypeScriptExternalPaths value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                out.writeUTF(value.baseUrl);
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value.rootDirs, descriptor -> out.writeUTF((String)descriptor));
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value.pathsInMappings, descriptor -> out.writeUTF((String)descriptor));
            }

            public TypeScriptExternalPaths read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                String baseUrl = in.readUTF();
                List rootDirs = DataInputOutputUtilRt.readSeq((DataInput)in, () -> in.readUTF());
                List paths = DataInputOutputUtilRt.readSeq((DataInput)in, () -> in.readUTF());
                return new TypeScriptExternalPaths(baseUrl, rootDirs, paths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull @NotNull FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.FileTypeSpecificInputFilter(){

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    3.$$$reportNull$$$0(0);
                }
                fileTypeSink.consume((Object)TypeScriptConfigFileType.INSTANCE);
            }

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(1);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class TypeScriptExternalPaths {
        public final String baseUrl;
        public final List<String> rootDirs;
        public final List<String> pathsInMappings;

        public TypeScriptExternalPaths(@NotNull String baseUrl, @NotNull List<String> rootDirs, @NotNull List<String> pathsInMappings) {
            if (baseUrl == null) {
                TypeScriptExternalPaths.$$$reportNull$$$0(0);
            }
            if (rootDirs == null) {
                TypeScriptExternalPaths.$$$reportNull$$$0(1);
            }
            if (pathsInMappings == null) {
                TypeScriptExternalPaths.$$$reportNull$$$0(2);
            }
            this.baseUrl = baseUrl;
            this.rootDirs = rootDirs;
            this.pathsInMappings = pathsInMappings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeScriptExternalPaths info2 = (TypeScriptExternalPaths)o;
            return Objects.equals(this.baseUrl, info2.baseUrl) && Objects.equals(this.pathsInMappings, info2.pathsInMappings);
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.pathsInMappings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootDirs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pathsInMappings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigIndex$TypeScriptExternalPaths";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

