/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.ES6ImportExecutorFactory;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptStubElementTypes.EXPORT_ASSIGNMENT});

    public static boolean isExportedElement(PsiElement elementToImport, JSImportPlaceInfo placeInfo) {
        TypeScriptModule tsModule;
        PsiElement parent;
        if (elementToImport instanceof ES6ExportSpecifier) {
            return true;
        }
        PsiElement psiElement = parent = elementToImport instanceof JSVariable ? JSDestructuringUtil.getParentSkippingDestructuring((JSVariable)elementToImport) : elementToImport.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSModuleStatusOwner && !((JSModuleStatusOwner)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.getContainer())) {
            return false;
        }
        if (parent instanceof TypeScriptModule && (tsModule = (TypeScriptModule)parent).isAugmentation() && !TypeScriptAutoImportUtil.isAugmentationAcceptable(tsModule)) {
            return false;
        }
        if (TypeScriptModuleAccessibilityChecker.INSTANCE.check(placeInfo.getPlace(), elementToImport) != null) {
            return false;
        }
        return ES6ImportHandler.isExported(elementToImport) || elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault();
    }

    private static boolean isAugmentationAcceptable(@NotNull TypeScriptModule tsModule) {
        PsiElement parent;
        if (tsModule == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(0);
        }
        if (!ES6PsiUtil.isExternalModule(parent = tsModule.getParent())) {
            return false;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        return assignment instanceof TypeScriptExportAssignment;
    }

    public static boolean isContextAcceptable(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(1);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(2);
        }
        if (!(placeInfo.getPlace() instanceof JSReferenceExpression)) {
            return true;
        }
        if (elementToImport instanceof TypeScriptModule) {
            if (!((TypeScriptModule)elementToImport).isInternal()) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(elementToImport);
            if (module == null) {
                return false;
            }
        }
        boolean isClassType = TypeScriptAutoImportUtil.isClassLikeType(elementToImport);
        if (placeInfo.isStrictTypeContext() && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isClassLikeType(@NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(3);
        }
        return elementToImport instanceof JSClass || elementToImport instanceof TypeScriptModule || elementToImport instanceof TypeScriptImportStatement || elementToImport instanceof TypeScriptVariable;
    }

    private static boolean isElementCanBeUsedInContext(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(4);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(5);
        }
        PsiElement parentContext = placeInfo.getParentElement();
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptCompileTimeType) || !isCallContext;
    }

    public static void showError(Project project, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        String name = TypeScriptAutoImportUtil.getDialogTitle();
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("dialog.message.cannot.find.module.for.import", new Object[0]), (String)name, null);
    }

    public static boolean isSelfExportedAugmentationModule(@NotNull TypeScriptModule container) {
        String reference;
        PsiElement parent;
        JSExportAssignment assignment;
        if (container == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(6);
        }
        if ((assignment = TypeScriptAutoImportUtil.getExportAssignment(parent = container.getContext())) != null && (reference = assignment.getInitializerReference()) != null) {
            JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
            return result2.getElements().contains(container);
        }
        return false;
    }

    @NotNull
    public static String createTypeScriptImportText(@NotNull PsiElement place, @NotNull JSImportDescriptor info2, boolean withSemicolon) {
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(7);
        }
        if (info2 == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(8);
        }
        String moduleName = info2.getModuleName();
        JSImportExportType importType = info2.getImportType();
        String name = info2.getImportedName();
        StringBuilder builder2 = new StringBuilder("import ");
        if (importType.isTypeScriptRequire()) {
            String quote = JSCodeStyleSettings.getQuote(place);
            builder2.append(name).append(" = require(").append(quote).append(moduleName).append(quote).append(')');
        } else {
            builder2.append(name).append(" = ").append(moduleName);
        }
        if (withSemicolon) {
            builder2.append(JSCodeStyleSettings.getSemicolon(place));
        }
        String string = builder2.toString();
        if (string == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static JSExportAssignment getExportAssignment(@Nullable PsiElement module) {
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NlsContexts.DialogTitle
    public static String getDialogTitle() {
        return JavaScriptBundle.message("ts.add.import.statement.dialog.title", new Object[0]);
    }

    @Nullable
    public static String buildElementText(@NotNull PsiElement context2, List<? extends JSImportCandidate> candidates, boolean severalVariants) {
        JSImportDescriptor descriptor;
        String newText;
        JSImportCandidate firstItem;
        if (context2 == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(10);
        }
        if ((firstItem = (JSImportCandidate)ContainerUtil.getFirstItem(candidates)) == null) {
            return null;
        }
        PsiElement element = firstItem.getElement();
        String string = newText = element instanceof JSElement ? new ES6QualifiedNamedElementRenderer<PsiElement>().getElementText(element) : firstItem.getName();
        if (!severalVariants && (descriptor = firstItem.getDescriptor()) != null) {
            JSAddImportExecutor executor = JSHandlersFactory.forElement(context2).createAddImportExecutor(context2);
            if (executor == null) {
                executor = ES6ImportExecutorFactory.FACTORY.createExecutor(context2);
            }
            return executor.getImportStatementText(descriptor);
        }
        return newText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsModule";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptImportText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAugmentationAcceptable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isContextAcceptable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isClassLikeType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeUsedInContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelfExportedAugmentationModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptImportText";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildElementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

