/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceProvider;
import com.intellij.lang.typescript.editing.TypeScriptServiceInlayHintsService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptServiceInlayHintsPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDelay", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.impl"})
public final class TypeScriptServiceInlayHintsPass
extends TextEditorHighlightingPass {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;

    public TypeScriptServiceInlayHintsPass(@NotNull Project project, @NotNull Document document2, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(project, document2);
        this.project = project;
        this.editor = editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        VirtualFile file = this.editor.getVirtualFile();
        if (file != null && TypeScriptLanguageServiceProvider.isJavaScriptOrTypeScriptFileType(file.getFileType())) {
            TypeScriptServiceInlayHintsService typeScriptServiceInlayHintsService = (TypeScriptServiceInlayHintsService)this.project.getService(TypeScriptServiceInlayHintsService.class);
            VirtualFile virtualFile = this.editor.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Document document2 = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            typeScriptServiceInlayHintsService.enqueueRenderHints(new TypeScriptServiceInlayHintsService.RenderHintsRequest(virtualFile, this.getDelay(file, document2), false, 4, null));
        }
    }

    private final int getDelay(VirtualFile file, Document document2) {
        int base = Registry.intValue((String)"typescript.service.provideInlayHints.passDelayMs");
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile2 == null) {
            return base;
        }
        PsiFile psiFile3 = psiFile2;
        int additionalDelayPer1000Lines = DialectDetector.isJSX((PsiElement)psiFile3) ? Registry.intValue((String)"typescript.service.provideInlayHints.additionalPassDelayPer1000LinesMs.jsx") : Registry.intValue((String)"typescript.service.provideInlayHints.additionalPassDelayPer1000LinesMs");
        return (int)Math.min((long)Registry.intValue((String)"typescript.service.provideInlayHints.maxPassDelayMs"), (long)base + (long)document2.getLineCount() * (long)additionalDelayPer1000Lines / (long)1000);
    }

    public void doApplyInformationToEditor() {
    }
}

