/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.frameworks;

import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.frameworks.DownloadableTypeScriptServicePlugin;
import com.intellij.lang.typescript.compiler.languageService.frameworks.PluggableTypeScriptServiceProtocol;
import com.intellij.lang.typescript.lsp.JSServiceSetActivationRule;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "servicePlugin", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;)V", "createProtocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "readyConsumer", "Ljava/util/function/Consumer;", "tsServicePath", "", "hasDependenciesReady", "", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDisabledByContext", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class PluggableTypeScriptService
extends TypeScriptServerServiceImpl {
    @NotNull
    private final DownloadableTypeScriptServicePlugin servicePlugin;

    public PluggableTypeScriptService(@NotNull Project project, @NotNull DownloadableTypeScriptServicePlugin servicePlugin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)servicePlugin, (String)"servicePlugin");
        super(project, servicePlugin.getPackageName());
        this.servicePlugin = servicePlugin;
    }

    @Override
    public boolean isDisabledByContext(@NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (super.isDisabledByContext(context2)) {
            return true;
        }
        return !this.hasDependenciesReady(context2);
    }

    private final boolean hasDependenciesReady(VirtualFile context2) {
        JSServiceSetActivationRule jSServiceSetActivationRule = this.servicePlugin.getActivationRule();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return jSServiceSetActivationRule.isTypeScriptPluginEnabledAndAvailable(project, context2);
    }

    @Override
    @NotNull
    protected JSLanguageServiceProtocol createProtocol(@NotNull Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        TypeScriptCompilerSettings typeScriptCompilerSettings = this.mySettings;
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptCompilerSettings, (String)"mySettings");
        Consumer<JSLanguageServiceAnswer> consumer = this.createEventConsumer();
        Intrinsics.checkNotNullExpressionValue(consumer, (String)"createEventConsumer(...)");
        return new PluggableTypeScriptServiceProtocol(project, typeScriptCompilerSettings, readyConsumer, consumer, tsServicePath, this.servicePlugin);
    }
}

