/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.concurrency.ThreadContext;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.linter.JSLinterExecutionSuppressor;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceFileCommandCache;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticEventKind;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptGeterrService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceQueueImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptMessageBus;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceProjectErrors;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceWidgetItem;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptSuppressByCommentFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCache;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.GetCodeFixesRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ProjectInfoRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ProjectInfoRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SemanticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SetCompilerOptionsForInferredProjectsArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SetCompilerOptionsForInferredProjectsRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.StatusCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SuggestionDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SyntacticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.EmitResult;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.StatusResponseBody;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptProjectInfoResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptStatusResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptConfigurable;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.update.Update;
import icons.JavaScriptLanguageIcons;
import icons.JavaScriptPsiIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final String PROCESSED_FILES_FIELD = "processedFiles";
    public static final String DIAGNOSTICS_FIELD = "diagnostics";
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final JSLanguageServiceFileCommandCache myQuickFixCache;
    @NotNull
    private final TypeScriptMessageBus myMessageBus;
    @NotNull
    private final Condition<VirtualFile> myFileFilter;
    @Nullable
    private Throwable disposeStack;
    private static boolean ourPreventInitializationInTest = false;

    @Override
    @NlsSafe
    @NotNull
    protected String getProcessName() {
        return "TypeScript";
    }

    @Override
    @Nullable
    public SemVer getServiceVersion() {
        TypeScriptServerState state = this.getServerStateIfStarted();
        return state != null ? state.getServerVersion() : null;
    }

    public TypeScriptServerServiceImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(0);
        }
        this(project, "Console");
    }

    @NonInjectable
    protected TypeScriptServerServiceImpl(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(2);
        }
        super(project, consoleId);
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
        this.myQuickFixCache = new JSLanguageServiceFileCommandCache(this);
        this.myMessageBus = TypeScriptMessageBus.get(project);
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(project);
        this.myFileFilter = virtualFile -> {
            if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
                return false;
            }
            if (TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value(virtualFile)) {
                return true;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (DumbService.isDumb((Project)project)) {
                    return false;
                }
                return this.isAcceptableNonTsFile(project, service2, (VirtualFile)virtualFile);
            });
        };
        TypeScriptConfigService.Provider.get(project).addConfigListener(config -> {
            TypeScriptServerState state = this.getServerStateIfStarted();
            if (state == null) {
                return;
            }
            state.clearCompiledProject(config.getPath());
            VirtualFile defaultConfig = state.getDefaultConfig();
            if (defaultConfig == null || !defaultConfig.equals(config)) {
                return;
            }
            state.addUpdate(new Update(defaultConfig){

                public void run() {
                    ReadAction.run(() -> TypeScriptServerServiceImpl.this.sendSetCompilerOptionsForInferredProjects(TypeScriptServerServiceImpl.this.getProcessIfCreated()));
                }
            });
        }, this);
    }

    protected boolean isAcceptableNonTsFile(@NotNull Project project, @NotNull TypeScriptConfigService service2, @NotNull VirtualFile virtualFile) {
        FileType type2;
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(3);
        }
        if (service2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(5);
        }
        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type2 = virtualFile.getFileType())) {
            return false;
        }
        TypeScriptConfig config = service2.getDirectIncludePreferableConfig(virtualFile);
        return config != null && config.allowJs();
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(6);
        }
        if (!this.isServiceCreated()) {
            return;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process != null) {
            String path2 = command.getCompilerId();
            if (StringUtil.isEmpty((String)path2)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = LocalFilePath.create(path2);
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    protected void processVfsChangesForFiles(@NotNull Collection<TypeScriptCompilerService.UpdateFileInfo> updates) {
        TypeScriptServerState serverState;
        if (updates == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(7);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isReCompileOnChanges()) {
            this.addToCompileQueueWithUpdate(updates.stream().map(el -> el.getFile()).collect(Collectors.toSet()));
        }
        if ((serverState = this.getServerStateIfStarted()) != null) {
            updates.forEach(el -> serverState.addFileToContentChangedQueue((TypeScriptCompilerService.UpdateFileInfo)el));
        }
    }

    private void addToCompileQueueWithUpdate(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(8);
        }
        ReadAction.run(() -> this.addToCompileQueueWithUpdateImpl(files2));
    }

    private void addToCompileQueueWithUpdateImpl(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isReCompileOnChanges() || !this.isEnabled()) {
            return;
        }
        List<String> fileNames2 = this.getFileNamesForCompilation(files2);
        if (fileNames2.isEmpty()) {
            return;
        }
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addUpdate(new Update(new TypeScriptCompileUpdater(), 10){

                public void run() {
                    if (TypeScriptServerServiceImpl.this.isServiceCreated()) {
                        JSLanguageServiceUpdateContext context2 = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> TypeScriptServerServiceImpl.this.createUpdateContext(null));
                        TypeScriptServerServiceImpl.this.update(context2);
                    }
                }
            });
        }
        this.addToCompileQueue(fileNames2);
    }

    @Override
    @Nullable
    protected TypeScriptLanguageServiceQueueImpl getProcess() {
        return (TypeScriptLanguageServiceQueueImpl)super.getProcess();
    }

    @TestOnly
    public void assertProcessStarted() {
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            throw new IllegalStateException("The language service process was not started");
        }
        this.disposeStack = null;
    }

    @NotNull
    private List<String> getFileNamesForCompilation(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(10);
        }
        GlobalSearchScope scope2 = this.getScope();
        List list2 = ContainerUtil.mapNotNull(files2, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope2.accept(el) && null == el.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        if (list2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return null;
    }

    @Override
    public boolean isDisabledByContext(@NotNull VirtualFile context2) {
        if (context2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(12);
        }
        return !TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject);
    }

    @Nullable
    public CompletableFuture<Boolean> update(@NotNull JSLanguageServiceUpdateContext context2) {
        if (context2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(13);
        }
        this.updateImpl(context2);
        return null;
    }

    @Nullable
    public CompletableFuture<JSLanguageServiceResultContainer> compileFile(@NotNull VirtualFile file, boolean explicit) {
        String projectName;
        TypeScriptLanguageServiceQueueImpl process;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(14);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        TypeScriptServerState state = process.getServerState();
        String path2 = file.getPath();
        if (TypeScriptUtil.isDefinitionFile(path2) || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file)) {
            return null;
        }
        TypeScriptConfig config = (TypeScriptConfig)ReadAction.compute(() -> TypeScriptConfigService.Provider.get(this.myProject).getPreferableConfig(file));
        if (config != null && !explicit && config.hasExplicitCompileOnSave() && !config.compileOnSave()) {
            return null;
        }
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        if (!explicit && config != null && !state.isProjectCompiled(projectName = config.getConfigFile().getPath())) {
            return this.compileProject(config.getConfigFile());
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.richResponse = explicit;
        args.forced = explicit;
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file));
        args.projectFileName = config != null ? LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(config.getConfigFile())) : null;
        this.setMacroParamsIfNeeded(args, file);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    private static void setUpdateForVfsChangedFiles(@NotNull TypeScriptLanguageServiceQueueImpl process) {
        TypeScriptServerState state;
        Set<VirtualFile> files2;
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(15);
        }
        if ((files2 = (state = process.getServerState()).getChangedContentFiles()).isEmpty()) {
            return;
        }
        files2.forEach(el -> process.executeNoBlocking(new TypeScriptReloadFileCommand((VirtualFile)el), null));
    }

    @Nullable
    public CompletableFuture<JSLanguageServiceResultContainer> compileProject(@NotNull VirtualFile config) {
        TypeScriptLanguageServiceQueueImpl process;
        if (config == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(16);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        TypeScriptServerState state = process.getServerState();
        state.setProjectCompiled(config.getPath());
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        StatusCommand command = new StatusCommand();
        CompletableFuture<TypeScriptStatusResponse> future = process.execute(command, (serviceObject, answer) -> (TypeScriptStatusResponse)this.getGson().fromJson((JsonElement)answer.getElement(), TypeScriptStatusResponse.class));
        if (future == null) {
            return null;
        }
        return future.thenCompose(response -> {
            if (response == null) {
                return null;
            }
            StatusResponseBody body2 = response.body;
            if (body2 != null && body2.compileOverride) {
                TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                args.richResponse = true;
                args.forced = true;
                args.projectFileName = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(config));
                return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
            }
            List list2 = (List)ReadAction.compute(() -> {
                TypeScriptConfig tsConfig = TypeScriptConfigService.Provider.parseConfigFile(this.myProject, config);
                if (tsConfig == null) {
                    return ContainerUtil.emptyList();
                }
                JSImportGraph graph = JSConfigGraphCache.getService(this.myProject).getGraph(tsConfig);
                return StreamEx.of((Collection)graph.getNodes()).map(el -> this.compileFile((VirtualFile)el, true)).nonNull().toImmutableList();
            });
            return TypeScriptServerServiceImpl.sequenceFuture(list2).thenApply(el -> JSLanguageServiceResultContainer.compose(el));
        });
    }

    @NotNull
    public static <R> CompletableFuture<List<R>> sequenceFuture(@NotNull List<CompletableFuture<R>> futures) {
        if (futures == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(17);
        }
        CompletionStage completionStage = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(el -> {
            try {
                return el.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        if (completionStage == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(18);
        }
        return completionStage;
    }

    @Nullable
    public @Nullable CompletableFuture<@Nullable TypeScriptProjectInfoResponse> getProjectInfo(@Nullable VirtualFile config, @Nullable VirtualFile file) {
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        ProjectInfoRequestArgs args = new ProjectInfoRequestArgs();
        args.file = file != null ? LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file)) : null;
        args.projectFileName = config != null ? LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(config)) : null;
        args.needFileNameList = true;
        ProjectInfoRequest request2 = new ProjectInfoRequest(args);
        return this.sendCommand(request2, (serviceObject, answer) -> (TypeScriptProjectInfoResponse)this.getGson().fromJson((JsonElement)answer.getElement(), TypeScriptProjectInfoResponse.class));
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file) {
        VirtualFile mainFile;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(19);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!this.isServiceCreated() || this.isDisabledByContext(file) && (!ApplicationManager.getApplication().isUnitTestMode() || TypeScriptLanguageServiceUtil.ourUseService == TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.DO_NOT_USE)) {
            return;
        }
        if (this.mySettings.useMainFile() && file.equals(mainFile = this.getMainFile())) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file);
        arguments.file = LocalFilePath.create(normalizeNameAndPath);
        this.sendCommand(command);
    }

    @Override
    @NotNull
    public Collection<IntentionAction> getServiceFixes(@NotNull PsiFile file, PsiElement element, @NotNull JSAnnotationError result2) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(21);
        }
        if (!(result2 instanceof TypeScriptLanguageServiceAnnotationResult)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(22);
            }
            return list2;
        }
        TypeScriptLanguageServiceAnnotationResult typescriptResult = (TypeScriptLanguageServiceAnnotationResult)result2;
        int code = typescriptResult.getErrorCode();
        if (code == -1) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(23);
            }
            return list3;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        Set tsCompilerCodesErrorCodes = process == null ? Collections.emptySet() : process.getServerState().myErrorCodeFixes;
        boolean isSuggestion = "suggestion".equals(result2.getCategory());
        boolean isTSCompilerError = TypeScriptServerServiceImpl.isTSCompilerError(typescriptResult);
        if ((tsCompilerCodesErrorCodes.contains(String.valueOf(code)) || !isTSCompilerError) && file.getVirtualFile() != null) {
            TypeScriptSuppressByCommentFix suppressByCommentFix;
            TypeScriptLanguageServiceFixSet set = this.createFixSet(file, this.myQuickFixCache, typescriptResult);
            ArrayList<IntentionAction> resultActions = new ArrayList<IntentionAction>(set.getFixes());
            if (!isSuggestion && isTSCompilerError && (suppressByCommentFix = this.getSuppressAction(element)) != null) {
                resultActions.add((IntentionAction)suppressByCommentFix);
            }
            ArrayList<IntentionAction> arrayList = resultActions;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        List list4 = isSuggestion ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)this.getSuppressAction(element));
        if (list4 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(25);
        }
        return list4;
    }

    @NotNull
    protected TypeScriptLanguageServiceFixSet createFixSet(@NotNull PsiFile file, @NotNull JSLanguageServiceFileCommandCache cache2, @NotNull TypeScriptLanguageServiceAnnotationResult typescriptResult) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(26);
        }
        if (cache2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(27);
        }
        if (typescriptResult == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(28);
        }
        return new TypeScriptLanguageServiceFixSet(file.getProject(), cache2, file.getVirtualFile(), typescriptResult, null);
    }

    private static boolean isTSCompilerError(@NotNull TypeScriptLanguageServiceAnnotationResult error) {
        if (error == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(29);
        }
        return !StringUtil.equals((CharSequence)error.getSource(), (CharSequence)"tslint");
    }

    @Nullable
    public TypeScriptSuppressByCommentFix getSuppressAction(@Nullable PsiElement element) {
        if (element != null) {
            Class<? extends JSSuppressionHolder> aClass = JSInspectionSuppressor.getHolderClass(element);
            return new TypeScriptSuppressByCommentFix(aClass);
        }
        return null;
    }

    @Override
    @RequiresReadLock
    public void openEditor(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!this.isServiceCreated() || this.isDisabledByContext(file) && (!ApplicationManager.getApplication().isUnitTestMode() || TypeScriptLanguageServiceUtil.ourUseService == TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.DO_NOT_USE)) {
            return;
        }
        TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(file);
        if (command == null) {
            return;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)el -> this.addToCompileQueueWithUpdate(Collections.singletonList(file))));
    }

    @Override
    public boolean checkCanUseService() {
        return this.getCanStartProcessState() != ThreeState.NO && (this.mySettings.isRecompileOnChanges() || this.myFailCount.get() < (long)this.getAliveCheckCount());
    }

    @Override
    @Nullable
    public CompletableFuture<List<JSAnnotationError>> highlight(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (TypeScriptLanguageServiceUtil.saveChangedConfigs(file)) {
            return null;
        }
        JSLanguageServiceUpdateContext context2 = this.createUpdateContext(file.getVirtualFile());
        return this.updateFilesAndGetErrors(file, new JSFileHighlightingInfo(file.getVirtualFile(), context2));
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        VirtualFile context2;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(32);
        }
        if ((context2 = file.getVirtualFile()) == null) {
            return false;
        }
        if (this.isDisabledByContext(context2)) {
            return false;
        }
        return this.checkAnnotationProvider(file);
    }

    @Override
    public boolean isAcceptableForHighlighting(@NotNull PsiFile file) {
        DialectOptionHolder holder;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(33);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)file)) == null) {
            return false;
        }
        if (!holder.isJavaScript()) {
            return holder.isTypeScript;
        }
        TypeScriptConfig configForPsiFile = TypeScriptConfigUtil.getConfigForPsiFile(file);
        return configForPsiFile != null && configForPsiFile.allowJs();
    }

    protected boolean checkAnnotationProvider(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(34);
        }
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file);
        return provider instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
    }

    @Override
    public boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(35);
        }
        return this.myFileFilter.value((Object)file);
    }

    @Override
    protected void resetState() {
        super.resetState();
        if (ourPreventInitializationInTest) {
            this.disposeStack = new Exception("Server was disposed here.");
        }
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        NodeJsInterpreter interpreter2 = TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
        boolean hasInterpreter = interpreter2 != null;
        ThreeState prevValue = this.getCanStartProcessState();
        this.setCanStartProcessState(ThreeState.fromBoolean((boolean)hasInterpreter));
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        java.util.function.Consumer<JsonObject> readyConsumer = this.createReadyConsumer((Ref<TypeScriptLanguageServiceQueueImpl>)serviceRef);
        JSLanguageServiceProtocol protocol = this.createProtocol(readyConsumer, this.getServicePath());
        if (protocol == null) {
            return null;
        }
        if (ourPreventInitializationInTest && application.isUnitTestMode()) {
            throw new IllegalStateException("TypeScript Server Service " + this + " is being initialized, even though it should not. This usually means that an incorrect server is chosen for handling the request.", this.disposeStack);
        }
        boolean setActive = this.myFailCount.get() == 0L;
        JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, setActive) : this.myDefaultReporter;
        java.util.function.Consumer<JSLanguageServiceQueue> initializer = this.getInitializedCallback();
        TypeScriptLanguageServiceQueueImpl service2 = null;
        TypeScriptServerState state = null;
        try {
            String tsServicePath = this.getServicePath();
            ProgressManager.checkCanceled();
            if (JSLinterExecutionSuppressor.executionIsSuppressed(tsServicePath)) {
                return null;
            }
            state = this.createLanguageServiceState(protocol, errorReporter, this.createLSCache(), tsServicePath);
            service2 = new TypeScriptLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, errorReporter, this.createLSCache(), state);
            if (protocol instanceof JSLanguageServiceNodeStdProtocolBase) {
                JSLanguageServiceNodeStdProtocolBase protocolBase = (JSLanguageServiceNodeStdProtocolBase)protocol;
                if (Registry.is((String)"js.language.service.log.messages")) {
                    protocolBase.startMessageStreamLogging("typescript", service2);
                }
            }
            serviceRef.set((Object)service2);
            initializer.accept(service2);
            JSLanguageServiceQueue.Holder.LOGGER.trace("New service queue was created and initialized: " + service2.hashCode());
            return service2;
        }
        catch (Error | RuntimeException error) {
            if (service2 != null) {
                Disposer.dispose(service2);
            } else if (state != null) {
                Disposer.dispose(state);
            }
            throw error;
        }
    }

    @NotNull
    protected TypeScriptServerState createLanguageServiceState(@NotNull JSLanguageServiceProtocol protocol, @NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter reporter, @NotNull TypeScriptLanguageServiceCache cacheData, @NotNull String servicePath) {
        if (protocol == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(36);
        }
        if (reporter == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(37);
        }
        if (cacheData == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(38);
        }
        if (servicePath == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(39);
        }
        JSAnnotationErrorsFilter filter = (path2, errors) -> {
            PsiFile psiFile2;
            if (errors.isEmpty()) {
                return errors;
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path2);
            if (vFile != null && (psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(vFile)) != null && psiFile2.isValid()) {
                return this.postprocessErrors(psiFile2, errors);
            }
            return errors;
        };
        TypeScriptServerState state = new TypeScriptServerState(this.myProject, cacheData, protocol, reporter, filter, servicePath);
        for (DiagnosticEventKind kind : DiagnosticEventKind.values()) {
            state.registerEventTracker(kind.name(), answer -> {
                Pair<String, List<JSAnnotationError>> pathAndErrors = state.getProjectErrors().getPathAndErrors((JSLanguageServiceAnswer)answer, state.getLanguageServiceInfo());
                if (pathAndErrors == null) {
                    return;
                }
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath((String)pathAndErrors.first);
                if (file == null) {
                    return;
                }
                ((TypeScriptGeterrService)this.myProject.getService(TypeScriptGeterrService.class)).receivedDiagnosticInfo(file, kind, (List)pathAndErrors.second);
            });
        }
        TypeScriptServerState typeScriptServerState = state;
        if (typeScriptServerState == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(40);
        }
        return typeScriptServerState;
    }

    @NotNull
    protected TypeScriptLanguageServiceCache createLSCache() {
        return new TypeScriptLanguageServiceCache(this.myProject);
    }

    @NotNull
    private String getServicePath() {
        String string = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
        if (string == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private java.util.function.Consumer<JsonObject> createReadyConsumer(@NotNull Ref<TypeScriptLanguageServiceQueueImpl> serviceRef) {
        if (serviceRef == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(42);
        }
        java.util.function.Consumer<JsonObject> consumer = el -> {
            try {
                JsonObject message = el.getAsJsonObject("message");
                if (message == null) {
                    JSLanguageServiceQueue.Holder.LOGGER.error("No ready message");
                    return;
                }
                TypeScriptLanguageServiceQueueImpl queue = (TypeScriptLanguageServiceQueueImpl)serviceRef.get();
                JsonPrimitive version2 = message.getAsJsonPrimitive("version");
                @NlsSafe String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version2.getAsString());
                if (queue != null && queue.isValid()) {
                    TypeScriptServerState state = queue.getServerState();
                    state.setProcessName(this.getProcessName());
                    state.setServerVersion(versionAsString);
                    if (versionAsString != null) {
                        String servicePath = (String)ReadAction.compute(() -> this.getServicePath());
                        state.setLanguageServiceInfo(new LanguageServiceInfo(servicePath, versionAsString, this.getLocale()));
                    }
                    this.myMessageBus.changed();
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(43);
        }
        return consumer;
    }

    @Nullable
    private String getLocale() {
        String paramsStr = this.mySettings.getDefaultServiceOptions();
        if (StringUtil.isEmptyOrSpaces((String)paramsStr)) {
            return null;
        }
        List params = ParametersListUtil.parse((String)paramsStr);
        int indexOfLocale = params.indexOf("--locale");
        if (0 <= indexOfLocale && indexOfLocale < params.size() - 1) {
            return (String)params.get(indexOfLocale + 1);
        }
        return null;
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(@NotNull java.util.function.Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        if (readyConsumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(44);
        }
        if (tsServicePath == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(45);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, readyConsumer, this.createEventConsumer(), "typescript", tsServicePath);
    }

    @NotNull
    protected java.util.function.Consumer<JSLanguageServiceAnswer> createEventConsumer() {
        java.util.function.Consumer<JSLanguageServiceAnswer> consumer = el -> {
            TypeScriptServerState serverState = this.getServerStateIfStarted();
            if (serverState == null) {
                return;
            }
            serverState.processEvent((JSLanguageServiceAnswer)el);
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(46);
        }
        return consumer;
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    @Override
    protected void initToolWindow() {
        super.initToolWindow();
        this.myMessageBus.changed();
    }

    @Override
    protected boolean needInitToolWindow() {
        return this.isEnabled();
    }

    @NotNull
    protected java.util.function.Consumer<JSLanguageServiceQueue> getInitializedCallback() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Map<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> commands = this.getInitialOpenCommands();
        java.util.function.Consumer<JSLanguageServiceQueue> consumer = service2 -> ReadAction.run(() -> {
            TypeScriptServerServiceImpl.sendUpdateCodeFixesState(service2);
            TypeScriptServerServiceImpl.sendOpenFakeFile(service2);
            this.sendSetCompilerOptionsForInferredProjects((JSLanguageServiceQueue)service2);
            this.sendDefaultOptionProject((JSLanguageServiceQueue)service2);
            TypeScriptServerServiceImpl.sendInitialOpenState(service2, commands);
        });
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(47);
        }
        return consumer;
    }

    private static void sendOpenFakeFile(@NotNull JSLanguageServiceQueue service2) {
        if (service2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(48);
        }
        File file = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/init.ts");
        TypeScriptCommandWithArguments<TypeScriptFileWithConfigArgs> open = new TypeScriptCommandWithArguments<TypeScriptFileWithConfigArgs>("open", new TypeScriptFileWithConfigArgs(file.getAbsolutePath()));
        TypeScriptCommandWithArguments<TypeScriptFileWithConfigArgs> close = new TypeScriptCommandWithArguments<TypeScriptFileWithConfigArgs>("close", new TypeScriptFileWithConfigArgs(file.getAbsolutePath()));
        service2.executeNoBlocking(open, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> {}));
        service2.executeNoBlocking(close, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> {}));
    }

    private static void sendUpdateCodeFixesState(@NotNull JSLanguageServiceQueue service2) {
        if (service2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(49);
        }
        GetCodeFixesRequest fixes = new GetCodeFixesRequest();
        if (service2 instanceof TypeScriptLanguageServiceQueueImpl) {
            TypeScriptServerState state = ((TypeScriptLanguageServiceQueueImpl)service2).getServerState();
            service2.executeNoBlocking(fixes, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> {
                JsonObject nested = answer.getElement();
                JsonElement body2 = nested.get(BODY_FIELD);
                if (body2 == null || !body2.isJsonArray()) {
                    return;
                }
                JsonArray array = body2.getAsJsonArray();
                Set result2 = StreamEx.of((Iterator)array.iterator()).map(element -> {
                    if (element.isJsonPrimitive()) {
                        return element.getAsString();
                    }
                    return "";
                }).toSet();
                state.setErrorCodes(result2);
            }));
        }
    }

    private static void sendInitialOpenState(@NotNull JSLanguageServiceQueue service2, @NotNull Map<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> initialCommands) {
        if (service2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(50);
        }
        if (initialCommands == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(51);
        }
        JSLanguageServiceQueue.Holder.LOGGER.trace("Send initial state for " + service2.hashCode());
        initialCommands.forEach((command, consumer) -> service2.executeNoBlocking((JSLanguageServiceCommand)command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)el -> consumer.accept(el))));
    }

    @NotNull
    protected Map<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> getInitialOpenCommands() {
        VirtualFile mainFile;
        ArrayList<VirtualFile> toProcess = new ArrayList<VirtualFile>();
        VirtualFile virtualFile = mainFile = this.isMainFileContext() ? this.getMainFile() : null;
        if (mainFile != null) {
            toProcess.add(mainFile);
        }
        toProcess.addAll(JSHighlightingInfoBuilder.getFilteredOpenedFiles(this.myProject, this::isAcceptable).keySet());
        if (toProcess.isEmpty()) {
            Map<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(52);
            }
            return map;
        }
        HashMap<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> commandsToConsumers = new HashMap<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>>();
        for (VirtualFile vFile : toProcess) {
            TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(vFile);
            if (command == null) continue;
            java.util.function.Consumer<JSLanguageServiceObject> consumer = serviceObject -> ReadAction.run(() -> {
                PsiFile file;
                if (vFile.isValid() && !this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)this.myProject).findFile(vFile)) != null) {
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
                }
            });
            commandsToConsumers.put(command, consumer);
        }
        HashMap<JSLanguageServiceSimpleCommand, java.util.function.Consumer<JSLanguageServiceObject>> hashMap = commandsToConsumers;
        if (hashMap == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(53);
        }
        return hashMap;
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && this.mySettings.useService();
    }

    @Override
    @Nullable
    public TypeScriptLanguageServiceQueueImpl getProcessIfCreated() {
        return (TypeScriptLanguageServiceQueueImpl)super.getProcessIfCreated();
    }

    @Nullable
    public TypeScriptServerState getServerStateIfStarted() {
        TypeScriptLanguageServiceQueueImpl process = this.getProcessIfCreated();
        return TypeScriptServerServiceImpl.getServerState(process);
    }

    @Contract(value="null->null")
    private static TypeScriptServerState getServerState(@Nullable JSLanguageServiceQueue process) {
        return !(process instanceof TypeScriptLanguageServiceQueueImpl) || !TypeScriptServerServiceImpl.checkState(process) ? null : ((TypeScriptLanguageServiceQueueImpl)process).getServerState();
    }

    @Override
    public void flushCommandQueue() {
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.flushQueue();
        }
    }

    @TestOnly
    public void flushQueues() {
        this.flushCommandQueue();
    }

    @Nullable
    @RequiresReadLock
    protected TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(54);
        }
        ThreadingAssertions.softAssertReadAccess();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager instance = FileDocumentManager.getInstance();
        Document document2 = instance.getDocument(file);
        if (document2 == null) {
            return null;
        }
        return this.createOpenCommand(file, instance, document2);
    }

    @NotNull
    protected TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file, @NotNull FileDocumentManager instance, @NotNull Document document2) {
        long contentLength;
        int lastLineStartOffset;
        int lineCount;
        CharSequence contentToSend;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(55);
        }
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(56);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(57);
        }
        if ((contentToSend = this.getPreprocessedDocumentText(file, instance, document2)) == null) {
            lineCount = document2.getLineCount();
            lastLineStartOffset = lineCount == 0 ? 0 : document2.getLineStartOffset(lineCount - 1);
            contentLength = document2.getTextLength();
        } else {
            lineCount = TypeScriptServerServiceImpl.getLineCountForText(contentToSend);
            lastLineStartOffset = TypeScriptServerServiceImpl.getLastLineStartOffsetFromText(contentToSend, lineCount);
            contentLength = contentToSend.length();
        }
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = this.createOpenCommand(file, -1L, contentLength, lineCount, lastLineStartOffset, contentLength == 0L ? "" : contentToSend);
        if (typeScriptOpenEditorCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(58);
        }
        return typeScriptOpenEditorCommand;
    }

    private void sendDefaultOptionProject(@NotNull JSLanguageServiceQueue queue) {
        VirtualFile config;
        if (queue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(59);
        }
        if ((config = TypeScriptLanguageServiceUtil.getDefaultOptionsConfig(this.myProject)) == null) {
            return;
        }
        String name = JSLanguageServiceUtil.normalizeNameAndPath(config);
        if (name == null) {
            return;
        }
        TypeScriptOpenExternalProjectRequest request2 = new TypeScriptOpenExternalProjectRequest(name);
        queue.executeNoBlocking(request2, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart()));
    }

    private void sendSetCompilerOptionsForInferredProjects(@Nullable JSLanguageServiceQueue queue) {
        TypeScriptServerState state = TypeScriptServerServiceImpl.getServerState(queue);
        if (state == null) {
            return;
        }
        VirtualFile config = state.getDefaultConfig();
        Map<String, Object> parsedOptions = TypeScriptLanguageServiceUtil.getDefaultOptions(this.myProject);
        if (config == null && parsedOptions.isEmpty()) {
            return;
        }
        SetCompilerOptionsForInferredProjectsArgs args = new SetCompilerOptionsForInferredProjectsArgs();
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(this.myProject);
        TypeScriptConfig tsConfig = service2.parseConfigFile(config);
        HashMap<String, Object> options = new HashMap<String, Object>(tsConfig != null ? TypeScriptServerServiceImpl.expandUrls(tsConfig) : Collections.emptyMap());
        SetCompilerOptionsForInferredProjectsRequest request2 = new SetCompilerOptionsForInferredProjectsRequest(args);
        args.options = options;
        options.putAll(parsedOptions);
        queue.executeNoBlocking(request2, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart()));
    }

    @NotNull
    private static Map<String, Object> expandUrls(@NotNull TypeScriptConfig tsConfig) {
        Map<String, Object> options;
        if (tsConfig == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(60);
        }
        if ((options = tsConfig.getRawCompilerOptions()).isEmpty()) {
            Map<String, Object> map = options;
            if (map == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(61);
            }
            return map;
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        options.forEach((key2, value) -> {
            switch (key2) {
                case "baseUrl": {
                    TypeScriptServerServiceImpl.addUrl("baseUrl", tsConfig.getBaseUrl(), result2);
                    break;
                }
                case "rootDir": {
                    TypeScriptServerServiceImpl.addUrl("rootDir", tsConfig.getRootDirFile(), result2);
                    break;
                }
                case "rootDirs": {
                    TypeScriptServerServiceImpl.addUrls("rootDirs", tsConfig.getRootDirsFiles(), result2);
                    break;
                }
                case "typeRoots": {
                    TypeScriptServerServiceImpl.addUrls("typeRoots", tsConfig.getTypeRoots(), result2);
                    break;
                }
                case "composite": {
                    break;
                }
                case "lib": {
                    break;
                }
                default: {
                    result2.put((String)key2, value);
                }
            }
        });
        HashMap<String, Object> hashMap = result2;
        if (hashMap == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(62);
        }
        return hashMap;
    }

    private static void addUrl(@NotNull String key2, @Nullable VirtualFile url, @NotNull Map<String, Object> result2) {
        if (key2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(63);
        }
        if (result2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(64);
        }
        if (url == null) {
            return;
        }
        LocalFilePath path2 = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(url));
        if (path2 != null) {
            result2.put(key2, path2);
        }
    }

    private static void addUrls(@NotNull String key2, @NotNull Collection<VirtualFile> urls, @NotNull Map<String, Object> result2) {
        if (key2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(65);
        }
        if (urls == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(66);
        }
        if (result2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(67);
        }
        if (urls.isEmpty()) {
            return;
        }
        List paths = ContainerUtil.mapNotNull(urls, el -> LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(el)));
        if (!paths.isEmpty()) {
            result2.put(key2, paths);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file, long timestamp, long contentLength, int lineCount, int n, @Nullable CharSequence charSequence) {
        void content;
        void lastLineStartOffset;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(68);
        }
        return new TypeScriptOpenEditorCommand(file, timestamp, contentLength, lineCount, (int)lastLineStartOffset, (CharSequence)content, null);
    }

    public static int getLastLineStartOffsetFromText(@NotNull CharSequence contentToSent, int lineCount) {
        if (contentToSent == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(69);
        }
        if (lineCount == 0) {
            return 0;
        }
        return StringUtil.endsWithChar((CharSequence)contentToSent, (char)'\n') ? contentToSent.length() : StringUtil.lastIndexOf((CharSequence)contentToSent, (char)'\n', (int)0, (int)contentToSent.length()) + 1;
    }

    public static int getLineCountForText(@NotNull CharSequence contentToSent) {
        if (contentToSent == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(70);
        }
        return StringUtil.countNewLines((CharSequence)contentToSent) + 1;
    }

    @Nullable
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file, @NotNull FileDocumentManager instance, @NotNull Document document2) {
        CharSequence text2;
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(71);
        }
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(72);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(73);
        }
        if ((text2 = TypeScriptServerServiceImpl.getDocumentText(instance, document2)) == null) {
            return null;
        }
        return JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text2, file);
    }

    @Nullable
    private static CharSequence getDocumentText(@NotNull FileDocumentManager instance, @NotNull Document document2) {
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(74);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(75);
        }
        return instance.isDocumentUnsaved(document2) ? document2.getImmutableCharSequence() : null;
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            List<String> emittedFiles;
            JsonObject element = answer.getElement();
            JsonElement body2 = element.get(BODY_FIELD);
            if (body2 == null || !body2.isJsonObject()) {
                return null;
            }
            JsonObject bodyObject = body2.getAsJsonObject();
            List<String> list2 = emittedFiles = bodyObject.has(GENERATED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)Objects.requireNonNull(bodyObject.getAsJsonArray(GENERATED_FILES_FIELD))) : ContainerUtil.emptyList();
            if (!emittedFiles.isEmpty()) {
                TypeScriptCompilerConfigUtil.refreshFiles(this.myProject, emittedFiles);
            }
            List<String> processedFiles = bodyObject.has(PROCESSED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)Objects.requireNonNull(bodyObject.getAsJsonArray(PROCESSED_FILES_FIELD))) : ContainerUtil.emptyList();
            List<JSAnnotationError> results = TypeScriptServerServiceImpl.parseCompileResult(this.getGson(), (JsonElement)bodyObject, this.myProject, this.getLanguageServiceInfo());
            return new JSLanguageServiceResultContainer(results, processedFiles, emittedFiles);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(76);
        }
        return jSLanguageServiceCommandProcessor;
    }

    protected void beforeGetErrors(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(77);
        }
    }

    @Nullable
    private CompletableFuture<List<JSAnnotationError>> updateFilesAndGetErrors(@NotNull PsiFile psiFile2, @NotNull JSFileHighlightingInfo info2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (psiFile2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(78);
        }
        if (info2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(79);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        VirtualFile file = psiFile2.getVirtualFile();
        final String path2 = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        if (path2 == null) {
            return null;
        }
        boolean projectErrors = this.isShowProjectErrors();
        this.updateImpl(info2.updateContext);
        this.beforeGetErrors(file);
        @Nullable TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile(this.myProject, file);
        ArrayList<CompletableFuture<List<JSAnnotationError>>> futures = new ArrayList<CompletableFuture<List<JSAnnotationError>>>();
        if (Registry.is((String)"typescript.service.geterr.enabled")) {
            CompletableFuture<List<JSAnnotationError>> geterrFuture;
            TypeScriptGeterrService geterrService = (TypeScriptGeterrService)this.myProject.getService(TypeScriptGeterrService.class);
            int delay = projectErrors ? 0 : TypeScriptServerServiceImpl.getGeterrDelay(psiFile2, file);
            int timeout = delay + Registry.intValue((String)"typescript.service.geterr.timeoutMs");
            CompletableFuture<List<JSAnnotationError>> completableFuture = geterrFuture = projectErrors ? geterrService.getGeterrResultsFuture(psiFile2, timeout) : geterrService.geterr(psiFile2, delay, timeout, this);
            if (geterrFuture != null) {
                futures.add(geterrFuture);
            }
        } else {
            Collection<JSLanguageServiceCacheableCommand> commands = this.createGetErrCommand(file, path2);
            if (commands.isEmpty()) {
                return null;
            }
            for (JSLanguageServiceCacheableCommand command : commands) {
                CompletableFuture<List<JSAnnotationError>> result2 = process.executeWithCache(command, new JSLanguageServiceCacheableCommandProcessor<List<JSAnnotationError>>(){

                    @Override
                    public @Unmodifiable List<JSAnnotationError> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                        if (command == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (object == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (answer == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return TypeScriptServerServiceImpl.this.parseGetErrorResult(answer, path2);
                    }

                    @Override
                    @NotNull
                    public List<JSAnnotationError> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSAnnotationError> result2) {
                        if (command == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        if (result2 == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        List<JSAnnotationError> list2 = result2;
                        if (list2 == null) {
                            3.$$$reportNull$$$0(5);
                        }
                        return list2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 5 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "command";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "object";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "answer";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$3";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "processFromCache";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "process";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "processFromCache";
                                break;
                            }
                            case 5: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 5 -> new IllegalStateException(string);
                        };
                    }
                });
                if (result2 == null) continue;
                futures.add(result2);
            }
        }
        CompletionStage result3 = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ThreadContext.captureThreadContext(_void -> {
            Collection annotations = (Collection)StreamEx.of((Collection)futures).map(future -> future.getNow(ContainerUtil.emptyList())).nonNull().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            this.appendGlobalErrors(process, config, annotations, file);
            List<JSAnnotationError> list2 = new ArrayList<JSAnnotationError>(annotations);
            list2 = this.postprocessErrors(psiFile2, list2);
            if (TypeScriptServerServiceImpl.checkState(process) && !this.isShowProjectErrors()) {
                this.updateErrorsForCurrentSelectedEditor(file, list2);
            }
            return list2;
        }));
        if (projectErrors) {
            ArrayList<JSAnnotationError> force = new ArrayList<JSAnnotationError>();
            this.appendGlobalErrors(process, config, force, file);
            String owner = config != null ? TypeScriptCompilerConfigUtil.normalizeNameAndPath(config.getConfigFile()) : path2;
            process.getServerState().forceProjectOwner(owner, force);
            TypeScriptServerServiceImpl.queueProjectErrorsTask(process, new TypeScriptGetProjectErrCommand(path2));
        } else {
            process.getServerState().forceProjectOwner(null, Collections.emptyList());
        }
        return result3;
    }

    protected boolean isShowProjectErrors() {
        return this.mySettings.isShowAllProjectErrors() && (ApplicationManager.getApplication().isUnitTestMode() || Boolean.TRUE.equals(this.myProject.getUserData(TypeScriptServiceProjectErrors.TOOL_WINDOW_IS_SHOWN)) || TypeScriptCompilerSettings.isTypeScriptToolWindowEnable());
    }

    private static int getGeterrDelay(PsiFile psiFile2, VirtualFile file) {
        int base = Registry.intValue((String)"typescript.service.geterr.delayMs");
        Document document2 = FileDocumentManager.getInstance().getDocument(file);
        if (document2 == null) {
            return base;
        }
        int additionalDelayPer1000Lines = DialectDetector.isJSX((PsiElement)psiFile2) ? Registry.intValue((String)"typescript.service.geterr.additionalDelayPer1000LinesMs.jsx") : Registry.intValue((String)"typescript.service.geterr.additionalDelayPer1000LinesMs");
        return (int)Math.min((long)Registry.intValue((String)"typescript.service.geterr.maxDelayMs"), (long)base + (long)document2.getLineCount() * (long)additionalDelayPer1000Lines / 1000L);
    }

    @NotNull
    protected List<JSAnnotationError> postprocessErrors(@NotNull PsiFile file, @NotNull List<JSAnnotationError> list2) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(80);
        }
        if (list2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(81);
        }
        List<JSAnnotationError> list3 = list2;
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(82);
        }
        return list3;
    }

    @NotNull
    protected @Unmodifiable List<JSAnnotationError> parseGetErrorResult(@NotNull JSLanguageServiceAnswer answer, String path2) {
        JsonObject element;
        JsonElement bodyProperty;
        if (answer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(83);
        }
        if ((bodyProperty = (element = answer.getElement()).get(BODY_FIELD)) == null) {
            List<JSAnnotationError> list2 = this.processInternalError(element, path2);
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(84);
            }
            return list2;
        }
        if (bodyProperty.isJsonArray()) {
            return TypeScriptServerServiceImpl.parseDiagnosticsForFile(path2, (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(bodyProperty, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class), this.myProject, this.getLanguageServiceInfo());
        }
        return TypeScriptServerServiceImpl.parseAnnotationResult(this.getGson(), bodyProperty, this.myProject, this.getLanguageServiceInfo());
    }

    private LanguageServiceInfo getLanguageServiceInfo() {
        TypeScriptServerState state = this.getServerStateIfStarted();
        return state != null ? state.getLanguageServiceInfo() : null;
    }

    @NotNull
    protected @Unmodifiable List<JSAnnotationError> processInternalError(@NotNull JsonObject element, @NotNull String path2) {
        if (element == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(85);
        }
        if (path2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(86);
        }
        JsonElement successElement = element.get("success");
        JsonElement messageElement = element.get("message");
        if (successElement != null && !successElement.getAsBoolean() && messageElement != null) {
            String errorMessage = messageElement.getAsString();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Service internal error: " + errorMessage);
            } else {
                JSLanguageServiceQueue.Holder.LOGGER.warn("Service internal error: " + errorMessage);
            }
            List<JSAnnotationError> list2 = Collections.singletonList(new TypeScriptLanguageServiceAnnotationResult(errorMessage, path2));
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(87);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(88);
        }
        return list3;
    }

    private void updateImpl(@NotNull JSLanguageServiceUpdateContext context2) {
        if (context2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(89);
        }
        TypeScriptLanguageServiceUpdateCommand command = this.getUpdateFilesCommand(context2);
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)serviceObject -> {
            if (!this.isEnabled()) {
                return;
            }
            List<VirtualFile> files2 = TypeScriptServerServiceImpl.getFilesToUpdateFromServiceObject(serviceObject);
            if (!files2.isEmpty() && this.isReCompileOnChanges()) {
                this.addToCompileQueueWithUpdate(files2);
            }
        }));
    }

    @NotNull
    private static List<VirtualFile> getFilesToUpdateFromServiceObject(@NotNull JSLanguageServiceObject object) {
        if (object == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(90);
        }
        if (object instanceof TypeScriptFileObject) {
            LocalFilePath file = ((TypeScriptFileObject)object).file;
            if (file != null) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)LocalFileSystem.getInstance().findFileByPath(file.getPath()));
                if (list2 == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(91);
                }
                return list2;
            }
        } else if (object instanceof TypeScriptCommandSetRequest) {
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            ((TypeScriptCommandSetRequest)object).nestedRequests.forEach((obj, command) -> result2.addAll(TypeScriptServerServiceImpl.getFilesToUpdateFromServiceObject(obj)));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(92);
            }
            return arrayList;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(93);
        }
        return list3;
    }

    @NotNull
    protected TypeScriptLanguageServiceUpdateCommand getUpdateFilesCommand(@NotNull JSLanguageServiceUpdateContext context2) {
        if (context2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(94);
        }
        HashMap<VirtualFile, Long> timestamps = new HashMap<VirtualFile, Long>(context2.getTimestamps());
        HashMap<VirtualFile, Document> contents = new HashMap<VirtualFile, Document>();
        contents.putAll(context2.getOpenContents());
        contents.putAll(context2.getUnsavedContents());
        return new TypeScriptLanguageServiceUpdateCommand(timestamps, contents, context2.getFilesOpenBySideEffect());
    }

    @NotNull
    private GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = TypeScriptCompilerConfigUtil.getCompileScope(this.myProject);
        if (globalSearchScope == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(95);
        }
        return globalSearchScope;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file, @NotNull String path2) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(96);
        }
        if (path2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(97);
        }
        String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, file);
        SyntacticDiagnosticsSyncRequest syntactic = new SyntacticDiagnosticsSyncRequest(path2, projectFileName);
        SemanticDiagnosticsSyncRequest semantic = new SemanticDiagnosticsSyncRequest(path2, projectFileName);
        SuggestionDiagnosticsSyncRequest suggestion = new SuggestionDiagnosticsSyncRequest(path2, projectFileName);
        List<JSLanguageServiceCacheableCommand> list2 = List.of(semantic, syntactic, suggestion);
        if (list2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(98);
        }
        return list2;
    }

    protected boolean isMainFileContext() {
        return TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    private static @Unmodifiable @NotNull List<JSAnnotationError> parseAnnotationResult(@NotNull Gson gson, @NotNull JsonElement bodyProperty, Project project, LanguageServiceInfo languageServiceInfo) {
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(99);
        }
        if (bodyProperty == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(100);
        }
        if (!bodyProperty.isJsonObject()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(101);
            }
            return list2;
        }
        TypeScriptDiagnosticsResponse result2 = (TypeScriptDiagnosticsResponse)gson.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        LinkedHashSet<JSAnnotationError> results = new LinkedHashSet<JSAnnotationError>();
        if (result2 == null || result2.infos == null || result2.infos.length == 0) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(102);
            }
            return list3;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body2 : result2.infos) {
            results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(body2.file), body2.diagnostics, project, languageServiceInfo));
        }
        List<JSAnnotationError> list4 = List.copyOf(results);
        if (list4 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(103);
        }
        return list4;
    }

    private static @Unmodifiable @NotNull List<JSAnnotationError> parseCompileResult(@NotNull Gson gson, @NotNull JsonElement bodyProperty, Project project, LanguageServiceInfo languageServiceInfo) {
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(104);
        }
        if (bodyProperty == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(105);
        }
        if (!bodyProperty.isJsonObject()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(106);
            }
            return list2;
        }
        EmitResult result2 = (EmitResult)gson.fromJson(bodyProperty, EmitResult.class);
        LinkedHashSet<JSAnnotationError> results = new LinkedHashSet<JSAnnotationError>();
        if (result2 == null || result2.diagnostics.length == 0) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(107);
            }
            return list3;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body2 : result2.diagnostics) {
            results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(body2.file), body2.diagnostics, project, languageServiceInfo));
        }
        List<JSAnnotationError> list4 = List.copyOf(results);
        if (list4 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(108);
        }
        return list4;
    }

    @NotNull
    public static @Unmodifiable List<JSAnnotationError> parseDiagnosticsForFile(@Nullable String fileName, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics @Nullable [] diagnostics, Project project, @Nullable LanguageServiceInfo languageServiceInfo) {
        if (diagnostics == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(109);
            }
            return list2;
        }
        List<JSAnnotationError> list3 = List.copyOf(ContainerUtil.map((Object[])diagnostics, diagnostic -> TypeScriptLanguageServiceAnnotationResult.buildAnnotation(project, fileName, diagnostic, languageServiceInfo)));
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(110);
        }
        return list3;
    }

    private void addToCompileQueue(@NotNull Collection<String> fileNames2) {
        if (fileNames2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(111);
        }
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
            String path2 = this.mySettings.getMainFilePath();
            VirtualFile main = null;
            if (path2 != null) {
                main = LocalFileSystem.getInstance().findFileByPath(path2);
            }
            if (main != null) {
                this.queueCompileTask(main);
            }
            return;
        }
        StreamEx.of(fileNames2).map(el -> LocalFileSystem.getInstance().findFileByPath(el)).nonNull().forEach(this::queueCompileTask);
    }

    private boolean isReCompileOnChanges() {
        return this.mySettings.isRecompileOnChanges();
    }

    private static void queueProjectErrorsTask(@NotNull TypeScriptLanguageServiceQueueImpl process, @NotNull JSLanguageServiceCommand command) {
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(112);
        }
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(113);
        }
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        process.executeNoBlocking(command, null);
    }

    private void queueCompileTask(final @NotNull VirtualFile path2) {
        if (path2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(114);
        }
        if (!(this.getScope().contains(path2) && TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)path2) && path2.isValid())) {
            return;
        }
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addUpdate(new Update(path2.getPath()){

                public void run() {
                    if (!path2.isValid()) {
                        return;
                    }
                    ReadAction.run(() -> TypeScriptServerServiceImpl.this.compileFile(path2, false));
                }
            });
        }
    }

    private void setMacroParamsIfNeeded(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path2) {
        String outDir;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(115);
        }
        if (path2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(116);
        }
        if (this.mySettings.useDeprecatedSettings() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info2 = JSHighlightingInfoBuilder.getModuleInfo(this.myProject, path2);
            args.contentRootForMacro = LocalFilePath.create((String)info2.first);
            args.sourceRootForMacro = LocalFilePath.create((String)info2.second);
        }
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(117);
        }
        return (String)ReadAction.compute(() -> TypeScriptCompilerConfigUtil.getConfigIdForFile(this.myProject, file));
    }

    private void appendGlobalErrors(@NotNull TypeScriptLanguageServiceQueueImpl process, @Nullable TypeScriptConfig config, @NotNull Collection<JSAnnotationError> results, @NotNull VirtualFile file) {
        String ConfigPath;
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(118);
        }
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(119);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(120);
        }
        if (this.isMainFileContext()) {
            VirtualFile mainFile = this.getMainFile();
            if (mainFile != null) {
                ReadAction.run(() -> {
                    if (DumbService.isDumb((Project)this.myProject)) {
                        return;
                    }
                    JSImportGraph graph = new JSImportGraph(TypeScriptFileImportsFactory.createFileImports(this.myProject, mainFile));
                    if (!graph.containsFile(file)) {
                        results.add(new TypeScriptLanguageServiceAnnotationResult(JavaScriptBundle.message("typescript.service.no.main.reference", new Object[0]), TypeScriptCompilerConfigUtil.normalizeNameAndPath(file)));
                    }
                });
            }
            return;
        }
        if (config == null && !this.skipConfigNotFoundError(file)) {
            results.add(new TypeScriptLanguageServiceAnnotationResult(JavaScriptBundle.message("typescript.service.no.config", new Object[0]), TypeScriptCompilerConfigUtil.normalizeNameAndPath(file)));
        }
        if (config == null) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        JSLanguageServiceAnswer configErrors = serverState.getConfigDiagnostics(ConfigPath = config.getConfigFile().getPath());
        if (configErrors == null) {
            return;
        }
        JsonObject body2 = configErrors.getElement().get(BODY_FIELD).getAsJsonObject();
        JsonElement diags = body2.get(DIAGNOSTICS_FIELD);
        if (diags == null) {
            return;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics = (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(diags, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class);
        results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(FileUtil.toSystemDependentName((String)ConfigPath), diagnostics, this.myProject, this.getLanguageServiceInfo()));
    }

    @Nullable
    private VirtualFile getMainFile() {
        String mainPath = this.mySettings.getMainFilePath();
        return StringUtil.isEmpty((String)mainPath) ? null : LocalFileSystem.getInstance().findFileByPath(mainPath);
    }

    protected boolean skipConfigNotFoundError(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(121);
        }
        return !StringUtil.isEmpty((String)this.mySettings.getDefaultServiceOptions()) || this.mySettings.useDeprecatedSettings() || this.mySettings.useMainFile() || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file);
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file, @NotNull List<JSAnnotationError> results) {
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(122);
        }
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(123);
        }
        this.getReporter().logCurrentErrors(file, results);
    }

    protected static boolean checkState(@Nullable JSLanguageServiceQueue process) {
        if (process == null) {
            return false;
        }
        return process.isValid();
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(124);
        }
        if (prevValue != this.getCanStartProcessState()) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors(JSLanguageServiceAnnotationResult.buildError(JavaScriptBundle.message("javascript.service.node.error", new Object[0])), this.mySettings.isRecompileOnChanges() || this.mySettings.useServiceForProjectsWithoutConfig());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    protected boolean checkServiceQueueAliveUnderLock(@NotNull JSLanguageServiceExecutor serviceQueue) {
        if (serviceQueue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(125);
        }
        if (!super.checkServiceQueueAliveUnderLock(serviceQueue)) {
            return false;
        }
        TypeScriptServerState serverState = ((TypeScriptLanguageServiceQueueImpl)serviceQueue).getServerState();
        return serverState.isServiceValid();
    }

    @Override
    @NotNull
    public TypeScriptService.CompletionMergeStrategy getCompletionMergeStrategy(@NotNull CompletionParameters parameters, @NotNull PsiFile file, @NotNull PsiElement context2) {
        if (parameters == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(126);
        }
        if (file == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(127);
        }
        if (context2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(128);
        }
        TypeScriptService.CompletionMergeStrategy completionMergeStrategy = this.checkCanUseService() ? TypeScriptLanguageServiceUtil.getCompletionMergeStrategy(parameters, file, context2) : TypeScriptService.CompletionMergeStrategy.NON;
        if (completionMergeStrategy == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(129);
        }
        return completionMergeStrategy;
    }

    @Override
    protected boolean canUseServiceForNavigation(@NotNull PsiElement place) {
        Object[] reference;
        if (place == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(130);
        }
        if (!super.canUseServiceForNavigation(place)) {
            return false;
        }
        if (place instanceof LeafElement) {
            place = place.getParent();
        }
        if (place instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)place).multiResolve(false);
            return results.length == 0 || JSResolveResult.isTooManyCandidatesResult(results);
        }
        if (place instanceof ES6FromClause) {
            return ((ES6FromClause)place).resolveReferencedElements().isEmpty();
        }
        if (place instanceof XmlAttribute && DialectDetector.isJSX(place) && (reference = place.getReference()) != null && reference.resolve() == null) {
            return true;
        }
        if (place instanceof JSProperty) {
            reference = place.getReferences();
            if (reference.length == 0) {
                return true;
            }
            @NotNull PsiElement finalPlace = place;
            return ContainerUtil.or((Object[])reference, ref -> {
                PsiElement resolve2 = ref.resolve();
                return resolve2 != null && resolve2 != finalPlace;
            });
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresReadLock
    @NotNull
    public JSLanguageServiceUpdateContext createUpdateContext(@Nullable VirtualFile virtualFile) {
        TypeScriptConfig config;
        void contextFile;
        ThreadingAssertions.softAssertReadAccess();
        Predicate<VirtualFile> condition = this::isAcceptable;
        if (contextFile != null && (config = TypeScriptConfigUtil.getConfigForFile(this.myProject, (VirtualFile)contextFile)) != null && config.resolveJsonModule()) {
            JSImportGraph graph = JSConfigGraphCache.getService(this.myProject).getGraph(config);
            condition = el -> StringUtil.endsWith((CharSequence)el.getName(), (CharSequence)".json") && graph.containsFile((VirtualFile)el) || this.isAcceptable((VirtualFile)el);
        }
        JSLanguageServiceUpdateContext jSLanguageServiceUpdateContext = JSHighlightingInfoBuilder.createUpdateContext(this.myProject, condition, (VirtualFile)contextFile);
        if (jSLanguageServiceUpdateContext == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(131);
        }
        return jSLanguageServiceUpdateContext;
    }

    @Override
    @Nullable
    public LanguageServiceWidgetItem createWidgetItem(@Nullable VirtualFile currentFile) {
        return new TypeScriptServiceWidgetItem(this, currentFile, JavaScriptPsiIcons.FileTypes.TypeScriptFile, JavaScriptLanguageIcons.Typescript.TypeScriptStatusBar, TypeScriptConfigurable.class);
    }

    @TestOnly
    public static void preventInitializationInTest(@NotNull Disposable disposable) {
        if (disposable == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(132);
        }
        ourPreventInitializationInTest = true;
        Disposer.register((Disposable)disposable, () -> {
            ourPreventInitializationInTest = false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 18, 22, 23, 24, 25, 40, 41, 43, 46, 47, 52, 53, 58, 61, 62, 76, 82, 84, 87, 88, 91, 92, 93, 95, 98, 101, 102, 103, 106, 107, 108, 109, 110, 129, 131 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 4: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 58: 
            case 61: 
            case 62: 
            case 76: 
            case 82: 
            case 84: 
            case 87: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 12: 
            case 13: 
            case 89: 
            case 94: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 54: 
            case 55: 
            case 68: 
            case 71: 
            case 77: 
            case 80: 
            case 96: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 112: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 21: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typescriptResult";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheData";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servicePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceRef";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCommands";
                break;
            }
            case 56: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 57: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfig";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentToSent";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 86: 
            case 97: 
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 99: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 100: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyProperty";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevValue";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceQueue";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNamesForCompilation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sequenceFuture";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceFixes";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageServiceState";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadyConsumer";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventConsumer";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedCallback";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialOpenCommands";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenCommand";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUrls";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileResultProcessor";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "postprocessErrors";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGetErrorResult";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "processInternalError";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdateFromServiceObject";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotationResult";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCompileResult";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDiagnosticsForFile";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionMergeStrategy";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNonTsFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendCleanCommandToCompiler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processVfsChangesForFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileNamesForCompilation";
                break;
            }
            case 11: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 58: 
            case 61: 
            case 62: 
            case 76: 
            case 82: 
            case 84: 
            case 87: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 129: 
            case 131: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDisabledByContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateForVfsChangedFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compileProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sequenceFuture";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "closeLastEditor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFixes";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFixSet";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isTSCompilerError";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForHighlighting";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationProvider";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageServiceState";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createReadyConsumer";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createProtocol";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sendOpenFakeFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sendUpdateCodeFixesState";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sendInitialOpenState";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createOpenEditorCommand";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createOpenCommand";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sendDefaultOptionProject";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "expandUrls";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addUrl";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addUrls";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLastLineStartOffsetFromText";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getLineCountForText";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedDocumentText";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentText";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "beforeGetErrors";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "updateFilesAndGetErrors";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "postprocessErrors";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "parseGetErrorResult";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processInternalError";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToUpdateFromServiceObject";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesCommand";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotationResult";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "parseCompileResult";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueue";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "queueProjectErrorsTask";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "queueCompileTask";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "setMacroParamsIfNeeded";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "appendGlobalErrors";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "skipConfigNotFoundError";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorsForCurrentSelectedEditor";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "showInterpreterError";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceQueueAliveUnderLock";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionMergeStrategy";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "canUseServiceForNavigation";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "preventInitializationInTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 18, 22, 23, 24, 25, 40, 41, 43, 46, 47, 52, 53, 58, 61, 62, 76, 82, 84, 87, 88, 91, 92, 93, 95, 98, 101, 102, 103, 106, 107, 108, 109, 110, 129, 131 -> new IllegalStateException(string);
        };
    }

    private static class TypeScriptCompileUpdater {
        private TypeScriptCompileUpdater() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

