/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageParser;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesLocalizedProvider;", "", "()V", "myCache", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache;", "getCodeToTemplate", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "", "file", "Ljava/nio/file/Path;", "getTemplates", "", "servicePath", "locale", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "getTemplatesFile", "intellij.javascript.impl"})
public final class DiagnosticTemplatesLocalizedProvider {
    @NotNull
    private final DiagnosticTemplatesMemoryCache myCache = new DiagnosticTemplatesMemoryCache((Function1<? super Path, ? extends Sequence<Pair<Integer, String>>>)((Function1)new Function1<Path, Sequence<? extends Pair<? extends Integer, ? extends String>>>(this){
        final /* synthetic */ DiagnosticTemplatesLocalizedProvider this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        @NotNull
        public final Sequence<Pair<Integer, String>> invoke(@NotNull Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return DiagnosticTemplatesLocalizedProvider.access$getCodeToTemplate(this.this$0, it);
        }
    }));

    @RequiresBackgroundThread
    @NotNull
    public final List<String> getTemplates(@NotNull String servicePath, @NotNull String locale, @NotNull DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        Intrinsics.checkNotNullParameter((Object)servicePath, (String)"servicePath");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)getCriteria, (String)"getCriteria");
        Path file = this.getTemplatesFile(servicePath, locale);
        return file != null ? this.myCache.getTemplates(file, getCriteria) : CollectionsKt.emptyList();
    }

    private final Path getTemplatesFile(String servicePath, String locale) {
        String[] stringArray = new String[]{locale, "diagnosticMessages.generated.json"};
        Path file = Paths.get(servicePath, stringArray);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? file : null;
    }

    private final Sequence<Pair<Integer, String>> getCodeToTemplate(Path file) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Pair<? extends Integer, ? extends String>>, Continuation<? super Unit>, Object>(file, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Path $file;
            {
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                String jsonKey;
                JsonElement jsonVal;
                Iterator<E> iterator;
                SequenceScope $this$sequence;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$sequence = (SequenceScope)this.L$0;
                        JsonElement root = JsonParser.parseReader((Reader)Files.newBufferedReader(this.$file));
                        if (!root.isJsonObject()) {
                            Logger.getInstance(DiagnosticTemplatesEnProvider.class).error("Not json object: " + this.$file);
                            return Unit.INSTANCE;
                        }
                        iterator = root.getAsJsonObject().entrySet().iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        jsonVal = (JsonElement)this.L$3;
                        jsonKey = (String)this.L$2;
                        iterator = (Iterator<E>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator.hasNext()) {
                    block11: {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Intrinsics.checkNotNull((Object)entry);
                        jsonKey = (String)entry.getKey();
                        jsonVal = (JsonElement)entry.getValue();
                        if (jsonVal.isJsonPrimitive() && jsonVal.getAsJsonPrimitive().isString()) {
                            Intrinsics.checkNotNull((Object)jsonKey);
                            int lastIndexOfUnderscore = StringsKt.lastIndexOf$default((CharSequence)jsonKey, (char)'_', (int)0, (boolean)false, (int)6, null);
                            if (lastIndexOfUnderscore != -1) {
                                String codeStr;
                                Intrinsics.checkNotNullExpressionValue((Object)jsonKey.substring(lastIndexOfUnderscore + 1), (String)"substring(...)");
                                int code = Integer.parseInt(codeStr);
                                this.L$0 = $this$sequence;
                                this.L$1 = iterator;
                                this.L$2 = jsonKey;
                                this.L$3 = jsonVal;
                                this.label = 1;
                                object2 = $this$sequence.yield((Object)TuplesKt.to((Object)Boxing.boxInt((int)code), (Object)jsonVal.getAsString()), (Continuation)this);
                                if (object2 != object3) continue;
                                return object3;
                            }
                        }
                        break block11;
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Logger.getInstance(DiagnosticMessageParser.INSTANCE.getClass()).error("Unexpected json key=" + jsonKey + ", value=" + jsonVal);
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Pair<Integer, String>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ Sequence access$getCodeToTemplate(DiagnosticTemplatesLocalizedProvider $this, Path file) {
        return $this.getCodeToTemplate(file);
    }
}

