/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.template.postfix.JSIntroduceVarPostfixTemplate;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructPostfixTemplate
extends JSIntroduceVarPostfixTemplate {
    private static final String TEMP_VAR_NAME = "_tmp_webstorm_";

    public JSDestructPostfixTemplate() {
        super("destruct", "let {} = expr", JSPostfixTemplateUtils.selectorWithFeature(JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)((Condition)JSDestructPostfixTemplate::canDestruct)), JSLanguageFeature.LET_DEFINITIONS, null));
    }

    private static boolean canDestruct(PsiElement element) {
        if (!(element instanceof JSExpression)) {
            return false;
        }
        if (!(element.getParent() instanceof JSExpressionStatement)) {
            return false;
        }
        if (element instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)element)) {
            return false;
        }
        JSType jsType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive((JSExpression)element);
        if (jsType instanceof JSArrayType) {
            return true;
        }
        return JSGenerateDestructuringPatternIntention.isApplicableType(jsType, false);
    }

    @Override
    @NotNull
    protected Settings.IntroducedVarType getIntroduceVarType() {
        Settings.IntroducedVarType introducedVarType = Settings.IntroducedVarType.LET;
        if (introducedVarType == null) {
            JSDestructPostfixTemplate.$$$reportNull$$$0(0);
        }
        return introducedVarType;
    }

    @Override
    @NotNull
    protected JSNoBalloonIntroduceVariableHandler createHandler(PsiElement context2, Editor editor) {
        return this.doCreateHandler(context2, editor);
    }

    @NotNull
    private JSNoBalloonIntroduceVariableHandler doCreateHandler(PsiElement context2, Editor editor) {
        final PsiFile file = context2.getContainingFile();
        return new JSNoBalloonIntroduceVariableHandler(){
            int markerOffset = -1;

            @Override
            protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope2) {
                return JSDestructPostfixTemplate.this.getIntroduceVarType();
            }

            @Override
            @NotNull
            protected Expression createCustomTemplateExpression(PsiElement selectedElement) {
                return new ConstantNode(JSDestructPostfixTemplate.TEMP_VAR_NAME);
            }

            @Override
            protected void afterIntroduce(boolean isInPlace, JSElement scope2, Editor editor) {
                PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
                JSVariable variable = JSDestructPostfixTemplate.findVariable(Objects.requireNonNull(element));
                JSType jsType = JSResolveUtil.getElementJSType((PsiElement)variable);
                this.markerOffset = StringUtil.indexOf((CharSequence)editor.getDocument().getCharsSequence(), (CharSequence)JSDestructPostfixTemplate.TEMP_VAR_NAME);
                editor.getDocument().replaceString(this.markerOffset, this.markerOffset + JSDestructPostfixTemplate.TEMP_VAR_NAME.length(), (CharSequence)(jsType instanceof JSTupleType || jsType instanceof JSArrayType ? "[]" : "{}"));
                AutoPopupController.getInstance((Project)Objects.requireNonNull(editor.getProject())).scheduleAutoPopup(editor);
            }

            @Override
            protected int getCustomFinalOffset() {
                return this.markerOffset + 1;
            }
        };
    }

    @Override
    protected JSIntroduceVariableHandler getMockHandlerForTestMode(PsiElement context2, Editor editor) {
        return this.doCreateHandler(context2, editor);
    }

    @Nullable
    private static JSVariable findVariable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSDestructPostfixTemplate.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof JSVarStatement) {
            return (JSVariable)ArrayUtil.getFirstElement((Object[])((JSVarStatement)parent).getVariables());
        }
        if (parent instanceof JSVariable) {
            return (JSVariable)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSDestructPostfixTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntroduceVarType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSDestructPostfixTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

