/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public class JSWithIfSurrounder
extends JSStatementSurrounder {
    protected final boolean processingCondition;

    public JSWithIfSurrounder() {
        this(false);
    }

    public JSWithIfSurrounder(boolean processingCondition) {
        this.processingCondition = processingCondition;
    }

    public String getTemplateDescription() {
        return JavaScriptBundle.message(this.processingCondition ? "javascript.surround.with.if.cond" : "javascript.surround.with.if", new Object[0]);
    }

    @Override
    @NonNls
    protected String getStatementTemplate(Project project, PsiElement context2) {
        return this.willWrapExpression() ? this.getStatementTemplateWhenWrappingBody() : this.getStatementTemplateWhenWrappingCondition();
    }

    protected String getStatementTemplateWhenWrappingBody() {
        return "if(a) { }";
    }

    protected String getStatementTemplateWhenWrappingCondition() {
        return "if() { a }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSIfStatement stmt = (JSIfStatement)statementNode.getPsi();
        return this.willWrapExpression() ? ((JSStatement)stmt.getThenBranch()).getNode().getLastChildNode() : stmt.getNode().findChildByType(JSTokenTypes.RPAR);
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        int offset;
        JSIfStatement stmt = (JSIfStatement)statementNode.getPsi();
        if (this.willWrapExpression()) {
            ASTNode conditionNode = stmt.getCondition().getNode();
            offset = conditionNode.getStartOffset();
            stmt.getNode().removeChild(conditionNode);
        } else {
            Document document2 = stmt.getContainingFile().getViewProvider().getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)stmt.getContainingFile().getProject());
            assert (document2 != null);
            documentManager.doPostponedOperationsAndUnblockDocument(document2);
            PsiElement element = PsiTreeUtil.getChildOfType((PsiElement)stmt.getThenBranch(), JSExpressionStatement.class);
            assert (element != null);
            offset = element.getTextOffset();
            ASTNode astNode = element.getNode();
            astNode.getTreeParent().removeChild(astNode);
        }
        return new TextRange(offset, offset);
    }

    @Override
    protected ASTNode cleanup(ASTNode node) {
        if (!this.willWrapExpression()) {
            ASTNode parent;
            ASTNode errorNode = node.findChildByType(TokenType.ERROR_ELEMENT);
            if (errorNode != null) {
                node.removeChild(errorNode);
            }
            if ((parent = node.getTreeParent()).getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
                ASTNode grandParent = parent.getTreeParent();
                ASTNode newNode = node.copyElement();
                grandParent.replaceChild(parent, newNode);
                return newNode;
            }
        }
        return node;
    }

    @Override
    protected boolean willWrapExpression() {
        return !this.processingCondition;
    }
}

