/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageServiceAnnotationProvider {
    @NonNls
    public static final String JS_SERVICE_SOURCE = "JS Language Service Source";

    static void updateWolfTheProblemSolver(@NotNull PsiFile file, @NotNull String name, @NotNull List<? extends HighlightInfo> holder) {
        if (file == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(2);
        }
        Project project = file.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        VirtualFile virtualFile = file.getVirtualFile();
        if (document2 == null) {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)JSLanguageServiceAnnotationProvider.getServiceName(name));
            return;
        }
        boolean hasErrorResults = ContainerUtil.exists(holder, info2 -> info2.getSeverity() == HighlightSeverity.ERROR);
        if (hasErrorResults) {
            WolfTheProblemSolver.getInstance((Project)project).reportProblemsFromExternalSource(virtualFile, (Object)JSLanguageServiceAnnotationProvider.getServiceName(name));
        } else {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)JSLanguageServiceAnnotationProvider.getServiceName(name));
        }
    }

    @NotNull
    private static String getServiceName(@NotNull String name) {
        if (name == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(3);
        }
        String string = "JS Language Service Source " + name;
        if (string == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    static List<HighlightInfo> convertToHighlightingInfos(@NotNull PsiFile file, @Nullable List<? extends JSAnnotationError> annotationResult, @NotNull JSLanguageService languageService) {
        VirtualFile virtualFile;
        if (file == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(5);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(6);
        }
        if ((virtualFile = file.getVirtualFile()) == null || !virtualFile.isInLocalFileSystem()) {
            List<HighlightInfo> list2 = List.of();
            if (list2 == null) {
                JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(7);
            }
            return list2;
        }
        Project project = file.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document2 == null) {
            List<HighlightInfo> list3 = List.of();
            if (list3 == null) {
                JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(8);
            }
            return list3;
        }
        String simplePath = virtualFile.getPath();
        String canonicalPath = virtualFile.getCanonicalPath();
        VirtualFileSystem system = virtualFile.getFileSystem();
        Path path2 = system.getNioPath(virtualFile);
        if (path2 == null) {
            List<HighlightInfo> list4 = List.of();
            if (list4 == null) {
                JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(9);
            }
            return list4;
        }
        ArrayList<HighlightInfo> holder = new ArrayList<HighlightInfo>(annotationResult.size());
        String ioFilePath = LocalFilePath.asLocalFilePath(path2);
        for (JSAnnotationError jSAnnotationError : annotationResult) {
            String annotationFilePath = jSAnnotationError.getAbsoluteFilePath();
            if (StringUtil.isEmpty((String)annotationFilePath) || !FileUtil.pathsEqual((String)annotationFilePath, (String)simplePath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)canonicalPath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)ioFilePath)) continue;
            try {
                HighlightInfo annotation;
                JSLanguageServiceUtil.PsiElementInfo info2 = JSLanguageServiceUtil.getElementInfo(file, document2, jSAnnotationError);
                if (info2 == null) continue;
                PsiElement element = info2.getElement();
                TextRange range = info2.getRange();
                if (element == null && range == null || (annotation = JSLanguageServiceAnnotationProvider.registerAnnotation(file, jSAnnotationError, element, range, languageService, document2)) == null) continue;
                holder.add(annotation);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<HighlightInfo> arrayList = holder;
        if (arrayList == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    private static HighlightInfo registerAnnotation(@NotNull PsiFile file, @NotNull JSAnnotationError result2, @Nullable PsiElement element, @Nullable TextRange range, @NotNull JSLanguageService languageService, @NotNull Document document2) {
        ProblemHighlightType type2;
        if (file == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(12);
        }
        if (languageService == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(13);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(14);
        }
        assert (element != null || range != null);
        String message = result2.getDescription();
        if (range == null) {
            range = element.getTextRange();
        }
        if ((type2 = result2.getHighlightType()) == null) {
            type2 = result2.getSeverity() == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)result2.getSeverity());
        }
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type2, (HighlightSeverity)result2.getSeverity(), (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
        String tooltip = result2.getTooltipText();
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(range).description(message);
        if (tooltip == null) {
            tooltip = message;
        }
        builder2.escapedToolTip(tooltip);
        if (JSLanguageServiceAnnotationProvider.isAnnotationAtEndOfLine((Segment)range, document2)) {
            builder2.endOfLine();
        }
        Collection<IntentionAction> fixes = languageService.getServiceFixes(file, element, result2);
        fixes.forEach(a -> builder2.registerFix(a, null, null, null, null));
        return builder2.create();
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Segment annotation, @NotNull Document document2) {
        if (annotation == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(15);
        }
        if (document2 == null) {
            JSLanguageServiceAnnotationProvider.$$$reportNull$$$0(16);
        }
        int startOffset = annotation.getStartOffset();
        int endOffset = annotation.getEndOffset();
        if (startOffset >= document2.getTextLength()) {
            return true;
        }
        return document2.getImmutableCharSequence().charAt(startOffset) == '\n' && (startOffset == endOffset || endOffset == startOffset + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHighlightingInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateWolfTheProblemSolver";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceName";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToHighlightingInfos";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationAtEndOfLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

