/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatementList;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionPopup;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceConstantHandler
extends JSBaseIntroduceHandler<JSSourceElement, BaseIntroduceSettings, JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider>>
implements ContextAwareActionHandler {
    private static final JSIntroduceTargetChooser<JSElement> DEFAULT_SCOPE_CHOOSER = (editor, elements, callback, __) -> callback.accept(ContainerUtil.getLastItem((List)elements));
    private final JSIntroduceTargetChooser<JSElement> myScopeChooser;
    private final JSIntroduceFieldHandler myFieldHandler;
    private final JSNoBalloonIntroduceVariableHandler myVarHandler;

    public JSIntroduceConstantHandler() {
        this(ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_SCOPE_CHOOSER : (editor, elements, callback, __) -> JSIntroduceConstantHandler.showScopeChooser(editor, elements, callback));
    }

    public JSIntroduceConstantHandler(JSIntroduceTargetChooser<JSElement> chooser) {
        this.myScopeChooser = chooser;
        this.myFieldHandler = new JSIntroduceFieldHandler(true){

            @Override
            @Nullable
            @NonNls
            public String getRefactoringId() {
                return JSIntroduceConstantHandler.this.getRefactoringId();
            }
        };
        this.myVarHandler = new JSNoBalloonIntroduceVariableHandler(){

            @Override
            @Nullable
            @NonNls
            public String getRefactoringId() {
                return JSIntroduceConstantHandler.this.getRefactoringId();
            }

            @Override
            protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope2) {
                return Settings.IntroducedVarType.CONST;
            }

            @Override
            protected JSSourceElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, boolean replaceAllOccurrences) {
                return JSIntroduceConstantHandler.this.findAnchor((JSBaseIntroduceHandler.BaseIntroduceContext)context2, replaceAllOccurrences);
            }
        };
    }

    @Override
    @Nullable
    @NonNls
    public String getRefactoringId() {
        return "refactoring.javascript.introduceConstant";
    }

    @Override
    protected boolean canInplaceIntroduceForSubexpression() {
        return true;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        if (file instanceof HtmlCompatibleFile) {
            return true;
        }
        return JSIntroduceConstantHandler.isSupportedLanguageLevel((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), (Object)file));
    }

    private static boolean isSupportedLanguageLevel(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && (dialect.isTypeScript || dialect.isFlow || dialect.isECMA6);
    }

    private static void showScopeChooser(Editor editor, List<? extends JSElement> elements, Consumer<? super JSElement> callback) {
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            callback.accept(elements.get(0));
            return;
        }
        List scopeList = ContainerUtil.map(elements, e -> {
            String presentation = JSIntroduceConstantHandler.getScopePresentation(e);
            return new JSScopeSelectionUI.ScopePresentation<IntroductionScope>(new IntroductionScope((JSElement)e, presentation), JSIntroduceConstantHandler.getScopePresentation(e), JSIntroduceConstantHandler.getScopePresentableOffset(e), e instanceof JSFile || ES6PsiUtil.isEmbeddedBlock((PsiElement)e) ? 0 : 1);
        });
        new JSScopeSelectionPopup<IntroductionScope>(editor, 3).show((IntroductionScope)((JSScopeSelectionUI.ScopePresentation)scopeList.get(0)).getScope(), scopeList, scope2 -> callback.accept(scope2.parent));
    }

    private static int getScopePresentableOffset(@NotNull JSElement e) {
        PsiElement itemAtOffset;
        Editor editor;
        if (e == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(4);
        }
        int currentOffset = (editor = PsiEditorUtil.findEditor((PsiElement)e)) == null ? -1 : editor.getCaretModel().getOffset();
        PsiFile file = e.getContainingFile();
        PsiElement psiElement = itemAtOffset = file == null || currentOffset == -1 ? null : file.findElementAt(currentOffset);
        if (e instanceof JSClass) {
            PsiElement memberForOffset = JSIntroduceConstantHandler.getMemberForTooltip(itemAtOffset, (PsiElement)e, ((JSClass)e).getMembers());
            return memberForOffset.getTextRange().getEndOffset();
        }
        if (e instanceof JSStatementList) {
            PsiElement memberForOffset = JSIntroduceConstantHandler.getMemberForTooltip(itemAtOffset, (PsiElement)e, Arrays.asList(((JSStatementList)((Object)e)).getStatementListItems()));
            return memberForOffset.getTextRange().getStartOffset();
        }
        if (e instanceof JSFunction) {
            JSBlockStatement block = ((JSFunction)e).getBlock();
            if (block != null) {
                return JSIntroduceConstantHandler.getScopePresentableOffset(block);
            }
        } else if (e instanceof JSEmbeddedContent) {
            PsiElement memberForOffset = JSIntroduceConstantHandler.getMemberForTooltip(itemAtOffset, (PsiElement)e, Arrays.asList(e.getChildren()));
            return memberForOffset.getTextRange().getStartOffset();
        }
        return e.getTextOffset();
    }

    private static PsiElement getMemberForTooltip(PsiElement itemAtOffset, PsiElement memberForOffset, Iterable<? extends PsiElement> members) {
        PsiElement child;
        if (itemAtOffset != null) {
            boolean first = true;
            for (PsiElement psiElement : members) {
                if (PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)itemAtOffset, (boolean)false)) {
                    if (first) break;
                    memberForOffset = psiElement;
                    break;
                }
                first = false;
            }
        }
        if ((child = memberForOffset.getFirstChild()) instanceof PsiWhiteSpace) {
            child = PsiTreeUtil.skipWhitespacesForward((PsiElement)child);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)child, (Object)memberForOffset);
    }

    @Override
    protected JSBaseInplaceIntroducer<BaseIntroduceSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, JSElement scope2, Editor editor, Project project, JSExpression[] occurrences, Runnable callback) {
        if (scope2 instanceof JSClass) {
            return this.myFieldHandler.createInplaceIntroducer((JSBaseIntroduceHandler.BaseIntroduceContext)context2, scope2, editor, project, occurrences, callback);
        }
        return this.myVarHandler.createInplaceIntroducer(context2, scope2, editor, project, occurrences, callback);
    }

    @Override
    protected boolean isInplaceIntroduce(Editor editor, JSElement scope2, PsiFile file) {
        return !(scope2 instanceof JSClass) && super.isInplaceIntroduce(editor, scope2, file);
    }

    @Override
    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor, @NotNull NullableConsumer<? super JSElement> callback) {
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        if (expressionDescriptor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        JSIntroduceConstantHandler.chooseElement(this.myScopeChooser, editor, JSIntroduceConstantHandler.getScopeCandidates((JSExpression)expressionDescriptor.first), arg_0 -> callback.consume(arg_0), JSIntroduceConstantHandler::getScopePresentation);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> baseIntroduceContext, JSSourceElement anchor) {
        return baseIntroduceContext.scope instanceof JSClass ? this.myFieldHandler.getDeclText(baseIntroduceContext, anchor) : this.myVarHandler.getDeclText(baseIntroduceContext, anchor);
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, Project project, @Nullable JSLanguageDialect languageDialect, JSSourceElement anchorStatement, Editor editor) throws IncorrectOperationException {
        return context2.scope instanceof JSClass ? this.myFieldHandler.prepareDeclaration(varDeclText, context2, project, languageDialect, anchorStatement, editor) : this.myVarHandler.prepareDeclaration(varDeclText, context2, project, languageDialect, anchorStatement, editor);
    }

    private static boolean isAwaitOrYield(PsiElement element) {
        return element instanceof JSPrefixExpression && ((JSPrefixExpression)element).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD || element instanceof JSYieldExpression;
    }

    @NotNull
    private static List<JSElement> getScopeCandidates(JSExpression first) {
        JSElement exportScope;
        JSElement grandParent;
        SmartList candidates = new SmartList();
        JSElement parentElement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)first, (Class[])new Class[]{JSClass.class, JSFunction.class});
        if (parentElement != null && JSIntroduceConstantHandler.checkLocalRefs(first, parentElement)) {
            candidates.add(parentElement);
        }
        if (parentElement instanceof JSFunction && (((JSFunction)parentElement).isAsync() || ((JSFunction)parentElement).isGenerator()) && ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)first).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSIntroduceConstantHandler::isAwaitOrYield)).traverse().isNotEmpty()) {
            SmartList smartList = candidates;
            if (smartList == null) {
                JSIntroduceConstantHandler.$$$reportNull$$$0(8);
            }
            return smartList;
        }
        if ((parentElement == null || parentElement instanceof JSFunction) && (grandParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)parentElement, (Object)first)), JSClass.class)) != null && JSIntroduceConstantHandler.checkLocalRefs(first, grandParent)) {
            candidates.add(grandParent);
        }
        if ((candidates.isEmpty() || parentElement instanceof JSClass) && (grandParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)parentElement, (Object)first)), JSFunction.class)) != null && JSIntroduceConstantHandler.checkLocalRefs(first, grandParent)) {
            candidates.add(grandParent);
        }
        if ((exportScope = ES6PsiUtil.getExportScope((PsiElement)first)) != null && JSIntroduceConstantHandler.checkLocalRefs(first, exportScope)) {
            candidates.add(exportScope);
        }
        SmartList smartList = candidates;
        if (smartList == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private static boolean checkLocalRefs(JSExpression first, JSElement parentElement) {
        if (parentElement instanceof JSClass && !DialectDetector.isTypeScript((PsiElement)parentElement)) {
            return false;
        }
        return SyntaxTraverser.psiTraverser((PsiElement)first).filter(JSReferenceExpression.class).filter(referenceExpression -> JSIntroduceConstantHandler.isLocalReference(referenceExpression, parentElement)).isEmpty();
    }

    private static boolean isLocalReference(JSReferenceExpression referenceExpression, JSElement parentElement) {
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier instanceof JSThisExpression) {
            PsiElement element = ((JSThisExpression)qualifier).resolve();
            return element != null && PsiTreeUtil.isAncestor((PsiElement)parentElement, (PsiElement)element, (boolean)true);
        }
        PsiElement resolve2 = referenceExpression.resolve();
        if (resolve2 == null) {
            return false;
        }
        SearchScope scope2 = resolve2.getUseScope();
        if (!(scope2 instanceof LocalSearchScope)) {
            return false;
        }
        for (PsiElement element : ((LocalSearchScope)scope2).getScope()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)parentElement, (PsiElement)element, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.ListItem
    private static String getScopePresentation(@NotNull JSElement element) {
        if (element == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(10);
        }
        if (element instanceof JSClass) {
            return JavaScriptBundle.message("list.item.class.field", new Object[0]);
        }
        if (element instanceof JSFile || element instanceof JSEmbeddedContent) {
            return JavaScriptBundle.message("list.item.global.or.module.constant", new Object[0]);
        }
        return JavaScriptBundle.message("list.item.local.constant", new Object[0]);
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = JavaScriptBundle.message("javascript.introduce.constant.title", new Object[0]);
        if (string == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.constant.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.constant.error.expression.has.void.type";
    }

    @Override
    protected InplaceSettings<BaseIntroduceSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope2, OccurrencesChooser.ReplaceChoice choice) {
        if (scope2 instanceof JSClass) {
            return this.myFieldHandler.getInplaceSettings(expr, occurrences, scope2, choice);
        }
        return this.myVarHandler.getInplaceSettings(expr, occurrences, scope2, choice);
    }

    @Override
    protected JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider> createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope2) {
        if (scope2 instanceof JSClass) {
            return this.myFieldHandler.createDialog(project, expression, occurrences, scope2);
        }
        return this.myVarHandler.createDialog(project, expression, occurrences, scope2);
    }

    @Override
    public JSExpression createRefExpr(PsiElement context2, BaseIntroduceSettings settings2, PsiElement scope2, JSLanguageDialect languageDialect) {
        return scope2 instanceof JSClass ? this.myFieldHandler.createRefExpr(context2, settings2, scope2, languageDialect) : this.myVarHandler.createRefExpr(context2, settings2, scope2, languageDialect);
    }

    @Override
    protected boolean isSilent() {
        return true;
    }

    @Override
    protected void afterIntroduce(boolean isInPlace, JSElement scope2, Editor editor) {
        if (isInPlace) {
            return;
        }
        PsiFile file = scope2.getContainingFile();
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSThisExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return;
        }
        PsiElement resolved = ((JSReferenceExpression)parent).resolve();
        if (!(resolved instanceof JSFieldVariable)) {
            return;
        }
        editor.getCaretModel().moveToOffset(parent.getTextRange().getEndOffset());
        JSRefactoringUtil.suggestSameFileRename(file, editor, (JSFieldVariable)resolved, ((JSFieldVariable)resolved).getName());
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression expression;
        if (file == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(13);
        }
        if (expressionDescriptor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(14);
        }
        if (!JSIntroduceConstantHandler.isSupportedLanguageLevel((PsiElement)(expression = (JSExpression)expressionDescriptor.first))) {
            this.showErrorHint(editor, file, JavaScriptBundle.message("javascript.introduce.constant.in.es5", new Object[0]));
            return false;
        }
        return super.validateSelectedExpression(file, editor, expressionDescriptor);
    }

    @Override
    protected JSSourceElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, boolean replaceAllOccurrences) {
        JSExpression[] jSExpressionArray;
        if (replaceAllOccurrences) {
            jSExpressionArray = context2.occurrences;
        } else {
            JSExpression[] jSExpressionArray2 = new JSExpression[1];
            jSExpressionArray = jSExpressionArray2;
            jSExpressionArray2[0] = (JSExpression)context2.expressionDescriptor.first;
        }
        JSExpression[] allExpressions = jSExpressionArray;
        PsiElement scope2 = context2.scope;
        for (PsiElement child : JSIntroduceConstantHandler.getAnchorChildren(scope2)) {
            if (!(child instanceof JSSourceElement) || !Arrays.stream(allExpressions).allMatch(e -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)e, (boolean)true))) continue;
            return (JSSourceElement)child;
        }
        return (JSSourceElement)super.findAnchor(context2, replaceAllOccurrences);
    }

    private static PsiElement @NotNull [] getAnchorChildren(PsiElement scope2) {
        if (scope2 instanceof JSFunction) {
            JSBlockStatement block = ((JSFunction)scope2).getBlock();
            PsiElement[] psiElementArray = block == null ? PsiElement.EMPTY_ARRAY : block.getChildren();
            if (psiElementArray == null) {
                JSIntroduceConstantHandler.$$$reportNull$$$0(15);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = scope2.getChildren();
        if (psiElementArray == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(16);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceConstantHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceConstantHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedLanguageLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getScopePresentableOffset";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScopePresentation";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 11, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static class IntroductionScope {
        @NotNull
        public final JSElement parent;
        @NlsSafe
        private final String presentation;

        IntroductionScope(@NotNull JSElement parent, @NlsSafe String presentation) {
            if (parent == null) {
                IntroductionScope.$$$reportNull$$$0(0);
            }
            this.parent = parent;
            this.presentation = presentation;
        }

        public String toString() {
            return this.presentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceConstantHandler$IntroductionScope", "<init>"));
        }
    }
}

