/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGeneratorReturnType
extends JSFunctionReturnWrapperType {
    @Nullable
    private final JSType myTypeForYield;
    @Nullable
    private final JSType myReturnType;
    private final boolean myIsAsync;

    public JSGeneratorReturnType(@NotNull JSTypeSource typeSource, @Nullable JSType innerType, @Nullable JSType returnType, @Nullable JSType typeForYield, boolean isAsync) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(0);
        }
        super(typeSource, innerType instanceof JSVoidType ? JSNamedTypeFactory.createNeverType(innerType.getSource()) : innerType);
        this.myTypeForYield = typeForYield;
        this.myIsAsync = isAsync;
        this.myReturnType = returnType;
    }

    public JSGeneratorReturnType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(2);
        }
        super(source, inputStream);
        this.myIsAsync = JSTypeSerializer.readBoolean(inputStream);
        this.myReturnType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myTypeForYield = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myIsAsync, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myReturnType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myTypeForYield, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(4);
        }
        if (newSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(5);
        }
        JSType innerTransformed = JSTypeUtils.transformTypeHierarchySafe(this.myInnerType, childTransform);
        JSType returnTransformed = JSTypeUtils.transformTypeHierarchySafe(this.myReturnType, childTransform);
        JSType yieldTypeTransformed = JSTypeUtils.transformTypeHierarchySafe(this.myTypeForYield, childTransform);
        if (innerTransformed == this.myInnerType && returnTransformed == this.myReturnType && yieldTypeTransformed == this.myTypeForYield) {
            JSGeneratorReturnType jSGeneratorReturnType = this;
            if (jSGeneratorReturnType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(6);
            }
            return jSGeneratorReturnType;
        }
        return new JSGeneratorReturnType(newSource, innerTransformed, returnTransformed, yieldTypeTransformed, this.myIsAsync);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(7);
        }
        return super.isEquivalentToWithSameClass(type2, context2, allowResolve) && JSGeneratorReturnType.areEquivalent(this.myReturnType, ((JSGeneratorReturnType)type2).myReturnType, context2, allowResolve) && JSGeneratorReturnType.areEquivalent(this.myTypeForYield, ((JSGeneratorReturnType)type2).myTypeForYield, context2, allowResolve);
    }

    @Override
    protected JSType createInstance(@NotNull JSTypeSource typeSource, @Nullable JSType innerType) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(8);
        }
        return new JSGeneratorReturnType(typeSource, innerType, this.myReturnType, this.myTypeForYield, this.myIsAsync);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(9);
        }
        if (this.myInnerType != null) {
            this.myInnerType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myTypeForYield != null) {
            this.myTypeForYield.accept(visitor);
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myIsAsync, this.myInnerType, this.myReturnType, this.myTypeForYield);
    }

    @Override
    protected String getPrefix() {
        return "iret";
    }

    @Override
    protected JSType doSubstitute(@Nullable JSType type2, @NotNull JSTypeSource source, JSTypeSubstitutionContext context2) {
        JSType expandedReturn;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(10);
        }
        String typeName = this.getTypeName(source);
        JSType iterableType = JSNamedTypeFactory.createType(typeName, source, JSContext.INSTANCE);
        JSType expandedType = type2 == null ? null : context2.substituteNested(type2);
        JSType jSType = expandedReturn = this.myReturnType == null ? null : context2.substituteNested(this.myReturnType);
        if (typeName.equals("AsyncIterableIterator") || typeName.equals("IterableIterator")) {
            return new JSGenericTypeImpl(source, iterableType, JSGeneratorReturnType.combineObsoleteGeneratorType(source, expandedType, expandedReturn));
        }
        if (expandedType == null) {
            JSType jSType2 = expandedType = source.isTypeScript() ? JSNamedTypeFactory.createNeverType(source) : JSAnyType.get(source);
        }
        if (expandedReturn == null) {
            expandedReturn = JSNamedTypeFactory.createVoidType(source);
        }
        JSType expandedYield = this.expandYieldType(source, context2);
        return new JSGenericTypeImpl(source, iterableType, Arrays.asList(JSTypeUtils.widenLiteralTypes(expandedType), JSTypeUtils.widenLiteralTypes(expandedReturn), expandedYield));
    }

    @NotNull
    private JSType expandYieldType(@NotNull JSTypeSource source, JSTypeSubstitutionContext context2) {
        JSType expandedYield;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(11);
        }
        JSType jSType = this.myTypeForYield == null ? null : (expandedYield = this.myTypeForYield instanceof JSIntersectionType ? JSGeneratorReturnType.filterIntersection(source, (JSIntersectionType)this.myTypeForYield, context2, true) : context2.substituteNested(this.myTypeForYield));
        if (expandedYield == null) {
            expandedYield = JSNamedTypeFactory.createType("unknown", source, JSTypeContext.UNKNOWN);
        }
        if (expandedYield instanceof JSIntersectionType) {
            expandedYield = JSGeneratorReturnType.filterIntersection(source, (JSIntersectionType)expandedYield, context2, false);
        }
        if (expandedYield instanceof JSAnyType) {
            expandedYield = JSNamedTypeFactory.createType("unknown", source, JSTypeContext.UNKNOWN);
        }
        JSType jSType2 = expandedYield;
        if (jSType2 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(12);
        }
        return jSType2;
    }

    @NotNull
    private static JSType filterIntersection(@NotNull JSTypeSource source, JSIntersectionType expandedYield, JSTypeSubstitutionContext context2, boolean substituteComponents) {
        List filtered;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(13);
        }
        if (ContainerUtil.equalsIdentity(filtered = expandedYield.getTypes().stream().map(t -> substituteComponents ? context2.substituteNested((JSType)t) : t).filter(t -> t != null && !(t instanceof JSAnyType)).collect(Collectors.toList()), expandedYield.getTypes())) {
            JSIntersectionType jSIntersectionType = expandedYield;
            if (jSIntersectionType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(14);
            }
            return jSIntersectionType;
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(filtered, source);
        if (jSType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    @NotNull
    private static JSType combineObsoleteGeneratorType(@NotNull JSTypeSource source, JSType expandedType, JSType expandedReturn) {
        boolean expandedIsNullOrVoid;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(16);
        }
        boolean bl = expandedIsNullOrVoid = expandedType == null || expandedType instanceof JSVoidType;
        if (expandedIsNullOrVoid && expandedReturn == null) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(17);
            }
            return jSAnyType;
        }
        if (expandedIsNullOrVoid) {
            JSType jSType = expandedReturn;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        if (expandedReturn == null) {
            JSType jSType = expandedType;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeFactory.getCommonType(expandedType, expandedReturn, source, true);
        if (jSType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @NotNull
    private String getTypeName(JSTypeSource source) {
        PsiElement sourceElement = source.getSourceElement();
        return JSGeneratorReturnType.getGeneratorClassName(sourceElement, this.myIsAsync);
    }

    @NotNull
    public static String getGeneratorClassName(PsiElement sourceElement, boolean isAsync) {
        String defaultName;
        String string = defaultName = isAsync ? "AsyncIterableIterator" : "IterableIterator";
        if (sourceElement == null) {
            String string2 = defaultName;
            if (string2 == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(21);
            }
            return string2;
        }
        String generatorClassName = isAsync ? "AsyncGenerator" : "Generator";
        JSTypeResolveResult result2 = JSImportHandler.getInstance().resolveTypeName(generatorClassName, sourceElement);
        if (result2.hasElements() && result2.getElements().stream().anyMatch(e -> e instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)e).getTypeParameters().length > 0)) {
            String string3 = generatorClassName;
            if (string3 == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(22);
            }
            return string3;
        }
        String string4 = defaultName;
        if (string4 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(23);
        }
        return string4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12, 14, 15, 17, 18, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandYieldType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIntersection";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "combineObsoleteGeneratorType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doSubstitute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandYieldType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterIntersection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "combineObsoleteGeneratorType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12, 14, 15, 17, 18, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

