/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSObjectLiteralExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSQualifiedItemProcessor,
JSModuleElementsProcessor {
    protected final boolean myEcma;
    protected final boolean myTypeScript;
    public TypeResolveState resolved;

    public QualifiedItemProcessor(@NotNull T sink, @NotNull PsiFile containingFile2) {
        if (sink == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (containingFile2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        super(sink);
        this.resolved = TypeResolveState.Unknown;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)this.place, (Object)containingFile2));
        this.myEcma = holder != null && holder.isECMA4;
        this.myTypeScript = holder != null && holder.isTypeScript;
        this.setToProcessHierarchy(true);
    }

    protected void forceResolvedState() {
        this.resolved = TypeResolveState.Resolved;
    }

    @Override
    public final void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (type2 instanceof JSAnyType && type2.getSource().isEcma()) {
            boolean currentIsNotResolved = this.isActionScriptDummyResolve();
            TypeResolveState typeResolveState = this.resolved = currentIsNotResolved ? TypeResolveState.PrefixUnknown : TypeResolveState.Unknown;
        }
        if (type2 instanceof JSModuleTypeImpl) {
            PsiElement module = ((JSModuleTypeImpl)type2).getModule();
            ES6PsiUtil.processExportDeclarationInScope(module, this, evaluateContext, ((JSModuleTypeImpl)type2).isFromRequire(), null);
            boolean hasIncompleteMatch = false;
            if (module instanceof JSFile) {
                JSModuleStatusOwner.ModuleStatus status = ((JSFile)module).getModuleStatus();
                boolean bl = hasIncompleteMatch = status == JSModuleStatusOwner.ModuleStatus.COMMONJS || status == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
            }
            if (!hasIncompleteMatch) {
                this.forceResolvedState();
            }
            return;
        }
        if (type2 instanceof JSObjectLiteralExpressionType) {
            JSObjectLiteralExpression element = ((JSObjectLiteralExpressionType)type2).findAssociatedExpression();
            if (element != null) {
                element.processDeclarations(this, ResolveState.initial(), (PsiElement)element, this.place);
            }
            return;
        }
        JSType substituted = type2.substitute((PsiElement)evaluateContext.targetFile);
        if (substituted instanceof JSClassExpressionType) {
            JSClassExpressionType classExpressionType = (JSClassExpressionType)substituted;
            boolean isStatic = classExpressionType.getJSContext() == JSContext.STATIC;
            JSClassExpression element = classExpressionType.findAssociatedExpression();
            if (element != null) {
                AccessibilityProcessingHandler.processWithStatic(this, isStatic, () -> element.processDeclarations(this, ResolveState.initial(), element, this.place));
                if (this.myTypeScript && type2.isSourceStrict() && !this.isTypeContext() && this.resolved != TypeResolveState.PrefixUnknown) {
                    this.forceResolvedState();
                }
            }
            return;
        }
        this.processImpl(substituted, evaluateContext);
        if (this.resolved == TypeResolveState.Unknown) {
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                if (!handler.useOnlyCompleteMatch(type2, evaluateContext)) continue;
                this.forceResolvedState();
                break;
            }
        }
    }

    protected void processImpl(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        JSType finalType;
        Boolean evaluate;
        Object element;
        JSType constraintType;
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (type2 instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type2).getConstraintType()) != null) {
            type2 = constraintType;
        }
        if (type2 instanceof JSRecordType) {
            this.processRecordTypeImpl((JSRecordType)type2);
            return;
        }
        if ((type2 instanceof JsonElementType || type2 instanceof JSCustomElementType) && !QualifiedItemProcessor.processResolvedElement(element = ((JSTypeOfPsiElementBase)type2).getElement(), this)) {
            this.forceResolvedState();
        }
        if (Boolean.FALSE.equals(evaluate = (Boolean)JSEvaluationRecursionGuard.evaluateWithGuard(type2, evaluateContext, () -> this.lambda$processImpl$1(finalType = type2, evaluateContext)))) {
            return;
        }
        this.processActionScriptClass(type2, evaluateContext);
    }

    private void processActionScriptClass(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        if (!this.myEcma) {
            return;
        }
        String typeString = JSTypeUtils.getQualifiedNameMatchingType(type2, true);
        if (type2 instanceof JSAnyType || typeString == null) {
            return;
        }
        PsiElement placeParent = this.place.getParent();
        boolean setTypeContext = placeParent instanceof JSReferenceListMember;
        PsiElement clazz = JSClassResolver.findClassFromNamespace(typeString, this.place);
        if (!(clazz instanceof XmlBackedJSClass)) {
            JSClass resolvedFromType = type2.resolveClass();
            if (clazz == null || resolvedFromType instanceof XmlBackedJSClass) {
                clazz = resolvedFromType;
            }
        }
        if (clazz instanceof JSClass) {
            JSClass finalClass = (JSClass)clazz;
            PsiElement typeSource = evaluateContext.getSource();
            AccessibilityProcessingHandler.processWithStatic(this, false, () -> {
                this.addTypeFromClass(type2, evaluateContext, typeString, typeSource, setTypeContext, finalClass);
                return true;
            });
        }
        if (type2 instanceof JSObjectType) {
            this.resolved = TypeResolveState.Unknown;
        } else if (!(clazz instanceof JSQualifiedNamedElement) && type2.isSourceStrict()) {
            this.forceResolvedState();
        }
    }

    @Override
    public void processAdditionalType(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        this.process(type2, evaluateContext);
    }

    private static boolean processResolvedElement(@NotNull PsiElement element, @NotNull JSResolveProcessor processor) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                JsonFile file = (JsonFile)element;
                value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> file.getTopLevelValue());
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                        return false;
                    }
                } else {
                    List list2 = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list2) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
            }
        } else {
            if (element instanceof StylesheetFile) {
                CssStylesheet stylesheet = ((StylesheetFile)element).getStylesheet();
                if (stylesheet != null) {
                    QualifiedItemProcessor.processCssClasses(stylesheet, processor);
                }
                return false;
            }
            if (element instanceof JSPackage) {
                element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, element);
                return false;
            }
        }
        return true;
    }

    private static void processCssClasses(@NotNull CssStylesheet stylesheet, @NotNull JSResolveProcessor processor) {
        if (stylesheet == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        MultiMap stylesheetClasses = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)stylesheet, () -> {
            MultiMap classes = new MultiMap();
            for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
                QualifiedItemProcessor.collectCssClasses(cssRuleset, (MultiMap<String, CssClass>)classes);
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{stylesheet.getContainingFile()});
        });
        Collection classes = processor.getName() != null ? stylesheetClasses.get((Object)processor.getName()) : stylesheetClasses.values();
        for (CssClass cssClass : classes) {
            ProgressManager.checkCanceled();
            processor.execute((PsiElement)cssClass, ResolveState.initial());
        }
    }

    private static void collectCssClasses(@NotNull CssRuleset cssRuleset, @NotNull MultiMap<String, CssClass> classes) {
        if (cssRuleset == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        if (classes == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            if (cssSelector.isAmpersandSelector()) {
                cssSelector.processAmpersandEvaluatedSelectors(effectiveSelector -> {
                    QualifiedItemProcessor.collectCssClasses(effectiveSelector, classes);
                    return true;
                });
                continue;
            }
            QualifiedItemProcessor.collectCssClasses(cssSelector, classes);
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            QualifiedItemProcessor.collectCssClasses((CssRuleset)cssSelector, classes);
        }
    }

    private static void collectCssClasses(@NotNull CssSelector selector, @NotNull MultiMap<String, CssClass> classes) {
        if (selector == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        if (classes == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
            for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                String name;
                if (!(selectorSuffix instanceof CssClass) || (name = ResolveProcessor.getName((PsiElement)selectorSuffix)) == null) continue;
                classes.putValue((Object)name, (Object)((CssClass)selectorSuffix));
            }
        }
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type2) {
        JSRecordType.IndexSignature indexer;
        List<PsiElement> results;
        String name;
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(18);
        }
        if (this.myTypeScript && type2.isSourceStrict() && this.resolved != TypeResolveState.PrefixUnknown) {
            this.forceResolvedState();
        }
        if (type2 instanceof JSNotARecordType) {
            return;
        }
        PsiElement sourceElement = type2.getSourceElement();
        if (sourceElement == null && ApplicationManager.getApplication().isUnitTestMode() && this.place != null && TypeScriptCompilerEvaluationFacade.getInstance(this.place.getProject()) == null) {
            Logger.getInstance(this.getClass()).error((Throwable)((Object)new AssertionError((Object)"Record type source must be not empty")));
        }
        boolean isSimpleRecordWithDefinedSource = type2 instanceof JSSimpleRecordTypeImpl && sourceElement != null && sourceElement.isValid();
        boolean isTypeScriptObjectType = sourceElement instanceof TypeScriptObjectType;
        if (isSimpleRecordWithDefinedSource && (sourceElement instanceof JSClassExpression || isTypeScriptObjectType)) {
            Stream<JSType> constructors = JSTypeUtils.getFunctionType(type2, true, this.place);
            this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
            boolean found = !sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place);
            boolean processBaseDeclarations = !found || isTypeScriptObjectType && QualifiedItemProcessor.hasOnlyIndexers(this.getResults());
            boolean processObjectClassMembers = this.getResultSink() instanceof ResolveResultSink;
            if (processBaseDeclarations && isTypeScriptObjectType && processObjectClassMembers) {
                boolean hasCallSignature = false;
                boolean hasConstructSignature = false;
                for (TypeScriptTypeMember typeMember : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    hasCallSignature |= typeMember instanceof JSRecordType.CallSignature && !((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                    hasConstructSignature |= typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                }
                this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
            }
            return;
        }
        if (isSimpleRecordWithDefinedSource && sourceElement instanceof JSObjectLiteralExpression) {
            for (JSProperty property : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                if (this.execute((PsiElement)property, ResolveState.initial())) continue;
                return;
            }
        }
        boolean isCompleteResolve = isSimpleRecordWithDefinedSource || !(this.getResultSink() instanceof ResolveResultSink) || sourceElement != null && (DialectDetector.isTypeScript(sourceElement) || type2.isSourceStrict());
        for (JSRecordType.TypeMember typeMember : type2.getProperties()) {
            String name2 = this.getName();
            if (name2 != null && !name2.equals(typeMember.getMemberName())) continue;
            if (!type2.isSourceStrict()) {
                typeMember = typeMember.copyTypeHierarchy(t -> t.copyWithStrict(false));
            }
            if (this.processRecordTypeMember(sourceElement, isSimpleRecordWithDefinedSource, isCompleteResolve, typeMember)) continue;
            return;
        }
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement) && !ES6PsiUtil.isExternalModule(sourceElement)) {
            boolean hasCallSignature = false;
            boolean hasConstructSignature = false;
            List<JSRecordType.CallSignature> signatures2 = type2.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures2) {
                hasCallSignature |= !signature.hasNew();
                hasConstructSignature |= signature.hasNew();
            }
            this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
        }
        if ((name = this.getName()) != null && type2.hasIndexers() && ((results = this.getResults()) == null || results.isEmpty()) && (indexer = type2.findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null && !indexer.isForComputedProperty()) {
            PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)indexer.getMemberSource().getSingleElement(), (Object)sourceElement);
            if (element == null) {
                return;
            }
            this.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), element, false), ResolveState.initial());
        }
    }

    public static boolean hasOnlyIndexers(List<PsiElement> results) {
        return results != null && results.stream().allMatch(e -> e instanceof TypeScriptIndexSignature);
    }

    private boolean processRecordTypeMember(@Nullable PsiElement sourceElement, boolean isSimpleRecordWithDefinedSource, boolean isCompleteResolve, @NotNull JSRecordType.TypeMember typeMember) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, !isSimpleRecordWithDefinedSource);
        boolean added = false;
        for (PsiElement element : elements) {
            if (element == null) continue;
            if (!isCompleteResolve) {
                this.addPossibleCandidateResult(element, null);
                continue;
            }
            if (element instanceof JSImplicitElement && !(element instanceof TypeScriptProxyImplicitElement)) {
                this.addResult(element);
                continue;
            }
            if (this.execute(element, ResolveState.initial())) continue;
            added = true;
        }
        return !added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature, boolean hasConstructSignature) {
        if (sourceElement == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(20);
        }
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature || hasConstructSignature ? JSTypeUtils.getFunctionTypeName(sourceElement.getContainingFile(), hasConstructSignature) : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, (PsiElement)object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    @NotNull
    public static Collection<PsiElement> getElementsForTypeMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable PsiElement sourceElement, boolean createImplicitElement) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(21);
        }
        if (typeMember instanceof PsiElement) {
            List<PsiElement> list2 = Collections.singletonList((PsiElement)typeMember);
            if (list2 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(22);
            }
            return list2;
        }
        if (typeMember instanceof JSCompositeFunctionPropertySignatureImpl) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (JSRecordType.PropertySignature signature : ((JSCompositeFunctionPropertySignatureImpl)typeMember).getMembers()) {
                results.addAll(QualifiedItemProcessor.getElementsForTypeMember(signature, sourceElement, createImplicitElement));
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(23);
            }
            return arrayList;
        }
        JSRecordType.MemberSource ownSource = typeMember.getMemberSource();
        if ((createImplicitElement || ownSource.isMerged()) && typeMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
            JSType propertySignatureType = propertySignature.getJSType();
            return QualifiedItemProcessor.createImplicitElements(sourceElement, propertySignature, propertySignatureType);
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)ownSource.getSingleElement());
        if (list3 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    private static Collection<PsiElement> createImplicitElements(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, @Nullable JSType propertySignatureType) {
        JSRecordType.MemberSource source;
        if (propertySignature == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(25);
        }
        if (!(source = propertySignature.getMemberSource()).isMerged()) {
            List<JSImplicitElement> elementsByName;
            JSElementIndexingData indexingData;
            PsiElement propertySource = source.getSingleElement();
            final boolean hasType = propertySignatureType != null;
            final boolean isConst = propertySignature.isConst();
            PsiElement provider = (PsiElement)ObjectUtils.coalesce((Object)propertySource, (Object)sourceElement);
            if (provider == null) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(26);
                }
                return list2;
            }
            String name = propertySignature.getMemberName();
            if (provider instanceof JSDocComment && (indexingData = ((JSDocComment)provider).getIndexingData()) != null && (elementsByName = indexingData.findElementsByNameOrQName(propertySignature.getMemberName())).size() == 1) {
                List<JSImplicitElement> list3 = Collections.unmodifiableList(elementsByName);
                if (list3 == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(27);
                }
                return list3;
            }
            JSLocalImplicitElementImpl element = new JSLocalImplicitElementImpl(name, propertySignatureType, provider, null){

                @Override
                public boolean hasMinorImportance() {
                    return !hasType;
                }

                @Override
                public boolean isConst() {
                    return isConst;
                }
            };
            List list4 = ContainerUtil.createMaybeSingletonList((Object)element);
            if (list4 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(28);
            }
            return list4;
        }
        List<PsiElement> elements = source.getAllSourceElements();
        boolean readonly = propertySignature.isConst() || source.isReadonly() || source.isForceReadonly();
        boolean optional = propertySignature.isOptional() || source.isForceOptional();
        boolean hasSingleDoc = source.hasSingleDocumentation();
        Collection collection = elements.stream().filter(e -> e != null).map(e -> new TypeScriptMergedTypeImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, (PsiElement)e, readonly, optional, hasSingleDoc, source.getSourceKind())).collect(Collectors.toList());
        if (collection == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeFromClass(JSType type2, JSEvaluateContext evaluateContext, String typeString, PsiElement typeSource, boolean setTypeContext, JSQualifiedNamedElement jsClass) {
        JSExpression placeQualifier;
        JSReferenceExpression evaluateQualifier;
        if ("RemoteObject".equals(jsClass.getName()) && typeSource instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)typeSource).getType() == JSImplicitElement.Type.Tag) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((JSOffsetBasedImplicitElement)typeSource).getElementAtOffset(), XmlTag.class);
            for (XmlTag method : tag.findSubTags("method", tag.getNamespace())) {
                if (!this.execute((PsiElement)method, ResolveState.initial())) break;
            }
            this.forceResolvedState();
            return;
        }
        boolean statics = false;
        if (!(!JSPsiImplUtils.isTheSameClass(typeSource, jsClass) || (evaluateQualifier = evaluateContext.getProcessedExpression()) == null || (placeQualifier = evaluateQualifier.getQualifier()) instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSParenthesizedExpression || placeQualifier instanceof JSParenthesizedExpression)) {
            statics = true;
        }
        if (type2 instanceof JSNamedType && ((JSNamedType)type2).isStaticOrInstance() == JSContext.STATIC) {
            statics = true;
        }
        this.getAccessibilityProcessingHandler().setProcessStatics(statics);
        if (statics) {
            this.setTypeName(jsClass.getQualifiedName());
        }
        boolean saveSetTypeContext = this.isTypeContext();
        boolean saveToProcessMembers = this.isToProcessMembers();
        if (setTypeContext) {
            this.setTypeContext(setTypeContext);
            this.setToProcessMembers(false);
        }
        try {
            JSAttributeList attrList;
            if (!this.resolved.isResolved() && ("XML".equals(typeString) || "XMLList".equals(typeString))) {
                this.resolved = TypeResolveState.PrefixUnknown;
            }
            if (!jsClass.processDeclarations(this, ResolveState.initial(), (PsiElement)jsClass, this.place)) {
                this.forceResolvedState();
            }
            if (this.myEcma && ((attrList = ((JSAttributeListOwner)((Object)jsClass)).getAttributeList()) == null || !attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                this.forceResolvedState();
            }
        }
        finally {
            if (setTypeContext) {
                this.setTypeContext(saveSetTypeContext);
                this.setToProcessMembers(saveToProcessMembers);
            }
        }
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(30);
        }
        if (state == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(31);
        }
        if (this.needPackages() && !(element instanceof JSPackage)) {
            return true;
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        boolean b = super.execute(element, state);
        if (this.myEcma && this.getResult() != null) {
            this.forceResolvedState();
        }
        return b;
    }

    @Override
    public void prefixResolved() {
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element) {
        super.elementIsNotAccessible(element);
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    private boolean isActionScriptDummyResolve() {
        if (this.place instanceof JSReferenceExpressionImpl) {
            JSExpression originalQualifier = BaseJSSymbolProcessor.getOriginalQualifier(((JSReferenceExpressionImpl)this.place).getQualifier());
            if (originalQualifier instanceof JSCallExpression) {
                originalQualifier = ((JSCallExpression)originalQualifier).getMethodExpression();
            }
            if (originalQualifier instanceof JSReferenceExpression && ((JSReferenceExpression)originalQualifier).multiResolve(false).length == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean noMoreResultsPossible() {
        return this.resolved == TypeResolveState.Resolved || this.resolved == TypeResolveState.PrefixUnknown && this.myEcma;
    }

    public ResolveResult @Nullable [] getResultsIfResolveCompleted() {
        return this.getResultsIfResolveCompletedJS();
    }

    protected ResolveResult @Nullable [] getResultsIfResolveCompletedJS() {
        ResolveResultSink sink = (ResolveResultSink)this.getResultSink();
        if (this.noMoreResultsPossible() || sink.getCompleteResult() != null) {
            return this.getResultsAsResolveResults();
        }
        return null;
    }

    public void evaluateExpressionOrElementType(@NotNull PsiElement element, @Nullable PsiFile targetFile) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(32);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, (JSTypeProcessor)this, true);
    }

    private /* synthetic */ Boolean lambda$processImpl$1(JSType finalType, JSEvaluateContext evaluateContext) {
        return JSTypeUtils.processExpandedType(this, finalType, evaluateContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 23, 24, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 10: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForTypeMember";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processActionScriptClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processCssClasses";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectCssClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeMember";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForTypeMember";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElements";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 23, 24, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        ResolvedAllowsExtras,
        PrefixUnknown;


        public boolean isResolved() {
            return this == Resolved || this == ResolvedAllowsExtras;
        }

        public boolean isSuitableForReferenceResolve() {
            return this.isResolved();
        }
    }
}

