/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface TypeScriptOverloadsMixin
extends TypeScriptFunction {
    public static final Key<ParameterizedCachedValue<State, TypeScriptOverloadsMixin>> OVERLOAD_STATE_KEY = Key.create((String)"ts.overloadState");
    public static final Key<JSStubElementImpl.StubBuildCachedValue<State>> STUB_BUILDING_OVERLOAD_STATE_KEY = Key.create((String)"js.stub.building.overloadState");

    @Nullable
    public TypeScriptOverloadsMixin doGetPrevOverloadCandidate();

    @Nullable
    public TypeScriptOverloadsMixin doGetNextOverloadCandidate();

    @Nullable
    public TypeScriptFunctionStub<?> getGreenStub();

    @Override
    @Nullable
    default public TypeScriptFunction getNextOverloadOrImplementation() {
        if (!this.isOverloadDeclaration()) {
            return null;
        }
        return TypeScriptOverloadsMixin.getNextOverloadFunction(this);
    }

    @Override
    @NotNull
    default public List<TypeScriptFunction> getOverloadDeclarations() {
        if (this.hasOverloadDeclarations()) {
            List<TypeScriptFunction> list2 = TypeScriptOverloadsMixin.getOverloadDeclarationsImpl(this, false);
            if (list2 == null) {
                TypeScriptOverloadsMixin.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(1);
        }
        return list3;
    }

    @Override
    default public boolean hasOverloadDeclarations() {
        TypeScriptFunctionStub<?> stub = this.getGreenStub();
        if (stub != null) {
            return stub.hasOverloadDeclarations();
        }
        State state = TypeScriptOverloadsMixin.calcOverloadState(this);
        return state == State.IS_OVERLOAD_IMPLEMENTATION || state == State.HAS_OVERLOADS || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    @Override
    default public boolean isOverloadImplementation() {
        TypeScriptFunctionStub<?> stub = this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadImplementation();
        }
        return TypeScriptOverloadsMixin.calcOverloadState(this) == State.IS_OVERLOAD_IMPLEMENTATION;
    }

    @Override
    default public boolean isOverloadDeclaration() {
        TypeScriptFunctionStub<?> stub = this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadDeclaration();
        }
        State state = TypeScriptOverloadsMixin.calcOverloadState(this);
        return state == State.IS_OVERLOAD || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    public static TypeScriptOverloadsMixin getNextOverloadFunction(@NotNull TypeScriptOverloadsMixin function2) {
        TypeScriptOverloadsMixin nextFunction;
        if (function2 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(2);
        }
        return (nextFunction = function2.doGetNextOverloadCandidate()) != null && StringUtil.equals((CharSequence)function2.getName(), (CharSequence)nextFunction.getName()) ? nextFunction : null;
    }

    public static State calcOverloadState(@NotNull TypeScriptOverloadsMixin function2) {
        if (function2 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(3);
        }
        return JSStubElementImpl.getCachedValueStubBuildOptimized(function2, OVERLOAD_STATE_KEY, STUB_BUILDING_OVERLOAD_STATE_KEY, it -> {
            boolean hasOverloads;
            boolean isOverload = TypeScriptOverloadsMixin.isOverloadDeclarationImpl(it);
            boolean bl = hasOverloads = !TypeScriptOverloadsMixin.getOverloadDeclarationsImpl(it, true).isEmpty();
            if (isOverload) {
                return CachedValueProvider.Result.create((Object)((Object)(hasOverloads ? State.IS_OVERLOAD_AND_HAS_OVERLOADS : State.IS_OVERLOAD)), (Object[])new Object[]{it});
            }
            if (it.getBlock() != null && hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.IS_OVERLOAD_IMPLEMENTATION), (Object[])new Object[]{it});
            }
            if (hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.HAS_OVERLOADS), (Object[])new Object[]{it});
            }
            return CachedValueProvider.Result.create((Object)((Object)State.IS_NOT_OVERLOAD), (Object[])new Object[]{it});
        }, function2);
    }

    public static boolean isOverloadDeclarationImpl(@NotNull TypeScriptOverloadsMixin function2) {
        TypeScriptFunctionStub<?> stub;
        if (function2 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(4);
        }
        if ((stub = function2.getGreenStub()) != null) {
            return stub.isOverloadDeclaration();
        }
        return function2.getBlock() == null && TypeScriptOverloadsMixin.getNextOverloadFunction(function2) != null;
    }

    public static List<TypeScriptFunction> getOverloadDeclarationsImpl(@NotNull TypeScriptOverloadsMixin function2, boolean firstOnly) {
        if (function2 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(5);
        }
        String name = function2.getName();
        TypeScriptOverloadsMixin prevSibling = function2.doGetPrevOverloadCandidate();
        if (prevSibling != null) {
            SmartList result2 = new SmartList();
            while (prevSibling != null && StringUtil.equals((CharSequence)name, (CharSequence)prevSibling.getName()) && TypeScriptOverloadsMixin.isOverloadDeclarationImpl(prevSibling)) {
                result2.add(0, prevSibling);
                if (firstOnly) {
                    return result2;
                }
                prevSibling = prevSibling.doGetPrevOverloadCandidate();
            }
            return result2;
        }
        return ContainerUtil.emptyList();
    }

    @Nullable
    public static JSSourceElement getSourceElementStubSafely(@NotNull PsiElement source, boolean forward) {
        if (source == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(6);
        }
        boolean isSourceStatic = TypeScriptOverloadsMixin.isStatic(source);
        PsiElement result2 = TypeScriptOverloadsMixin.getFollowing(source, forward);
        while (!(result2 == null || result2 instanceof JSSourceElement && TypeScriptOverloadsMixin.isStatic(result2) == isSourceStatic)) {
            result2 = TypeScriptOverloadsMixin.getFollowing(result2, forward);
        }
        return (JSSourceElement)ObjectUtils.tryCast((Object)result2, JSSourceElement.class);
    }

    public static boolean isStatic(@NotNull PsiElement source) {
        if (source == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(7);
        }
        return JSPsiImplUtils.hasModifier((JSAttributeListOwner)ObjectUtils.tryCast((Object)source, JSAttributeListOwner.class), JSAttributeList.ModifierType.STATIC);
    }

    @Nullable
    public static PsiElement getFollowing(@NotNull PsiElement source, boolean forward) {
        if (source == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(8);
        }
        return forward ? JSStubBasedPsiTreeUtil.getNextSibling(source) : JSStubBasedPsiTreeUtil.getPrevSibling(source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptOverloadsMixin";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadDeclarations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptOverloadsMixin";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNextOverloadFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcOverloadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadDeclarationImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadDeclarationsImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElementStubSafely";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFollowing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static enum State {
        IS_NOT_OVERLOAD,
        IS_OVERLOAD,
        IS_OVERLOAD_AND_HAS_OVERLOADS,
        IS_OVERLOAD_IMPLEMENTATION,
        HAS_OVERLOADS;

    }
}

