/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LinterUnsavedConfigFileManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LinterUnsavedConfigFileManager.class);
    private static final int SAVE_POSTPONE_TIMEOUT_MILLIS = 300;
    private final Project myProject;
    private final Map<VirtualFile, WatchedDocument> myWatchedDocumentsByFile;
    @NotNull
    private final Alarm myAlarm;
    private Runnable myUpdateRunnable;

    public LinterUnsavedConfigFileManager(@NotNull Project project) {
        if (project == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(0);
        }
        this.myWatchedDocumentsByFile = new HashMap<VirtualFile, WatchedDocument>();
        this.myProject = project;
        this.myAlarm = new Alarm((Disposable)this);
        this.myUpdateRunnable = () -> {
            if (this.canSaveNow()) {
                this.doSaveFiles();
            } else {
                LOG.trace("Could not save now, rescheduling");
                this.myAlarm.addRequest(this.myUpdateRunnable, 300);
            }
        };
    }

    public boolean requestSaveIfNeeded(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(1);
        }
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        boolean hasModifiedConfigs = configs.stream().anyMatch(LinterUnsavedConfigFileManager::isFileModified);
        if (!hasModifiedConfigs) {
            return true;
        }
        application.invokeLater(() -> {
            this.registerDocumentsToSave(configs);
            this.rescheduleSave();
        }, ModalityState.any(), this.myProject.getDisposed());
        return false;
    }

    private void registerDocumentsToSave(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(2);
        }
        configs.forEach(config -> {
            if (!LinterUnsavedConfigFileManager.isFileModified(config) || this.myWatchedDocumentsByFile.containsKey(config)) {
                return;
            }
            Document document2 = FileDocumentManager.getInstance().getDocument(config);
            if (document2 != null) {
                this.myWatchedDocumentsByFile.put((VirtualFile)config, new WatchedDocument((VirtualFile)config, document2));
            } else {
                LOG.info("Could not find document for save for file: " + config.getPath());
            }
        });
    }

    private void rescheduleSave() {
        if (this.myAlarm.isEmpty()) {
            LOG.trace("Scheduling save in 300");
            this.myAlarm.addRequest(this.myUpdateRunnable, 300);
        }
    }

    private void doSaveFiles() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myWatchedDocumentsByFile.values().stream().filter(item -> item.myFile.isValid()).forEach(item -> {
            LOG.debug("Saving " + item.myFile.getPath());
            FileDocumentManager.getInstance().saveDocument(item.myDocument);
            item.stop();
        });
        this.myWatchedDocumentsByFile.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private boolean canSaveNow() {
        long currentTimeMillis = System.currentTimeMillis();
        return this.myWatchedDocumentsByFile.values().stream().allMatch(d -> currentTimeMillis - d.myLastModifiedMillis >= 300L);
    }

    private static boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(3);
        }
        return file.isValid() && !file.isDirectory() && FileDocumentManager.getInstance().isFileModified(file);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestSaveIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerDocumentsToSave";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WatchedDocument
    implements DocumentListener {
        private final VirtualFile myFile;
        private final Document myDocument;
        private long myLastModifiedMillis;

        WatchedDocument(@NotNull VirtualFile file, @NotNull Document document2) {
            if (file == null) {
                WatchedDocument.$$$reportNull$$$0(0);
            }
            if (document2 == null) {
                WatchedDocument.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myDocument = document2;
            this.myDocument.addDocumentListener((DocumentListener)this);
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                WatchedDocument.$$$reportNull$$$0(2);
            }
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void stop() {
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

