/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryCommitChangesMerger {
    private static final Logger LOG = Logger.getInstance(LibraryCommitChangesMerger.class);
    private final JSLibraryManager myLibraryManager;
    private final long myMergeDelayMillis;
    private final NotNullLazyValue<Alarm> myAlarmLazyValue;

    LibraryCommitChangesMerger(@NotNull JSLibraryManager libraryManager, long mergeDelayMillis) {
        if (libraryManager == null) {
            LibraryCommitChangesMerger.$$$reportNull$$$0(0);
        }
        this.myLibraryManager = libraryManager;
        this.myMergeDelayMillis = mergeDelayMillis;
        this.myAlarmLazyValue = NotNullLazyValue.atomicLazy(() -> new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myLibraryManager));
    }

    void request(@Nullable RootsChangeRescanningInfo info2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Runnable runnable = () -> WriteAction.run(() -> this.myLibraryManager.commitChanges(info2));
            if (ApplicationManager.getApplication().isDispatchThread()) {
                runnable.run();
            } else if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                ApplicationManager.getApplication().invokeAndWait(runnable);
            } else {
                LOG.error("Skipping request");
            }
        } else {
            Alarm alarm = (Alarm)this.myAlarmLazyValue.getValue();
            alarm.cancelAllRequests();
            alarm.addRequest(() -> WriteAction.run(() -> this.myLibraryManager.commitChanges(info2)), this.myMergeDelayMillis, ModalityState.nonModal());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryManager", "com/intellij/lang/javascript/library/LibraryCommitChangesMerger", "<init>"));
    }
}

