/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.json.adapters.JSJsonPropertyAdapter;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSJsonLikePsiWalker
implements JsonLikePsiWalker {
    public static final JSJsonLikePsiWalker INSTANCE_ARRAY_ALLOWED = new JSJsonLikePsiWalker(true);
    public static final JSJsonLikePsiWalker INSTANCE_ARRAY_NOT_ALLOWED = new JSJsonLikePsiWalker(false);
    private final boolean myTopLevelArraysAllowed;

    private JSJsonLikePsiWalker(boolean topLevelArrayAllowed) {
        this.myTopLevelArraysAllowed = topLevelArrayAllowed;
    }

    public boolean isQuotedString(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isStringLiteral();
    }

    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            return ThreeState.YES;
        }
        if (parent instanceof JSProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSProperty)parent).getNameIdentifier(), (PsiElement)element, (boolean)false) ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null) {
                return ThreeState.NO;
            }
            PsiElement parentParent = parent.getParent();
            return parentParent instanceof ES6Property && ((ES6Property)parentParent).isShorthanded() ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.NO;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof JSProperty && ((JSProperty)element).getValue() != null;
    }

    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (!(current instanceof JSExpression) && !(current instanceof JSProperty)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(3);
        }
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!this.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JSArrayLiteralExpression) {
                JSArrayLiteralExpression array = (JSArrayLiteralExpression)current;
                Object[] expressions = array.getExpressions();
                int idx = ArrayUtil.indexOf((Object[])expressions, (Object)position);
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof JSProperty) {
                propertyName = StringUtil.notNullize((String)((JSProperty)current).getName());
                if (!((current = current.getParent()) instanceof JSObjectLiteralExpression)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof JSObjectLiteralExpression && position instanceof JSProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = StringUtil.notNullize((String)((JSProperty)position).getName());
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (this.breakCondition(current)) break;
            return null;
        }
        return !this.myTopLevelArraysAllowed && pos.isArray(0) ? pos.skip(1) : pos;
    }

    public boolean requiresNameQuotes() {
        return false;
    }

    public boolean allowsSingleQuotes() {
        return true;
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = current = element instanceof JSProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class);
        while (current != null && current.getNode().getElementType() != JSTokenTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JSObjectLiteralExpression object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class);
        if (object != null) {
            for (JSProperty property : object.getProperties()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        JSObjectLiteralExpression object;
        if (originalPosition == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(5);
        }
        if ((object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, JSObjectLiteralExpression.class)) != null) {
            return Arrays.stream(object.getProperties()).filter(p -> p != null && p.getName() != null).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        JSProperty property;
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(6);
        }
        return (property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class, (boolean)false)) == null ? null : new JSJsonPropertyAdapter(property);
    }

    private boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof JSEmbeddedContent || JSJsonLikePsiWalker.isTerminalInStatement(current) || !this.myTopLevelArraysAllowed && current instanceof JSArrayLiteralExpression && JSJsonLikePsiWalker.isTerminalInStatement(current.getParent());
    }

    public static boolean isTerminalInStatement(PsiElement current) {
        return current instanceof JSStatement || current instanceof JSArgumentList || current instanceof JSVariable || current instanceof JSParenthesizedExpression && JSJsonLikePsiWalker.isParenthesisAroundObjectReturnedFromArrowFunction((JSParenthesizedExpression)current) || current instanceof JSAssignmentExpression && (current.getParent() instanceof JSStatement || current instanceof JSCommaExpression);
    }

    private static boolean isParenthesisAroundObjectReturnedFromArrowFunction(JSParenthesizedExpression parenthesis) {
        JSExpression inner = parenthesis.getInnerExpression();
        PsiElement parent = parenthesis.getParent();
        return inner instanceof JSObjectLiteralExpression && parent instanceof JSFunction && parenthesis.equals(JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)parent));
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(7);
        }
        return this.breakCondition(element);
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(8);
        }
        return element instanceof JSExpression ? (JsonValueAdapter)ContainerUtil.getFirstItem(JSJsonPropertyAdapter.createValueAdaptersByType((JSExpression)element)) : null;
    }

    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class), (Class[])new Class[]{JSObjectLiteralExpression.class, JSArrayLiteralExpression.class});
    }

    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        if (file == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(9);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof JSProperty ? ((JSProperty)property).getNameIdentifier() : null;
    }

    public boolean isValidIdentifier(String string, Project project) {
        return StringUtil.isJavaIdentifier((String)string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/json/JSJsonLikePsiWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/json/JSJsonLikePsiWalker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementToCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPosition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingCommaAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentPropertyAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTopJsonElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

