/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.modules.JSRemoteModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSXmlLibraryReferenceContributor;
import com.intellij.lang.javascript.modules.remote.JSDownloadRemoteModuleQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSUnresolvedLibraryURLInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(1);
        }
        return new XmlElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                String url;
                XmlAttributeValue attributeValue;
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((attributeValue = attribute.getValueElement()) == null) {
                    return;
                }
                if (JSXmlLibraryReferenceContributor.isLibraryReferenceAttribute(attribute, attributeValue) && JSLibraryUtil.containsLibURL(attributeValue.getValue())) {
                    PsiReference libRef = JSLibReferenceResolver.getLibReference(attributeValue);
                    if (libRef == null || libRef.resolve() == null) {
                        holder.registerProblem((PsiElement)attributeValue, JSUnresolvedLibraryURLInspection.this.getDisplayName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, attribute.getValueTextRange(), new LocalQuickFix[]{JSFixFactory.getInstance().downloadLibraryQuickFix()});
                    }
                } else if (JSUrlImportsUtil.isRemoteModuleReferenceAttribute(attribute, attributeValue) && JSUrlImportsUtil.isSupportedRemoteModuleUrl(url = attributeValue.getValue())) {
                    ProblemHighlightType highlightType;
                    PsiReference reference = (PsiReference)ContainerUtil.find((Object[])attributeValue.getReferences(), ref -> ref instanceof JSRemoteModuleReference);
                    Object object = reference == null || reference.resolve() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (highlightType = holder.isOnTheFly() ? ProblemHighlightType.INFORMATION : null);
                    if (highlightType != null) {
                        holder.registerProblem((PsiElement)attributeValue, JSUnresolvedLibraryURLInspection.this.getDisplayName(), highlightType, attribute.getValueTextRange(), new LocalQuickFix[]{new JSDownloadRemoteModuleQuickFix(url)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection$1", "visitXmlAttribute"));
            }
        };
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JavaScriptBundle.message("js.library.unresolved.url.inspection.name", new Object[0]);
        if (string == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

