/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class HtmlScriptSrcIndex
extends XmlIndex<Void> {
    public static final ID<String, Void> KEY = ID.create((String)"HtmlScriptSrcIndex");

    @NotNull
    public static Collection<String> getReferencedUrls(@NotNull Project project) {
        if (project == null) {
            HtmlScriptSrcIndex.$$$reportNull$$$0(0);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashSet keys = new HashSet(index.getAllKeys(KEY, project));
        GlobalSearchScope scope2 = GlobalSearchScope.projectScope((Project)project);
        HashSet<String> urls = new HashSet<String>();
        for (String key2 : keys) {
            if (!JSUrlImportsUtil.startsWithRemoteUrlPrefix(key2) || index.getContainingFiles(KEY, (Object)key2, scope2).isEmpty()) continue;
            urls.add(key2);
        }
        HashSet<String> hashSet = urls;
        if (hashSet == null) {
            HtmlScriptSrcIndex.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = KEY;
        if (iD == null) {
            HtmlScriptSrcIndex.$$$reportNull$$$0(2);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new BaseFileTypeInputFilter(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION){

            @NotNull
            public ThreeState acceptFileType(@NotNull FileType fileType) {
                if (fileType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileType == HtmlFileType.INSTANCE) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return threeState;
                }
                if (fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage() instanceof TemplateLanguage) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return threeState;
                }
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    1.$$$reportNull$$$0(3);
                }
                return threeState;
            }

            public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                return file.getFile().isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "acceptFileType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptFileType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "slowPathIfFileTypeHintUnsure";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                HashMap<String, Void> result2 = new HashMap<String, Void>();
                inputData.getPsiFile().getViewProvider().getAllFiles().forEach(root -> this.processPsiFile((Map<String, Void>)result2, (PsiFile)root));
                HashMap<String, Void> hashMap = result2;
                if (hashMap == null) {
                    2.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private void processPsiFile(final Map<String, Void> result2, PsiFile file) {
                if (file instanceof HtmlCompatibleFile) {
                    new XmlRecursiveElementWalkingVisitor(){

                        public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                            if (attribute == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitXmlAttribute(attribute);
                            if (!Objects.equals(attribute.getName(), "src")) {
                                return;
                            }
                            XmlTag parent = attribute.getParent();
                            if (!HtmlUtil.isScriptTag((XmlTag)parent)) {
                                return;
                            }
                            String value = attribute.getValue();
                            if (!StringUtil.isEmpty((String)value)) {
                                result2.put(value, null);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/lang/javascript/index/HtmlScriptSrcIndex$2$1", "visitXmlAttribute"));
                        }
                    }.visitFile(file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            HtmlScriptSrcIndex.$$$reportNull$$$0(3);
        }
        return voidDataExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/HtmlScriptSrcIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedUrls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedUrls";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

