/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowImportOptimizer
extends ES6ImportOptimizer {
    @Override
    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.isFlow;
    }

    private static boolean isTypeImport(@NotNull ES6UnusedImportsHelper.UnusedInfo info2) {
        ES6ImportExportDeclaration.ImportExportPrefixKind kind;
        if (info2 == null) {
            FlowImportOptimizer.$$$reportNull$$$0(0);
        }
        return (kind = info2.getDeclaration().getImportExportPrefixKind()) == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE;
    }

    private static boolean isTypeOfImport(@NotNull ES6UnusedImportsHelper.UnusedInfo info2) {
        ES6ImportExportDeclaration.ImportExportPrefixKind kind;
        if (info2 == null) {
            FlowImportOptimizer.$$$reportNull$$$0(1);
        }
        return (kind = info2.getDeclaration().getImportExportPrefixKind()) == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPEOF;
    }

    @Override
    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        ES6UnusedImportsHelper.UnusedInfo item;
        if (imports == null) {
            FlowImportOptimizer.$$$reportNull$$$0(2);
        }
        if ((item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(imports)) == null) {
            String string = super.getImportPrefix(imports);
            if (string == null) {
                FlowImportOptimizer.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (FlowImportOptimizer.isTypeImport(item)) {
            return "import type ";
        }
        if (FlowImportOptimizer.isTypeOfImport(item)) {
            return "import typeof ";
        }
        String string = super.getImportPrefix(imports);
        if (string == null) {
            FlowImportOptimizer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected List<ES6ImportOptimizer.MergedImports> getMergedImports(@NotNull PsiElement module, @Nullable Document document2, @NotNull String fromText, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (module == null) {
            FlowImportOptimizer.$$$reportNull$$$0(5);
        }
        if (fromText == null) {
            FlowImportOptimizer.$$$reportNull$$$0(6);
        }
        if (mergedImports == null) {
            FlowImportOptimizer.$$$reportNull$$$0(7);
        }
        ArrayList<ES6ImportOptimizer.MergedImports> result2 = new ArrayList<ES6ImportOptimizer.MergedImports>();
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> types2 = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>();
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> typeOf = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>();
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> simple = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>();
        for (ES6UnusedImportsHelper.UnusedInfo anImport : mergedImports) {
            ArrayList<ES6UnusedImportsHelper.UnusedInfo> current = simple;
            if (FlowImportOptimizer.isTypeImport(anImport)) {
                current = types2;
            }
            if (FlowImportOptimizer.isTypeOfImport(anImport)) {
                current = typeOf;
            }
            current.add(anImport);
        }
        if (!types2.isEmpty()) {
            result2.addAll(super.getMergedImports(module, document2, fromText, types2));
        }
        if (!typeOf.isEmpty()) {
            result2.addAll(super.getMergedImports(module, document2, fromText, typeOf));
        }
        if (!simple.isEmpty()) {
            result2.addAll(super.getMergedImports(module, document2, fromText, simple));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/FlowImportOptimizer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/FlowImportOptimizer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeImport";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOfImport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImportPrefix";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMergedImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

