/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.ChooseOneOrAllRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class JSExtendsImplementsHighlightingFactory
extends HighlightUsagesHandlerFactoryBase {
    JSExtendsImplementsHighlightingFactory() {
    }

    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        PsiElement parent;
        IElementType elementType;
        ASTNode node;
        if (editor == null) {
            JSExtendsImplementsHighlightingFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSExtendsImplementsHighlightingFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JSExtendsImplementsHighlightingFactory.$$$reportNull$$$0(2);
        }
        if ((node = target.getNode()) != null && (elementType = node.getElementType()) instanceof JSElementType && (elementType == JSTokenTypes.EXTENDS_KEYWORD || elementType == JSTokenTypes.IMPLEMENTS_KEYWORD) && (parent = target.getParent()) instanceof JSReferenceList) {
            return new JSExtendsImplementsHighlightUsagesHandler(editor, file, (JSReferenceList)parent);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSExtendsImplementsHighlightUsagesHandler
    extends HighlightUsagesHandlerBase<JSClass> {
        private final JSReferenceList myReferenceList;

        JSExtendsImplementsHighlightUsagesHandler(Editor editor, PsiFile file, JSReferenceList referenceList) {
            super(editor, file);
            this.myReferenceList = referenceList;
        }

        @NotNull
        public List<JSClass> getTargets() {
            List<JSClass> list2 = Arrays.asList(this.myReferenceList.getReferencedClasses());
            if (list2 == null) {
                JSExtendsImplementsHighlightUsagesHandler.$$$reportNull$$$0(0);
            }
            return list2;
        }

        protected void selectTargets(@NotNull List<? extends JSClass> targets, final @NotNull Consumer<? super List<? extends JSClass>> selectionConsumer) {
            if (targets == null) {
                JSExtendsImplementsHighlightUsagesHandler.$$$reportNull$$$0(1);
            }
            if (selectionConsumer == null) {
                JSExtendsImplementsHighlightUsagesHandler.$$$reportNull$$$0(2);
            }
            new ChooseOneOrAllRunnable<JSClass>(targets, this.myEditor, JavaScriptBundle.message("popup.title.choose.class", new Object[0]), JSClass.class){

                protected void selected(JSClass ... classes) {
                    if (classes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    selectionConsumer.consume(Arrays.asList(classes));
                }

                @NotNull
                protected PsiElementListCellRenderer<JSClass> createRenderer() {
                    return new JSQualifiedNamedElementRenderer<JSClass>();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory$JSExtendsImplementsHighlightUsagesHandler$1", "selected"));
                }
            }.run();
        }

        public void computeUsages(@NotNull List<? extends JSClass> targets) {
            JSClass clazz;
            if (targets == null) {
                JSExtendsImplementsHighlightUsagesHandler.$$$reportNull$$$0(3);
            }
            if ((clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceList, JSClass.class)) != null) {
                boolean extendsList = JSElementTypes.EXTENDS_LISTS.contains(this.myReferenceList.getNode().getElementType());
                for (JSFunction fun : clazz.getFunctions()) {
                    if (extendsList && !JSInheritanceUtil.iterateOverriddenMembersUp(fun, false, (jsNamedElements, s) -> Boolean.FALSE, true)) {
                        ASTNode identifier = fun.findNameIdentifier();
                        this.myReadUsages.add(identifier == null ? fun.getFirstChild().getTextRange() : identifier.getTextRange());
                        continue;
                    }
                    if (extendsList) continue;
                    boolean isImplemented = false;
                    for (JSFunction ifun : JSInheritanceUtil.findImplementedMethods(fun)) {
                        PsiElement parent = JSResolveUtil.findParent(ifun);
                        if (!(parent instanceof JSClass) || !targets.contains(parent)) continue;
                        isImplemented = true;
                        break;
                    }
                    ASTNode identifier = fun.findNameIdentifier();
                    if (!isImplemented) continue;
                    this.myReadUsages.add(identifier == null ? fun.getFirstChild().getTextRange() : identifier.getTextRange());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory$JSExtendsImplementsHighlightUsagesHandler";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory$JSExtendsImplementsHighlightUsagesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTargets";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeUsages";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

