/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideMethodsFix
extends BaseCreateMembersFix<JSQualifiedNamedElement> {
    private static final String ourOverriddenMethodBodyTemplate = "JavaScript Overridden Method Body.js";

    public OverrideMethodsFix(JSClass jsClass) {
        super(jsClass);
    }

    @Override
    protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSQualifiedNamedElement func) {
        if (!(func instanceof JSFunction)) {
            return JSCodeStyleSettings.getSemicolon((PsiElement)func);
        }
        return OverrideMethodsFix.buildDelegatingText(retType, parameterList, func, "super", this.anchor != null ? this.anchor : this.myJsClass);
    }

    public static String buildDelegatingText(String retType, JSParameterList parameterList, JSQualifiedNamedElement func, String qualifier, @NotNull PsiElement anchor) {
        if (anchor == null) {
            OverrideMethodsFix.$$$reportNull$$$0(0);
        }
        @NonNls StringBuilder functionText = new StringBuilder();
        functionText.append("{\n");
        OverrideMethodsFix.addText(retType, parameterList, func, qualifier, anchor, functionText);
        functionText.append("}");
        return functionText.toString();
    }

    private static void addText(String retType, JSParameterList parameterList, JSQualifiedNamedElement func, String qualifier, @NotNull PsiElement anchor, StringBuilder functionText) {
        if (anchor == null) {
            OverrideMethodsFix.$$$reportNull$$$0(1);
        }
        if (!(func instanceof JSFunction)) {
            return;
        }
        if (OverrideMethodsFix.isAbstractMethod((JSFunction)func)) {
            JSType type2 = retType == null ? null : new JSTypeParser(anchor.getProject(), retType, JSTypeSourceFactory.createTypeSource(anchor)).parse();
            TypeScriptImplementMemberUtil.appendDefaultMethodBody(anchor, type2, functionText, func.getName());
            return;
        }
        boolean isNoReturn = !((JSFunction)func).isGenerator() && !((JSFunction)func).isGetProperty() && OverrideMethodsFix.noReturnStatement(retType, (JSFunction)func) || ((JSFunction)func).isSetProperty();
        String superCall = OverrideMethodsFix.buildSuperCall(parameterList, (JSFunction)func, qualifier, anchor, ((JSFunction)func).getAttributeList());
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)anchor.getProject());
        FileTemplate template = fileTemplateManager.getCodeTemplate(ourOverriddenMethodBodyTemplate);
        Properties properties = fileTemplateManager.getDefaultProperties();
        JSType returnType = retType == null ? null : new JSTypeParser(anchor.getProject(), retType, JSTypeSourceFactory.createTypeSource(anchor)).parse();
        properties.setProperty("RETURN_TYPE", retType == null ? "any" : retType);
        properties.setProperty("DEFAULT_RETURN_VALUE", JSRefactoringUtil.defaultValueOfType(returnType));
        properties.setProperty("CALL_SUPER", (String)(isNoReturn ? superCall : (((JSFunction)func).isGenerator() ? "yield* " : "return ") + superCall));
        properties.setProperty("PLAIN_CALL_SUPER", superCall);
        functionText.append(TypeScriptImplementMemberUtil.getBodyTextFromTemplate(template, properties));
    }

    private static boolean isAbstractMethod(@NotNull JSFunction func) {
        JSAttributeList attributeList;
        if (func == null) {
            OverrideMethodsFix.$$$reportNull$$$0(2);
        }
        if ((attributeList = func.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            return true;
        }
        return OverrideMethodsFix.isReactRenderFunction(func);
    }

    private static boolean isReactRenderFunction(@NotNull JSElement func) {
        if (func == null) {
            OverrideMethodsFix.$$$reportNull$$$0(3);
        }
        if (!(func instanceof JSFunction)) {
            return false;
        }
        String name = ((JSFunction)func).getQualifiedName();
        return "React.Component.render".equals(name);
    }

    private static boolean noReturnStatement(@Nullable String retType, @NotNull JSFunction func) {
        if (func == null) {
            OverrideMethodsFix.$$$reportNull$$$0(4);
        }
        if ("void".equals(retType)) {
            return true;
        }
        if (PsiTreeUtil.findChildrenOfType((PsiElement)func, JSReturnStatement.class).size() != 0) {
            return false;
        }
        PsiElement typeElement = func.getReturnTypeElement();
        if (typeElement != null) {
            if (typeElement instanceof JSTypeDeclaration) {
                return ((JSTypeDeclaration)typeElement).getJSType() instanceof JSVoidType;
            }
            return false;
        }
        if (func.isGetProperty()) {
            return false;
        }
        JSAttributeList attributeList = func.getAttributeList();
        return attributeList == null || !DialectDetector.isActionScript(func) || !ContainerUtil.exists((Object[])attributeList.getChildren(), e -> e instanceof JSReferenceExpression);
    }

    private static String buildSuperCall(JSParameterList parameterList, JSFunction func, String qualifier, @NotNull PsiElement anchor, JSAttributeList attributeList) {
        if (anchor == null) {
            OverrideMethodsFix.$$$reportNull$$$0(5);
        }
        StringBuilder superBuilder = new StringBuilder();
        superBuilder.append(" ").append(qualifier);
        String name = func.getName();
        assert (name != null);
        boolean indexer = false;
        if (!name.startsWith("[Symbol.")) {
            if (!JSSymbolUtil.isValidPropertyName(name)) {
                superBuilder.append("[");
                indexer = true;
            } else {
                superBuilder.append(".");
            }
        }
        if (attributeList != null && ActionScriptPsiImplUtil.getNamespace(attributeList) != null) {
            superBuilder.append(OverrideMethodsFix.calcNamespaceId(attributeList, ActionScriptPsiImplUtil.getNamespaceValue(attributeList), anchor)).append("::");
        }
        superBuilder.append(JSSymbolUtil.quoteIfSpecialPropertyName(name, false, JSCodeStyleSettings.getQuoteChar(func)));
        if (indexer) {
            superBuilder.append("]");
        }
        if (!func.isGetProperty()) {
            if (func.isSetProperty()) {
                superBuilder.append("=").append(parameterList.getParameters()[0].getName());
            } else {
                superBuilder.append("(");
                boolean first = true;
                boolean canHaveRest = DialectDetector.isES6(func) || DialectDetector.isTypeScript(func);
                for (JSParameterListElement param : parameterList.getParameters()) {
                    if (!first) {
                        superBuilder.append(",");
                    }
                    first = false;
                    if (canHaveRest && param.isRest()) {
                        superBuilder.append("...");
                    }
                    superBuilder.append(param.getName());
                }
                superBuilder.append(")");
            }
        }
        return superBuilder.toString();
    }

    @Override
    protected boolean useReturnType(@NotNull JSQualifiedNamedElement fun, @Nullable JSType type2) {
        if (fun == null) {
            OverrideMethodsFix.$$$reportNull$$$0(6);
        }
        if (OverrideMethodsFix.isReactRenderFunction(fun)) {
            return JSCodeStyleSettings.getSettings((PsiElement)fun).PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS;
        }
        return super.useReturnType(fun, type2);
    }

    @Override
    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSQualifiedNamedElement qElement) {
        JSClass jsClass;
        super.adjustAttributeList(attributeListWrapper, qElement);
        assert (this.myJsClass != null);
        if (DialectDetector.isActionScript(this.myJsClass)) {
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.DYNAMIC, false);
            PsiElement element = JSResolveUtil.findParent((PsiElement)qElement);
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, element instanceof JSClass && !JSResolveUtil.isObjectClass((JSClass)element));
        }
        if (DialectDetector.isTypeScript(this.myJsClass) && (jsClass = JSUtils.getMemberContainingClass((PsiElement)qElement)) != null && !jsClass.isInterface() && !JSResolveUtil.isObjectClass(jsClass)) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.myJsClass);
            TypeScriptConfig config = TypeScriptConfigService.Provider.get(this.myJsClass.getProject()).getPreferableConfig(file);
            if (config != null && config.noImplicitOverride() || qElement instanceof JSAttributeListOwner && ((JSAttributeListOwner)((Object)qElement)).hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/generation/OverrideMethodsFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDelegatingText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReactRenderFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "noReturnStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSuperCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "useReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

